/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.ui.ComboBoxCompositeEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class DarculaUIUtil {
    private static final Color MAC_ACTIVE_ERROR_COLOR = new Color(-2131412165, true);
    private static final Color DEFAULT_ACTIVE_ERROR_COLOR = new JBColor(15023693, 9124924);
    private static final Color MAC_INACTIVE_ERROR_COLOR = new Color(-2131247940, true);
    private static final Color DEFAULT_INACTIVE_ERROR_COLOR = new JBColor(0xEBBCBC, 0x725252);
    public static final Color ACTIVE_ERROR_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_ACTIVE_ERROR_COLOR : DEFAULT_ACTIVE_ERROR_COLOR);
    public static final Color INACTIVE_ERROR_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_INACTIVE_ERROR_COLOR : DEFAULT_INACTIVE_ERROR_COLOR);
    private static final Color MAC_ACTIVE_WARNING_COLOR = new Color(-2132169405, true);
    private static final Color DEFAULT_ACTIVE_WARNING_COLOR = new JBColor(14853434, 11303200);
    private static final Color MAC_INACTIVE_WARNING_COLOR = new Color(-2130716007, true);
    private static final Color DEFAULT_INACTIVE_WARNING_COLOR = new JBColor(16765829, 7230244);
    public static final Color ACTIVE_WARNING_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_ACTIVE_WARNING_COLOR : DEFAULT_ACTIVE_WARNING_COLOR);
    public static final Color INACTIVE_WARNING_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_INACTIVE_WARNING_COLOR : DEFAULT_INACTIVE_WARNING_COLOR);
    private static final Color MAC_REGULAR_COLOR = new JBColor(new Color(-2142790404, true), new Color(3759490));
    private static final Color DEFAULT_REGULAR_COLOR = new JBColor(new Color(9089771), new Color(3759490));
    private static final Color REGULAR_COLOR = new JBColor(() -> UIUtil.isUnderDefaultMacTheme() ? MAC_REGULAR_COLOR : DEFAULT_REGULAR_COLOR);
    private static final Color GRAPHITE_COLOR = new JBColor(new Color(-2137417827, true), new Color(6776937));

    @Deprecated
    public static void paintFocusRing(Graphics g, Rectangle r) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(r.x, r.y);
            DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, DarculaUIUtil.arc(), true);
        }
        finally {
            g2.dispose();
        }
    }

    public static void paintFocusOval(Graphics2D g, float x, float y, float width, float height) {
        g.setPaint(IntelliJLaf.isGraphite() ? GRAPHITE_COLOR : REGULAR_COLOR);
        float blw = DarculaUIUtil.bw() + DarculaUIUtil.lw(g);
        Path2D.Float shape = new Path2D.Float(0);
        shape.append(new Ellipse2D.Float(x - blw, y - blw, width + blw * 2.0f, height + blw * 2.0f), false);
        shape.append(new Ellipse2D.Float(x, y, width, height), false);
        g.fill(shape);
    }

    @Deprecated
    public static void paintErrorBorder(Graphics2D g, int width, int height, int arc, boolean symmetric, boolean hasFocus) {
        DarculaUIUtil.paintOutlineBorder(g, width, height, arc, symmetric, hasFocus, Outline.error);
    }

    public static void paintOutlineBorder(Graphics2D g, int width, int height, float arc, boolean symmetric, boolean hasFocus, Outline type) {
        type.setGraphicsColor(g, hasFocus);
        DarculaUIUtil.doPaint(g, width, height, arc, symmetric);
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, int arc, boolean symmetric) {
        DarculaUIUtil.paintFocusBorder(g, width, height, (float)arc, symmetric);
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, float arc, boolean symmetric) {
        g.setPaint(IntelliJLaf.isGraphite() ? GRAPHITE_COLOR : REGULAR_COLOR);
        DarculaUIUtil.doPaint(g, width, height, arc, symmetric);
    }

    private static void doPaint(Graphics2D g, int width, int height, float arc, boolean symmetric) {
        float bw;
        float f = bw = UIUtil.isUnderDefaultMacTheme() ? (float)JBUI.scale((int)3) : DarculaUIUtil.bw();
        float lw = UIUtil.isUnderDefaultMacTheme() ? JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g) ? 0.5f : 1.0f)) : JBUI.scale((float)0.5f);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        float outerArc = arc > 0.0f ? arc + bw - JBUI.scale((float)2.0f) : bw;
        float rightOuterArc = symmetric ? outerArc : JBUI.scale((float)6.0f);
        Path2D.Float outerRect = new Path2D.Float(0);
        ((Path2D)outerRect).moveTo((float)width - rightOuterArc, 0.0);
        ((Path2D)outerRect).quadTo(width, 0.0, width, rightOuterArc);
        ((Path2D)outerRect).lineTo(width, (float)height - rightOuterArc);
        ((Path2D)outerRect).quadTo(width, height, (float)width - rightOuterArc, height);
        ((Path2D)outerRect).lineTo(outerArc, height);
        ((Path2D)outerRect).quadTo(0.0, height, 0.0, (float)height - outerArc);
        ((Path2D)outerRect).lineTo(0.0, outerArc);
        ((Path2D)outerRect).quadTo(0.0, 0.0, outerArc, 0.0);
        outerRect.closePath();
        float rightInnerArc = symmetric ? outerArc : JBUI.scale((float)7.0f);
        Path2D.Float innerRect = new Path2D.Float(0);
        ((Path2D)innerRect).moveTo((float)width - rightInnerArc, bw += lw);
        ((Path2D)innerRect).quadTo((float)width - bw, bw, (float)width - bw, rightInnerArc);
        ((Path2D)innerRect).lineTo((float)width - bw, (float)height - rightInnerArc);
        ((Path2D)innerRect).quadTo((float)width - bw, (float)height - bw, (float)width - rightInnerArc, (float)height - bw);
        ((Path2D)innerRect).lineTo(outerArc, (float)height - bw);
        ((Path2D)innerRect).quadTo(bw, (float)height - bw, bw, (float)height - outerArc);
        ((Path2D)innerRect).lineTo(bw, outerArc);
        ((Path2D)innerRect).quadTo(bw, bw, outerArc, bw);
        innerRect.closePath();
        Path2D.Float path = new Path2D.Float(0);
        path.append(outerRect, false);
        path.append(innerRect, false);
        g.fill(path);
    }

    public static boolean isCurrentEventShiftDownEvent() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        return event instanceof KeyEvent && ((KeyEvent)event).isShiftDown();
    }

    public static int getPatchedNextVisualPositionFrom(JTextComponent t, int pos, int direction) {
        if (!DarculaUIUtil.isCurrentEventShiftDownEvent()) {
            if (direction == 7 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionEnd() == pos) {
                return t.getSelectionStart();
            }
            if (direction == 3 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionStart() == pos) {
                return t.getSelectionEnd();
            }
        }
        return -1;
    }

    public static float lw(Graphics2D g2) {
        return UIUtil.isJreHiDPI((Graphics2D)g2) ? JBUI.scale((float)0.5f) : 1.0f;
    }

    public static float bw() {
        return JBUI.scale((int)2);
    }

    public static float arc() {
        return JBUI.scale((float)5.0f);
    }

    public static Color getOutlineColor(boolean enabled) {
        if (UIUtil.isUnderDarcula()) {
            return enabled ? Gray._100 : Gray._83;
        }
        return Gray.xBC;
    }

    public static Color getArrowButtonFillColor(boolean hasFocus, boolean enabled, Color defaultColor) {
        Color color = UIManager.getColor(hasFocus ? "ComboBox.darcula.arrowFocusedFillColor" : "ComboBox.darcula.arrowFillColor");
        return color == null ? defaultColor : (enabled ? color : DarculaUIUtil.getOutlineColor(false));
    }

    public static boolean isEmpty(Dimension d) {
        return d == null || d.width == 0 && d.height == 0;
    }

    public static class MouseHoverPropertyTrigger
    extends MouseAdapter {
        private final JComponent repaintComponent;
        private final String hoverProperty;

        public MouseHoverPropertyTrigger(@NotNull JComponent repaintComponent, @NotNull String hoverProperty) {
            if (repaintComponent == null) {
                MouseHoverPropertyTrigger.$$$reportNull$$$0(0);
            }
            if (hoverProperty == null) {
                MouseHoverPropertyTrigger.$$$reportNull$$$0(1);
            }
            this.repaintComponent = repaintComponent;
            this.hoverProperty = hoverProperty;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setHover((JComponent)e.getComponent(), Boolean.TRUE);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setHover((JComponent)e.getComponent(), Boolean.FALSE);
        }

        private void setHover(JComponent c, Boolean value) {
            if (c.isEnabled()) {
                c.putClientProperty(this.hoverProperty, value);
                this.repaintComponent.repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repaintComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hoverProperty";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/ui/laf/darcula/DarculaUIUtil$MouseHoverPropertyTrigger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class WinEditorTextFieldBorder
    extends DarculaEditorTextFieldBorder {
        public WinEditorTextFieldBorder(final EditorTextField editorTextField, EditorEx editor) {
            super(editorTextField, editor);
            editor.addEditorMouseListener((EditorMouseListener)new EditorMouseAdapter(){

                public void mouseEntered(EditorMouseEvent e) {
                    editorTextField.putClientProperty("JTextField.hover", Boolean.TRUE);
                    editorTextField.repaint();
                }

                public void mouseExited(EditorMouseEvent e) {
                    editorTextField.putClientProperty("JTextField.hover", Boolean.FALSE);
                    editorTextField.repaint();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (WinEditorTextFieldBorder.isComboBoxEditor(c)) {
                g.setColor(c.getBackground());
                g.fillRect(x, y, width, height);
                return;
            }
            EditorTextField editorTextField = (EditorTextField)UIUtil.getParentOfType(EditorTextField.class, (Component)c);
            if (editorTextField == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Rectangle r = new Rectangle(x, y, width, height);
                if (UIUtil.getParentOfType(Wrapper.class, (Component)c) != null && TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(c)) {
                    JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2, (int)0));
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                if (this.isBorderOpaque() || c.getParent() != null) {
                    g2.setColor(c.getParent().getBackground());
                    Path2D.Float borderArea = new Path2D.Float(0);
                    borderArea.append(r, false);
                    Rectangle innerRect = new Rectangle(r);
                    JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)2));
                    borderArea.append(innerRect, false);
                    g2.fill(borderArea);
                }
                boolean hasFocus = editorTextField.getFocusTarget().hasFocus();
                int bw = 1;
                Object op = editorTextField.getClientProperty("JComponent.outline");
                if (op != null) {
                    Outline.valueOf(op.toString()).setGraphicsColor(g2, c.hasFocus());
                    bw = 2;
                } else {
                    if (hasFocus) {
                        g2.setColor(UIManager.getColor("TextField.focusedBorderColor"));
                    } else if (editorTextField.isEnabled() && editorTextField.getClientProperty("JTextField.hover") == Boolean.TRUE) {
                        g2.setColor(UIManager.getColor("TextField.hoverBorderColor"));
                    } else {
                        g2.setColor(UIManager.getColor("TextField.borderColor"));
                    }
                    JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
                }
                if (!editorTextField.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                }
                Path2D.Float border = new Path2D.Float(0);
                border.append(r, false);
                Rectangle innerRect = new Rectangle(r);
                JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)bw));
                border.append(innerRect, false);
                g2.fill(border);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (UIUtil.getParentOfType(ComboBoxCompositeEditor.class, (Component)c) != null) {
                return JBUI.emptyInsets().asUIResource();
            }
            return WinEditorTextFieldBorder.isComboBoxEditor(c) ? JBUI.insets((int)1, (int)6).asUIResource() : JBUI.insets((int)4, (int)6).asUIResource();
        }
    }

    public static class MacEditorTextFieldBorder
    extends DarculaEditorTextFieldBorder {
        public MacEditorTextFieldBorder(EditorTextField editorTextField, EditorEx editor) {
            super(editorTextField, editor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (MacEditorTextFieldBorder.isComboBoxEditor(c)) {
                g.setColor(c.getBackground());
                g.fillRect(x, y, width, height);
                return;
            }
            EditorTextField editorTextField = (EditorTextField)UIUtil.getParentOfType(EditorTextField.class, (Component)c);
            if (editorTextField == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                if (c.isOpaque() || c instanceof JComponent && ((JComponent)c).getClientProperty("MAC_FILL_BORDER") == Boolean.TRUE) {
                    g2.setColor(UIUtil.getPanelBackground());
                    g2.fillRect(x, y, width, height);
                }
                Rectangle2D.Float rect = new Rectangle2D.Float(x + JBUI.scale((int)3), y + JBUI.scale((int)3), width - JBUI.scale((int)3) * 2, height - JBUI.scale((int)3) * 2);
                g2.setColor(c.getBackground());
                g2.fill(rect);
                if (!editorTextField.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                }
                float bw = UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f;
                Path2D.Float outline = new Path2D.Float(0);
                outline.append(rect, false);
                outline.append(new Rectangle2D.Float((float)((RectangularShape)rect).getX() + bw, (float)((RectangularShape)rect).getY() + bw, (float)((RectangularShape)rect).getWidth() - 2.0f * bw, (float)((RectangularShape)rect).getHeight() - 2.0f * bw), false);
                g2.setColor((Color)Gray.xBC);
                g2.fill(outline);
                g2.translate(x, y);
                boolean hasFocus = editorTextField.getFocusTarget().hasFocus();
                Object op = editorTextField.getClientProperty("JComponent.outline");
                if (op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, width, height, 0.0f, true, hasFocus, Outline.valueOf(op.toString()));
                } else if (editorTextField.isEnabled() && editorTextField.isVisible() && hasFocus) {
                    DarculaUIUtil.paintFocusBorder(g2, width, height, 0, true);
                }
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return MacEditorTextFieldBorder.isComboBoxEditor(c) ? JBUI.insets((int)1, (int)3, (int)2, (int)3).asUIResource() : JBUI.insets((int)5, (int)8).asUIResource();
        }
    }

    public static enum Outline {
        error{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                g.setColor(focused ? ACTIVE_ERROR_COLOR : INACTIVE_ERROR_COLOR);
            }
        }
        ,
        warning{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                g.setColor(focused ? ACTIVE_WARNING_COLOR : INACTIVE_WARNING_COLOR);
            }
        };


        public abstract void setGraphicsColor(Graphics2D var1, boolean var2);
    }
}

