/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldWithPopupHandlerUI
extends BasicTextFieldUI
implements Condition {
    private static final String DOCUMENT = "document";
    private static final String MONOSPACED = "monospaced";
    private static final String VARIANT = "JTextField.variant";
    private static final String POPUP = "JTextField.Search.FindPopup";
    private static final String INPLACE_HISTORY = "JTextField.Search.InplaceHistory";
    private static final String ON_CLEAR = "JTextField.Search.CancelAction";
    private final Insets insets = new Insets(0, 0, 0, 0);
    protected final LinkedHashMap<String, IconHolder> icons = new LinkedHashMap();
    private final Handler handler = new Handler();
    private boolean monospaced;
    private Object variant;
    private int cursor;
    @Deprecated
    protected JTextField myTextField;

    public TextFieldWithPopupHandlerUI() {
    }

    @Deprecated
    public TextFieldWithPopupHandlerUI(JTextField textField2) {
        this.myTextField = textField2;
    }

    public static void updateBorderInsets(Component c, Insets insets) {
        JTextComponent component;
        if (c instanceof JTextComponent && (component = (JTextComponent)c).getUI() instanceof TextFieldWithPopupHandlerUI) {
            TextFieldWithPopupHandlerUI ui = (TextFieldWithPopupHandlerUI)component.getUI();
            insets.top += ui.insets.top;
            insets.left += ui.insets.left;
            insets.right += ui.insets.right;
            insets.bottom += ui.insets.bottom;
        }
    }

    protected Icon getSearchIcon(boolean hovered, boolean clickable) {
        return AllIcons.Actions.Search;
    }

    protected int getSearchIconPreferredSpace() {
        Icon icon = this.getSearchIcon(true, true);
        return icon == null ? 0 : icon.getIconWidth() + this.getSearchIconGap();
    }

    protected int getSearchIconGap() {
        return JBUI.scale((int)2);
    }

    protected Icon getClearIcon(boolean hovered, boolean clickable) {
        return !clickable ? null : (hovered ? AllIcons.Actions.Clean : AllIcons.Actions.CleanLight);
    }

    protected int getClearIconPreferredSpace() {
        Icon icon = this.getClearIcon(true, true);
        return icon == null ? 0 : icon.getIconWidth() + this.getClearIconGap();
    }

    protected int getClearIconGap() {
        return JBUI.scale((int)2);
    }

    protected boolean hasText() {
        JTextComponent component = this.getComponent();
        return component != null && !StringUtil.isEmpty((String)component.getText());
    }

    protected void updateIconsLayout(Rectangle bounds) {
        for (IconHolder holder : this.icons.values()) {
            int gap = holder.extension.getIconGap();
            if (holder.extension.isIconBeforeText()) {
                holder.bounds.x = bounds.x;
                bounds.width -= holder.bounds.width + gap;
                bounds.x += holder.bounds.width + gap;
            } else {
                bounds.width -= holder.bounds.width + gap;
                holder.bounds.x = bounds.x + bounds.width + gap;
            }
            int top = (bounds.height - holder.bounds.height) / 2;
            if (top > gap) {
                boolean multiline;
                JTextComponent component = this.getComponent();
                boolean bl = multiline = component != null && !Boolean.TRUE.equals(component.getDocument().getProperty("filterNewlines"));
                if (multiline) {
                    top = gap;
                }
            }
            holder.bounds.y = bounds.y + top;
        }
    }

    protected SearchAction getActionUnder(@NotNull Point p) {
        if (p == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(0);
        }
        return null;
    }

    protected void showSearchPopup() {
    }

    @Override
    protected void installListeners() {
        JTextComponent component = this.getComponent();
        this.handler.installListener(component.getDocument());
        component.addPropertyChangeListener(this.handler);
        component.addMouseMotionListener(this.handler);
        component.addMouseListener(this.handler);
        component.addFocusListener(this.handler);
        this.setVariant(component.getClientProperty(VARIANT));
        this.setMonospaced(component.getClientProperty(MONOSPACED));
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent component = this.getComponent();
        component.removeFocusListener(this.handler);
        component.removeMouseListener(this.handler);
        component.removeMouseMotionListener(this.handler);
        component.removePropertyChangeListener(this.handler);
        this.handler.uninstallListener(component.getDocument());
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int position = DarculaUIUtil.getPatchedNextVisualPositionFrom(t, pos, direction);
        return position != -1 ? position : super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    protected Caret createCaret() {
        return Registry.is((String)"ide.text.mouse.selection.new") ? new MyCaret(this.getComponent()) : super.createCaret();
    }

    public boolean value(Object o) {
        MouseEvent me;
        if (o instanceof MouseEvent && this.getActionUnder((me = (MouseEvent)o).getPoint()) != null) {
            if (me.getID() == 500) {
                SwingUtilities.invokeLater(() -> this.handler.mouseClicked(me));
            }
            return true;
        }
        return false;
    }

    public static boolean isSearchField(Component c) {
        return c instanceof JTextField && "search".equals(((JTextField)c).getClientProperty(VARIANT));
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        return TextFieldWithPopupHandlerUI.isSearchField(c) && ((JTextField)c).getClientProperty(POPUP) instanceof JPopupMenu;
    }

    @Nullable
    public static AbstractAction getNewLineAction(Component c) {
        if (!TextFieldWithPopupHandlerUI.isSearchField(c) || !Registry.is((String)"ide.find.show.add.newline.hint")) {
            return null;
        }
        Object action = ((JTextField)c).getClientProperty("JTextField.Search.NewLineAction");
        return action instanceof AbstractAction ? (AbstractAction)action : null;
    }

    @Override
    public String getToolTipText(JTextComponent component, Point point) {
        if (!this.icons.isEmpty() && component != null && component.isEnabled()) {
            for (IconHolder holder : this.icons.values()) {
                if (!holder.bounds.contains(point)) continue;
                return holder.extension.getTooltip();
            }
        }
        return super.getToolTipText(component, point);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension size = super.getMinimumSize(c);
        if (size != null) {
            this.updatePreferredSize(c, size);
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (size != null) {
            this.updatePreferredSize(c, size);
        }
        return size;
    }

    protected void updatePreferredSize(JComponent c, Dimension size) {
        size.height = Math.max(size.height, this.getMinimumHeight());
        JBInsets.addTo((Dimension)size, (Insets)this.insets);
    }

    protected int getMinimumHeight() {
        return 0;
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle bounds = super.getVisibleEditorRect();
        if (bounds != null && !this.icons.isEmpty()) {
            JBInsets.addTo((Rectangle)bounds, (Insets)this.insets);
            this.updateIconsLayout(bounds);
        }
        return bounds;
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent component = this.getComponent();
        if (!component.isOpaque()) {
            this.paintBackground(g);
        }
        Shape clip = g.getClip();
        super.paintSafely(g);
        if (!this.icons.isEmpty()) {
            g.setClip(clip);
            for (IconHolder holder : this.icons.values()) {
                if (holder.icon == null) continue;
                holder.icon.paintIcon(component, g, holder.bounds.x, holder.bounds.y);
            }
        }
    }

    private void repaint(boolean invalid) {
        JTextComponent component = this.getComponent();
        if (component != null) {
            if (invalid) {
                component.revalidate();
            }
            component.repaint();
        }
    }

    private void updateIcon(IconHolder holder) {
        Icon icon;
        if (holder != null && holder.icon != (icon = holder.extension.getIcon(holder.hovered))) {
            this.repaint(holder.setIcon(icon));
        }
    }

    private void handleMouse(MouseEvent event, boolean run2) {
        JTextComponent component = this.getComponent();
        if (component != null) {
            Runnable action;
            boolean invalid = false;
            boolean repaint = false;
            IconHolder result2 = null;
            for (IconHolder holder : this.icons.values()) {
                Icon icon;
                boolean bl = holder.hovered = component.isEnabled() && holder.bounds.contains(event.getX(), event.getY());
                if (holder.hovered) {
                    result2 = holder;
                }
                if (holder.icon == (icon = holder.extension.getIcon(holder.hovered))) continue;
                if (holder.setIcon(icon)) {
                    invalid = true;
                }
                repaint = true;
            }
            if (repaint) {
                this.repaint(invalid);
            }
            Runnable runnable2 = action = result2 == null ? null : result2.extension.getActionOnClick();
            if (action == null) {
                this.setCursor(2);
            } else {
                this.setCursor(12);
                if (run2) {
                    action.run();
                    event.consume();
                }
            }
        }
    }

    private void setCursor(int cursor) {
        if (this.cursor != cursor) {
            this.cursor = cursor;
            JTextComponent component = this.getComponent();
            if (component != null) {
                component.setCursor(Cursor.getPredefinedCursor(cursor));
            }
        }
    }

    private void setVariant(Object variant) {
        if (!Objects.equals(this.variant, variant)) {
            this.variant = variant;
            this.icons.clear();
            this.insets.set(0, 0, 0, 0);
            if ("extendable".equals(variant)) {
                JTextComponent component = this.getComponent();
                if (component instanceof ExtendableTextField) {
                    ExtendableTextField field = (ExtendableTextField)component;
                    for (ExtendableTextField.Extension extension : field.getExtensions()) {
                        if (extension == null) continue;
                        this.addExtension(extension);
                    }
                }
            } else if ("search".equals(variant)) {
                this.addExtension(new SearchExtension());
                this.addExtension(new ClearExtension());
            }
        }
    }

    protected void addExtension(ExtendableTextField.Extension extension) {
        this.icons.put(extension.toString(), new IconHolder(extension));
        if (extension.isIconBeforeText()) {
            this.insets.left += extension.getPreferredSpace();
        } else {
            this.insets.right += extension.getPreferredSpace();
        }
    }

    private void setMonospaced(Object value) {
        boolean monospaced = Boolean.TRUE.equals(value);
        if (this.monospaced != monospaced) {
            Font font;
            this.monospaced = monospaced;
            JTextComponent component = this.getComponent();
            if (component != null && ((font = component.getFont()) == null || font instanceof UIResource)) {
                font = UIManager.getFont(this.getPropertyPrefix() + ".font");
                component.setFont(!monospaced ? font : new FontUIResource(MONOSPACED, font.getStyle(), font.getSize()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI", "getActionUnder"));
    }

    static class MyCaret
    extends BasicTextUI.BasicCaret {
        private final JTextComponent myComponent;

        public MyCaret(JTextComponent component) {
            this.myComponent = component;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getID() == 506 && !this.myComponent.getText().contains("\n")) {
                boolean consumed = e.isConsumed();
                e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers() | e.getModifiersEx(), e.getX(), this.myComponent.getHeight() / 2, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                if (consumed) {
                    e.consume();
                }
            }
            super.mouseDragged(e);
        }
    }

    private class ClearExtension
    implements ExtendableTextField.Extension {
        private ClearExtension() {
        }

        public Icon getIcon(boolean hovered) {
            return TextFieldWithPopupHandlerUI.this.getClearIcon(hovered, TextFieldWithPopupHandlerUI.this.hasText());
        }

        public int getIconGap() {
            return TextFieldWithPopupHandlerUI.this.getClearIconGap();
        }

        public int getPreferredSpace() {
            return TextFieldWithPopupHandlerUI.this.getClearIconPreferredSpace();
        }

        public Runnable getActionOnClick() {
            JTextComponent component = TextFieldWithPopupHandlerUI.this.getComponent();
            return component == null ? null : () -> {
                component.setText(null);
                Object property = component.getClientProperty(TextFieldWithPopupHandlerUI.ON_CLEAR);
                if (property instanceof ActionListener) {
                    ActionListener listener2 = (ActionListener)property;
                    listener2.actionPerformed(new ActionEvent(component, 1001, "clear"));
                }
            };
        }

        public String toString() {
            return "clear";
        }
    }

    private final class SearchExtension
    implements ExtendableTextField.Extension {
        private Rectangle bounds;

        private SearchExtension() {
        }

        public Icon getIcon(boolean hovered) {
            return TextFieldWithPopupHandlerUI.this.getSearchIcon(hovered, null != this.getActionOnClick());
        }

        public int getIconGap() {
            return TextFieldWithPopupHandlerUI.this.getSearchIconGap();
        }

        public int getPreferredSpace() {
            return TextFieldWithPopupHandlerUI.this.getSearchIconPreferredSpace();
        }

        public boolean isIconBeforeText() {
            return true;
        }

        public Runnable getActionOnClick() {
            JTextComponent component = TextFieldWithPopupHandlerUI.this.getComponent();
            Object property = component == null ? null : component.getClientProperty(TextFieldWithPopupHandlerUI.POPUP);
            JPopupMenu popup2 = property instanceof JPopupMenu ? (JPopupMenu)property : null;
            return popup2 == null ? null : () -> {
                Rectangle editor = TextFieldWithPopupHandlerUI.this.getVisibleEditorRect();
                if (editor != null) {
                    popup2.show(component, this.bounds.x, editor.y + editor.height);
                }
            };
        }

        public String getTooltip() {
            String prefix = null;
            if (UIUtil.getClientProperty((Object)TextFieldWithPopupHandlerUI.this.getComponent(), (Object)TextFieldWithPopupHandlerUI.INPLACE_HISTORY) != null) {
                prefix = "Recent Search";
            }
            if (this.getActionOnClick() != null) {
                prefix = "Search History";
            }
            return prefix == null ? null : prefix + " (" + KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.SHOW_HISTORY_KEYSTROKE) + ")";
        }

        public String toString() {
            return "search";
        }
    }

    public static final class IconHolder {
        public final Rectangle bounds = new Rectangle();
        public final ExtendableTextField.Extension extension;
        public boolean hovered;
        public Icon icon;

        private IconHolder(ExtendableTextField.Extension extension) {
            this.extension = extension;
            if (extension instanceof SearchExtension) {
                SearchExtension se = (SearchExtension)extension;
                se.bounds = this.bounds;
            }
            this.setIcon(extension.getIcon(false));
        }

        private boolean setIcon(Icon icon) {
            int height;
            this.icon = icon;
            int width = icon == null ? 0 : icon.getIconWidth();
            int n = height = icon == null ? 0 : icon.getIconHeight();
            if (this.bounds.width == width && this.bounds.height == height) {
                return false;
            }
            this.bounds.width = width;
            this.bounds.height = height;
            return true;
        }

        public boolean isClickable() {
            return null != this.extension.getActionOnClick();
        }
    }

    private final class Handler
    extends MouseAdapter
    implements DocumentListener,
    FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        private void installListener(Document document) {
            if (document != null) {
                document.addDocumentListener(this);
            }
        }

        private void uninstallListener(Document document) {
            if (document != null) {
                document.removeDocumentListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (TextFieldWithPopupHandlerUI.DOCUMENT.equals(event.getPropertyName())) {
                if (event.getOldValue() instanceof Document) {
                    this.uninstallListener((Document)event.getOldValue());
                }
                if (event.getNewValue() instanceof Document) {
                    this.installListener((Document)event.getNewValue());
                }
            } else if (TextFieldWithPopupHandlerUI.MONOSPACED.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.setMonospaced(event.getNewValue());
            } else if (TextFieldWithPopupHandlerUI.VARIANT.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.setVariant(event.getNewValue());
            } else if (TextFieldWithPopupHandlerUI.POPUP.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.updateIcon(TextFieldWithPopupHandlerUI.this.icons.get("search"));
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            TextFieldWithPopupHandlerUI.this.repaint(false);
        }

        @Override
        public void focusLost(FocusEvent event) {
            TextFieldWithPopupHandlerUI.this.repaint(false);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.changedUpdate(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.changedUpdate(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                for (IconHolder holder : TextFieldWithPopupHandlerUI.this.icons.values()) {
                    TextFieldWithPopupHandlerUI.this.updateIcon(holder);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, false);
            } else if (TextFieldWithPopupHandlerUI.this.getComponent() != null && TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.getComponent())) {
                SearchAction action = TextFieldWithPopupHandlerUI.this.getActionUnder(e.getPoint());
                if (action == SearchAction.POPUP && !TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(TextFieldWithPopupHandlerUI.this.getComponent())) {
                    action = null;
                }
                TextFieldWithPopupHandlerUI.this.setCursor(action != null ? 12 : 2);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SearchAction action;
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, true);
            } else if (TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.getComponent()) && (action = TextFieldWithPopupHandlerUI.this.getActionUnder(e.getPoint())) != null) {
                switch (action) {
                    case POPUP: {
                        TextFieldWithPopupHandlerUI.this.showSearchPopup();
                        break;
                    }
                    case CLEAR: {
                        Object listener2 = TextFieldWithPopupHandlerUI.this.getComponent().getClientProperty(TextFieldWithPopupHandlerUI.ON_CLEAR);
                        if (listener2 instanceof ActionListener) {
                            ((ActionListener)listener2).actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.getComponent(), 1001, "action"));
                        }
                        TextFieldWithPopupHandlerUI.this.getComponent().setText("");
                        break;
                    }
                    case NEWLINE: {
                        AbstractAction newLineAction = TextFieldWithPopupHandlerUI.getNewLineAction(TextFieldWithPopupHandlerUI.this.getComponent());
                        if (newLineAction == null) break;
                        newLineAction.actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.getComponent(), 1001, "action"));
                        break;
                    }
                }
                e.consume();
            }
        }
    }

    public static enum SearchAction {
        POPUP,
        CLEAR,
        NEWLINE;

    }
}

