/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;

public class FocusDebuggerAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.focus.FocusDebuggerAction");
    private FocusDrawer myFocusDrawer;

    public FocusDebuggerAction() {
        if (Boolean.getBoolean("idea.ui.debug.mode")) {
            ApplicationManager.getApplication().invokeLater(() -> this.actionPerformed(null));
        }
    }

    public void actionPerformed(AnActionEvent e) {
        if (this.myFocusDrawer == null) {
            this.myFocusDrawer = new FocusDrawer();
            this.myFocusDrawer.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myFocusDrawer, 4L);
        } else {
            this.myFocusDrawer.setRunning(false);
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myFocusDrawer);
            this.myFocusDrawer = null;
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (this.myFocusDrawer == null) {
            presentation.setText("Start Focus Debugger");
        } else {
            presentation.setText("Stop Focus Debugger");
        }
    }

    private static class FocusDrawer
    extends Thread
    implements AWTEventListener,
    ApplicationActivationListener {
        private Component myCurrent;
        private Component myPrevious;
        private boolean myTemporary;
        private boolean myRunning = true;
        private ApplicationState myApplicationState = ApplicationState.UNKNOWN;

        public FocusDrawer() {
            super("focus debugger");
            Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)this);
        }

        public void applicationActivated(IdeFrame ideFrame) {
            this.myApplicationState = ApplicationState.ACTIVE;
        }

        public void applicationDeactivated(IdeFrame ideFrame) {
            this.myApplicationState = ApplicationState.INACTIVE;
        }

        public void delayedApplicationDeactivated(IdeFrame ideFrame) {
            this.myApplicationState = ApplicationState.DELAYED;
        }

        public void setRunning(boolean running) {
            this.myRunning = running;
        }

        public boolean isRunning() {
            return this.myRunning;
        }

        @Override
        public void run() {
            try {
                while (this.myRunning) {
                    this.paintFocusBorders(false);
                    Thread.sleep(100L);
                }
                this.paintFocusBorders(true);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintFocusBorders(boolean clean) {
            if (this.myCurrent != null) {
                Graphics2D currentFocusGraphics = (Graphics2D)(this.myCurrent.getGraphics() != null ? this.myCurrent.getGraphics().create() : null);
                try {
                    if (currentFocusGraphics != null) {
                        if (clean) {
                            if (this.myCurrent.isDisplayable()) {
                                this.myCurrent.repaint();
                            }
                        } else {
                            currentFocusGraphics.setStroke(new BasicStroke(JBUI.scale((int)1)));
                            currentFocusGraphics.setColor((Color)(this.myTemporary ? JBColor.ORANGE : JBColor.GREEN));
                            UIUtil.drawDottedRectangle((Graphics)currentFocusGraphics, (int)1, (int)1, (int)(this.myCurrent.getSize().width - 2), (int)(this.myCurrent.getSize().height - 2));
                        }
                    }
                }
                finally {
                    if (currentFocusGraphics != null) {
                        currentFocusGraphics.dispose();
                    }
                }
                if (this.myPrevious != null) {
                    Graphics2D previousFocusGraphics = (Graphics2D)(this.myPrevious.getGraphics() != null ? this.myPrevious.getGraphics().create() : null);
                    try {
                        if (previousFocusGraphics != null) {
                            if (clean) {
                                if (this.myPrevious.isDisplayable()) {
                                    this.myPrevious.repaint();
                                }
                            } else {
                                previousFocusGraphics.setStroke(new BasicStroke(JBUI.scale((int)1)));
                                previousFocusGraphics.setColor((Color)JBColor.RED);
                                UIUtil.drawDottedRectangle((Graphics)previousFocusGraphics, (int)1, (int)1, (int)(this.myPrevious.getSize().width - 2), (int)(this.myPrevious.getSize().height - 2));
                            }
                        }
                    }
                    finally {
                        if (previousFocusGraphics != null) {
                            previousFocusGraphics.dispose();
                        }
                    }
                }
                this.drawOnGraphics(g -> {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(this.myApplicationState.getColor());
                    g.fillOval(5, 5, 10, 10);
                    g.setColor((Color)JBColor.black);
                    g.setStroke(new BasicStroke(2.0f));
                    g.drawOval(5, 5, 10, 10);
                });
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof FocusEvent) {
                FocusEvent focusEvent = (FocusEvent)event;
                Component fromComponent = focusEvent.getComponent();
                Component oppositeComponent = focusEvent.getOppositeComponent();
                this.paintFocusBorders(true);
                switch (event.getID()) {
                    case 1004: {
                        this.myCurrent = fromComponent;
                        this.myPrevious = oppositeComponent;
                        this.myTemporary = focusEvent.isTemporary();
                        break;
                    }
                    case 1005: {
                        this.myTemporary = focusEvent.isTemporary();
                    }
                }
                this.drawOnGraphics(g -> {
                    g.setColor(this.myApplicationState.getColor());
                    g.fillOval(5, 5, 10, 10);
                    g.setColor((Color)JBColor.black);
                    g.setStroke(new BasicStroke(2.0f));
                    g.drawOval(5, 5, 10, 10);
                    g.setColor(this.myApplicationState.getColor());
                    g.fillOval(5, 5, 10, 10);
                });
                Arrays.stream(Window.getOwnerlessWindows()).filter(window -> window != null && window instanceof RootPaneContainer).map(window -> (RootPaneContainer)((Object)window)).filter(f -> f.getRootPane() != null).filter(window -> window.getRootPane() != null).map(window -> window.getGlassPane()).map(jGlassPane -> jGlassPane.getGraphics()).filter(g -> g != null).forEach(graphics -> {
                    Graphics2D glassPaneGraphics = (Graphics2D)graphics.create();
                    glassPaneGraphics.dispose();
                });
            }
        }

        private void drawOnGraphics(Consumer<Graphics2D> consumer) {
            Arrays.stream(Frame.getFrames()).filter(window -> window != null && window instanceof RootPaneContainer).map(window -> (RootPaneContainer)((Object)window)).filter(w -> w instanceof JFrame).filter(f -> f.getRootPane() != null).filter(f -> f.getGlassPane() != null).filter(window -> window.getRootPane() != null).map(window -> window.getGlassPane()).map(jGlassPane -> jGlassPane.getGraphics()).filter(g -> g != null).forEach(graphics -> {
                Graphics glassPaneGraphics = graphics.create();
                try {
                    consumer.accept((Graphics2D)glassPaneGraphics);
                }
                finally {
                    glassPaneGraphics.dispose();
                }
            });
        }

        static enum ApplicationState {
            ACTIVE,
            DELAYED,
            INACTIVE,
            UNKNOWN;


            public Color getColor() {
                switch (this) {
                    case ACTIVE: {
                        return JBColor.green;
                    }
                    case DELAYED: {
                        return JBColor.yellow;
                    }
                    case INACTIVE: {
                        return JBColor.red;
                    }
                    case UNKNOWN: {
                        return JBColor.gray;
                    }
                }
                throw new RuntimeException("Unknown application state");
            }
        }
    }
}

