/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.customUsageCollectors.actions;

import com.intellij.ide.actions.ActionsCollector;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsDifferenceSender;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED), @Storage(value="statistics.actions.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ActionsCollectorImpl
extends ActionsCollector
implements PersistentStateComponent<ActionsCollector.State> {
    private ActionsCollector.State myState = new ActionsCollector.State();

    public void record(String actionId) {
        if (actionId == null) {
            return;
        }
        ActionsCollector.State state = this.getState();
        if (state == null) {
            return;
        }
        String key = ConvertUsagesUtil.escapeDescriptorName(actionId);
        FeatureUsageLogger.INSTANCE.log("action-stats", key);
        Integer count = (Integer)state.myValues.get(key);
        int value = count == null ? 1 : count + 1;
        state.myValues.put(key, value);
    }

    @Nullable
    public ActionsCollector.State getState() {
        return this.myState;
    }

    public void loadState(@NotNull ActionsCollector.State state) {
        if (state == null) {
            ActionsCollectorImpl.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/internal/statistic/customUsageCollectors/actions/ActionsCollectorImpl", "loadState"));
    }

    static final class ActionUsagesCollectorNew
    extends ApplicationUsagesCollector
    implements FUStatisticsDifferenceSender {
        ActionUsagesCollectorNew() {
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() {
            ActionsCollector.State state = ActionsCollector.getInstance().getState();
            assert (state != null);
            Set set2 = ContainerUtil.map2Set(state.myValues.entrySet(), e -> new UsageDescriptor((String)e.getKey(), (Integer)e.getValue()));
            if (set2 == null) {
                ActionUsagesCollectorNew.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public String getGroupId() {
            if ("statistics.actions" == null) {
                ActionUsagesCollectorNew.$$$reportNull$$$0(1);
            }
            return "statistics.actions";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/internal/statistic/customUsageCollectors/actions/ActionsCollectorImpl$ActionUsagesCollectorNew";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    @Deprecated
    static final class ActionUsagesCollector
    extends UsagesCollector {
        private static final GroupDescriptor GROUP = GroupDescriptor.create("Actions", 100.0);

        ActionUsagesCollector() {
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() {
            ActionsCollector.State state = ActionsCollector.getInstance().getState();
            assert (state != null);
            Set set2 = ContainerUtil.map2Set(state.myValues.entrySet(), e -> new UsageDescriptor((String)e.getKey(), (Integer)e.getValue()));
            if (set2 == null) {
                ActionUsagesCollector.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP;
            if (groupDescriptor == null) {
                ActionUsagesCollector.$$$reportNull$$$0(1);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/internal/statistic/customUsageCollectors/actions/ActionsCollectorImpl$ActionUsagesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

