/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.beans;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FSGroup {
    private static final String FORBIDDEN_PATTERN = "[,\\s\\n]+";
    private static final String FORBIDDEN_PATTERN_REPLACEMENT = "[??]";
    public String id;
    public Map<String, Integer> metrics;

    private FSGroup(String id, Set<UsageDescriptor> usages) {
        this.id = id;
        for (UsageDescriptor usage : usages) {
            this.getMetrics().put(FSGroup.replaceForbiddenPattern(usage), usage.getValue());
        }
    }

    @NotNull
    private static String replaceForbiddenPattern(@NotNull UsageDescriptor usage) {
        if (usage == null) {
            FSGroup.$$$reportNull$$$0(0);
        }
        String string = usage.getKey().replaceAll(FORBIDDEN_PATTERN, FORBIDDEN_PATTERN_REPLACEMENT);
        if (string == null) {
            FSGroup.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Map<String, Integer> getMetrics() {
        if (this.metrics == null) {
            this.metrics = ContainerUtil.newHashMap();
        }
        Map<String, Integer> map = this.metrics;
        if (map == null) {
            FSGroup.$$$reportNull$$$0(2);
        }
        return map;
    }

    public static FSGroup create(@NotNull String groupId, @NotNull Set<UsageDescriptor> usages) {
        if (groupId == null) {
            FSGroup.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            FSGroup.$$$reportNull$$$0(4);
        }
        return new FSGroup(groupId, usages);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FSGroup group = (FSGroup)o;
        return Objects.equals(this.id, group.id) && Objects.equals(this.metrics, group.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.metrics);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/beans/FSGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/beans/FSGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceForbiddenPattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceForbiddenPattern";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

