/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.PsiBuilderImpl;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MarkerOptionalData
extends BitSet {
    private final TIntObjectHashMap<Throwable> myDebugAllocationPositions = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> myDoneErrors = new TIntObjectHashMap();
    private final TIntObjectHashMap<WhitespacesAndCommentsBinder> myLeftBinders = new TIntObjectHashMap();
    private final TIntObjectHashMap<WhitespacesAndCommentsBinder> myRightBinders = new TIntObjectHashMap();
    private final TIntHashSet myCollapsed = new TIntHashSet();

    MarkerOptionalData() {
    }

    void clean(int markerId) {
        if (this.get(markerId)) {
            this.set(markerId, false);
            this.myLeftBinders.remove(markerId);
            this.myRightBinders.remove(markerId);
            this.myDoneErrors.remove(markerId);
            this.myCollapsed.remove(markerId);
            this.myDebugAllocationPositions.remove(markerId);
        }
    }

    void compact() {
        this.myLeftBinders.compact();
        this.myRightBinders.compact();
        this.myDebugAllocationPositions.compact();
        this.myCollapsed.compact();
        this.myDoneErrors.compact();
    }

    @Nullable
    String getDoneError(int markerId) {
        return (String)this.myDoneErrors.get(markerId);
    }

    boolean isCollapsed(int markerId) {
        return this.myCollapsed.contains(markerId);
    }

    void setErrorMessage(int markerId, String message) {
        this.markAsHavingOptionalData(markerId);
        this.myDoneErrors.put(markerId, (Object)message);
    }

    void markCollapsed(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myCollapsed.add(markerId);
    }

    private void markAsHavingOptionalData(int markerId) {
        this.set(markerId);
    }

    void notifyAllocated(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myDebugAllocationPositions.put(markerId, (Object)new Throwable("Created at the following trace."));
    }

    Throwable getAllocationTrace(PsiBuilderImpl.StartMarker marker) {
        return (Throwable)this.myDebugAllocationPositions.get(marker.markerId);
    }

    WhitespacesAndCommentsBinder getBinder(int markerId, boolean right) {
        WhitespacesAndCommentsBinder binder = (WhitespacesAndCommentsBinder)this.getBinderMap(right).get(markerId);
        return binder != null ? binder : MarkerOptionalData.getDefaultBinder(right);
    }

    void assignBinder(int markerId, @NotNull WhitespacesAndCommentsBinder binder, boolean right) {
        if (binder == null) {
            MarkerOptionalData.$$$reportNull$$$0(0);
        }
        TIntObjectHashMap<WhitespacesAndCommentsBinder> map = this.getBinderMap(right);
        if (binder != MarkerOptionalData.getDefaultBinder(right)) {
            this.markAsHavingOptionalData(markerId);
            map.put(markerId, (Object)binder);
        } else {
            map.remove(markerId);
        }
    }

    private static WhitespacesAndCommentsBinder getDefaultBinder(boolean right) {
        return right ? WhitespacesBinders.DEFAULT_RIGHT_BINDER : WhitespacesBinders.DEFAULT_LEFT_BINDER;
    }

    private TIntObjectHashMap<WhitespacesAndCommentsBinder> getBinderMap(boolean right) {
        return right ? this.myRightBinders : this.myLeftBinders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binder", "com/intellij/lang/impl/MarkerOptionalData", "assignBinder"));
    }
}

