/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MergeVersion {
    public Document createWorkingDocument(Project var1);

    public void applyText(@NotNull String var1, Project var2);

    @Nullable
    public VirtualFile getFile();

    public byte[] getBytes() throws IOException;

    public FileType getContentType();

    public void restoreOriginalContent(Project var1);

    public static class MergeDocumentVersion
    implements MergeVersion {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.mergeTool.MergeVersion.MergeDocumentVersion");
        protected final Document myDocument;
        private final String myOriginalText;
        private String myTextBeforeMerge;

        public MergeDocumentVersion(Document document, String originalText) {
            LOG.assertTrue(originalText != null, (Object)"text should not be null");
            LOG.assertTrue(document != null, (Object)"document should not be null");
            LOG.assertTrue(document.isWritable(), (Object)"document should be writable");
            this.myDocument = document;
            this.myOriginalText = originalText;
        }

        @Override
        public Document createWorkingDocument(Project project) {
            Document workingDocument = this.myDocument;
            workingDocument.setReadOnly(false);
            DocumentReference ref = DocumentReferenceManager.getInstance().create(workingDocument);
            this.myTextBeforeMerge = this.myDocument.getText();
            ApplicationManager.getApplication().runWriteAction(() -> {
                UndoManager undoManager;
                MergeDocumentVersion.setDocumentText(workingDocument, this.myOriginalText, DiffBundle.message((String)"merge.init.merge.content.command.name", (Object[])new Object[0]), project);
                if (project != null && (undoManager = UndoManager.getInstance((Project)project)) != null) {
                    undoManager.nonundoableActionPerformed(ref, false);
                }
            });
            return workingDocument;
        }

        @Override
        public void applyText(@NotNull String text, Project project) {
            if (text == null) {
                MergeDocumentVersion.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (text == null) {
                    MergeDocumentVersion.$$$reportNull$$$0(9);
                }
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    if (text == null) {
                        MergeDocumentVersion.$$$reportNull$$$0(10);
                    }
                    this.doApplyText(text, project);
                }, "Merge changes", null);
            });
        }

        protected void doApplyText(@NotNull String text, Project project) {
            if (text == null) {
                MergeDocumentVersion.$$$reportNull$$$0(1);
            }
            MergeDocumentVersion.setDocumentText(this.myDocument, text, DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0]), project);
            FileDocumentManager.getInstance().saveDocument(this.myDocument);
            MergeDocumentVersion.reportProjectFileChangeIfNeeded(project, this.getFile());
        }

        public static void reportProjectFileChangeIfNeeded(@Nullable Project project, @Nullable VirtualFile file2) {
            if (project != null && file2 != null && !file2.isDirectory() && (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2) || MergeDocumentVersion.isProjectFile(file2))) {
                ProjectManagerEx.getInstanceEx().saveChangedProjectFile(file2, project);
            }
        }

        @Nullable
        public static Runnable prepareToReportChangedProjectFiles(@NotNull Project project, @NotNull Collection<VirtualFile> files2) {
            if (project == null) {
                MergeDocumentVersion.$$$reportNull$$$0(2);
            }
            if (files2 == null) {
                MergeDocumentVersion.$$$reportNull$$$0(3);
            }
            THashSet vfs = new THashSet();
            for (VirtualFile file2 : files2) {
                if (file2 == null || file2.isDirectory() || !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2) && !MergeDocumentVersion.isProjectFile(file2)) continue;
                vfs.add(file2);
            }
            return vfs.isEmpty() ? null : () -> MergeDocumentVersion.lambda$prepareToReportChangedProjectFiles$3((Set)vfs, project);
        }

        @Override
        public void restoreOriginalContent(Project project) {
            ApplicationManager.getApplication().runWriteAction(() -> this.doRestoreOriginalContent(project));
        }

        public static boolean isProjectFile(VirtualFile file2) {
            ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
            return importProvider != null && importProvider.lookForProjectsInDirectory();
        }

        protected void doRestoreOriginalContent(@Nullable Project project) {
            MergeDocumentVersion.setDocumentText(this.myDocument, this.myTextBeforeMerge, "", project);
        }

        @Override
        @Nullable
        public VirtualFile getFile() {
            return FileDocumentManager.getInstance().getFile(this.myDocument);
        }

        @Override
        public byte[] getBytes() throws IOException {
            VirtualFile file2 = this.getFile();
            return file2 != null ? file2.contentsToByteArray() : this.myDocument.getText().getBytes();
        }

        @Override
        public FileType getContentType() {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return FileTypes.PLAIN_TEXT;
            }
            return file2.getFileType();
        }

        private static void setDocumentText(@NotNull Document document, @NotNull String text, @Nullable String name, @Nullable Project project) {
            if (document == null) {
                MergeDocumentVersion.$$$reportNull$$$0(4);
            }
            if (text == null) {
                MergeDocumentVersion.$$$reportNull$$$0(5);
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (document == null) {
                    MergeDocumentVersion.$$$reportNull$$$0(6);
                }
                if (text == null) {
                    MergeDocumentVersion.$$$reportNull$$$0(7);
                }
                document.replaceString(0, document.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)text));
            }, name, null);
        }

        private static /* synthetic */ void lambda$prepareToReportChangedProjectFiles$3(Set vfs, @NotNull Project project) {
            if (project == null) {
                MergeDocumentVersion.$$$reportNull$$$0(8);
            }
            ProjectManagerEx ex = ProjectManagerEx.getInstanceEx();
            for (VirtualFile vf : vfs) {
                ex.saveChangedProjectFile(vf, project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/mergeTool/MergeVersion$MergeDocumentVersion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doApplyText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareToReportChangedProjectFiles";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDocumentText";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$setDocumentText$5";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$prepareToReportChangedProjectFiles$3";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$applyText$2";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

