/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.BlockingProgressIndicator;
import com.intellij.openapi.progress.util.ProgressDialog;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWindow
extends ProgressIndicatorBase
implements BlockingProgressIndicator,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressWindow");
    public static final int DEFAULT_PROGRESS_DIALOG_POSTPONE_TIME_MILLIS = 300;
    private ProgressDialog myDialog;
    final Project myProject;
    final boolean myShouldShowCancel;
    String myCancelText;
    private String myTitle;
    private boolean myStoppedAlready;
    private boolean myStarted;
    protected boolean myBackgrounded;
    @Nullable
    private volatile Runnable myBackgroundHandler;
    protected int myDelayInMillis = 300;
    private boolean myModalityEntered;
    public static final Topic<Listener> TOPIC = Topic.create((String)"progress window", Listener.class);

    public ProgressWindow(boolean shouldShowCancel, Project project) {
        this(shouldShowCancel, false, project);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project) {
        this(shouldShowCancel, shouldShowBackground, project, null);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, String cancelText) {
        this(shouldShowCancel, shouldShowBackground, project, null, cancelText);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, JComponent parentComponent, String cancelText) {
        this.myProject = project;
        this.myShouldShowCancel = shouldShowCancel;
        this.myCancelText = cancelText;
        this.setModalityProgress(shouldShowBackground ? null : this);
        Container parent = parentComponent;
        if (parent == null && project == null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            parent = JOptionPane.getRootFrame();
        }
        this.myDialog = parent == null ? new ProgressDialog(this, shouldShowBackground, this.myProject, this.myCancelText) : new ProgressDialog(this, shouldShowBackground, parent, this.myCancelText);
        Disposer.register((Disposable)this, (Disposable)this.myDialog);
        this.addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                if (ProgressWindow.this.myDialog != null) {
                    ProgressWindow.this.myDialog.cancel();
                }
            }
        });
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).progressWindowCreated(this);
        if (this.myProject != null) {
            Disposer.register((Disposable)this.myProject, (Disposable)this);
        }
    }

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning());
        LOG.assertTrue(!this.myStoppedAlready);
        super.start();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.prepareShowDialog();
        }
        this.myStarted = true;
    }

    public void setDelayInMillis(int delayInMillis) {
        this.myDelayInMillis = delayInMillis;
    }

    private synchronized boolean isStarted() {
        return this.myStarted;
    }

    protected void prepareShowDialog() {
        Timer timer = UIUtil.createNamedTimer((String)"Progress window timer", (int)this.myDelayInMillis, e -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isRunning()) {
                DialogWrapper popup2;
                if (this.myDialog != null && (popup2 = this.myDialog.myPopup) != null && popup2.isShowing()) {
                    this.myDialog.myWasShown = true;
                }
                this.showDialog();
            } else {
                Disposer.dispose((Disposable)this);
                IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
                focusManager.doWhenFocusSettlesDown(() -> focusManager.requestDefaultFocus(true), ModalityState.defaultModalityState());
            }
        }, this.getModalityState()));
        timer.setRepeats(false);
        timer.start();
    }

    final void enterModality() {
        if (this.myModalityProgress == this && !this.myModalityEntered) {
            LaterInvocator.enterModal(this, (ModalityStateEx)this.getModalityState());
            this.myModalityEntered = true;
        }
    }

    final void exitModality() {
        if (this.myModalityProgress == this && this.myModalityEntered) {
            this.myModalityEntered = false;
            LaterInvocator.leaveModal(this);
        }
    }

    @Override
    public void startBlocking() {
        this.startBlocking(EmptyRunnable.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlocking(@NotNull Runnable init) {
        if (init == null) {
            ProgressWindow.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProgressWindow progressWindow = this;
        synchronized (progressWindow) {
            LOG.assertTrue(!this.isRunning());
            LOG.assertTrue(!this.myStoppedAlready);
        }
        this.enterModality();
        init.run();
        try {
            IdeEventQueue.getInstance().pumpEventsForHierarchy(this.myDialog.myPanel, (Condition<AWTEvent>)((Condition)event -> {
                if (this.isCancellationEvent((AWTEvent)event)) {
                    this.cancel();
                }
                return this.isStarted() && !this.isRunning();
            }));
        }
        finally {
            this.exitModality();
        }
    }

    protected final boolean isCancellationEvent(AWTEvent event) {
        return this.myShouldShowCancel && event instanceof KeyEvent && event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 27 && ((KeyEvent)event).getModifiers() == 0;
    }

    protected void showDialog() {
        if (!this.isRunning() || this.isCanceled()) {
            return;
        }
        this.myDialog.show();
        if (this.myDialog != null) {
            this.myDialog.myRepaintRunnable.run();
        }
    }

    @Override
    public void startNonCancelableSection() {
        if (this.isCancelable()) {
            this.enableCancel(false);
        }
        super.startNonCancelableSection();
    }

    @Override
    public void finishNonCancelableSection() {
        super.finishNonCancelableSection();
        if (this.isCancelable()) {
            this.enableCancel(true);
        }
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.update();
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(!this.myStoppedAlready);
        super.stop();
        UIUtil.invokeLaterIfNeeded(() -> {
            boolean wasShowing = this.isDialogShowing();
            if (this.myDialog != null) {
                this.myDialog.hide();
            }
            ProgressWindow progressWindow = this;
            synchronized (progressWindow) {
                this.myStoppedAlready = true;
            }
            Disposer.dispose((Disposable)this);
        });
        SwingUtilities.invokeLater(EmptyRunnable.INSTANCE);
    }

    protected boolean isDialogShowing() {
        return this.myDialog != null && this.myDialog.getPanel() != null && this.myDialog.getPanel().isShowing();
    }

    @Nullable
    protected ProgressDialog getDialog() {
        return this.myDialog;
    }

    public void background() {
        Runnable backgroundHandler = this.myBackgroundHandler;
        if (backgroundHandler != null) {
            backgroundHandler.run();
            return;
        }
        if (this.myDialog != null) {
            this.myBackgrounded = true;
            this.myDialog.background();
            this.myDialog = null;
        }
    }

    public boolean isBackgrounded() {
        return this.myBackgrounded;
    }

    @Override
    public void setText(String text) {
        if (!Comparing.equal((String)text, (String)this.getText())) {
            super.setText(text);
            this.update();
        }
    }

    @Override
    public void setFraction(double fraction) {
        if (fraction != this.getFraction()) {
            super.setFraction(fraction);
            this.update();
        }
    }

    @Override
    public void setText2(String text) {
        if (!Comparing.equal((String)text, (String)this.getText2())) {
            super.setText2(text);
            this.update();
        }
    }

    private void update() {
        if (this.myDialog != null) {
            this.myDialog.update();
        }
    }

    public void setTitle(String title) {
        if (!Comparing.equal((String)title, (String)this.myTitle)) {
            this.myTitle = title;
            this.update();
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setBackgroundHandler(@Nullable Runnable backgroundHandler) {
        this.myBackgroundHandler = backgroundHandler;
        this.myDialog.setShouldShowBackground(backgroundHandler != null);
    }

    public void setCancelButtonText(String text) {
        if (this.myDialog != null) {
            this.myDialog.changeCancelButtonText(text);
        } else {
            this.myCancelText = text;
        }
    }

    IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void dispose() {
        this.stopSystemActivity();
        if (this.isRunning()) {
            this.cancel();
        }
    }

    @Override
    public boolean isPopupWasShown() {
        return this.myDialog != null && this.myDialog.myPopup != null && this.myDialog.myPopup.isShowing();
    }

    private void enableCancel(boolean enable) {
        if (this.myDialog != null) {
            this.myDialog.enableCancelButtonIfNeeded(enable);
        }
    }

    @Override
    public String toString() {
        return this.getTitle() + " " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "init", "com/intellij/openapi/progress/util/ProgressWindow", "startBlocking"));
    }

    @FunctionalInterface
    public static interface Listener {
        public void progressWindowCreated(ProgressWindow var1);
    }
}

