/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.CachedVcsContext;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsContextWrapper
implements VcsContext {
    @NotNull
    protected final DataContext myContext;
    protected final int myModifiers;
    @NotNull
    private final String myPlace;
    @Nullable
    private final String myActionName;

    public VcsContextWrapper(@NotNull DataContext context, int modifiers, @NotNull String place, @Nullable String actionName) {
        if (context == null) {
            VcsContextWrapper.$$$reportNull$$$0(0);
        }
        if (place == null) {
            VcsContextWrapper.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myModifiers = modifiers;
        this.myPlace = place;
        this.myActionName = actionName;
    }

    @NotNull
    public String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            VcsContextWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getActionName() {
        return this.myActionName;
    }

    @NotNull
    public static VcsContext createCachedInstanceOn(@NotNull AnActionEvent event) {
        if (event == null) {
            VcsContextWrapper.$$$reportNull$$$0(3);
        }
        CachedVcsContext cachedVcsContext = new CachedVcsContext(VcsContextWrapper.createInstanceOn(event));
        if (cachedVcsContext == null) {
            VcsContextWrapper.$$$reportNull$$$0(4);
        }
        return cachedVcsContext;
    }

    @NotNull
    public static VcsContextWrapper createInstanceOn(@NotNull AnActionEvent event) {
        if (event == null) {
            VcsContextWrapper.$$$reportNull$$$0(5);
        }
        VcsContextWrapper vcsContextWrapper = new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
        if (vcsContextWrapper == null) {
            VcsContextWrapper.$$$reportNull$$$0(6);
        }
        return vcsContextWrapper;
    }

    @Nullable
    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(this.myContext);
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        return this.getSelectedFilesStream().findFirst().orElse(null);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        VirtualFile[] fileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(this.myContext);
        if (fileArray != null) {
            VirtualFile[] virtualFileArray2 = (VirtualFile[])Stream.of(fileArray).filter(VirtualFile::isInLocalFileSystem).toArray(VirtualFile[]::new);
            if (virtualFileArray2 == null) {
                VcsContextWrapper.$$$reportNull$$$0(7);
            }
            return virtualFileArray2;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myContext);
        if (file2 != null && file2.isInLocalFileSystem()) {
            VirtualFile[] virtualFileArray3 = new VirtualFile[1];
            virtualFileArray = virtualFileArray3;
            virtualFileArray3[0] = file2;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        if (virtualFileArray == null) {
            VcsContextWrapper.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    @NotNull
    public Stream<VirtualFile> getSelectedFilesStream() {
        Stream result2 = (Stream)VcsDataKeys.VIRTUAL_FILE_STREAM.getData(this.myContext);
        Stream<VirtualFile> stream = result2 != null ? result2.filter(VirtualFile::isInLocalFileSystem) : super.getSelectedFilesStream();
        if (stream == null) {
            VcsContextWrapper.$$$reportNull$$$0(9);
        }
        return stream;
    }

    @NotNull
    public List<VirtualFile> getSelectedUnversionedFiles() {
        Stream result2 = (Stream)ChangesListView.UNVERSIONED_FILES_DATA_KEY.getData(this.myContext);
        List<Object> list2 = result2 != null ? result2.collect(Collectors.toList()) : Collections.emptyList();
        if (list2 == null) {
            VcsContextWrapper.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public Editor getEditor() {
        return (Editor)CommonDataKeys.EDITOR.getData(this.myContext);
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return Arrays.asList(this.getSelectedFiles());
    }

    @Nullable
    public File getSelectedIOFile() {
        File file2 = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        return file2 != null ? file2 : (File)ArrayUtil.getFirstElement((Object[])((Object[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext)));
    }

    @Nullable
    public File[] getSelectedIOFiles() {
        File[] fileArray;
        Object[] files2 = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (!ArrayUtil.isEmpty((Object[])files2)) {
            return files2;
        }
        File file2 = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        if (file2 != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file2;
        } else {
            fileArray = null;
        }
        return fileArray;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public Refreshable getRefreshableDialog() {
        return (Refreshable)Refreshable.PANEL_KEY.getData(this.myContext);
    }

    @NotNull
    public FilePath[] getSelectedFilePaths() {
        FilePath[] filePathArray = (FilePath[])this.getSelectedFilePathsStream().toArray(FilePath[]::new);
        if (filePathArray == null) {
            VcsContextWrapper.$$$reportNull$$$0(11);
        }
        return filePathArray;
    }

    @NotNull
    public Stream<FilePath> getSelectedFilePathsStream() {
        FilePath path = (FilePath)VcsDataKeys.FILE_PATH.getData(this.myContext);
        Stream stream = UtilKt.concat((Stream[])new Stream[]{path != null ? Stream.of(path) : Stream.empty(), UtilKt.stream((Object[])((Object[])VcsDataKeys.FILE_PATH_ARRAY.getData(this.myContext))), this.getSelectedFilesStream().map(VcsUtil::getFilePath), UtilKt.stream((Object[])this.getSelectedIOFiles()).map(VcsUtil::getFilePath)});
        if (stream == null) {
            VcsContextWrapper.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @Nullable
    public FilePath getSelectedFilePath() {
        return (FilePath)ArrayUtil.getFirstElement((Object[])this.getSelectedFilePaths());
    }

    @Nullable
    public ChangeList[] getSelectedChangeLists() {
        return (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(this.myContext);
    }

    @Nullable
    public Change[] getSelectedChanges() {
        return (Change[])VcsDataKeys.CHANGES.getData(this.myContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsContextWrapper";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsContextWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedInstanceOn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstanceOn";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilesStream";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilePaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilePathsStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCachedInstanceOn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInstanceOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

