/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveChangesToAnotherListAction
extends AnAction
implements DumbAware {
    public MoveChangesToAnotherListAction() {
        super(ActionsBundle.actionText((String)"ChangesView.Move"), ActionsBundle.actionDescription((String)"ChangesView.Move"), AllIcons.Actions.MoveToAnotherChangelist);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(0);
        }
        boolean isEnabled = this.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setEnabledAndVisible(isEnabled);
        } else {
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            return false;
        }
        return !UtilKt.isEmpty((Stream)((Stream)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY))) || !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES))) || !ArrayUtil.isEmpty((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
    }

    @NotNull
    private static List<Change> getChangesForSelectedFiles(@NotNull Project project, @NotNull VirtualFile[] selectedFiles, @NotNull List<VirtualFile> unversionedFiles, @NotNull List<VirtualFile> changedFiles) {
        if (project == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(2);
        }
        if (selectedFiles == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(3);
        }
        if (unversionedFiles == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(4);
        }
        if (changedFiles == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(5);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        for (VirtualFile vFile : selectedFiles) {
            Change change = changeListManager.getChange(vFile);
            if (change == null) {
                FileStatus status = changeListManager.getStatus(vFile);
                if (FileStatus.UNKNOWN.equals(status)) {
                    unversionedFiles.add(vFile);
                    changedFiles.add(vFile);
                    continue;
                }
                if (!FileStatus.NOT_CHANGED.equals(status) || !vFile.isDirectory()) continue;
                MoveChangesToAnotherListAction.addAllChangesUnderPath(changeListManager, VcsUtil.getFilePath((VirtualFile)vFile), changes, changedFiles);
                continue;
            }
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            if (afterPath != null && afterPath.isDirectory()) {
                MoveChangesToAnotherListAction.addAllChangesUnderPath(changeListManager, afterPath, changes, changedFiles);
                continue;
            }
            changes.add(change);
            changedFiles.add(vFile);
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void addAllChangesUnderPath(@NotNull ChangeListManager changeListManager, @NotNull FilePath file2, @NotNull List<Change> changes, @NotNull List<VirtualFile> changedFiles) {
        if (changeListManager == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(8);
        }
        if (changes == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(9);
        }
        if (changedFiles == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(10);
        }
        for (Change change : changeListManager.getChangesIn(file2)) {
            changes.add(change);
            FilePath path = ChangesUtil.getAfterPath((Change)change);
            if (path == null || path.getVirtualFile() == null) continue;
            changedFiles.add(path.getVirtualFile());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(11);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ArrayList changesList = ContainerUtil.newArrayList();
        Object[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes != null) {
            ContainerUtil.addAll((Collection)changesList, (Object[])changes);
        }
        ArrayList unversionedFiles = ContainerUtil.newArrayList();
        ArrayList changedFiles = ContainerUtil.newArrayList();
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null && changesList.isEmpty()) {
            changesList.addAll(MoveChangesToAnotherListAction.getChangesForSelectedFiles(project, files2, unversionedFiles, changedFiles));
        }
        if (changesList.isEmpty() && unversionedFiles.isEmpty()) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Nothing is selected that can be moved", MessageType.INFO, new NamedRunnable[0]);
            return;
        }
        if (!MoveChangesToAnotherListAction.askAndMove(project, changesList, unversionedFiles)) {
            return;
        }
        if (!changedFiles.isEmpty()) {
            MoveChangesToAnotherListAction.selectAndShowFile(project, (VirtualFile)changedFiles.get(0));
        }
    }

    private static void selectAndShowFile(@NotNull Project project, @NotNull VirtualFile file2) {
        ToolWindow window;
        if (project == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(13);
        }
        if (!(window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID)).isVisible()) {
            window.activate(() -> {
                if (project == null) {
                    MoveChangesToAnotherListAction.$$$reportNull$$$0(23);
                }
                if (file2 == null) {
                    MoveChangesToAnotherListAction.$$$reportNull$$$0(24);
                }
                ChangesViewManager.getInstance(project).selectFile(file2);
            });
        }
    }

    public static boolean askAndMove(@NotNull Project project, @NotNull Collection<Change> changes, @NotNull List<VirtualFile> unversionedFiles) {
        if (project == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(14);
        }
        if (changes == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(15);
        }
        if (unversionedFiles == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(16);
        }
        if (changes.isEmpty() && unversionedFiles.isEmpty()) {
            return false;
        }
        LocalChangeList targetList = MoveChangesToAnotherListAction.askTargetList(project, changes);
        if (targetList != null) {
            ChangeListManagerImpl listManager = ChangeListManagerImpl.getInstanceImpl(project);
            listManager.moveChangesTo(targetList, (Change[])ArrayUtil.toObjectArray(changes, Change.class));
            if (!unversionedFiles.isEmpty()) {
                listManager.addUnversionedFiles(targetList, unversionedFiles);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static LocalChangeList askTargetList(@NotNull Project project, @NotNull Collection<Change> changes) {
        ChangeListManagerImpl listManager;
        List<LocalChangeList> nonAffectedLists;
        if (project == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(17);
        }
        if (changes == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(18);
        }
        List<LocalChangeList> suggestedLists = (nonAffectedLists = MoveChangesToAnotherListAction.getNonAffectedLists((listManager = ChangeListManagerImpl.getInstanceImpl(project)).getChangeListsCopy(), changes)).isEmpty() ? Collections.singletonList(listManager.getDefaultChangeList()) : nonAffectedLists;
        ChangeList defaultSelection2 = MoveChangesToAnotherListAction.guessPreferredList(nonAffectedLists);
        ChangeListChooser chooser = new ChangeListChooser(project, suggestedLists, defaultSelection2, ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]), null);
        chooser.show();
        return chooser.getSelectedList();
    }

    @Nullable
    public static ChangeList guessPreferredList(@NotNull List<LocalChangeList> lists) {
        LocalChangeList activeChangeList;
        if (lists == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(19);
        }
        if ((activeChangeList = (LocalChangeList)ContainerUtil.find(lists, LocalChangeList::isDefault)) != null) {
            return activeChangeList;
        }
        LocalChangeList emptyList = (LocalChangeList)ContainerUtil.find(lists, list2 -> list2.getChanges().isEmpty());
        return (ChangeList)ObjectUtils.chooseNotNull((Object)emptyList, (Object)ContainerUtil.getFirstItem(lists));
    }

    @NotNull
    private static List<LocalChangeList> getNonAffectedLists(@NotNull List<LocalChangeList> lists, @NotNull Collection<Change> changes) {
        if (lists == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(20);
        }
        if (changes == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(21);
        }
        HashSet changesSet = ContainerUtil.newHashSet(changes);
        List list3 = ContainerUtil.findAll(lists, list2 -> !ContainerUtil.intersects((Collection)changesSet, (Collection)list2.getChanges()));
        if (list3 == null) {
            MoveChangesToAnotherListAction.$$$reportNull$$$0(22);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFiles";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unversionedFiles";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFiles";
                break;
            }
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 8: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesForSelectedFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonAffectedLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChangesForSelectedFiles";
                break;
            }
            case 6: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addAllChangesUnderPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "selectAndShowFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "askAndMove";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "askTargetList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "guessPreferredList";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNonAffectedLists";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectAndShowFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

