/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.ex.MoveChangesLineStatusAction;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLocalChangeListDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final String myChangelistId;
    @NotNull
    private final String myChangelistName;
    @NotNull
    private final PartialLocalLineStatusTracker myTracker;
    private final boolean myAllowExcludeChangesFromCommit;

    public SimpleLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        if (context == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(0);
        }
        if (localRequest == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (DiffRequest)localRequest.getRequest());
        this.myChangelistId = localRequest.getChangelistId();
        this.myChangelistName = localRequest.getChangelistName();
        this.myTracker = (PartialLocalLineStatusTracker)ObjectUtils.notNull((Object)localRequest.getLineStatusTracker());
        this.myTracker.addListener(new MyTrackerListener(), (Disposable)this);
        DiffUtil.registerAction((AnAction)new MoveSelectedChangesToAnotherChangelistAction(true), this.myPanel);
        DiffUtil.registerAction((AnAction)new ExcludeSelectedChangesFromCommitAction(true), this.myPanel);
        this.myAllowExcludeChangesFromCommit = Boolean.TRUE.equals(context.getUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT));
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = super.getProject();
        if (project == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public PartialLocalLineStatusTracker getTracker() {
        PartialLocalLineStatusTracker partialLocalLineStatusTracker = this.myTracker;
        if (partialLocalLineStatusTracker == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(3);
        }
        return partialLocalLineStatusTracker;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(super.createEditorPopupActions());
        group.add((AnAction)new MoveSelectedChangesToAnotherChangelistAction(false));
        group.add((AnAction)new ExcludeSelectedChangesFromCommitAction(false));
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        TrackerData data;
        block26: {
            block25: {
                block24: {
                    block23: {
                        if (indicator == null) {
                            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(5);
                        }
                        if (this.getContent2().getDocument() != this.myTracker.getDocument()) {
                            Runnable runnable3 = this.applyNotification(DiffNotifications.createError());
                            if (runnable3 == null) {
                                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(6);
                            }
                            return runnable3;
                        }
                        indicator.checkCanceled();
                        data = (TrackerData)ReadAction.compute(() -> {
                            boolean isReleased = this.myTracker.isReleased();
                            boolean isOperational = this.myTracker.isOperational();
                            List<String> affectedChangelistIds = this.myTracker.getAffectedChangeListsIds();
                            List<PartialLocalLineStatusTracker.LocalRange> ranges = null;
                            CharSequence localText = null;
                            CharSequence vcsText = null;
                            CharSequence trackerVcsText = null;
                            if (isOperational) {
                                ranges = this.myTracker.getRanges();
                                localText = this.getContent2().getDocument().getImmutableCharSequence();
                                vcsText = this.getContent1().getDocument().getImmutableCharSequence();
                                trackerVcsText = this.myTracker.getVcsDocument().getImmutableCharSequence();
                            }
                            return new TrackerData(isReleased, isOperational, affectedChangelistIds, ranges, localText, vcsText, trackerVcsText);
                        });
                        if (!data.isReleased) break block23;
                        Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
                        if (runnable4 == null) {
                            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(7);
                        }
                        return runnable4;
                    }
                    if (data.isOperational || data.affectedChangelist.size() != 1 || !data.affectedChangelist.contains(this.myChangelistId)) break block24;
                    Runnable callback = super.performRediff(indicator);
                    Runnable runnable5 = () -> {
                        callback.run();
                        this.getStatusPanel().setBusy(true);
                    };
                    if (runnable5 == null) {
                        SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(8);
                    }
                    return runnable5;
                }
                if (data.ranges == null) {
                    this.scheduleRediff();
                    throw new ProcessCanceledException();
                }
                assert (data.localText != null);
                assert (data.vcsText != null);
                assert (data.trackerVcsText != null);
                if (StringUtil.equals((CharSequence)data.trackerVcsText, (CharSequence)data.vcsText)) break block25;
                Runnable runnable6 = this.applyNotification(DiffNotifications.createError());
                if (runnable6 == null) {
                    SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(9);
                }
                return runnable6;
            }
            if (!this.myTextDiffProvider.isHighlightingDisabled()) break block26;
            Runnable runnable7 = this.apply(new SimpleDiffViewer.CompareData(null, data.ranges.isEmpty()));
            if (runnable7 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(10);
            }
            return runnable7;
        }
        try {
            List linesRanges = ContainerUtil.map(data.ranges, range2 -> new Range(range2.getVcsLine1(), range2.getVcsLine2(), range2.getLine1(), range2.getLine2()));
            List newFragments = (List)ObjectUtils.notNull(this.myTextDiffProvider.compare(data.vcsText, data.localText, linesRanges, indicator));
            boolean isContentsEqual = data.ranges.isEmpty();
            ArrayList<SimpleDiffChange> changes = new ArrayList<SimpleDiffChange>();
            for (int i = 0; i < data.ranges.size(); ++i) {
                PartialLocalLineStatusTracker.LocalRange localRange = data.ranges.get(i);
                List rangeFragments = (List)newFragments.get(i);
                boolean isExcludedFromCommit = localRange.isExcludedFromCommit();
                boolean isFromActiveChangelist = localRange.getChangelistId().equals(this.myChangelistId);
                boolean isSkipped = !isFromActiveChangelist;
                boolean isExcluded = !isFromActiveChangelist || this.myAllowExcludeChangesFromCommit && isExcludedFromCommit;
                changes.addAll(ContainerUtil.map((Collection)rangeFragments, fragment -> new MySimpleDiffChange((LineFragment)fragment, isExcluded, isSkipped, localRange.getChangelistId(), isExcludedFromCommit)));
            }
            runnable2 = this.apply(new SimpleDiffViewer.CompareData(changes, isContentsEqual));
        }
        catch (DiffTooBigException e) {
            Runnable runnable8 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable8 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(12);
            }
            return runnable8;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable9 = this.applyNotification(DiffNotifications.createError());
            if (runnable9 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(13);
            }
            return runnable9;
        }
        if (runnable2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(11);
        }
        return runnable2;
    }

    @NotNull
    private static BitSet getLocalSelectedLines(@NotNull List<MySimpleDiffChange> changes) {
        if (changes == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(14);
        }
        BitSet selectedLines = new BitSet();
        for (SimpleDiffChange simpleDiffChange : changes) {
            int endLine;
            int startLine;
            selectedLines.set(startLine, (startLine = simpleDiffChange.getStartLine(Side.RIGHT)) == (endLine = simpleDiffChange.getEndLine(Side.RIGHT)) ? startLine + 1 : endLine);
        }
        BitSet bitSet = selectedLines;
        if (bitSet == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(15);
        }
        return bitSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRequest";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSelectedLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSelectedLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrackerData {
        private final boolean isReleased;
        public final boolean isOperational;
        @NotNull
        public final List<String> affectedChangelist;
        @Nullable
        public final List<PartialLocalLineStatusTracker.LocalRange> ranges;
        @Nullable
        public final CharSequence localText;
        @Nullable
        public final CharSequence vcsText;
        @Nullable
        public final CharSequence trackerVcsText;

        public TrackerData(boolean isReleased, boolean isOperational, @NotNull List<String> affectedChangelist, @Nullable List<PartialLocalLineStatusTracker.LocalRange> ranges, @Nullable CharSequence localText, @Nullable CharSequence vcsText, @Nullable CharSequence trackerVcsText) {
            if (affectedChangelist == null) {
                TrackerData.$$$reportNull$$$0(0);
            }
            this.isReleased = isReleased;
            this.isOperational = isOperational;
            this.affectedChangelist = affectedChangelist;
            this.ranges = ranges;
            this.localText = localText;
            this.vcsText = vcsText;
            this.trackerVcsText = trackerVcsText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedChangelist", "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$TrackerData", "<init>"));
        }
    }

    private class ExcludeSelectedChangesFromCommitAction
    extends DumbAwareAction {
        private final boolean myShortcut;

        public ExcludeSelectedChangesFromCommitAction(boolean shortcut) {
            this.myShortcut = shortcut;
            ActionUtil.copyFrom((AnAction)this, (String)"Vcs.Diff.ExcludeChangedLinesFromCommit");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(0);
            }
            if (!SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleLocalChangeListDiffViewer.this.getEditors(), (Object)editor);
            if (side == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            List<MySimpleDiffChange> activeChanges = this.getActiveChanges(side);
            boolean hasExcluded = ContainerUtil.or(activeChanges, MySimpleDiffChange::isExcludedFromCommit);
            e.getPresentation().setText(activeChanges.isEmpty() || !hasExcluded ? "Exclude Lines from Commit" : "Include Lines into Commit");
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(!activeChanges.isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(1);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleLocalChangeListDiffViewer.this.getEditors(), (Object)editor);
            if (editor == null || side == null) {
                return;
            }
            List<MySimpleDiffChange> activeChanges = this.getActiveChanges(side);
            if (activeChanges.isEmpty()) {
                return;
            }
            BitSet selectedLines = SimpleLocalChangeListDiffViewer.getLocalSelectedLines(activeChanges);
            boolean hasExcluded = ContainerUtil.or(activeChanges, MySimpleDiffChange::isExcludedFromCommit);
            SimpleLocalChangeListDiffViewer.this.myTracker.setExcludedFromCommit(selectedLines, !hasExcluded);
            SimpleLocalChangeListDiffViewer.this.rediff();
        }

        @NotNull
        private List<MySimpleDiffChange> getActiveChanges(@NotNull Side side) {
            if (side == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(2);
            }
            List selectedChanges = ContainerUtil.findAll((Collection)SimpleLocalChangeListDiffViewer.this.getSelectedChanges(side), MySimpleDiffChange.class);
            List list2 = ContainerUtil.filter((Collection)selectedChanges, MySimpleDiffChange::isFromActiveChangelist);
            if (list2 == null) {
                ExcludeSelectedChangesFromCommitAction.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$ExcludeSelectedChangesFromCommitAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$ExcludeSelectedChangesFromCommitAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getActiveChanges";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MoveSelectedChangesToAnotherChangelistAction
    extends DumbAwareAction {
        private final boolean myShortcut;

        public MoveSelectedChangesToAnotherChangelistAction(boolean shortcut) {
            this.myShortcut = shortcut;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Vcs.MoveChangedLinesToChangelist"));
        }

        public void update(@NotNull AnActionEvent e) {
            String text;
            if (e == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(0);
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleLocalChangeListDiffViewer.this.getEditors(), (Object)editor);
            if (side == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            List<MySimpleDiffChange> selectedChanges = this.getSelectedChanges(side);
            if (!selectedChanges.isEmpty() && ContainerUtil.and(selectedChanges, change -> !change.isFromActiveChangelist())) {
                String shortChangeListName = StringUtil.trimMiddle((String)SimpleLocalChangeListDiffViewer.this.myChangelistName, (int)40);
                text = String.format("Move to '%s' Changelist", shortChangeListName);
            } else {
                text = ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]);
            }
            e.getPresentation().setText(text);
            e.getPresentation().setIcon(AllIcons.Actions.MoveToAnotherChangelist);
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(!selectedChanges.isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(1);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleLocalChangeListDiffViewer.this.getEditors(), (Object)editor);
            if (editor == null || side == null) {
                return;
            }
            List<MySimpleDiffChange> selectedChanges = this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            BitSet selectedLines = SimpleLocalChangeListDiffViewer.getLocalSelectedLines(selectedChanges);
            if (ContainerUtil.and(selectedChanges, change -> !change.isFromActiveChangelist())) {
                LocalChangeList changeList = ChangeListManager.getInstance((Project)SimpleLocalChangeListDiffViewer.this.getProject()).getChangeList(SimpleLocalChangeListDiffViewer.this.myChangelistId);
                if (changeList != null) {
                    SimpleLocalChangeListDiffViewer.this.myTracker.moveToChangelist(selectedLines, changeList);
                }
            } else {
                MoveChangesLineStatusAction.moveToAnotherChangelist(SimpleLocalChangeListDiffViewer.this.myTracker, selectedLines);
            }
            SimpleLocalChangeListDiffViewer.this.rediff();
        }

        @NotNull
        private List<MySimpleDiffChange> getSelectedChanges(@NotNull Side side) {
            if (side == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(2);
            }
            List list2 = ContainerUtil.findAll((Collection)SimpleLocalChangeListDiffViewer.this.getSelectedChanges(side), MySimpleDiffChange.class);
            if (list2 == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MoveSelectedChangesToAnotherChangelistAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MoveSelectedChangesToAnotherChangelistAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedChanges";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyTrackerListener
    extends PartialLocalLineStatusTracker.ListenerAdapter {
        private MyTrackerListener() {
        }

        @Override
        public void onBecomingValid(@NotNull PartialLocalLineStatusTracker tracker) {
            if (tracker == null) {
                MyTrackerListener.$$$reportNull$$$0(0);
            }
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        @Override
        public void onChangeListMarkerChange(@NotNull PartialLocalLineStatusTracker tracker) {
            if (tracker == null) {
                MyTrackerListener.$$$reportNull$$$0(1);
            }
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        @Override
        public void onExcludedFromCommitChange(@NotNull PartialLocalLineStatusTracker tracker) {
            if (tracker == null) {
                MyTrackerListener.$$$reportNull$$$0(2);
            }
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tracker";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyTrackerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBecomingValid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onChangeListMarkerChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onExcludedFromCommitChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySimpleDiffChange
    extends SimpleDiffChange {
        @NotNull
        private final String myChangelistId;
        private final boolean myIsExcludedFromCommit;

        public MySimpleDiffChange(LineFragment fragment, boolean isExcluded, @NotNull boolean isSkipped, String changelistId, boolean isExcludedFromCommit) {
            if (fragment == null) {
                MySimpleDiffChange.$$$reportNull$$$0(0);
            }
            if (changelistId == null) {
                MySimpleDiffChange.$$$reportNull$$$0(1);
            }
            super(SimpleLocalChangeListDiffViewer.this, fragment, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsExcludedFromCommit = isExcludedFromCommit;
        }

        @NotNull
        private SimpleLocalChangeListDiffViewer getViewer() {
            SimpleLocalChangeListDiffViewer simpleLocalChangeListDiffViewer = (SimpleLocalChangeListDiffViewer)this.myViewer;
            if (simpleLocalChangeListDiffViewer == null) {
                MySimpleDiffChange.$$$reportNull$$$0(2);
            }
            return simpleLocalChangeListDiffViewer;
        }

        public boolean isFromActiveChangelist() {
            return this.myChangelistId.equals(this.getViewer().myChangelistId);
        }

        public boolean isExcludedFromCommit() {
            return this.myIsExcludedFromCommit;
        }

        @Override
        protected void doInstallActionHighlighters() {
            super.doInstallActionHighlighters();
            if (SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit && this.isFromActiveChangelist()) {
                this.myOperations.add(new ExcludeGutterOperation());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changelistId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class ExcludeGutterOperation
        extends SimpleDiffChange.GutterOperation {
            public ExcludeGutterOperation() {
                super(Side.RIGHT);
            }

            @Override
            public GutterIconRenderer createRenderer() {
                if (!MySimpleDiffChange.this.isFromActiveChangelist()) {
                    return null;
                }
                Icon icon = MySimpleDiffChange.this.myIsExcludedFromCommit ? AllIcons.Diff.GutterCheckBox : AllIcons.Diff.GutterCheckBoxSelected;
                return new DiffGutterRenderer(icon, "Include into commit"){

                    @Override
                    protected void performAction(AnActionEvent e) {
                        if (!MySimpleDiffChange.this.isValid()) {
                            return;
                        }
                        PartialLocalLineStatusTracker tracker = MySimpleDiffChange.this.getViewer().getTracker();
                        PartialLocalLineStatusTracker.LocalRange range2 = (PartialLocalLineStatusTracker.LocalRange)tracker.getRangeForLine(MySimpleDiffChange.this.getStartLine(Side.RIGHT));
                        if (range2 == null) {
                            return;
                        }
                        tracker.setExcludedFromCommit(range2, !MySimpleDiffChange.this.myIsExcludedFromCommit);
                        MySimpleDiffChange.this.getViewer().rediff();
                    }
                };
            }
        }
    }
}

