/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesBrowserBase
extends JPanel
implements DataProvider {
    public static final DataKey<ChangesBrowserBase> DATA_KEY = DataKey.create((String)"com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase");
    @NotNull
    protected final Project myProject;
    protected final ChangesTree myViewer;
    private final DefaultActionGroup myToolBarGroup;
    private final ActionToolbar myToolbar;
    private final JScrollPane myViewerScrollPane;
    private final AnAction myShowDiffAction;
    @Nullable
    private Runnable myInclusionChangedListener;

    protected ChangesBrowserBase(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            ChangesBrowserBase.$$$reportNull$$$0(0);
        }
        this.myToolBarGroup = new DefaultActionGroup();
        this.myProject = project;
        this.myViewer = this.createTreeList(project, showCheckboxes, highlightProblems);
        DefaultActionGroup toolbarGroups = new DefaultActionGroup();
        toolbarGroups.add((AnAction)this.myToolBarGroup);
        toolbarGroups.addSeparator();
        toolbarGroups.addAll(this.myViewer.getTreeActions());
        this.myToolbar = ActionManager.getInstance().createActionToolbar("ChangesBrowser", (ActionGroup)toolbarGroups, true);
        this.myToolbar.setTargetComponent((JComponent)this);
        this.myViewer.installPopupHandler((ActionGroup)this.myToolBarGroup);
        this.myViewerScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myViewer));
        this.myShowDiffAction = new MyShowDiffAction();
    }

    @NotNull
    protected ChangesBrowserTreeList createTreeList(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            ChangesBrowserBase.$$$reportNull$$$0(1);
        }
        ChangesBrowserTreeList changesBrowserTreeList = new ChangesBrowserTreeList(this, project, showCheckboxes, highlightProblems);
        if (changesBrowserTreeList == null) {
            ChangesBrowserBase.$$$reportNull$$$0(2);
        }
        return changesBrowserTreeList;
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.createToolbarComponent(), "Center");
        JComponent headerPanel = this.createHeaderPanel();
        if (headerPanel != null) {
            topPanel.add((Component)headerPanel, "East");
        }
        this.add((Component)topPanel, "North");
        this.add((Component)this.myViewerScrollPane, "Center");
        this.myToolBarGroup.addAll(this.createToolbarActions());
        this.myShowDiffAction.registerCustomShortcutSet((JComponent)this, null);
    }

    @NotNull
    protected JComponent createToolbarComponent() {
        JComponent jComponent = this.myToolbar.getComponent();
        if (jComponent == null) {
            ChangesBrowserBase.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    protected abstract DefaultTreeModel buildTreeModel();

    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        if (userObject == null) {
            ChangesBrowserBase.$$$reportNull$$$0(4);
        }
        if (userObject instanceof Change) {
            return ChangeDiffRequestProducer.create(this.myProject, (Change)userObject);
        }
        return null;
    }

    @Nullable
    protected JComponent createHeaderPanel() {
        return null;
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        List list2 = ContainerUtil.list((Object[])new AnAction[]{this.myShowDiffAction});
        if (list2 == null) {
            ChangesBrowserBase.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    protected List<AnAction> createDiffActions() {
        List list2 = ContainerUtil.list((Object[])new AnAction[0]);
        if (list2 == null) {
            ChangesBrowserBase.$$$reportNull$$$0(6);
        }
        return list2;
    }

    protected void onDoubleClick() {
        this.showDiff();
    }

    protected void onIncludedChanged() {
        if (this.myInclusionChangedListener != null) {
            this.myInclusionChangedListener.run();
        }
    }

    public void selectEntries(@NotNull Collection<?> changes) {
        if (changes == null) {
            ChangesBrowserBase.$$$reportNull$$$0(7);
        }
        this.myViewer.setSelectedChanges(changes);
    }

    public void setInclusionChangedListener(@Nullable Runnable value) {
        this.myInclusionChangedListener = value;
    }

    public void addToolbarAction(@NotNull AnAction action) {
        if (action == null) {
            ChangesBrowserBase.$$$reportNull$$$0(8);
        }
        this.myToolBarGroup.add(action);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myViewer.getPreferredFocusedComponent();
        if (jComponent == null) {
            ChangesBrowserBase.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            ChangesBrowserBase.$$$reportNull$$$0(10);
        }
        return actionToolbar;
    }

    @NotNull
    public JScrollPane getViewerScrollPane() {
        JScrollPane jScrollPane = this.myViewerScrollPane;
        if (jScrollPane == null) {
            ChangesBrowserBase.$$$reportNull$$$0(11);
        }
        return jScrollPane;
    }

    @NotNull
    public ChangesTree getViewer() {
        ChangesTree changesTree = this.myViewer;
        if (changesTree == null) {
            ChangesBrowserBase.$$$reportNull$$$0(12);
        }
        return changesTree;
    }

    @NotNull
    public ChangesGroupingPolicyFactory getGrouping() {
        ChangesGroupingPolicyFactory changesGroupingPolicyFactory = this.myViewer.getGrouping();
        if (changesGroupingPolicyFactory == null) {
            ChangesBrowserBase.$$$reportNull$$$0(13);
        }
        return changesGroupingPolicyFactory;
    }

    @Nullable
    public Object getData(String dataId) {
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        Object viewerData = this.myViewer.getData(dataId);
        return viewerData != null ? viewerData : VcsTreeModelData.getData(this.myProject, (JTree)((Object)this.myViewer), dataId);
    }

    @NotNull
    public AnAction getDiffAction() {
        AnAction anAction = this.myShowDiffAction;
        if (anAction == null) {
            ChangesBrowserBase.$$$reportNull$$$0(14);
        }
        return anAction;
    }

    public boolean canShowDiff() {
        ListSelection<Object> selection = VcsTreeModelData.getListSelection((JTree)((Object)this.myViewer));
        return ContainerUtil.exists((Iterable)selection.getList(), entry -> this.getDiffRequestProducer(entry) != null);
    }

    public void showDiff() {
        ListSelection<Object> selection = VcsTreeModelData.getListSelection((JTree)((Object)this.myViewer));
        ListSelection producers = selection.map(this::getDiffRequestProducer);
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(producers.getList(), producers.getSelectedIndex());
        this.updateDiffContext(chain);
        DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)chain, new DiffDialogHints(null, (Component)this));
    }

    protected void updateDiffContext(@NotNull DiffRequestChain chain) {
        if (chain == null) {
            ChangesBrowserBase.$$$reportNull$$$0(15);
        }
        chain.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, this.createDiffActions());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewerScrollPane";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTreeList";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectEntries";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateDiffContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ChangesBrowserTreeList
    extends ChangesTree {
        @NotNull
        private final ChangesBrowserBase myViewer;

        public ChangesBrowserTreeList(@NotNull ChangesBrowserBase viewer, @NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
            if (viewer == null) {
                ChangesBrowserTreeList.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ChangesBrowserTreeList.$$$reportNull$$$0(1);
            }
            super(project, showCheckboxes, highlightProblems);
            this.myViewer = viewer;
            this.setDoubleClickHandler(this.myViewer::onDoubleClick);
            this.setInclusionListener(this.myViewer::onIncludedChanged);
        }

        @Override
        public final void rebuildTree() {
            DefaultTreeModel newModel = this.myViewer.buildTreeModel();
            this.updateTreeModel(newModel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserBase$ChangesBrowserTreeList";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyShowDiffAction
    extends DumbAwareAction {
        public MyShowDiffAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowDiff");
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ChangesBrowserBase.this.canShowDiff() || e.getInputEvent() instanceof KeyEvent);
        }

        public void actionPerformed(AnActionEvent e) {
            if (ChangesBrowserBase.this.canShowDiff()) {
                ChangesBrowserBase.this.showDiff();
            }
        }
    }
}

