/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002*+B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0015J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020#H\u0015J\u0016\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%J\u0016\u0010)\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%R$\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "mode", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker$Mode;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/ex/LineStatusTracker$Mode;)V", "value", "getMode", "()Lcom/intellij/openapi/vcs/ex/LineStatusTracker$Mode;", "setMode", "(Lcom/intellij/openapi/vcs/ex/LineStatusTracker$Mode;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "renderer", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker$LocalLineStatusMarkerRenderer;", "getRenderer", "()Lcom/intellij/openapi/vcs/ex/LineStatusTracker$LocalLineStatusMarkerRenderer;", "vcsDirtyScopeManager", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeManager;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fireFileUnchanged", "", "fireLinesUnchanged", "startLine", "", "endLine", "isAvailableAt", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isDetectWhitespaceChangedLines", "scrollAndShowHint", "range", "showHint", "LocalLineStatusMarkerRenderer", "Mode", "intellij.platform.vcs.impl"})
public abstract class LineStatusTracker<R extends Range>
extends LineStatusTrackerBase<R> {
    private final VcsDirtyScopeManager vcsDirtyScopeManager;
    @NotNull
    private Mode mode;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;

    @Override
    @NotNull
    protected abstract LocalLineStatusMarkerRenderer getRenderer();

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        if (Intrinsics.areEqual((Object)((Object)value), (Object)((Object)this.mode))) {
            return;
        }
        this.mode = value;
        this.updateInnerRanges();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAvailableAt(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (!(Intrinsics.areEqual((Object)((Object)this.mode), (Object)((Object)Mode.SILENT)) ^ true)) return false;
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"editor.settings");
        if (!editorSettings.isLineMarkerAreaShown()) return false;
        if (DiffUtil.isDiffEditor(editor)) return false;
        return true;
    }

    @Override
    protected boolean isDetectWhitespaceChangedLines() {
        return Intrinsics.areEqual((Object)((Object)this.mode), (Object)((Object)Mode.SMART));
    }

    @Override
    protected void fireFileUnchanged() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalSettings, (String)"GeneralSettings.getInstance()");
        if (generalSettings.isSaveOnFrameDeactivation()) {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.getProject(), new Runnable(this){
                final /* synthetic */ LineStatusTracker this$0;

                public final void run() {
                    FileDocumentManager.getInstance().saveDocument(this.this$0.getDocument());
                    boolean isEmpty2 = (Boolean)this.this$0.getDocumentTracker().readLock((Function0)new Function0<Boolean>(this){
                        final /* synthetic */ fireFileUnchanged.1 this$0;

                        public final boolean invoke() {
                            return this.this$0.this$0.getBlocks().isEmpty();
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                    if (isEmpty2) {
                        LineStatusTracker.access$getVcsDirtyScopeManager$p(this.this$0).fileDirty(this.this$0.getVirtualFile());
                    }
                }
                {
                    this.this$0 = lineStatusTracker;
                }
            });
        }
    }

    @Override
    protected void fireLinesUnchanged(int startLine, int endLine) {
        if (this.getDocument().getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        Document document = this.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        }
        ((DocumentImpl)document).clearLineModificationFlags(startLine, endLine);
    }

    public final void scrollAndShowHint(@NotNull Range range2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.getRenderer().scrollAndShow(editor, range2);
    }

    public final void showHint(@NotNull Range range2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.getRenderer().showAfterScroll(editor, range2);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public LineStatusTracker(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull Mode mode) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        super(project, document);
        this.project = project;
        this.virtualFile = virtualFile;
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsDirtyScopeManager, (String)"VcsDirtyScopeManager.getInstance(project)");
        this.vcsDirtyScopeManager = vcsDirtyScopeManager;
        this.mode = mode;
    }

    @NotNull
    public static final /* synthetic */ VcsDirtyScopeManager access$getVcsDirtyScopeManager$p(LineStatusTracker $this) {
        return $this.vcsDirtyScopeManager;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTracker$Mode;", "", "(Ljava/lang/String;I)V", "DEFAULT", "SMART", "SILENT", "intellij.platform.vcs.impl"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode DEFAULT;
        public static final /* enum */ Mode SMART;
        public static final /* enum */ Mode SILENT;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[3];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = DEFAULT = new Mode();
            modeArray[1] = SMART = new Mode();
            modeArray[2] = SILENT = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0014\u0018\u00002\u00020\u0001:\u0001\u001cB\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTracker$LocalLineStatusMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "(Lcom/intellij/openapi/vcs/ex/LineStatusTracker;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "canDoAction", "", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "e", "Ljava/awt/event/MouseEvent;", "createToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "mousePosition", "Ljava/awt/Point;", "getEditorFilter", "Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "paint", "", "g", "Ljava/awt/Graphics;", "RollbackLineStatusRangeAction", "intellij.platform.vcs.impl"})
    protected static class LocalLineStatusMarkerRenderer
    extends LineStatusMarkerPopupRenderer {
        @NotNull
        private final LineStatusTracker<?> tracker;

        @Override
        @Nullable
        protected MarkupEditorFilter getEditorFilter() {
            return MarkupEditorFilterFactory.createIsNotDiffFilter();
        }

        @Override
        protected boolean canDoAction(@NotNull Range range2, @Nullable MouseEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
            if (Intrinsics.areEqual((Object)((Object)this.getTracker().getMode()), (Object)((Object)Mode.SILENT))) {
                return false;
            }
            return super.canDoAction(range2, e);
        }

        @Override
        protected void paint(@NotNull Editor editor, @NotNull Range range2, @NotNull Graphics g) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            if (Intrinsics.areEqual((Object)((Object)this.getTracker().getMode()), (Object)((Object)Mode.SILENT))) {
                return;
            }
            super.paint(editor, range2, g);
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add((Object)new LineStatusMarkerPopupRenderer.ShowPrevChangeMarkerAction(editor, range2));
            actions.add((Object)new LineStatusMarkerPopupRenderer.ShowNextChangeMarkerAction(editor, range2));
            actions.add((Object)new RollbackLineStatusRangeAction(editor, range2));
            actions.add((Object)new LineStatusMarkerPopupRenderer.ShowLineStatusRangeDiffAction(editor, range2));
            actions.add((Object)new LineStatusMarkerPopupRenderer.CopyLineStatusRangeAction(editor, range2));
            actions.add((Object)new LineStatusMarkerPopupRenderer.ToggleByWordDiffAction(editor, range2, mousePosition));
            return actions;
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            FileType fileType = this.getTracker().getVirtualFile().getFileType();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"tracker.virtualFile.fileType");
            return fileType;
        }

        @NotNull
        public LineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        public LocalLineStatusMarkerRenderer(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            super((LineStatusTrackerBase)tracker);
            this.tracker = tracker;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTracker$LocalLineStatusMarkerRenderer$RollbackLineStatusRangeAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$RangeMarkerAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "(Lcom/intellij/openapi/vcs/ex/LineStatusTracker$LocalLineStatusMarkerRenderer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/Range;)V", "actionPerformed", "", "isEnabled", "", "intellij.platform.vcs.impl"})
        private final class RollbackLineStatusRangeAction
        extends LineStatusMarkerPopupRenderer.RangeMarkerAction {
            @Override
            protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
                return true;
            }

            @Override
            protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
                RollbackLineStatusAction.rollback((LineStatusTrackerBase)LocalLineStatusMarkerRenderer.this.getTracker(), range2, editor);
            }

            public RollbackLineStatusRangeAction(@NotNull Editor editor, Range range2) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
                super(editor, range2, "Vcs.RollbackChangedLines");
            }
        }
    }
}

