/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartialChangesUtil {
    @Nullable
    public static PartialLocalLineStatusTracker getPartialTracker(@NotNull Project project, @NotNull Change change) {
        VirtualFile file2;
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(0);
        }
        if (change == null) {
            PartialChangesUtil.$$$reportNull$$$0(1);
        }
        if ((file2 = PartialChangesUtil.getVirtualFile(change)) == null) {
            return null;
        }
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(file2);
        return (PartialLocalLineStatusTracker)ObjectUtils.tryCast(tracker, PartialLocalLineStatusTracker.class);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            PartialChangesUtil.$$$reportNull$$$0(2);
        }
        if (!((revision = change.getAfterRevision()) instanceof CurrentContentRevision)) {
            return null;
        }
        return ((CurrentContentRevision)revision).getVirtualFile();
    }

    @NotNull
    public static List<Change> processPartialChanges(@NotNull Project project, @NotNull Collection<Change> changes, boolean executeOnEDT, @NotNull PairFunction<List<ChangeListChange>, PartialLocalLineStatusTracker, Boolean> partialProcessor) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(3);
        }
        if (changes == null) {
            PartialChangesUtil.$$$reportNull$$$0(4);
        }
        if (partialProcessor == null) {
            PartialChangesUtil.$$$reportNull$$$0(5);
        }
        if (!ContainerUtil.exists(changes, it -> it instanceof ChangeListChange)) {
            ArrayList<Change> arrayList = new ArrayList<Change>(changes);
            if (arrayList == null) {
                PartialChangesUtil.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        ArrayList<Change> otherChanges = new ArrayList<Change>();
        Runnable task = () -> {
            if (changes == null) {
                PartialChangesUtil.$$$reportNull$$$0(8);
            }
            if (project == null) {
                PartialChangesUtil.$$$reportNull$$$0(9);
            }
            if (partialProcessor == null) {
                PartialChangesUtil.$$$reportNull$$$0(10);
            }
            MultiMap partialChangesMap = new MultiMap();
            for (Change change : changes) {
                if (change instanceof ChangeListChange) {
                    VirtualFile virtualFile;
                    ChangeListChange changelistChange = (ChangeListChange)change;
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (afterRevision instanceof CurrentContentRevision && (virtualFile = ((CurrentContentRevision)afterRevision).getVirtualFile()) != null) {
                        partialChangesMap.putValue((Object)virtualFile, (Object)changelistChange);
                        continue;
                    }
                    otherChanges.add(changelistChange.getChange());
                    continue;
                }
                otherChanges.add(change);
            }
            LineStatusTrackerManagerI lstManager = LineStatusTrackerManager.getInstance(project);
            for (Map.Entry entry : partialChangesMap.entrySet()) {
                VirtualFile virtualFile = (VirtualFile)entry.getKey();
                List partialChanges = (List)entry.getValue();
                Change actualChange = ((ChangeListChange)partialChanges.get(0)).getChange();
                PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)ObjectUtils.tryCast(lstManager.getLineStatusTracker(virtualFile), PartialLocalLineStatusTracker.class);
                if (tracker == null) {
                    otherChanges.add(actualChange);
                    continue;
                }
                boolean success2 = (Boolean)partialProcessor.fun((Object)partialChanges, (Object)tracker);
                if (success2) continue;
                otherChanges.add(actualChange);
            }
        };
        if (executeOnEDT && !ApplicationManager.getApplication().isDispatchThread()) {
            TransactionGuard.getInstance().submitTransactionAndWait(task);
        } else {
            task.run();
        }
        ArrayList<Change> arrayList = otherChanges;
        if (arrayList == null) {
            PartialChangesUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialProcessor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/PartialChangesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/PartialChangesUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processPartialChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPartialTracker";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processPartialChanges";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processPartialChanges$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

