/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootProblemNotifier;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBus;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class VcsRootScanner
implements BulkFileListener,
ModuleRootListener,
VcsListener {
    @NotNull
    private final VcsRootProblemNotifier myRootProblemNotifier;
    @NotNull
    private final VcsRootChecker[] myCheckers;
    @NotNull
    private final Alarm myAlarm;
    private static final long WAIT_BEFORE_SCAN = TimeUnit.SECONDS.toMillis(1L);

    public static void start(@NotNull Project project, @NotNull VcsRootChecker[] checkers) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(0);
        }
        if (checkers == null) {
            VcsRootScanner.$$$reportNull$$$0(1);
        }
        new VcsRootScanner(project, checkers).scheduleScan();
    }

    private VcsRootScanner(@NotNull Project project, @NotNull VcsRootChecker[] checkers) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(2);
        }
        if (checkers == null) {
            VcsRootScanner.$$$reportNull$$$0(3);
        }
        this.myRootProblemNotifier = VcsRootProblemNotifier.getInstance(project);
        this.myCheckers = checkers;
        MessageBus messageBus = project.getMessageBus();
        messageBus.connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        messageBus.connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            VcsRootScanner.$$$reportNull$$$0(4);
        }
        block0: for (VFileEvent vFileEvent : events) {
            String filePath = vFileEvent.getPath();
            for (VcsRootChecker checker : this.myCheckers) {
                if (!checker.isVcsDir(filePath)) continue;
                this.scheduleScan();
                continue block0;
            }
        }
    }

    public void rootsChanged(ModuleRootEvent event) {
        this.scheduleScan();
    }

    public void directoryMappingChanged() {
        this.scheduleScan();
    }

    private void scheduleScan() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myAlarm, () -> this.myRootProblemNotifier.rescanAndNotifyIfNeeded()), WAIT_BEFORE_SCAN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

