/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.sun.jna.Platform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeFileWatcherImpl
extends PluggableFileWatcher {
    private static final Logger LOG = Logger.getInstance(NativeFileWatcherImpl.class);
    private static final String PROPERTY_WATCHER_DISABLED = "idea.filewatcher.disabled";
    private static final String PROPERTY_WATCHER_EXECUTABLE_PATH = "idea.filewatcher.executable.path";
    private static final File PLATFORM_NOT_SUPPORTED = new File("(platform not supported)");
    private static final String ROOTS_COMMAND = "ROOTS";
    private static final String EXIT_COMMAND = "EXIT";
    private static final int MAX_PROCESS_LAUNCH_ATTEMPT_COUNT = 10;
    private FileWatcherNotificationSink myNotificationSink;
    private File myExecutable;
    private volatile MyProcessHandler myProcessHandler;
    private volatile int myStartAttemptCount;
    private volatile boolean myIsShuttingDown;
    private final AtomicInteger mySettingRoots = new AtomicInteger(0);
    private volatile List<String> myRecursiveWatchRoots = Collections.emptyList();
    private volatile List<String> myFlatWatchRoots = Collections.emptyList();
    private final String[] myLastChangedPaths = new String[2];
    private int myLastChangedPathIndex;
    private static final Charset CHARSET;
    private static final BaseOutputReader.Options READER_OPTIONS;

    public void initialize(@NotNull ManagingFS managingFS, @NotNull FileWatcherNotificationSink notificationSink) {
        if (managingFS == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(0);
        }
        if (notificationSink == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(1);
        }
        this.myNotificationSink = notificationSink;
        boolean disabled = this.isDisabled();
        this.myExecutable = this.getExecutable();
        if (disabled) {
            LOG.info("Native file watcher is disabled");
        } else if (this.myExecutable == null) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.found", (Object[])new Object[0]), null);
        } else if (this.myExecutable == PLATFORM_NOT_SUPPORTED) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.exists", (Object[])new Object[0]), null);
        } else if (!this.myExecutable.canExecute()) {
            String message = ApplicationBundle.message((String)"watcher.exe.not.exe", (Object[])new Object[]{this.myExecutable});
            this.notifyOnFailure(message, (notification, event) -> ShowFilePathAction.openFile(this.myExecutable));
        } else {
            try {
                this.startupProcess(false);
                LOG.info("Native file watcher is operational.");
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            }
        }
    }

    public void dispose() {
        this.myIsShuttingDown = true;
        this.shutdownProcess();
    }

    public boolean isOperational() {
        return this.myProcessHandler != null;
    }

    public boolean isSettingRoots() {
        return this.isOperational() && this.mySettingRoots.get() > 0;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(2);
        }
        if (flat == null) {
            NativeFileWatcherImpl.$$$reportNull$$$0(3);
        }
        this.setWatchRoots(recursive, flat, false);
    }

    protected boolean isDisabled() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_WATCHER_DISABLED));
    }

    @Nullable
    protected File getExecutable() {
        String execPath = System.getProperty(PROPERTY_WATCHER_EXECUTABLE_PATH);
        if (execPath != null) {
            return new File(execPath);
        }
        String[] names = null;
        if (SystemInfo.isWindows) {
            if ("win32-x86".equals(Platform.RESOURCE_PREFIX)) {
                names = new String[]{"fsnotifier.exe"};
            } else if ("win32-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                names = new String[]{"fsnotifier64.exe", "fsnotifier.exe"};
            }
        } else if (SystemInfo.isMac) {
            names = new String[]{"fsnotifier"};
        } else if (SystemInfo.isLinux) {
            if ("linux-x86".equals(Platform.RESOURCE_PREFIX)) {
                names = new String[]{"fsnotifier"};
            } else if ("linux-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                names = new String[]{"fsnotifier64"};
            } else if ("linux-arm".equals(Platform.RESOURCE_PREFIX)) {
                names = new String[]{"fsnotifier-arm"};
            }
        }
        if (names == null) {
            return PLATFORM_NOT_SUPPORTED;
        }
        return Arrays.stream(names).map(PathManager::findBinFile).filter(o -> o != null).findFirst().orElse(null);
    }

    private void notifyOnFailure(String cause, @Nullable NotificationListener listener2) {
        this.myNotificationSink.notifyUserOnFailure(cause, listener2);
    }

    private void startupProcess(boolean restart) throws IOException {
        if (this.myIsShuttingDown) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            this.myIsShuttingDown = true;
            return;
        }
        if (this.myStartAttemptCount++ > 10) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            return;
        }
        if (restart) {
            this.shutdownProcess();
        }
        LOG.info("Starting file watcher: " + this.myExecutable);
        ProcessBuilder processBuilder = new ProcessBuilder(this.myExecutable.getAbsolutePath());
        Process process2 = processBuilder.start();
        this.myProcessHandler = new MyProcessHandler(process2, this.myExecutable.getName());
        this.myProcessHandler.startNotify();
        if (restart) {
            List<String> recursive = this.myRecursiveWatchRoots;
            List<String> flat = this.myFlatWatchRoots;
            if (recursive.size() + flat.size() > 0) {
                this.setWatchRoots(recursive, flat, true);
            }
        }
    }

    private void shutdownProcess() {
        MyProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 != null) {
            if (!processHandler2.isProcessTerminated()) {
                boolean killProcess = true;
                try {
                    this.writeLine(EXIT_COMMAND);
                    boolean bl = killProcess = !processHandler2.waitFor(500L);
                    if (killProcess) {
                        LOG.warn("File watcher is still alive. Doing a force quit.");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (killProcess) {
                    processHandler2.destroyProcess();
                }
            }
            this.myProcessHandler = null;
        }
    }

    private void setWatchRoots(List<String> recursive, List<String> flat, boolean restart) {
        if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated()) {
            return;
        }
        if (ApplicationManager.getApplication().isDisposeInProgress()) {
            flat = Collections.emptyList();
            recursive = flat;
        }
        if (!restart && this.myRecursiveWatchRoots.equals(recursive) && this.myFlatWatchRoots.equals(flat)) {
            return;
        }
        this.mySettingRoots.incrementAndGet();
        this.myRecursiveWatchRoots = recursive;
        this.myFlatWatchRoots = flat;
        try {
            this.writeLine(ROOTS_COMMAND);
            for (String path : recursive) {
                this.writeLine(path);
            }
            for (String path : flat) {
                this.writeLine("|" + path);
            }
            this.writeLine("#");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void writeLine(String line) throws IOException {
        MyProcessHandler processHandler2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("<< " + line);
        }
        if ((processHandler2 = this.myProcessHandler) != null) {
            processHandler2.writeLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChangedPaths() {
        String[] stringArray = this.myLastChangedPaths;
        synchronized (this.myLastChangedPaths) {
            this.myLastChangedPathIndex = 0;
            for (int i = 0; i < this.myLastChangedPaths.length; ++i) {
                this.myLastChangedPaths[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRepetition(String path) {
        String[] stringArray = this.myLastChangedPaths;
        synchronized (this.myLastChangedPaths) {
            for (int i = 0; i < this.myLastChangedPaths.length; ++i) {
                String lastChangedPath;
                int last = this.myLastChangedPathIndex - i - 1;
                if (last < 0) {
                    last += this.myLastChangedPaths.length;
                }
                if ((lastChangedPath = this.myLastChangedPaths[last]) == null || !lastChangedPath.equals(path)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            this.myLastChangedPaths[this.myLastChangedPathIndex++] = path;
            if (this.myLastChangedPathIndex == this.myLastChangedPaths.length) {
                this.myLastChangedPathIndex = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public void startup() throws IOException {
        Application app = ApplicationManager.getApplication();
        assert (app != null && app.isUnitTestMode()) : app;
        this.myIsShuttingDown = false;
        this.myStartAttemptCount = 0;
        this.startupProcess(false);
    }

    public void shutdown() throws InterruptedException {
        Application app = ApplicationManager.getApplication();
        assert (app != null && app.isUnitTestMode()) : app;
        MyProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 != null) {
            this.myIsShuttingDown = true;
            this.shutdownProcess();
            long t = System.currentTimeMillis();
            while (!processHandler2.isProcessTerminated()) {
                if (System.currentTimeMillis() - t > 5000L) {
                    throw new InterruptedException("Timed out waiting watcher process to terminate");
                }
                TimeoutUtil.sleep((long)100L);
            }
        }
    }

    static {
        Charset cs = null;
        try {
            cs = SystemInfo.isWindows | SystemInfo.isMac ? CharsetToolkit.UTF8_CHARSET : Charset.forName(System.getProperty("sun.jnu.encoding"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CHARSET = cs;
        READER_OPTIONS = new BaseOutputReader.Options(){

            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            public boolean sendIncompleteLines() {
                return false;
            }

            public boolean withSeparators() {
                return false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managingFS";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initialize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setWatchRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyProcessHandler
    extends OSProcessHandler {
        private final BufferedWriter myWriter;
        private WatcherOp myLastOp;
        private final List<String> myLines;

        private MyProcessHandler(@NotNull Process process2, String commandLine) {
            if (process2 == null) {
                MyProcessHandler.$$$reportNull$$$0(0);
            }
            if (commandLine == null) {
                MyProcessHandler.$$$reportNull$$$0(1);
            }
            super(process2, commandLine, CHARSET);
            this.myLines = ContainerUtil.newArrayList();
            this.myWriter = new BufferedWriter(this.writer(process2.getOutputStream()));
        }

        private OutputStreamWriter writer(OutputStream stream) {
            return CHARSET != null ? new OutputStreamWriter(stream, CHARSET) : new OutputStreamWriter(stream);
        }

        private void writeLine(String line) throws IOException {
            this.myWriter.write(line);
            this.myWriter.newLine();
            this.myWriter.flush();
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = READER_OPTIONS;
            if (options == null) {
                MyProcessHandler.$$$reportNull$$$0(2);
            }
            return options;
        }

        protected void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
            String message = "Watcher terminated with exit code " + exitCode;
            if (NativeFileWatcherImpl.this.myIsShuttingDown) {
                LOG.info(message);
            } else {
                LOG.warn(message);
            }
            NativeFileWatcherImpl.this.myProcessHandler = null;
            try {
                NativeFileWatcherImpl.this.startupProcess(true);
            }
            catch (IOException e) {
                NativeFileWatcherImpl.this.shutdownProcess();
                LOG.warn("Watcher terminated and attempt to restart has failed. Exiting watching thread.", (Throwable)e);
            }
        }

        public void notifyTextAvailable(@NotNull String line, @NotNull Key outputType) {
            if (line == null) {
                MyProcessHandler.$$$reportNull$$$0(3);
            }
            if (outputType == null) {
                MyProcessHandler.$$$reportNull$$$0(4);
            }
            if (outputType == ProcessOutputTypes.STDERR) {
                LOG.warn(line);
            }
            if (outputType != ProcessOutputTypes.STDOUT) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(">> " + line);
            }
            if (this.myLastOp == null) {
                WatcherOp watcherOp;
                try {
                    watcherOp = WatcherOp.valueOf(line);
                }
                catch (IllegalArgumentException e) {
                    String message = "Illegal watcher command: '" + line + "'";
                    if (line.length() <= 20) {
                        message = message + " " + Arrays.toString(line.chars().toArray());
                    }
                    LOG.error(message);
                    return;
                }
                if (watcherOp == WatcherOp.GIVEUP) {
                    NativeFileWatcherImpl.this.notifyOnFailure(ApplicationBundle.message((String)"watcher.gave.up", (Object[])new Object[0]), null);
                    NativeFileWatcherImpl.this.myIsShuttingDown = true;
                } else if (watcherOp == WatcherOp.RESET) {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyReset(null);
                } else {
                    this.myLastOp = watcherOp;
                }
            } else if (this.myLastOp == WatcherOp.MESSAGE) {
                LOG.warn(line);
                NativeFileWatcherImpl.this.notifyOnFailure(line, NotificationListener.URL_OPENING_LISTENER);
                this.myLastOp = null;
            } else if (this.myLastOp == WatcherOp.REMAP || this.myLastOp == WatcherOp.UNWATCHEABLE) {
                if ("#".equals(line)) {
                    if (this.myLastOp == WatcherOp.REMAP) {
                        this.processRemap();
                    } else {
                        NativeFileWatcherImpl.this.mySettingRoots.decrementAndGet();
                        this.processUnwatchable();
                    }
                    this.myLines.clear();
                    this.myLastOp = null;
                } else {
                    this.myLines.add(line);
                }
            } else {
                String path = StringUtil.trimEnd((String)line.replace('\u0000', '\n'), (String)File.separator);
                this.processChange(path, this.myLastOp);
                this.myLastOp = null;
            }
        }

        private void processRemap() {
            HashSet pairs = ContainerUtil.newHashSet();
            for (int i = 0; i < this.myLines.size() - 1; i += 2) {
                pairs.add(Pair.create((Object)this.myLines.get(i), (Object)this.myLines.get(i + 1)));
            }
            NativeFileWatcherImpl.this.myNotificationSink.notifyMapping((Collection)pairs);
        }

        private void processUnwatchable() {
            NativeFileWatcherImpl.this.myNotificationSink.notifyManualWatchRoots(this.myLines);
        }

        private void processChange(String path, WatcherOp op) {
            if (SystemInfo.isWindows && op == WatcherOp.RECDIRTY) {
                NativeFileWatcherImpl.this.myNotificationSink.notifyReset(path);
                return;
            }
            if ((op == WatcherOp.CHANGE || op == WatcherOp.STATS) && NativeFileWatcherImpl.this.isRepetition(path)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("repetition: " + path);
                }
                return;
            }
            if (SystemInfo.isMac) {
                path = Normalizer.normalize(path, Normalizer.Form.NFC);
            }
            switch (op) {
                case STATS: 
                case CHANGE: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPath(path);
                    break;
                }
                case CREATE: 
                case DELETE: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyPathCreatedOrDeleted(path);
                    break;
                }
                case DIRTY: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyDirectory(path);
                    break;
                }
                case RECDIRTY: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPathRecursive(path);
                    break;
                }
                default: {
                    LOG.error("Unexpected op: " + (Object)((Object)op));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum WatcherOp {
        GIVEUP,
        RESET,
        UNWATCHEABLE,
        REMAP,
        MESSAGE,
        CREATE,
        DELETE,
        STATS,
        CHANGE,
        DIRTY,
        RECDIRTY;

    }
}

