/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.content.AdditionalIcon;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentTabStep;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.reference.SoftReference;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TabbedContentTabLabel
extends ContentTabLabel {
    private final TabbedContent myContent;
    private Reference<JBPopup> myPopupReference;

    public TabbedContentTabLabel(@NotNull TabbedContent content, @NotNull TabContentLayout layout) {
        if (content == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(1);
        }
        super((Content)content, layout);
        this.myPopupReference = null;
        this.myContent = content;
    }

    private boolean isPopupShown() {
        return this.myPopupReference != null && this.myPopupReference.get() != null && this.myPopupReference.get().isVisible();
    }

    @Override
    protected void selectContent() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        super.selectContent();
        if (this.hasMultipleTabs()) {
            SelectContentTabStep step = new SelectContentTabStep(this.getContent());
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
            this.myPopupReference = new WeakReference<ListPopup>(popup2);
            popup2.showUnderneathOf((Component)this);
            popup2.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    TabbedContentTabLabel.this.repaint();
                }
            });
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.myContent != null) {
            this.setText(this.myContent.getTabName());
        }
    }

    @Override
    protected void fillIcons(List<AdditionalIcon> icons) {
        icons.add(new AdditionalIcon(new ActiveIcon(JBUI.CurrentTheme.ToolWindow.comboTabIcon((boolean)true), JBUI.CurrentTheme.ToolWindow.comboTabIcon((boolean)false))){

            @Override
            @NotNull
            public Rectangle getRectangle() {
                Rectangle rectangle = new Rectangle(this.getX(), 0, this.getIconWidth(), TabbedContentTabLabel.this.getHeight());
                if (rectangle == null) {
                    2.$$$reportNull$$$0(0);
                }
                return rectangle;
            }

            @Override
            public boolean getActive() {
                return TabbedContentTabLabel.this.mouseOverIcon(this) || TabbedContentTabLabel.this.isPopupShown();
            }

            @Override
            public boolean getAvailable() {
                return TabbedContentTabLabel.this.hasMultipleTabs();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel$2", "getRectangle"));
            }
        });
        super.fillIcons(icons);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JBPopup popup2 = (JBPopup)SoftReference.dereference(this.myPopupReference);
        if (popup2 != null) {
            Disposer.dispose((Disposable)popup2);
            this.myPopupReference = null;
        }
    }

    @NotNull
    public TabbedContent getContent() {
        TabbedContent tabbedContent = this.myContent;
        if (tabbedContent == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(2);
        }
        return tabbedContent;
    }

    private boolean hasMultipleTabs() {
        return this.myContent != null && this.myContent.hasMultipleTabs();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

