/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IndexCacheManagerImpl
implements CacheManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.cache.impl.IndexCacheManagerImpl");
    private final Project myProject;
    private final PsiManager myPsiManager;

    public IndexCacheManagerImpl(PsiManager psiManager) {
        this.myPsiManager = psiManager;
        this.myProject = psiManager.getProject();
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myProject.isDefault()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                IndexCacheManagerImpl.$$$reportNull$$$0(2);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processFilesWithWord((Processor<PsiFile>)processor2, word, occurenceMask, scope, caseSensitively);
        PsiFile[] psiFileArray = result2.isEmpty() ? PsiFile.EMPTY_ARRAY : result2.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(3);
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getVirtualFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDefault()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                IndexCacheManagerImpl.$$$reportNull$$$0(6);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList(5);
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.collectVirtualFilesWithWord(word, occurenceMask, scope, caseSensitively, (Processor<VirtualFile>)processor2);
        VirtualFile[] virtualFileArray = result2.isEmpty() ? VirtualFile.EMPTY_ARRAY : result2.toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    private boolean collectVirtualFilesWithWord(@NotNull String word, final short occurrenceMask, final @NotNull GlobalSearchScope scope, boolean caseSensitively, final @NotNull Processor<VirtualFile> fileProcessor) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(9);
        }
        if (fileProcessor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(10);
        }
        if (this.myProject.isDefault()) {
            return true;
        }
        try {
            return (Boolean)ReadAction.compute(() -> {
                if (word == null) {
                    IndexCacheManagerImpl.$$$reportNull$$$0(14);
                }
                if (scope == null) {
                    IndexCacheManagerImpl.$$$reportNull$$$0(15);
                }
                if (fileProcessor == null) {
                    IndexCacheManagerImpl.$$$reportNull$$$0(16);
                }
                return FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)new IdIndexEntry(word, caseSensitively), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Integer>(){
                    final FileIndexFacade index;
                    {
                        this.index = FileIndexFacade.getInstance((Project)IndexCacheManagerImpl.this.myProject);
                    }

                    public boolean process(@NotNull VirtualFile file2, Integer value) {
                        if (file2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ProgressIndicatorProvider.checkCanceled();
                        int mask = value;
                        return (mask & occurrenceMask) == 0 || !this.index.shouldBeFound(scope, file2) || fileProcessor.process((Object)file2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl$1", "process"));
                    }
                }, scope);
            });
        }
        catch (IndexNotReadyException e) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public boolean processFilesWithWord(final @NotNull Processor<PsiFile> psiFileProcessor, @NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (psiFileProcessor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(11);
        }
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(13);
        }
        ArrayList result2 = new ArrayList(5);
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.collectVirtualFilesWithWord(word, occurrenceMask, scope, caseSensitively, (Processor<VirtualFile>)processor2);
        if (result2.isEmpty()) {
            return true;
        }
        ReadActionProcessor<VirtualFile> virtualFileProcessor = new ReadActionProcessor<VirtualFile>(){

            public boolean processInReadAction(VirtualFile virtualFile) {
                if (virtualFile.isValid()) {
                    PsiFile psiFile = IndexCacheManagerImpl.this.myPsiManager.findFile(virtualFile);
                    return psiFile == null || psiFileProcessor.process((Object)psiFile);
                }
                return true;
            }
        };
        for (VirtualFile vFile : result2) {
            ProgressIndicatorProvider.checkCanceled();
            if (virtualFileProcessor.process((Object)vFile)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithWord";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesWithWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithWord";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesWithWord";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectVirtualFilesWithWord";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithWord";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectVirtualFilesWithWord$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

