/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLargeFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManagerImpl
implements FileManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final Key<FileViewProvider> myPsiHardRefKey = Key.create((String)"HARD_REFERENCE_TO_PSI");
    private final PsiManagerImpl myManager;
    private final FileIndexFacade myFileIndex;
    private final AtomicReference<ConcurrentMap<VirtualFile, PsiDirectory>> myVFileToPsiDirMap = new AtomicReference();
    private final AtomicReference<ConcurrentMap<VirtualFile, FileViewProvider>> myVFileToViewProviderMap = new AtomicReference();
    private boolean myDisposed;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(PsiManagerImpl manager, FileDocumentManager fileDocumentManager, FileIndexFacade fileIndex) {
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        Disposer.register((Disposable)manager.getProject(), (Disposable)this);
        LowMemoryWatcher.register(this::processQueue, (Disposable)this);
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.processFileTypesChanged();
            }

            public void exitDumbMode() {
                FileManagerImpl.this.processFileTypesChanged();
            }
        });
    }

    public void processQueue() {
        ConcurrentMap<VirtualFile, FileViewProvider> map = this.myVFileToViewProviderMap.get();
        if (map != null) {
            map.remove(NULL);
        }
    }

    @VisibleForTesting
    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap map = this.myVFileToViewProviderMap.get();
        if (map == null) {
            map = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, (Object)ContainerUtil.createConcurrentWeakValueMap());
        }
        ConcurrentMap concurrentMap = map;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(0);
        }
        return concurrentMap;
    }

    @NotNull
    private ConcurrentMap<VirtualFile, PsiDirectory> getVFileToPsiDirMap() {
        ConcurrentMap map = this.myVFileToPsiDirMap.get();
        if (map == null) {
            map = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, (Object)ContainerUtil.createConcurrentSoftValueMap());
        }
        ConcurrentMap concurrentMap = map;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(1);
        }
        return concurrentMap;
    }

    public static void clearPsiCaches(@NotNull FileViewProvider provider) {
        if (provider == null) {
            FileManagerImpl.$$$reportNull$$$0(2);
        }
        ((AbstractFileViewProvider)provider).getCachedPsiFiles().forEach(PsiFile::clearCaches);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(3);
        }
        LanguageSubstitutors.cancelReparsing((VirtualFile)vFile);
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider == null) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile dir = vFile.getParent();
        PsiDirectory parentDir = dir == null ? null : this.getCachedDirectory(dir);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir == null) {
            event.setPropertyName("propUnloadedPsi");
            this.myManager.beforePropertyChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.propertyChanged(event);
        } else {
            event.setParent((PsiElement)parentDir);
            this.myManager.beforeChildrenChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.childrenChanged(event);
        }
    }

    public void firePropertyChangedForUnloadedPsi() {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setPropertyName("propUnloadedPsi");
        this.myManager.beforePropertyChange(event);
        this.myManager.propertyChanged(event);
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.clearViewProviders();
        this.myDisposed = true;
    }

    private void clearViewProviders() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.performPsiModification("clearViewProviders", () -> {
            ConcurrentMap<VirtualFile, FileViewProvider> map = this.myVFileToViewProviderMap.get();
            if (map != null) {
                for (FileViewProvider provider : map.values()) {
                    this.markInvalidated(provider);
                }
            }
            this.myVFileToViewProviderMap.set(null);
        });
    }

    @Override
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(this::clearViewProviders);
        this.myVFileToPsiDirMap.set(null);
        ((PsiModificationTrackerImpl)this.myManager.getModificationTracker()).incCounter();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(4);
        }
        assert (!file2.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(file2);
        if (viewProvider != null) {
            FileViewProvider fileViewProvider = viewProvider;
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(5);
            }
            return fileViewProvider;
        }
        if (file2 instanceof VirtualFileWindow) {
            throw new IllegalStateException("File " + file2 + " is invalid");
        }
        viewProvider = this.createFileViewProvider(file2, true);
        if (file2 instanceof LightVirtualFile) {
            FileViewProvider fileViewProvider = (FileViewProvider)file2.putUserDataIfAbsent(this.myPsiHardRefKey, (Object)viewProvider);
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(6);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = (FileViewProvider)ConcurrencyUtil.cacheOrGet(this.getVFileToViewProviderMap(), (Object)file2, (Object)viewProvider);
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(7);
        }
        return fileViewProvider;
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        ConcurrentMap<VirtualFile, FileViewProvider> map;
        FileViewProvider viewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(8);
        }
        FileViewProvider fileViewProvider = viewProvider = (map = this.myVFileToViewProviderMap.get()) == null ? null : (FileViewProvider)map.get(file2);
        if (viewProvider == null) {
            viewProvider = (FileViewProvider)file2.getUserData(this.myPsiHardRefKey);
        }
        return viewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, @Nullable FileViewProvider fileViewProvider) {
        FileViewProvider prev2;
        if (virtualFile == null) {
            FileManagerImpl.$$$reportNull$$$0(9);
        }
        if ((prev2 = this.findCachedViewProvider(virtualFile)) == fileViewProvider) {
            return;
        }
        if (prev2 != null) {
            DebugUtil.performPsiModification(null, () -> {
                this.markInvalidated(prev2);
                DebugUtil.onInvalidated(prev2);
            });
        }
        if (fileViewProvider == null) {
            this.getVFileToViewProviderMap().remove(virtualFile);
        } else if (virtualFile instanceof LightVirtualFile) {
            virtualFile.putUserData(this.myPsiHardRefKey, (Object)fileViewProvider);
        } else {
            this.getVFileToViewProviderMap().put(virtualFile, fileViewProvider);
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(10);
        }
        FileType fileType = file2.getFileType();
        Language language = LanguageUtil.getLanguageForPsi((Project)this.myManager.getProject(), (VirtualFile)file2);
        FileViewProviderFactory factory = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory == null ? null : factory.createFileViewProvider(file2, language, (PsiManager)this.myManager, eventSystemEnabled);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider((PsiManager)this.myManager, file2, eventSystemEnabled, fileType) : viewProvider;
        if (singleRootFileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(11);
        }
        return singleRootFileViewProvider;
    }

    @Deprecated
    public void markInitialized() {
    }

    @Deprecated
    public boolean isInitialized() {
        return true;
    }

    void processFileTypesChanged() {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        DebugUtil.performPsiModification(null, () -> {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
                    event.setPropertyName("propFileTypes");
                    this.myManager.beforePropertyChange(event);
                    this.invalidateAllPsi();
                    this.myManager.propertyChanged(event);
                });
            }
            finally {
                this.myProcessingFileTypesChange = false;
            }
        });
    }

    void invalidateAllPsi() {
        this.myVFileToPsiDirMap.set(null);
        for (FileViewProvider provider : this.getVFileToViewProviderMap().values()) {
            this.markInvalidated(provider);
        }
        this.myVFileToViewProviderMap.set(null);
    }

    void dispatchPendingEvents() {
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.myConnection.deliverImmediately();
    }

    public void checkConsistency() {
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        this.myVFileToViewProviderMap.set(null);
        for (Map.Entry entry : fileToViewProvider.entrySet()) {
            FileViewProvider fileViewProvider = (FileViewProvider)entry.getValue();
            VirtualFile vFile = (VirtualFile)entry.getKey();
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.getVFileToPsiDirMap());
        this.myVFileToPsiDirMap.set(null);
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent = vFile.getParent();
            if (parent == null) continue;
            LOG.assertTrue(this.getVFileToPsiDirMap().get(parent) != null);
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(12);
        }
        if (vFile.isDirectory()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(vFile.isValid(), (Object)"Invalid file");
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(14);
        }
        if (this.myDisposed) {
            LOG.error("Access to psi files should not be performed after project disposal: " + this.myManager.getProject());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile);
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile) {
        PsiDirectory psiDir;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(15);
        }
        if ((psiDir = (PsiDirectory)this.getVFileToPsiDirMap().get(vFile)) != null) {
            return psiDir;
        }
        if (Registry.is((String)"ide.hide.excluded.files") ? this.myFileIndex.isExcludedFile(vFile) : this.myFileIndex.isUnderIgnored(vFile)) {
            return null;
        }
        VirtualFile parent = vFile.getParent();
        if (parent != null) {
            this.findDirectoryImpl(parent);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return (PsiDirectory)ConcurrencyUtil.cacheOrGet(this.getVFileToPsiDirMap(), (Object)vFile, (Object)psiDir);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(16);
        }
        return (PsiDirectory)this.getVFileToPsiDirMap().get(vFile);
    }

    void removeFilesAndDirsRecursively(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(17);
        }
        DebugUtil.performPsiModification("removeFilesAndDirsRecursively", () -> {
            if (vFile == null) {
                FileManagerImpl.$$$reportNull$$$0(28);
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (file2.isDirectory()) {
                        FileManagerImpl.this.getVFileToPsiDirMap().remove(file2);
                    } else {
                        FileViewProvider viewProvider = (FileViewProvider)FileManagerImpl.this.getVFileToViewProviderMap().remove(file2);
                        if (viewProvider != null) {
                            FileManagerImpl.this.markInvalidated(viewProvider);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/impl/FileManagerImpl$2", "visitFile"));
                }
            });
        });
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(18);
        }
        ((AbstractFileViewProvider)viewProvider).markInvalidated();
        viewProvider.getVirtualFile().putUserData(this.myPsiHardRefKey, null);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file2) {
        FileViewProvider fileViewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(19);
        }
        return (fileViewProvider = this.findCachedViewProvider(file2)) != null ? ((AbstractFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        for (FileViewProvider provider : this.getVFileToViewProviderMap().values()) {
            ContainerUtil.addIfNotNull(files2, (Object)((AbstractFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        ArrayList<PsiFile> arrayList = files2;
        if (arrayList == null) {
            FileManagerImpl.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private void removeInvalidDirs(boolean useFind) {
        THashMap fileToPsiDirMap = new THashMap(this.getVFileToPsiDirMap());
        if (useFind) {
            this.myVFileToPsiDirMap.set(null);
        }
        Iterator iterator = fileToPsiDirMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator.next();
            if (!vFile.isValid()) {
                iterator.remove();
                continue;
            }
            PsiDirectory psiDir = this.findDirectory(vFile);
            if (psiDir != null) continue;
            iterator.remove();
        }
        this.myVFileToPsiDirMap.set(null);
        this.getVFileToPsiDirMap().putAll((Map<VirtualFile, PsiDirectory>)fileToPsiDirMap);
    }

    void removeInvalidFilesAndDirs(boolean useFind) {
        this.removeInvalidDirs(useFind);
        THashMap fileToPsiFileMap = new THashMap(this.getVFileToViewProviderMap());
        THashMap originalFileToPsiFileMap = new THashMap(this.getVFileToViewProviderMap());
        if (useFind) {
            this.myVFileToViewProviderMap.set(null);
        }
        Iterator iterator = fileToPsiFileMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator.next();
            if (!vFile.isValid()) {
                iterator.remove();
                continue;
            }
            if (!useFind) continue;
            FileViewProvider view = (FileViewProvider)fileToPsiFileMap.get(vFile);
            if (view == null) {
                iterator.remove();
                continue;
            }
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null) {
                iterator.remove();
                continue;
            }
            if (!FileManagerImpl.areViewProvidersEquivalent(view, psiFile1.getViewProvider())) {
                iterator.remove();
                continue;
            }
            FileManagerImpl.clearPsiCaches(view);
        }
        this.myVFileToViewProviderMap.set(null);
        this.getVFileToViewProviderMap().putAll((Map<VirtualFile, FileViewProvider>)fileToPsiFileMap);
        this.markInvalidations((Map<VirtualFile, FileViewProvider>)originalFileToPsiFileMap);
    }

    static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1 == null) {
            FileManagerImpl.$$$reportNull$$$0(21);
        }
        if (view2 == null) {
            FileManagerImpl.$$$reportNull$$$0(22);
        }
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null) {
            return psi2 == null;
        }
        return psi1.getClass() == psi2.getClass();
    }

    private void markInvalidations(@NotNull Map<VirtualFile, FileViewProvider> originalFileToPsiFileMap) {
        if (originalFileToPsiFileMap == null) {
            FileManagerImpl.$$$reportNull$$$0(23);
        }
        DebugUtil.performPsiModification(null, () -> {
            if (originalFileToPsiFileMap == null) {
                FileManagerImpl.$$$reportNull$$$0(27);
            }
            for (Map.Entry entry : originalFileToPsiFileMap.entrySet()) {
                FileViewProvider viewProvider = (FileViewProvider)entry.getValue();
                if (this.getVFileToViewProviderMap().get(entry.getKey()) == viewProvider) continue;
                this.markInvalidated(viewProvider);
            }
        });
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = file2.getVirtualFile();
        assert (vFile != null);
        if (file2 instanceof PsiBinaryFile) {
            return;
        }
        FileDocumentManager fileDocumentManager = this.myFileDocumentManager;
        Document document = fileDocumentManager.getCachedDocument(vFile);
        if (document != null) {
            fileDocumentManager.reloadFromDisk(document);
        } else {
            this.reloadPsiAfterTextChange(file2, vFile);
        }
    }

    void reloadPsiAfterTextChange(@NotNull PsiFile file2, @NotNull VirtualFile vFile) {
        FileViewProvider latestProvider;
        PsiFile psi;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(25);
        }
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(26);
        }
        if ((psi = (latestProvider = this.createFileViewProvider(vFile, false)).getPsi(latestProvider.getBaseLanguage())) instanceof PsiLargeFile || psi instanceof PsiBinaryFile) {
            this.forceReload(vFile);
            return;
        }
        ((AbstractFileViewProvider)file2.getViewProvider()).onContentReload();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 19: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view1";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view2";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileToPsiFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToViewProviderMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToPsiDirMap";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileViewProvider";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCachedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearPsiCaches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forceReload";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findViewProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCachedViewProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setViewProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFileViewProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesAndDirsRecursively";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidated";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFileInner";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "areViewProvidersEquivalent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidations";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "reloadPsiAfterTextChange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$markInvalidations$5";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeFilesAndDirsRecursively$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

