/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.IndexPatternOccurrenceImpl;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.text.CharSequenceSubSequence;
import gnu.trove.TIntArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class IndexPatternSearcher
implements QueryExecutor<IndexPatternOccurrence, IndexPatternSearch.SearchParameters> {
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    public boolean execute(@NotNull IndexPatternSearch.SearchParameters queryParameters, @NotNull Processor<IndexPatternOccurrence> consumer) {
        if (queryParameters == null) {
            IndexPatternSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            IndexPatternSearcher.$$$reportNull$$$0(1);
        }
        PsiFile file2 = queryParameters.getFile();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (file2 instanceof PsiBinaryFile || file2 instanceof PsiCompiledElement || virtualFile == null) {
            return true;
        }
        TodoCacheManager cacheManager = TodoCacheManager.SERVICE.getInstance(file2.getProject());
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        int count = patternProvider != null ? cacheManager.getTodoCount(virtualFile, patternProvider) : cacheManager.getTodoCount(virtualFile, queryParameters.getPattern());
        return count == 0 || IndexPatternSearcher.executeImpl(queryParameters, consumer);
    }

    protected static boolean executeImpl(IndexPatternSearch.SearchParameters queryParameters, Processor<IndexPatternOccurrence> consumer) {
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        PsiFile file2 = queryParameters.getFile();
        TIntArrayList commentStarts = new TIntArrayList();
        TIntArrayList commentEnds = new TIntArrayList();
        CharSequence chars = file2.getViewProvider().getContents();
        IndexPatternSearcher.findCommentTokenRanges(file2, chars, queryParameters.getRange(), commentStarts, commentEnds);
        TIntArrayList occurrences = new TIntArrayList(1);
        IndexPattern[] patterns = patternProvider != null ? patternProvider.getIndexPatterns() : null;
        for (int i = 0; i < commentStarts.size(); ++i) {
            int commentStart = commentStarts.get(i);
            int commentEnd = commentEnds.get(i);
            occurrences.resetQuick();
            if (patternProvider != null) {
                for (int j = patterns.length - 1; j >= 0; --j) {
                    if (IndexPatternSearcher.collectPatternMatches(patterns[j], chars, commentStart, commentEnd, file2, queryParameters.getRange(), consumer, occurrences)) continue;
                    return false;
                }
                continue;
            }
            if (IndexPatternSearcher.collectPatternMatches(queryParameters.getPattern(), chars, commentStart, commentEnd, file2, queryParameters.getRange(), consumer, occurrences)) continue;
            return false;
        }
        return true;
    }

    private static void findCommentTokenRanges(PsiFile file2, CharSequence chars, TextRange range2, TIntArrayList commentStarts, TIntArrayList commentEnds) {
        if (file2 instanceof PsiPlainTextFile) {
            FileType fType = file2.getFileType();
            if (fType instanceof CustomSyntaxTableFileType) {
                Lexer lexer = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fType, (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile()).getHighlightingLexer();
                IndexPatternSearcher.findComments(lexer, chars, range2, COMMENT_TOKENS, commentStarts, commentEnds, null);
            } else {
                commentStarts.add(0);
                commentEnds.add(file2.getTextLength());
            }
        } else {
            FileViewProvider viewProvider = file2.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language lang : relevantLanguages) {
                ParserDefinition parserDefinition;
                TIntArrayList commentStartsList = new TIntArrayList();
                TIntArrayList commentEndsList = new TIntArrayList();
                SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
                Lexer lexer = syntaxHighlighter.getHighlightingLexer();
                TokenSet commentTokens = null;
                IndexPatternBuilder builderForFile = null;
                for (IndexPatternBuilder builder : (IndexPatternBuilder[])Extensions.getExtensions(IndexPatternBuilder.EP_NAME)) {
                    Lexer lexerFromBuilder = builder.getIndexingLexer(file2);
                    if (lexerFromBuilder == null) continue;
                    lexer = lexerFromBuilder;
                    commentTokens = builder.getCommentTokenSet(file2);
                    builderForFile = builder;
                }
                if (builderForFile == null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) != null) {
                    commentTokens = parserDefinition.getCommentTokens();
                }
                if (commentTokens == null) continue;
                IndexPatternSearcher.findComments(lexer, chars, range2, commentTokens, commentStartsList, commentEndsList, builderForFile);
                IndexPatternSearcher.mergeCommentLists(commentStarts, commentEnds, commentStartsList, commentEndsList);
            }
        }
    }

    private static void mergeCommentLists(TIntArrayList commentStarts, TIntArrayList commentEnds, TIntArrayList commentStartsList, TIntArrayList commentEndsList) {
        if (commentStarts.isEmpty() && commentEnds.isEmpty()) {
            commentStarts.add(commentStartsList.toNativeArray());
            commentEnds.add(commentEndsList.toNativeArray());
            return;
        }
        IndexPatternSearcher.mergeSortedArrays(commentStarts, commentEnds, commentStartsList, commentEndsList);
    }

    static void mergeSortedArrays(@NotNull TIntArrayList x1, @NotNull TIntArrayList y1, @NotNull TIntArrayList x2, @NotNull TIntArrayList y2) {
        if (x1 == null) {
            IndexPatternSearcher.$$$reportNull$$$0(2);
        }
        if (y1 == null) {
            IndexPatternSearcher.$$$reportNull$$$0(3);
        }
        if (x2 == null) {
            IndexPatternSearcher.$$$reportNull$$$0(4);
        }
        if (y2 == null) {
            IndexPatternSearcher.$$$reportNull$$$0(5);
        }
        TIntArrayList newX = new TIntArrayList();
        TIntArrayList newY = new TIntArrayList();
        int i = 0;
        int j = 0;
        while (i < x1.size() && j < x2.size()) {
            if (x1.get(i) < x2.get(j) || x1.get(i) == x2.get(j) && y1.get(i) < y2.get(j)) {
                newX.add(x1.get(i));
                newY.add(y1.get(i));
                ++i;
                continue;
            }
            if (x1.get(i) > x2.get(j) || x1.get(i) == x2.get(j) && y1.get(i) > y2.get(j)) {
                newX.add(x2.get(j));
                newY.add(y2.get(j));
                ++j;
                continue;
            }
            newX.add(x1.get(i));
            newY.add(y1.get(i));
            ++i;
            ++j;
        }
        while (i < x1.size()) {
            newX.add(x1.get(i));
            newY.add(y1.get(i));
            ++i;
        }
        while (j < x2.size()) {
            newX.add(x2.get(j));
            newY.add(y2.get(j));
            ++j;
        }
        x1.clear();
        y1.clear();
        x1.add(newX.toNativeArray());
        y1.add(newY.toNativeArray());
    }

    private static void findComments(Lexer lexer, CharSequence chars, TextRange range2, TokenSet commentTokens, TIntArrayList commentStarts, TIntArrayList commentEnds, IndexPatternBuilder builderForFile) {
        IElementType tokenType;
        lexer.start(chars);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (range2 != null) {
                if (lexer.getTokenEnd() > range2.getStartOffset()) {
                    if (lexer.getTokenStart() >= range2.getEndOffset()) break;
                }
            } else {
                boolean isComment;
                boolean bl = isComment = commentTokens.contains(tokenType) || CacheUtil.isInComments(tokenType);
                if (isComment) {
                    int startDelta = builderForFile != null ? builderForFile.getCommentStartDelta(lexer.getTokenType()) : 0;
                    int endDelta = builderForFile != null ? builderForFile.getCommentEndDelta(lexer.getTokenType()) : 0;
                    int start = lexer.getTokenStart() + startDelta;
                    int end = lexer.getTokenEnd() - endDelta;
                    assert (start <= end) : "Invalid comment range: " + new TextRange(start, end) + "; lexer token range=" + new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()) + "; delta=" + new TextRange(startDelta, endDelta) + "; lexer=" + lexer + "; builder=" + builderForFile + "; chars length:" + chars.length();
                    assert (end <= chars.length()) : "Invalid comment end: " + new TextRange(start, end) + "; lexer token range=" + new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()) + "; delta=" + new TextRange(startDelta, endDelta) + "; lexer=" + lexer + "; builder=" + builderForFile + "; chars length:" + chars.length();
                    commentStarts.add(start);
                    commentEnds.add(end);
                }
            }
            lexer.advance();
        }
    }

    private static boolean collectPatternMatches(IndexPattern indexPattern, CharSequence chars, int commentStart, int commentEnd, PsiFile file2, TextRange range2, Processor<IndexPatternOccurrence> consumer, TIntArrayList matches) {
        Pattern pattern = indexPattern.getPattern();
        if (pattern != null) {
            boolean found;
            ProgressManager.checkCanceled();
            CharSequenceSubSequence input = new CharSequenceSubSequence(chars, commentStart, commentEnd);
            Matcher matcher = pattern.matcher((CharSequence)input);
            while (found = matcher.find()) {
                int end;
                int start = matcher.start() + commentStart;
                if (start != (end = matcher.end() + commentStart) && (range2 == null || range2.getStartOffset() <= start && end <= range2.getEndOffset()) && matches.indexOf(start) == -1) {
                    matches.add(start);
                    if (!consumer.process((Object)new IndexPatternOccurrenceImpl(file2, start, end, indexPattern))) {
                        return false;
                    }
                }
                ProgressManager.checkCanceled();
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "y1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "y2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/IndexPatternSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeSortedArrays";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

