/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.messages.MessageBus;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguagePusher
implements FilePropertyPusher<Language> {
    public static final Key<Language> KEY = Key.create((String)"TEMPLATE_DATA_LANGUAGE");
    private static final VfsDependentEnum<String> ourLanguagesEnumerator = new VfsDependentEnum("languages", EnumeratorStringDescriptor.INSTANCE, 1);
    private static final FileAttribute PERSISTENCE = new FileAttribute("template_language", 2, true);

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(1);
        }
        if (languageLevelUpdater == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public Key<Language> getFileDataKey() {
        Key<Language> key = KEY;
        if (key == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(3);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public Language getDefaultValue() {
        Language language = Language.ANY;
        if (language == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(4);
        }
        return language;
    }

    @Nullable
    public Language getImmediateValue(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(5);
        }
        return (Language)TemplateDataLanguageMappings.getInstance(project).getImmediateMapping(file2);
    }

    @Nullable
    public Language getImmediateValue(@NotNull Module module) {
        if (module == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(6);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(7);
        }
        return true;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(8);
        }
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(9);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Language value) throws IOException {
        DataInputStream iStream;
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(10);
        }
        if (fileOrDir == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(11);
        }
        if (value == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(12);
        }
        if ((iStream = PERSISTENCE.readAttribute(fileOrDir)) != null) {
            try {
                int oldLanguage = DataInputOutputUtil.readINT((DataInput)iStream);
                String oldLanguageId = ourLanguagesEnumerator.getById(oldLanguage);
                if (value.getID().equals(oldLanguageId)) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        if (value != Language.ANY || iStream != null) {
            try (DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);){
                DataInputOutputUtil.writeINT((DataOutput)oStream, (int)ourLanguagesEnumerator.getId(value.getID()));
            }
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, Conditions.alwaysTrue());
        }
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(13);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelUpdater";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

