/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.RenameViewDescriptor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RelatedUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameProcessor");
    protected final LinkedHashMap<PsiElement, String> myAllRenames;
    @NotNull
    private PsiElement myPrimaryElement;
    private String myNewName;
    private boolean mySearchInComments;
    private boolean mySearchTextOccurrences;
    protected boolean myForceShowPreview;
    private String myCommandName;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final List<AutomaticRenamerFactory> myRenamerFactories;
    private final List<AutomaticRenamer> myRenamers;
    private final List<UnresolvableCollisionUsageInfo> mySkippedUsages;

    public RenameProcessor(Project project, @NotNull PsiElement element, @NotNull @NonNls String newName, boolean isSearchInComments, boolean isSearchTextOccurrences) {
        if (element == null) {
            RenameProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            RenameProcessor.$$$reportNull$$$0(1);
        }
        super(project);
        this.myAllRenames = new LinkedHashMap();
        this.myNewName = null;
        this.myNonCodeUsages = new NonCodeUsageInfo[0];
        this.myRenamerFactories = new ArrayList<AutomaticRenamerFactory>();
        this.myRenamers = new ArrayList<AutomaticRenamer>();
        this.mySkippedUsages = new ArrayList<UnresolvableCollisionUsageInfo>();
        this.myPrimaryElement = element;
        RenameProcessor.assertNonCompileElement(element);
        this.mySearchInComments = isSearchInComments;
        this.mySearchTextOccurrences = isSearchTextOccurrences;
        this.setNewName(newName);
    }

    public Set<PsiElement> getElements() {
        return Collections.unmodifiableSet(this.myAllRenames.keySet());
    }

    public String getNewName(PsiElement element) {
        return this.myAllRenames.get(element);
    }

    public void addRenamerFactory(AutomaticRenamerFactory factory) {
        if (!this.myRenamerFactories.contains(factory)) {
            this.myRenamerFactories.add(factory);
        }
    }

    public void removeRenamerFactory(AutomaticRenamerFactory factory) {
        this.myRenamerFactories.remove(factory);
    }

    @Override
    public void doRun() {
        if (!this.myPrimaryElement.isValid()) {
            return;
        }
        this.prepareRenaming(this.myPrimaryElement, this.myNewName, this.myAllRenames);
        super.doRun();
    }

    public void prepareRenaming(@NotNull PsiElement element, String newName, LinkedHashMap<PsiElement, String> allRenames) {
        if (element == null) {
            RenameProcessor.$$$reportNull$$$0(2);
        }
        List<RenamePsiElementProcessor> processors = RenamePsiElementProcessor.allForElement(element);
        this.myForceShowPreview = false;
        for (RenamePsiElementProcessor processor2 : processors) {
            if (!processor2.canProcessElement(element)) continue;
            processor2.prepareRenaming(element, newName, allRenames);
            this.myForceShowPreview |= processor2.forcesShowPreview();
        }
    }

    @Nullable
    private String getHelpID() {
        return RenamePsiElementProcessor.forElement(this.myPrimaryElement).getHelpID(this.myPrimaryElement);
    }

    @Override
    public boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        int[] nArray;
        if (refUsages == null) {
            RenameProcessor.$$$reportNull$$$0(3);
        }
        Object[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap<PsiElement, String>)conflicts);
        RenamePsiElementProcessor.forElement(this.myPrimaryElement).findExistingNameConflicts(this.myPrimaryElement, this.myNewName, (MultiMap<PsiElement, String>)conflicts, this.myAllRenames);
        if (!conflicts.isEmpty()) {
            RefactoringEventData conflictData = new RefactoringEventData();
            conflictData.putUserData(RefactoringEventData.CONFLICTS_KEY, (Object)conflicts.values());
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected("refactoring.rename", conflictData);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = this.prepareConflictsDialog((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
            if (!conflictsDialog.showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        ArrayList<UsageInfo> variableUsages = new ArrayList<UsageInfo>();
        if (!this.myRenamers.isEmpty()) {
            if (!this.findRenamedVariables(variableUsages)) {
                return false;
            }
            LinkedHashMap<PsiElement, String> renames = new LinkedHashMap<PsiElement, String>();
            for (AutomaticRenamer renamer : this.myRenamers) {
                List<PsiNamedElement> variables = renamer.getElements();
                for (PsiNamedElement variable : variables) {
                    String newName = renamer.getNewName(variable);
                    if (newName == null) continue;
                    this.addElement((PsiElement)variable, newName);
                    this.prepareRenaming((PsiElement)variable, newName, renames);
                }
            }
            if (!renames.isEmpty()) {
                for (PsiElement element : renames.keySet()) {
                    RenameProcessor.assertNonCompileElement(element);
                }
                this.myAllRenames.putAll(renames);
                Runnable runnable2 = () -> {
                    for (Map.Entry entry : renames.entrySet()) {
                        UsageInfo[] usages = (UsageInfo[])ReadAction.compute(() -> RenameUtil.findUsages((PsiElement)entry.getKey(), (String)entry.getValue(), this.mySearchInComments, this.mySearchTextOccurrences, this.myAllRenames));
                        Collections.addAll(variableUsages, usages);
                    }
                };
                if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable2, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject)) {
                    return false;
                }
            }
        }
        if (this.myAllRenames.size() > 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            nArray = null;
        }
        int[] choice = nArray;
        try {
            Iterator<Map.Entry<PsiElement, String>> iterator = this.myAllRenames.entrySet().iterator();
            while (iterator.hasNext()) {
                PsiFile file2;
                PsiDirectory containingDirectory;
                Map.Entry<PsiElement, String> entry = iterator.next();
                if (entry.getKey() instanceof PsiFile && CopyFilesOrDirectoriesHandler.checkFileExist(containingDirectory = (file2 = (PsiFile)entry.getKey()).getContainingDirectory(), choice, file2, entry.getValue(), "Rename")) {
                    iterator.remove();
                    continue;
                }
                RenameUtil.checkRename(entry.getKey(), entry.getValue());
            }
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"rename.title"), (String)e.getMessage(), (String)this.getHelpID(), (Project)this.myProject);
            return false;
        }
        LinkedHashSet usagesSet = ContainerUtil.newLinkedHashSet((Object[])usagesIn);
        usagesSet.addAll(variableUsages);
        List<UnresolvableCollisionUsageInfo> conflictUsages = RenameUtil.removeConflictUsages(usagesSet);
        if (conflictUsages != null) {
            this.mySkippedUsages.addAll(conflictUsages);
        }
        refUsages.set((Object)usagesSet.toArray(UsageInfo.EMPTY_ARRAY));
        this.prepareSuccessful();
        return PsiElementRenameHandler.canRename(this.myProject, null, this.myPrimaryElement);
    }

    public static void assertNonCompileElement(PsiElement element) {
        LOG.assertTrue(!(element instanceof PsiCompiledElement), (Object)element);
    }

    private void assertValidName(PsiElement element, String newName) {
        LOG.assertTrue(RenameUtil.isValidName(this.myProject, element, newName), (Object)("element: " + element + ", newName: " + newName));
    }

    private boolean findRenamedVariables(List<UsageInfo> variableUsages) {
        Iterator<AutomaticRenamer> iterator = this.myRenamers.iterator();
        while (iterator.hasNext()) {
            AutomaticRenamer automaticVariableRenamer = iterator.next();
            if (!automaticVariableRenamer.hasAnythingToRename() || this.showAutomaticRenamingDialog(automaticVariableRenamer)) continue;
            iterator.remove();
        }
        Runnable runnable2 = () -> ApplicationManager.getApplication().runReadAction(() -> {
            for (AutomaticRenamer renamer : this.myRenamers) {
                renamer.findUsages(variableUsages, this.mySearchInComments, this.mySearchTextOccurrences, this.mySkippedUsages, this.myAllRenames);
            }
        });
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable2, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject);
    }

    protected boolean showAutomaticRenamingDialog(AutomaticRenamer automaticVariableRenamer) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PsiNamedElement element : automaticVariableRenamer.getElements()) {
                automaticVariableRenamer.setRename(element, automaticVariableRenamer.getNewName(element));
            }
            return true;
        }
        AutomaticRenamingDialog dialog2 = new AutomaticRenamingDialog(this.myProject, automaticVariableRenamer);
        return dialog2.showAndGet();
    }

    public void addElement(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            RenameProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RenameProcessor.$$$reportNull$$$0(5);
        }
        RenameProcessor.assertNonCompileElement(element);
        this.myAllRenames.put(element, newName);
    }

    private void setNewName(@NotNull String newName) {
        if (newName == null) {
            RenameProcessor.$$$reportNull$$$0(6);
        }
        this.myNewName = newName;
        this.myAllRenames.put(this.myPrimaryElement, newName);
        this.myCommandName = RefactoringBundle.message((String)"renaming.0.1.to.2", (Object[])new Object[]{UsageViewUtil.getType(this.myPrimaryElement), DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myPrimaryElement), newName});
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(7);
        }
        RenameViewDescriptor renameViewDescriptor = new RenameViewDescriptor(this.myAllRenames);
        if (renameViewDescriptor == null) {
            RenameProcessor.$$$reportNull$$$0(8);
        }
        return renameViewDescriptor;
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        this.myRenamers.clear();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>(this.myAllRenames.keySet());
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = (PsiElement)elements.get(i);
            if (element == null) {
                LOG.error("primary: " + this.myPrimaryElement + "; renamers: " + this.myRenamers);
                continue;
            }
            String newName = this.myAllRenames.get(element);
            UsageInfo[] usages = RenameUtil.findUsages(element, newName, this.mySearchInComments, this.mySearchTextOccurrences, this.myAllRenames);
            List<UsageInfo> usagesList = Arrays.asList(usages);
            result2.addAll(usagesList);
            for (AutomaticRenamerFactory factory : this.myRenamerFactories) {
                if (!factory.isApplicable(element)) continue;
                this.myRenamers.add(factory.createRenamer(element, newName, usagesList));
            }
            for (AutomaticRenamerFactory factory : (AutomaticRenamerFactory[])Extensions.getExtensions(AutomaticRenamerFactory.EP_NAME)) {
                if (factory.getOptionName() != null || !factory.isApplicable(element)) continue;
                this.myRenamers.add(factory.createRenamer(element, newName, usagesList));
            }
        }
        UsageInfo[] usageInfos = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if ((usageInfos = UsageViewUtil.removeDuplicatedUsages(usageInfos)) == null) {
            RenameProcessor.$$$reportNull$$$0(9);
        }
        return usageInfos;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            RenameProcessor.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(elements.length > 0);
        this.myPrimaryElement = elements[0];
        Iterator<String> newNames = this.myAllRenames.values().iterator();
        LinkedHashMap<PsiElement, String> newAllRenames = new LinkedHashMap<PsiElement, String>();
        for (PsiElement resolved : elements) {
            newAllRenames.put(resolved, newNames.next());
        }
        this.myAllRenames.clear();
        this.myAllRenames.putAll(newAllRenames);
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(11);
        }
        if (this.myForceShowPreview) {
            return true;
        }
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        return UsageViewUtil.reportNonRegularUsages(usages, this.myProject);
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.rename";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myPrimaryElement);
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(12);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myPrimaryElement);
        return data;
    }

    @Override
    public void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RenameProcessor.$$$reportNull$$$0(13);
        }
        ArrayList<Runnable> postRenameCallbacks = new ArrayList<Runnable>();
        MultiMap<PsiElement, UsageInfo> classified = RenameProcessor.classifyUsages(this.myAllRenames.keySet(), usages);
        for (PsiElement element : this.myAllRenames.keySet()) {
            LOG.assertTrue(element.isValid());
            String newName = this.myAllRenames.get(element);
            RefactoringElementListener elementListener = this.getTransaction().getElementListener(element);
            RenamePsiElementProcessor renamePsiElementProcessor = RenamePsiElementProcessor.forElement(element);
            Runnable postRenameCallback = renamePsiElementProcessor.getPostRenameCallback(element, newName, elementListener);
            Collection infos = classified.get((Object)element);
            try {
                RenameUtil.doRename(element, newName, infos.toArray(UsageInfo.EMPTY_ARRAY), this.myProject, elementListener);
            }
            catch (IncorrectOperationException e) {
                RenameUtil.showErrorMessage(e, element, this.myProject);
                return;
            }
            if (postRenameCallback == null) continue;
            postRenameCallbacks.add(postRenameCallback);
        }
        for (Runnable runnable2 : postRenameCallbacks) {
            runnable2.run();
        }
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            nonCodeUsages.add((NonCodeUsageInfo)usage);
        }
        this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[0]);
        if (!(this.mySkippedUsages.isEmpty() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
                if (ideFrame != null) {
                    StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                    HyperlinkListener listener2 = new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                                return;
                            }
                            Messages.showMessageDialog((String)("<html>Following usages were safely skipped:<br>" + StringUtil.join((Collection)RenameProcessor.this.mySkippedUsages, unresolvableCollisionUsageInfo -> unresolvableCollisionUsageInfo.getDescription(), (String)"<br>") + "</html>"), (String)"Not All Usages Were Renamed", null);
                        }
                    };
                    statusBar.notifyProgressByBalloon(MessageType.WARNING, "<html><body>Unable to rename certain usages. <a href=\"\">Browse</a></body></html>", null, listener2);
                }
            }, ModalityState.NON_MODAL);
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = this.myCommandName;
        if (string == null) {
            RenameProcessor.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static MultiMap<PsiElement, UsageInfo> classifyUsages(Collection<? extends PsiElement> elements, UsageInfo[] usages) {
        MultiMap result2 = new MultiMap();
        for (UsageInfo usage : usages) {
            PsiElement indirect;
            LOG.assertTrue(usage instanceof MoveRenameUsageInfo);
            if (usage.getReference() instanceof LightElement) continue;
            MoveRenameUsageInfo usageInfo = (MoveRenameUsageInfo)usage;
            if (usage instanceof RelatedUsageInfo) {
                PsiElement relatedElement = ((RelatedUsageInfo)usage).getRelatedElement();
                if (!elements.contains(relatedElement)) continue;
                result2.putValue((Object)relatedElement, (Object)usage);
                continue;
            }
            PsiElement referenced = usageInfo.getReferencedElement();
            if (elements.contains(referenced)) {
                result2.putValue((Object)referenced, (Object)usage);
                continue;
            }
            if (referenced == null || !elements.contains(indirect = referenced.getNavigationElement())) continue;
            result2.putValue((Object)indirect, (Object)usage);
        }
        return result2;
    }

    public Collection<String> getNewNames() {
        return this.myAllRenames.values();
    }

    public void setSearchInComments(boolean value) {
        this.mySearchInComments = value;
    }

    public void setSearchTextOccurrences(boolean searchTextOccurrences) {
        this.mySearchTextOccurrences = searchTextOccurrences;
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public boolean isSearchTextOccurrences() {
        return this.mySearchTextOccurrences;
    }

    public void setCommandName(String commandName) {
        this.myCommandName = commandName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setNewName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

