/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.OwnerOptional;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacPathChooserDialog
implements PathChooserDialog,
FileChooserDialog {
    private FileDialog myFileDialog;
    private final FileChooserDescriptor myFileChooserDescriptor;
    private final WeakReference<Component> myParent;
    private final Project myProject;
    private final String myTitle;
    private VirtualFile[] virtualFiles;

    public MacPathChooserDialog(FileChooserDescriptor descriptor, Component parent, Project project) {
        this.myFileChooserDescriptor = descriptor;
        this.myParent = new WeakReference<Component>(parent);
        this.myProject = project;
        this.myTitle = MacPathChooserDialog.getChooserTitle(descriptor);
        Consumer dialogConsumer = owner -> {
            this.myFileDialog = new FileDialog((Dialog)owner, this.myTitle, 0);
        };
        Consumer frameConsumer = owner -> {
            this.myFileDialog = new FileDialog((Frame)owner, this.myTitle, 0);
        };
        OwnerOptional.fromComponent(parent).ifDialog((Consumer<Dialog>)dialogConsumer).ifFrame((Consumer<Frame>)frameConsumer).ifNull((Consumer<Frame>)frameConsumer);
    }

    private static String getChooserTitle(FileChooserDescriptor descriptor) {
        String title = descriptor.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    @NotNull
    private List<VirtualFile> getChosenFiles(Stream<File> streamOfFiles) {
        ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();
        streamOfFiles.forEach(file2 -> {
            VirtualFile virtualFile = this.fileToVirtualFile((File)file2);
            if (virtualFile != null && virtualFile.isValid()) {
                virtualFiles.add(virtualFile);
            }
        });
        List<VirtualFile> list2 = FileChooserUtil.getChosenFiles(this.myFileChooserDescriptor, virtualFiles);
        if (list2 == null) {
            MacPathChooserDialog.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private VirtualFile fileToVirtualFile(File file2) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        String vfsPath = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        return localFileSystem.refreshAndFindFileByPath(vfsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void choose(@Nullable VirtualFile toSelect2, @NotNull Consumer<List<VirtualFile>> callback) {
        boolean appStarted;
        if (callback == null) {
            MacPathChooserDialog.$$$reportNull$$$0(1);
        }
        if (toSelect2 != null && toSelect2.getParent() != null) {
            String directoryName;
            String fileName = null;
            if (toSelect2.isDirectory()) {
                directoryName = toSelect2.getCanonicalPath();
            } else {
                directoryName = toSelect2.getParent().getCanonicalPath();
                fileName = toSelect2.getPath();
            }
            this.myFileDialog.setDirectory(directoryName);
            this.myFileDialog.setFile(fileName);
        }
        this.myFileDialog.setFilenameFilter((dir, name) -> {
            File file2 = new File(dir, name);
            return this.myFileChooserDescriptor.isFileSelectable(this.fileToVirtualFile(file2));
        });
        this.myFileDialog.setMultipleMode(this.myFileChooserDescriptor.isChooseMultiple());
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean bl = appStarted = commandProcessor != null;
        if (appStarted) {
            commandProcessor.enterModal();
            LaterInvocator.enterModal(this.myFileDialog);
        }
        Component parent = (Component)this.myParent.get();
        try {
            this.myFileDialog.setVisible(true);
        }
        finally {
            if (appStarted) {
                commandProcessor.leaveModal();
                LaterInvocator.leaveModal(this.myFileDialog);
                if (parent != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(parent, true));
                }
            }
        }
        Object[] files2 = this.myFileDialog.getFiles();
        List<VirtualFile> virtualFileList = this.getChosenFiles(Stream.of(files2));
        this.virtualFiles = virtualFileList.toArray(VirtualFile.EMPTY_ARRAY);
        if (!virtualFileList.isEmpty()) {
            try {
                if (virtualFileList.size() == 1) {
                    this.myFileChooserDescriptor.isFileSelectable(virtualFileList.get(0));
                }
                this.myFileChooserDescriptor.validateSelectedFiles(this.virtualFiles);
            }
            catch (Exception e) {
                if (parent == null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.myTitle);
                } else {
                    Messages.showErrorDialog((Component)parent, (String)e.getMessage(), (String)this.myTitle);
                }
                return;
            }
            if (!ArrayUtil.isEmpty((Object[])files2)) {
                callback.consume(virtualFileList);
                return;
            }
        }
        if (callback instanceof FileChooser.FileChooserConsumer) {
            ((FileChooser.FileChooserConsumer)callback).cancelled();
        }
    }

    @NotNull
    private static FileDialog createFileDialogWithoutOwner(String title, int load2) {
        FileDialog fileDialog = new FileDialog((Frame)null, title, load2);
        if (fileDialog == null) {
            MacPathChooserDialog.$$$reportNull$$$0(2);
        }
        return fileDialog;
    }

    @NotNull
    public VirtualFile[] choose(@Nullable VirtualFile toSelect2, @Nullable Project project) {
        this.choose(toSelect2, (Consumer<List<VirtualFile>>)((Consumer)files2 -> {}));
        if (this.virtualFiles == null) {
            MacPathChooserDialog.$$$reportNull$$$0(3);
        }
        return this.virtualFiles;
    }

    @NotNull
    public VirtualFile[] choose(@Nullable Project project, VirtualFile ... toSelect2) {
        if (toSelect2 == null) {
            MacPathChooserDialog.$$$reportNull$$$0(4);
        }
        VirtualFile[] virtualFileArray = this.choose(toSelect2.length > 0 ? toSelect2[0] : null, project);
        if (virtualFileArray == null) {
            MacPathChooserDialog.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/MacPathChooserDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenFiles";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/MacPathChooserDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileDialogWithoutOwner";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "choose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

