/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogRevisionFilterImpl;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryFilterUi
implements VcsLogFilterUi {
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final CommitId myRevision;
    @NotNull
    private final FileHistoryUiProperties myProperties;

    public FileHistoryFilterUi(@NotNull FilePath path, @Nullable CommitId revision, @NotNull FileHistoryUiProperties properties) {
        if (path == null) {
            FileHistoryFilterUi.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            FileHistoryFilterUi.$$$reportNull$$$0(1);
        }
        this.myPath = path;
        this.myProperties = properties;
        this.myRevision = revision;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogStructureFilterImpl fileFilter = new VcsLogStructureFilterImpl((Collection<FilePath>)Collections.singleton(this.myPath));
        if (this.myRevision != null) {
            VcsLogRevisionFilterImpl revisionFilter = VcsLogRevisionFilterImpl.fromCommit(this.myRevision);
            VcsLogFilterCollection vcsLogFilterCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(new VcsLogFilter[]{fileFilter, revisionFilter}).build();
            if (vcsLogFilterCollection == null) {
                FileHistoryFilterUi.$$$reportNull$$$0(2);
            }
            return vcsLogFilterCollection;
        }
        VcsLogBranchFilterImpl branchFilter = this.myProperties.get(FileHistoryUiProperties.SHOW_ALL_BRANCHES) != false ? null : VcsLogBranchFilterImpl.fromBranch("HEAD");
        VcsLogFilterCollection vcsLogFilterCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(new VcsLogFilter[]{fileFilter, branchFilter}).build();
        if (vcsLogFilterCollection == null) {
            FileHistoryFilterUi.$$$reportNull$$$0(3);
        }
        return vcsLogFilterCollection;
    }

    public void setFilter(@Nullable VcsLogFilter filter2) {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryFilterUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryFilterUi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

