/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class VcsLogUiUtil {
    @NotNull
    public static JComponent installProgress(@NotNull JComponent component, final @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        if (component == null) {
            VcsLogUiUtil.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogUiUtil.$$$reportNull$$$0(1);
        }
        if (disposableParent == null) {
            VcsLogUiUtil.$$$reportNull$$$0(2);
        }
        final ProgressStripe progressStripe = new ProgressStripe(component, disposableParent, 300){

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.myDecorator != null && logData.getProgress().isRunning()) {
                    this.startLoadingImmediately();
                }
            }
        };
        logData.getProgress().addProgressIndicatorListener(new VcsLogProgress.ProgressListener(){

            @Override
            public void progressStarted() {
                progressStripe.startLoading();
            }

            @Override
            public void progressStopped() {
                progressStripe.stopLoading();
            }
        }, disposableParent);
        ProgressStripe progressStripe2 = progressStripe;
        if (progressStripe2 == null) {
            VcsLogUiUtil.$$$reportNull$$$0(3);
        }
        return progressStripe2;
    }

    @NotNull
    public static JScrollPane setupScrolledGraph(@NotNull VcsLogGraphTable graphTable, int border) {
        if (graphTable == null) {
            VcsLogUiUtil.$$$reportNull$$$0(4);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)graphTable), (int)border);
        graphTable.viewportSet(scrollPane.getViewport());
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            VcsLogUiUtil.$$$reportNull$$$0(5);
        }
        return jScrollPane;
    }

    public static void installDetailsListeners(@NotNull VcsLogGraphTable graphTable, @NotNull DetailsPanel detailsPanel, @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        if (graphTable == null) {
            VcsLogUiUtil.$$$reportNull$$$0(6);
        }
        if (detailsPanel == null) {
            VcsLogUiUtil.$$$reportNull$$$0(7);
        }
        if (logData == null) {
            VcsLogUiUtil.$$$reportNull$$$0(8);
        }
        if (disposableParent == null) {
            VcsLogUiUtil.$$$reportNull$$$0(9);
        }
        Runnable miniDetailsLoadedListener = () -> {
            if (graphTable == null) {
                VcsLogUiUtil.$$$reportNull$$$0(18);
            }
            graphTable.reLayout();
            graphTable.repaint();
        };
        Runnable containingBranchesListener = () -> {
            if (detailsPanel == null) {
                VcsLogUiUtil.$$$reportNull$$$0(16);
            }
            if (graphTable == null) {
                VcsLogUiUtil.$$$reportNull$$$0(17);
            }
            detailsPanel.branchesChanged();
            graphTable.repaint();
        };
        logData.getMiniDetailsGetter().addDetailsLoadedListener(miniDetailsLoadedListener);
        logData.getContainingBranchesGetter().addTaskCompletedListener(containingBranchesListener);
        Disposer.register((Disposable)disposableParent, () -> {
            if (logData == null) {
                VcsLogUiUtil.$$$reportNull$$$0(15);
            }
            logData.getContainingBranchesGetter().removeTaskCompletedListener(containingBranchesListener);
            logData.getMiniDetailsGetter().removeDetailsLoadedListener(miniDetailsLoadedListener);
        });
    }

    @NotNull
    public static SimpleTextAttributes getLinkAttributes() {
        SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(0, JBColor.link());
        if (simpleTextAttributes == null) {
            VcsLogUiUtil.$$$reportNull$$$0(10);
        }
        return simpleTextAttributes;
    }

    public static void showTooltip(@NotNull JComponent component, @NotNull Point point, @NotNull Balloon.Position position, @NotNull String text) {
        if (component == null) {
            VcsLogUiUtil.$$$reportNull$$$0(11);
        }
        if (point == null) {
            VcsLogUiUtil.$$$reportNull$$$0(12);
        }
        if (position == null) {
            VcsLogUiUtil.$$$reportNull$$$0(13);
        }
        if (text == null) {
            VcsLogUiUtil.$$$reportNull$$$0(14);
        }
        JEditorPane tipComponent = IdeTooltipManager.initPane(text, new HintHint(component, point).setAwtTooltip(true), null);
        IdeTooltip tooltip = new IdeTooltip(component, point, (JComponent)new Wrapper((JComponent)tipComponent), new Object[0]).setPreferredPosition(position).setToCenter(false).setToCenterIfSmall(false);
        IdeTooltipManager.getInstance().show(tooltip, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/VcsLogUiUtil";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphTable";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsPanel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/VcsLogUiUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "installProgress";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setupScrolledGraph";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installProgress";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupScrolledGraph";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "installDetailsListeners";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installDetailsListeners$2";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installDetailsListeners$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installDetailsListeners$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

