/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.availability.PsiAvailabilityService;
import com.intellij.ui.Gray;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.PsiBreadcrumbs;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import com.intellij.xml.breadcrumbs.ToggleBreadcrumbsAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.PriorityQueue;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsXmlWrapper
extends JComponent
implements Disposable {
    final PsiBreadcrumbs breadcrumbs;
    private static final Logger LOG = Logger.getInstance(BreadcrumbsXmlWrapper.class);
    private final Project myProject;
    private Editor myEditor;
    private Collection<RangeHighlighter> myHighlighed;
    private final VirtualFile myFile;
    private boolean myUserCaretChange;
    private final MergingUpdateQueue myQueue;
    private final BreadcrumbsProvider myInfoProvider;
    private final Update myUpdate;
    private ProgressIndicator myPsiAvaiableProgress;
    public static final Key<BreadcrumbsXmlWrapper> BREADCRUMBS_COMPONENT_KEY = new Key("BREADCRUMBS_KEY");

    public BreadcrumbsXmlWrapper(final @NotNull Editor editor) {
        if (editor == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(0);
        }
        this.breadcrumbs = new PsiBreadcrumbs();
        this.myUserCaretChange = true;
        this.myQueue = new MergingUpdateQueue("Breadcrumbs.Queue", 200, true, (JComponent)((Object)this.breadcrumbs));
        this.myUpdate = new MyUpdate(this);
        this.myPsiAvaiableProgress = null;
        this.myEditor = editor;
        this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, (Object)this);
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).addPropertyChangeListener(this::updateEditorFont, this);
        }
        Project project = editor.getProject();
        assert (project != null);
        this.myProject = project;
        this.myFile = BreadcrumbsXmlWrapper.getVirtualFile(this.myEditor);
        FileStatusManager manager = FileStatusManager.getInstance((Project)project);
        manager.addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                BreadcrumbsXmlWrapper.this.queueUpdate();
            }
        }, (Disposable)this);
        this.myInfoProvider = BreadcrumbsXmlWrapper.findInfoProvider(this.myEditor, this.myFile);
        final CaretListener caretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                if (BreadcrumbsXmlWrapper.this.myUserCaretChange) {
                    BreadcrumbsXmlWrapper.this.queueUpdate();
                }
                BreadcrumbsXmlWrapper.this.myUserCaretChange = true;
            }
        };
        editor.getCaretModel().addCaretListener(caretListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                editor.getCaretModel().removeCaretListener(caretListener);
            }
        });
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                PsiFile psiFile;
                VirtualFile file2;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                VirtualFile virtualFile = file2 = (psiFile = event.getFile()) == null ? null : psiFile.getVirtualFile();
                if (!Comparing.equal((Object)file2, (Object)BreadcrumbsXmlWrapper.this.myFile)) {
                    return;
                }
                BreadcrumbsXmlWrapper.this.queueUpdate();
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.propertyChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(2);
                }
                this.propertyChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(3);
                }
                this.propertyChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(4);
                }
                this.propertyChanged(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(5);
                }
                this.propertyChanged(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        this.breadcrumbs.onHover(this::itemHovered);
        this.breadcrumbs.onSelect(this::itemSelected);
        this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(this.myEditor));
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.breadcrumbs), (boolean)true);
        pane.setVerticalScrollBarPolicy(21);
        pane.getHorizontalScrollBar().setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add("Center", pane);
        EditorGutter gutter = editor.getGutter();
        if (gutter instanceof EditorGutterComponentEx) {
            final EditorGutterComponentEx gutterComponent = (EditorGutterComponentEx)gutter;
            MouseEventAdapter<EditorGutterComponentEx> mouseListener = new MouseEventAdapter<EditorGutterComponentEx>(gutterComponent){

                @NotNull
                protected MouseEvent convert(@NotNull MouseEvent event) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    MouseEvent mouseEvent = 5.convert((MouseEvent)event, (Component)gutterComponent);
                    if (mouseEvent == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return mouseEvent;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$5";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$5";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "convert";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "convert";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            ComponentAdapter resizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    BreadcrumbsXmlWrapper.this.breadcrumbs.updateBorder(gutterComponent.getWhitespaceSeparatorOffset());
                    BreadcrumbsXmlWrapper.this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(BreadcrumbsXmlWrapper.this.myEditor));
                }
            };
            this.addComponentListener(resizeListener);
            gutterComponent.addComponentListener(resizeListener);
            this.breadcrumbs.addMouseListener((MouseListener)mouseListener);
            Disposer.register((Disposable)this, () -> this.lambda$new$0(resizeListener, gutterComponent, (MouseEventAdapter)mouseListener));
            this.breadcrumbs.updateBorder(gutterComponent.getWhitespaceSeparatorOffset());
        } else {
            this.breadcrumbs.updateBorder(0);
        }
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)((Object)this.breadcrumbs), (Activatable)this.myQueue));
        Disposer.register((Disposable)this, (Disposable)this.myQueue);
        this.queueUpdate();
    }

    private void updateCrumbs() {
        if (this.myEditor == null || this.myEditor.isDisposed()) {
            return;
        }
        if (this.myPsiAvaiableProgress != null) {
            this.myPsiAvaiableProgress.cancel();
        }
        ProgressIndicatorBase progress = new ProgressIndicatorBase();
        this.myPsiAvaiableProgress = progress;
        PsiAvailabilityService.getInstance(this.myProject).performWhenPsiAvailable(this.myEditor.getDocument(), () -> {
            if (!(progress.isCanceled() || this.myFile == null || this.myEditor == null || this.myEditor.isDisposed() || this.myProject.isDisposed())) {
                this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(this.myEditor));
                this.updateCrumbs(this.myEditor.getCaretModel().getLogicalPosition());
            }
        }, progress);
    }

    public void queueUpdate() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(this.myUpdate);
    }

    private void moveEditorCaretTo(@NotNull PsiElement element) {
        if (element == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(1);
        }
        if (element.isValid()) {
            this.setUserCaretChange(false);
            this.myEditor.getCaretModel().moveToOffset(element.getTextOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Nullable
    private static BreadcrumbsProvider findProviderForElement(@NotNull PsiElement element, BreadcrumbsProvider defaultProvider) {
        if (element == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(2);
        }
        Language language = element.getLanguage();
        if (!EditorSettingsExternalizable.getInstance().isBreadcrumbsShownFor(language.getID())) {
            return defaultProvider;
        }
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)language);
        return provider == null ? defaultProvider : provider;
    }

    private static PsiElement[] toPsiElementArray(Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs) {
        PsiElement[] elements = new PsiElement[pairs.size()];
        int index = 0;
        for (Pair<PsiElement, BreadcrumbsProvider> pair : pairs) {
            elements[index++] = (PsiElement)pair.first;
        }
        return elements;
    }

    @Nullable
    private static CrumbPresentation[] getCrumbPresentations(PsiElement[] elements) {
        for (BreadcrumbsPresentationProvider provider : (BreadcrumbsPresentationProvider[])BreadcrumbsPresentationProvider.EP_NAME.getExtensions()) {
            CrumbPresentation[] presentations = provider.getCrumbPresentations(elements);
            if (presentations == null) continue;
            return presentations;
        }
        return null;
    }

    private void setUserCaretChange(boolean userCaretChange) {
        this.myUserCaretChange = userCaretChange;
    }

    @Nullable
    private static Iterable<PsiCrumb> getPresentableLineElements(@NotNull LogicalPosition position, VirtualFile file2, Editor editor, Project project, BreadcrumbsProvider defaultInfoProvider) {
        Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs;
        if (position == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(3);
        }
        if ((pairs = BreadcrumbsXmlWrapper.getLineElements(editor.logicalPositionToOffset(position), file2, project, defaultInfoProvider)) == null) {
            return null;
        }
        ArrayList<PsiCrumb> result2 = new ArrayList<PsiCrumb>(pairs.size());
        CrumbPresentation[] presentations = BreadcrumbsXmlWrapper.getCrumbPresentations(BreadcrumbsXmlWrapper.toPsiElementArray(pairs));
        int index = 0;
        for (Pair<PsiElement, BreadcrumbsProvider> pair : pairs) {
            PsiCrumb crumb = new PsiCrumb((PsiElement)pair.first, (BreadcrumbsProvider)pair.second);
            if (presentations != null && 0 <= index && index < presentations.length) {
                crumb.presentation = presentations[index++];
            }
            result2.add(crumb);
        }
        return result2;
    }

    @Nullable
    public static PsiElement[] getLinePsiElements(int offset, VirtualFile file2, Project project, BreadcrumbsProvider infoProvider) {
        Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs = BreadcrumbsXmlWrapper.getLineElements(offset, file2, project, infoProvider);
        return pairs == null ? null : BreadcrumbsXmlWrapper.toPsiElementArray(pairs);
    }

    @Nullable
    private static Collection<Pair<PsiElement, BreadcrumbsProvider>> getLineElements(int offset, VirtualFile file2, Project project, BreadcrumbsProvider defaultInfoProvider) {
        PsiElement element = BreadcrumbsXmlWrapper.findFirstBreadcrumbedElement(offset, file2, project, defaultInfoProvider);
        if (element == null) {
            return null;
        }
        LinkedList<Pair<PsiElement, BreadcrumbsProvider>> result2 = new LinkedList<Pair<PsiElement, BreadcrumbsProvider>>();
        while (element != null) {
            BreadcrumbsProvider provider = BreadcrumbsXmlWrapper.findProviderForElement(element, defaultInfoProvider);
            if (provider != null && provider.acceptElement(element)) {
                result2.addFirst((Pair<PsiElement, BreadcrumbsProvider>)Pair.create((Object)element, (Object)provider));
            }
            element = BreadcrumbsXmlWrapper.getParent(element, provider);
        }
        return result2;
    }

    @Nullable
    private static PsiElement findFirstBreadcrumbedElement(int offset, VirtualFile file2, Project project, BreadcrumbsProvider defaultInfoProvider) {
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        PriorityQueue leafs = new PriorityQueue(3, (o1, o2) -> {
            TextRange range1 = o1.getTextRange();
            if (range1 == null) {
                LOG.error(o1 + " returned null range");
                return 1;
            }
            TextRange range2 = o2.getTextRange();
            if (range2 == null) {
                LOG.error(o2 + " returned null range");
                return -1;
            }
            return range2.getStartOffset() - range1.getStartOffset();
        });
        FileViewProvider viewProvider = BreadcrumbsXmlWrapper.findViewProvider(file2, project);
        if (viewProvider == null) {
            return null;
        }
        for (Language language : viewProvider.getLanguages()) {
            ContainerUtil.addIfNotNull(leafs, (Object)viewProvider.findElementAt(offset, language));
        }
        while (!leafs.isEmpty()) {
            PsiElement element = (PsiElement)leafs.remove();
            if (!element.isValid()) continue;
            BreadcrumbsProvider provider = BreadcrumbsXmlWrapper.findProviderForElement(element, defaultInfoProvider);
            if (provider != null && provider.acceptElement(element)) {
                return element;
            }
            if (element instanceof PsiFile) continue;
            ContainerUtil.addIfNotNull(leafs, (Object)BreadcrumbsXmlWrapper.getParent(element, provider));
        }
        return null;
    }

    @Nullable
    private static PsiElement getParent(@NotNull PsiElement element, @Nullable BreadcrumbsProvider provider) {
        if (element == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(4);
        }
        return provider != null ? provider.getParent(element) : element.getParent();
    }

    @Nullable
    private static FileViewProvider findViewProvider(VirtualFile file2, Project project) {
        if (file2 == null || file2.isDirectory()) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findViewProvider(file2);
    }

    @Nullable
    static FileViewProvider findViewProvider(Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        VirtualFile file2 = BreadcrumbsXmlWrapper.getVirtualFile(editor);
        return BreadcrumbsXmlWrapper.findViewProvider(file2, project);
    }

    @Nullable
    static BreadcrumbsProvider findInfoProvider(@NotNull Editor editor, VirtualFile file2) {
        Project project;
        if (editor == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(5);
        }
        return (project = editor.getProject()) == null ? null : BreadcrumbsXmlWrapper.findInfoProvider(editor, BreadcrumbsXmlWrapper.findViewProvider(file2, project));
    }

    private static VirtualFile getVirtualFile(@NotNull Editor editor) {
        if (editor == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(6);
        }
        return FileDocumentManager.getInstance().getFile(editor.getDocument());
    }

    private void updateCrumbs(LogicalPosition position) {
        if (!this.breadcrumbs.isShowing()) {
            this.breadcrumbs.setCrumbs(null);
            return;
        }
        this.breadcrumbs.setCrumbs(BreadcrumbsXmlWrapper.getPresentableLineElements(position, this.myFile, this.myEditor, this.myProject, this.myInfoProvider));
    }

    @Nullable
    public static BreadcrumbsProvider findInfoProvider(@NotNull Editor editor, @Nullable FileViewProvider viewProvider) {
        if (editor == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(7);
        }
        if (viewProvider == null) {
            return null;
        }
        Boolean shown = ToggleBreadcrumbsAction.getForcedShown(editor);
        return shown != null && shown == false ? null : BreadcrumbsXmlWrapper.findInfoProvider(shown == null, viewProvider);
    }

    @Nullable
    static BreadcrumbsProvider findInfoProvider(boolean checkSettings, @NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(8);
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (checkSettings && !settings.isBreadcrumbsShown()) {
            return null;
        }
        Language baseLang = viewProvider.getBaseLanguage();
        if (checkSettings && !settings.isBreadcrumbsShownFor(baseLang.getID())) {
            return null;
        }
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)baseLang);
        if (provider == null) {
            for (Language language : viewProvider.getLanguages()) {
                if (checkSettings && !settings.isBreadcrumbsShownFor(language.getID()) || (provider = BreadcrumbsUtil.getInfoProvider((Language)language)) == null) continue;
                break;
            }
        }
        return provider;
    }

    @Deprecated
    public JComponent getComponent() {
        return this;
    }

    private void itemSelected(Crumb crumb, InputEvent event) {
        if (event == null) {
            return;
        }
        PsiElement psiElement = PsiCrumb.getElement(crumb);
        if (psiElement == null) {
            return;
        }
        this.moveEditorCaretTo(psiElement);
        if (event.isShiftDown() || event.isMetaDown()) {
            TextRange range2 = psiElement.getTextRange();
            this.myEditor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
    }

    private void itemHovered(Crumb crumb, InputEvent event) {
        PsiElement psiElement;
        if (!Registry.is((String)"editor.breadcrumbs.highlight.on.hover")) {
            return;
        }
        HighlightManager hm = HighlightManager.getInstance((Project)this.myProject);
        if (this.myHighlighed != null) {
            for (RangeHighlighter highlighter : this.myHighlighed) {
                hm.removeSegmentHighlighter(this.myEditor, highlighter);
            }
            this.myHighlighed = null;
        }
        if ((psiElement = PsiCrumb.getElement(crumb)) != null) {
            Color background;
            Color color;
            TextRange range2 = psiElement.getTextRange();
            TextAttributes attributes = new TextAttributes();
            CrumbPresentation p = PsiCrumb.getPresentation(crumb);
            Color color2 = color = p == null ? null : p.getBackgroundColor(false, false, false);
            if (color == null) {
                color = BreadcrumbsComponent.ButtonSettings.getBackgroundColor((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (color == null) {
                color = UIUtil.getLabelBackground();
            }
            attributes.setBackgroundColor(XmlTagTreeHighlightingUtil.makeTransparent(color, (background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR)) != null ? background : Gray._200, 0.3));
            this.myHighlighed = new ArrayList<RangeHighlighter>(1);
            int flags = 7;
            hm.addOccurrenceHighlight(this.myEditor, range2.getStartOffset(), range2.getEndOffset(), attributes, flags, this.myHighlighed, null);
        }
    }

    @Nullable
    public static BreadcrumbsXmlWrapper getBreadcrumbsComponent(@NotNull Editor editor) {
        if (editor == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(9);
        }
        return (BreadcrumbsXmlWrapper)editor.getUserData(BREADCRUMBS_COMPONENT_KEY);
    }

    public void dispose() {
        if (this.myEditor != null) {
            this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, null);
        }
        this.myEditor = null;
        this.breadcrumbs.setCrumbs(null);
    }

    private void updateEditorFont(PropertyChangeEvent event) {
        if ("fontSize".equals(event.getPropertyName())) {
            this.queueUpdate();
        }
    }

    private static Font getNewFont(Editor editor) {
        Font font = editor == null || Registry.is((String)"editor.breadcrumbs.system.font") ? UIUtil.getLabelFont() : BreadcrumbsXmlWrapper.getEditorFont(editor);
        return UISettings.getInstance().getUseSmallLabelsOnTabs() ? RelativeFont.SMALL.derive(font) : font;
    }

    private static Font getEditorFont(Editor editor) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(97, 0, editor.getColorsScheme().getFontPreferences(), null).getFont();
    }

    private /* synthetic */ void lambda$new$0(ComponentAdapter resizeListener, EditorGutterComponentEx gutterComponent, MouseEventAdapter mouseListener) {
        this.removeComponentListener(resizeListener);
        gutterComponent.removeComponentListener(resizeListener);
        this.breadcrumbs.removeMouseListener((MouseListener)mouseListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "moveEditorCaretTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findProviderForElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentableLineElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getParent";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findInfoProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getVirtualFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getBreadcrumbsComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyUpdate
    extends Update {
        private final BreadcrumbsXmlWrapper myBreadcrumbsComponent;

        public MyUpdate(@NonNls BreadcrumbsXmlWrapper c) {
            super((Object)c);
            this.myBreadcrumbsComponent = c;
        }

        public void run() {
            this.myBreadcrumbsComponent.updateCrumbs();
        }

        public boolean canEat(Update update) {
            return true;
        }
    }
}

