/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.jpa;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaIntegrationUtil {
    public static final String EMF_BEAN = "org.springframework.orm.jpa.AbstractEntityManagerFactoryBean";

    private JpaIntegrationUtil() {
    }

    public static boolean isEmfBean(SpringBean bean) {
        String beanClassName;
        if (bean == null || bean.isAbstract()) {
            return false;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType());
        String string = beanClassName = beanClass != null ? beanClass.getQualifiedName() : bean.getClazz().getRawText();
        if (EMF_BEAN.equals(beanClassName)) {
            return true;
        }
        return JamCommonUtil.isSuperClass((PsiClass)beanClass, (String)EMF_BEAN);
    }

    private static Condition<Pair<PsiType, GenericDomValue>> createBeanPropertyCondition(String propertyName) {
        return pair -> {
            GenericDomValue domValue = (GenericDomValue)pair.getSecond();
            if (!JpaIntegrationUtil.isEmfBean((SpringBean)domValue.getParentOfType(SpringBean.class, true))) {
                return false;
            }
            SpringProperty property = (SpringProperty)domValue.getParentOfType(SpringProperty.class, true);
            String name = property == null ? null : property.getName().getStringValue();
            return propertyName.equals(name);
        };
    }

    public static class MyUnitConverter
    extends ResolvingConverter<PersistencePackage>
    implements GenericDomValueConvertersRegistry.Provider {
        public PersistencePackage fromString(@Nullable @NonNls String s, ConvertContext context) {
            if (s == null) {
                return null;
            }
            for (PersistencePackage persistencePackage : this.getVariants(context)) {
                if (!Comparing.equal((String)((String)persistencePackage.getName().getValue()), (String)s)) continue;
                return persistencePackage;
            }
            return null;
        }

        public String toString(@Nullable PersistencePackage o, ConvertContext context) {
            return o == null ? null : (String)o.getName().getValue();
        }

        @NotNull
        public Collection<? extends PersistencePackage> getVariants(ConvertContext context) {
            ArrayList result = new ArrayList();
            for (PersistenceFacet o : PersistenceCommonUtil.getAllPersistenceFacets((Project)context.getFile().getProject())) {
                if (!(o instanceof JpaFacet)) continue;
                result.addAll(o.getPersistenceUnits());
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                MyUnitConverter.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        public Converter getConverter() {
            return this;
        }

        public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
            return JpaIntegrationUtil.createBeanPropertyCondition("persistenceUnitName");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/jpa/JpaIntegrationUtil$MyUnitConverter", "getVariants"));
        }
    }
}

