/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSRecordType
extends JSType {
    @NotNull
    public List<TypeMember> getTypeMembers();

    public boolean hasProperty(@NotNull String var1);

    @Nullable
    public PropertySignature findPropertySignature(@NotNull String var1);

    @Nullable
    public IndexSignature findIndexer(@NotNull IndexSignatureKind var1);

    @NotNull
    public List<CallSignature> getCallSignatures();

    @NotNull
    public Set<String> getPropertyNames();

    public boolean hasMembers();

    public boolean hasProperties();

    public boolean hasIndexers();

    public static interface IndexSignature
    extends TypeMember {
        @NotNull
        public IndexSignatureKind getIndexSignatureKind();

        @NotNull
        public JSType getMemberParameterType();

        @NotNull
        public JSType getMemberType();

        @Override
        @NotNull
        public IndexSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }

    public static enum IndexSignatureKind {
        STRING,
        NUMERIC,
        UNKNOWN;

    }

    public static interface CallSignature
    extends TypeMember {
        public boolean hasNew();

        @NotNull
        public JSFunctionType getFunctionType();

        @Override
        @NotNull
        public CallSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);

        @NotNull
        default public List<JSParameterTypeDecorator> getParameterTypeDecorators() {
            List<JSParameterTypeDecorator> list = this.getFunctionType().getParameters();
            if (list == null) {
                CallSignature.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        default public JSType getReturnType() {
            return this.getFunctionType().getReturnType();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSRecordType$CallSignature", "getParameterTypeDecorators"));
        }
    }

    public static interface PropertySignature
    extends TypeMember {
        @NotNull
        public String getMemberName();

        @Override
        @NotNull
        public PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);

        public boolean isOptional();

        @Nullable
        public JSType getType();
    }

    public static interface TypeMember {
        @Contract(pure=true)
        public boolean isEquivalentTo(@Nullable TypeMember var1, boolean var2);

        @NotNull
        public MemberSource getMemberSource();

        @NotNull
        public TypeMember copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);

        public void appendMemberPresentation(@NotNull JSType.TypeTextFormat var1, @NotNull StringBuilder var2, @NotNull String var3, char var4);

        public void acceptChildren(JSRecursiveTypeVisitor var1);
    }

    public static interface MemberSource {
        public boolean isEmpty();

        @NotNull
        public MemberSourceKind getMemberSourceKind();

        @Nullable
        public PsiElement getSingleElement();

        @NotNull
        public List<PsiElement> getAllSourceElements();

        public MemberSource copyWithKind(MemberSourceKind var1);
    }

    public static enum MemberSourceKind {
        Empty,
        Identity,
        Union,
        Intersection,
        MappedNoStatus,
        MappedReadonly,
        MappedMinusReadonly,
        MappedOptional,
        MappedMinusOptional,
        MappedOptionalReadonly,
        MappedOptionalMinusReadonly,
        MappedMinusOptionalReadonly,
        MappedMinusOptionalMinusReadonly,
        CompositeSignature;


        public static MemberSourceKind getMappedKind(boolean forceOptional, boolean forceNonOptional, boolean forceReadonly, boolean forceNonReadonly) {
            if (forceOptional) {
                return forceReadonly ? MappedOptionalReadonly : (forceNonReadonly ? MappedOptionalMinusReadonly : MappedOptional);
            }
            if (forceNonOptional) {
                return forceReadonly ? MappedMinusOptionalReadonly : (forceNonReadonly ? MappedMinusOptionalMinusReadonly : MappedMinusOptional);
            }
            return forceReadonly ? MappedReadonly : (forceNonReadonly ? MappedMinusReadonly : MappedNoStatus);
        }

        private boolean isMapped() {
            return this.ordinal() >= MappedNoStatus.ordinal() && this.ordinal() <= MappedMinusOptionalMinusReadonly.ordinal();
        }

        public boolean isTypeScriptMergedTypeKind() {
            return this == Union || this == Intersection || this.isMapped();
        }

        public boolean isForceReadonly() {
            return this == MappedReadonly || this == MappedOptionalReadonly || this == MappedMinusOptionalReadonly;
        }

        public boolean isForceNonReadonly() {
            return this == MappedMinusReadonly || this == MappedOptionalMinusReadonly || this == MappedMinusOptionalMinusReadonly;
        }

        public boolean isForceOptional() {
            return this == MappedOptional || this == MappedOptionalReadonly || this == MappedOptionalMinusReadonly;
        }

        public boolean isForceNonOptional() {
            return this == MappedMinusOptional || this == MappedMinusOptionalReadonly || this == MappedMinusOptionalMinusReadonly;
        }
    }
}

