/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.customizeActions.DissociateResourceBundleAction;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftLazyValue;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousLocalesLanguagesInspection
extends BaseLocalInspectionTool {
    private static final String ADDITIONAL_LANGUAGES_ATTR_NAME = "additionalLanguages";
    private static final SoftLazyValue<Set<String>> JAVA_LOCALES = new SoftLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            HashSet<String> result = new HashSet<String>();
            for (Locale locale : Locale.getAvailableLocales()) {
                result.add(locale.getLanguage());
            }
            HashSet<String> hashSet = result;
            if (hashSet == null) {
                1.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$1", "compute"));
        }
    };
    private final List<String> myAdditionalLanguages = new ArrayList<String>();

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Suspicious resource bundle locale languages" == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(0);
        }
        return "Suspicious resource bundle locale languages";
    }

    public void setAdditionalLanguages(List<String> additionalLanguages) {
        this.myAdditionalLanguages.clear();
        this.myAdditionalLanguages.addAll(additionalLanguages);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        String rawLanguages;
        if (node == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(1);
        }
        if ((rawLanguages = node.getAttributeValue(ADDITIONAL_LANGUAGES_ATTR_NAME)) != null) {
            this.myAdditionalLanguages.clear();
            this.myAdditionalLanguages.addAll(StringUtil.split((String)rawLanguages, (String)","));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(2);
        }
        if (!this.myAdditionalLanguages.isEmpty()) {
            ArrayList uniqueLanguages = ContainerUtil.newArrayList((Iterable)ContainerUtil.newHashSet(this.myAdditionalLanguages));
            Collections.sort(uniqueLanguages);
            String locales = StringUtil.join((Collection)uniqueLanguages, (String)",");
            node.setAttribute(ADDITIONAL_LANGUAGES_ATTR_NAME, locales);
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new MyOptions().getComponent();
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PropertiesFile propertiesFile;
        if (file == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(4);
        }
        if ((propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)file)) == null) {
            return null;
        }
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        List files = resourceBundle.getPropertiesFiles();
        if (!(resourceBundle instanceof ResourceBundleImpl) || files.size() < 2) {
            return null;
        }
        List bundleLocales = ContainerUtil.mapNotNull((Collection)files, propertiesFile1 -> {
            Locale locale = propertiesFile1.getLocale();
            return locale == PropertiesUtil.DEFAULT_LOCALE ? null : locale;
        });
        if ((bundleLocales = ContainerUtil.filter((Collection)bundleLocales, locale -> !((Set)JAVA_LOCALES.getValue()).contains(locale.getLanguage()) && !this.myAdditionalLanguages.contains(locale.getLanguage()))).isEmpty()) {
            return null;
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)file, PropertiesBundle.message((String)"resource.bundle.contains.locales.with.suspicious.locale.languages.desciptor", (Object[])new Object[0]), (LocalQuickFix)new DissociateResourceBundleQuickFix(resourceBundle), ProblemHighlightType.WEAK_WARNING, true);
        return new ProblemDescriptor[]{descriptor};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyOptions {
        private final JBList myAdditionalLocalesList = new JBList((ListModel)new MyListModel());

        public MyOptions() {
            this.myAdditionalLocalesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer());
        }

        public JPanel getComponent() {
            final JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel(PropertiesBundle.message((String)"dissociate.resource.bundle.quick.fix.options.label", (Object[])new Object[0])), "North");
            panel.add((Component)ToolbarDecorator.createDecorator((JList)this.myAdditionalLocalesList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    Messages.showInputDialog((Component)panel, (String)PropertiesBundle.message((String)"dissociate.resource.bundle.quick.fix.options.input.text", (Object[])new Object[0]), (String)PropertiesBundle.message((String)"dissociate.resource.bundle.quick.fix.options.input.title", (Object[])new Object[0]), null, (String)"", (InputValidator)new InputValidator(){

                        public boolean checkInput(String inputString) {
                            return 1 < inputString.length() && inputString.length() < 9 && !SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.contains(inputString);
                        }

                        public boolean canClose(String inputString) {
                            if (inputString != null) {
                                SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.add(inputString);
                                ((MyListModel)MyOptions.this.myAdditionalLocalesList.getModel()).fireContentsChanged();
                            }
                            return true;
                        }
                    });
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    int index = MyOptions.this.myAdditionalLocalesList.getSelectedIndex();
                    if (index > -1 && index < SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.size()) {
                        SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.remove(index);
                        ((MyListModel)MyOptions.this.myAdditionalLocalesList.getModel()).fireContentsChanged();
                    }
                }
            }).setPreferredSize(new Dimension(-1, 100)).disableUpDownActions().createPanel(), "Center");
            return panel;
        }

        private class MyListModel
        extends AbstractListModel {
            private MyListModel() {
            }

            @Override
            public int getSize() {
                return SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.size();
            }

            @Override
            public Object getElementAt(int index) {
                return SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.get(index);
            }

            public void fireContentsChanged() {
                this.fireContentsChanged(SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages, -1, -1);
            }
        }
    }

    private static class DissociateResourceBundleQuickFix
    implements LocalQuickFix {
        private final ResourceBundle myResourceBundle;

        private DissociateResourceBundleQuickFix(ResourceBundle bundle) {
            this.myResourceBundle = bundle;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message((String)"dissociate.resource.bundle.quick.fix.name", (Object[])new Object[0]);
            if (string == null) {
                DissociateResourceBundleQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DissociateResourceBundleQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DissociateResourceBundleQuickFix.$$$reportNull$$$0(2);
            }
            DissociateResourceBundleAction.dissociate(Collections.singleton(this.myResourceBundle), (Project)project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$DissociateResourceBundleQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$DissociateResourceBundleQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

