/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.view.ui.DbSchemasSelector;
import com.intellij.database.view.ui.DbSchemasTree;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionTargetDialog
extends DialogWrapper {
    private final Project myProject;
    private final ExecutionTargetEditor myEditor;
    private final JLabel myLabel;
    private final Alarm myUpdateAlarm;
    private final Consumer<List<Pair<LocalDataSource, ObjectPath>>> myConsumer;
    private ThreeState myHaveSchemaSwitches;

    public ExecutionTargetDialog(@NotNull Project project, @NotNull Function<Boolean, Iterable<LocalDataSource>> dsProvider, @NotNull Consumer<List<Pair<LocalDataSource, ObjectPath>>> consumer) {
        if (project == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(0);
        }
        if (dsProvider == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myUpdateAlarm = AlarmFactory.getInstance().create();
        this.myHaveSchemaSwitches = ThreeState.NO;
        this.myConsumer = consumer;
        this.setTitle("Execution Target");
        this.myProject = project;
        this.myLabel = new JBLabel();
        this.myEditor = new ExecutionTargetEditor(project, dsProvider);
        this.myEditor.getSelectionModel().addNodeListener(new FilteringTree.SearchTreeModel.Listener<DbSchemasTree.MyNode>(){

            @Override
            public void beforeNodeChanged(DbSchemasTree.MyNode x) {
            }

            @Override
            public void nodeChanged(DbSchemasTree.MyNode x) {
                ExecutionTargetDialog.this.myUpdateAlarm.cancelAllRequests();
                ExecutionTargetDialog.this.myUpdateAlarm.addRequest(() -> ExecutionTargetDialog.this.updateLabel(), 0);
            }
        });
        this.loadState();
        this.init();
        this.updateLabel();
    }

    private DialogState getStateService() {
        return (DialogState)ServiceManager.getService((Project)this.myEditor.getProject(), DialogState.class);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "ExecutionTargetDialog";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getTree();
    }

    protected void doOKAction() {
        ArrayList targets = ContainerUtil.newArrayList();
        JBTreeTraverser checked = JBTreeTraverser.from(n -> n.getChildNodes().filter(x -> x.isChecked()));
        JBIterable dataSources2 = this.myEditor.getSelectionModel().getRootObject().getChildNodes().filter(n -> n.isChecked());
        if (!dataSources2.isEmpty()) {
            for (DbSchemasTree.MyNode ds : dataSources2) {
                LocalDataSource dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)ds.getObject(), LocalDataSource.class);
                if (dataSource == null) continue;
                for (DbSchemasTree.MyNode leaf : ((JBTreeTraverser)checked.withRoot((Object)ds)).traverse(TreeTraversal.LEAVES_DFS)) {
                    Object obj = leaf.getObject();
                    if (obj == dataSource) {
                        targets.add(Pair.create((Object)dataSource, null));
                        continue;
                    }
                    if (!(obj instanceof DasObject)) continue;
                    targets.add(Pair.create((Object)dataSource, (Object)ObjectPaths.of((DasObject)obj)));
                }
            }
        }
        if (!targets.isEmpty()) {
            this.myConsumer.consume((Object)targets);
        }
        this.saveState();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.saveState();
        super.doCancelAction();
    }

    public void saveState() {
        Element root2 = new Element("ExecutionTargetDialog");
        if (!this.myEditor.myFiltered) {
            root2.setAttribute("filtered", "false");
        }
        this.myEditor.saveState(root2);
        this.getStateService().element = root2;
    }

    public void loadState() {
        Element state = this.getStateService().element;
        if (state == null) {
            return;
        }
        this.myEditor.setFiltered(!"false".equals(state.getAttributeValue("filtered")));
        this.myEditor.loadState(state);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myEditor.getComponent(), "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)SeparatorFactory.createSeparator((String)"Script execution target", (JComponent)this.myLabel), "North");
        southPanel.add((Component)this.myLabel, "Center");
        panel.add((Component)southPanel, "South");
        panel.setMinimumSize(new Dimension(300, 300));
        return panel;
    }

    private void updateLabel() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        JBTreeTraverser checked = JBTreeTraverser.from(n -> n.getChildNodes().filter(x -> x.isChecked()));
        JBIterable dataSources2 = this.myEditor.getSelectionModel().getRootObject().getChildNodes().filter(n -> n.isChecked());
        if (!dataSources2.isEmpty()) {
            for (DbSchemasTree.MyNode ds : dataSources2) {
                builder.append("<b>").append(StringUtil.escapeXml((String)ds.getName())).append(":</b> ");
                int offs = builder.length();
                DatabaseSystem databaseSystem = (DatabaseSystem)ObjectUtils.tryCast((Object)ds.getObject(), DatabaseSystem.class);
                ObjectKind kind = databaseSystem == null ? null : DbSchemasSelector.getDatabaseDialect(this.myProject, databaseSystem).getSearchPathObjectKind();
                for (DbSchemasTree.MyNode leaf : ((JBTreeTraverser)checked.withRoot((Object)ds)).traverse(TreeTraversal.LEAVES_DFS)) {
                    Object obj;
                    if (offs != builder.length()) {
                        builder.append(", ");
                    }
                    if ((obj = leaf.getObject()) instanceof DatabaseSystem) {
                        builder.append("&lt;Default&gt;");
                        continue;
                    }
                    if (obj instanceof DasObject) {
                        DasObject o = (DasObject)obj;
                        builder.append(QNameUtil.getQualifiedName(o));
                        if (o.getKind() == kind) continue;
                        builder.append(".&lt;Default&gt;");
                        continue;
                    }
                    builder.append(StringUtil.escapeXml((String)leaf.getName()));
                }
                builder.append("<br>");
            }
            this.getOKAction().setEnabled(true);
        } else {
            builder.append("No target selected<br>");
            this.getOKAction().setEnabled(false);
        }
        if (this.myHaveSchemaSwitches != ThreeState.NO) {
            Icon icon = AllIcons.General.BalloonWarning;
            boolean pending = this.myHaveSchemaSwitches == ThreeState.UNSURE;
            String iconPath = DataSourceUiUtil.getIconUrl(pending ? "/general/balloonInformation.png" : "/general/balloonWarning.png");
            builder.append("<br>");
            builder.append("<img hspace=\"0\" vspace=\"0\" border=\"0\" width=\"").append(icon.getIconWidth()).append("\" height=\"").append(icon.getIconHeight()).append("\" src=\"").append(iconPath == null ? "" : StringUtil.escapeStringCharacters((String)iconPath)).append("\">");
            if (pending) {
                builder.append("<i>Checking script for current schema/database switch statements...</i>");
            } else {
                builder.append("<i>Warning! Script contains current schema/database switch statements.</i>");
            }
        }
        builder.append("</html>");
        this.myLabel.setText(builder.toString());
    }

    public void setSchemaSwitchWarning(@NotNull ThreeState state) {
        if (state == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(3);
        }
        this.myHaveSchemaSwitches = state;
        this.updateLabel();
    }

    public void checkFilesForSchemaSwitches(JBIterable<VirtualFile> files) {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        this.setSchemaSwitchWarning(ThreeState.UNSURE);
        Application application = ApplicationManager.getApplication();
        Disposer.register((Disposable)this.getDisposable(), () -> indicator.cancel());
        application.executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
            boolean haveSchemaSwitches = false;
            try {
                haveSchemaSwitches = ExecutionTargetDialog.haveSchemaSwitches(this.myProject, files);
            }
            finally {
                if (!indicator.isCanceled()) {
                    boolean finalHaveSchemaSwitches = haveSchemaSwitches;
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (!indicator.isCanceled()) {
                            this.setSchemaSwitchWarning(ThreeState.fromBoolean((boolean)finalHaveSchemaSwitches));
                        }
                    });
                }
            }
        }, (ProgressIndicator)indicator));
    }

    private static boolean haveSchemaSwitches(@NotNull Project project, @NotNull JBIterable<VirtualFile> files) {
        if (project == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(4);
        }
        if (files == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(5);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return (Boolean)ReadAction.compute(() -> {
            if (files == null) {
                ExecutionTargetDialog.$$$reportNull$$$0(6);
            }
            for (VirtualFile vfile : files) {
                PsiFile file = psiManager.findFile(vfile);
                if (file == null) continue;
                ScriptModel model = facade.createScriptModel(file);
                try {
                    for (ScriptModel.StatementIt it : model.statements()) {
                        if (!(it.object() instanceof SqlUseDatabaseStatement)) continue;
                        Boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    Disposer.dispose((Disposable)model);
                }
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/console/ExecutionTargetDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSchemaSwitchWarning";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "haveSchemaSwitches";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$haveSchemaSwitches$10";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ExecutionTargetEditor
    extends DbSchemasSelector {
        private final Function<Boolean, Iterable<LocalDataSource>> myDsSupplier;
        private boolean myFiltered;

        public ExecutionTargetEditor(@NotNull Project project, @NotNull Function<Boolean, Iterable<LocalDataSource>> dsSupplier) {
            if (project == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(0);
            }
            if (dsSupplier == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(1);
            }
            super(project);
            this.myFiltered = true;
            this.myDsSupplier = dsSupplier;
        }

        @NotNull
        public FilteringTree.SearchTreeModel<CheckedTreeNode, DbSchemasTree.MyNode> getSelectionModel() {
            FilteringTree.SearchTreeModel<CheckedTreeNode, DbSchemasTree.MyNode> searchTreeModel = this.myTree.getSearchModel();
            if (searchTreeModel == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(2);
            }
            return searchTreeModel;
        }

        @Override
        @NotNull
        protected DefaultActionGroup getTreeActions() {
            DefaultActionGroup res = super.getTreeActions();
            res.add((AnAction)new ToggleAction("&Filter", "Display only matching", AllIcons.General.Filter){

                public boolean isSelected(AnActionEvent e) {
                    return myFiltered;
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    this.setFiltered(state);
                }
            });
            DefaultActionGroup defaultActionGroup = res;
            if (defaultActionGroup == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(3);
            }
            return defaultActionGroup;
        }

        @Override
        @NotNull
        protected DbSchemasSelector.TreeEditor createTree(@NotNull Project project) {
            if (project == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(4);
            }
            DbSchemasTree.MyNode r = new DbSchemasTree.MyNode(null, ObjectKind.NONE, null){

                @Override
                public ObjectKind getAllKind() {
                    return ObjectKind.NONE;
                }
            };
            CheckedTreeNode node = DbSchemasTree.createNode(r);
            DbSchemasSelector.TreeEditor treeEditor = new DbSchemasSelector.TreeEditor(project, (Tree)new DbSchemasTree(node), node){

                @Override
                protected boolean shouldExpand(BasicNamespace object) {
                    DatabaseDialectEx dialect;
                    BasicModel model = object.getModel();
                    DatabaseDialectEx databaseDialectEx = dialect = model == null ? null : DbImplUtil.guessDatabaseDialect(DbImplUtil.getFamily(model.getRdbms()));
                    if (dialect == null) {
                        dialect = GenericDialect.INSTANCE;
                    }
                    return dialect.getSearchPathObjectKind() != object.getKind() && super.shouldExpand(object);
                }

                @Override
                @NotNull
                protected Iterable<? extends DatabaseSystem> getDataSources() {
                    Iterable iterable = (Iterable)myDsSupplier.fun((Object)(!myFiltered ? 1 : 0));
                    if (iterable == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return iterable;
                }

                @Override
                protected void createShadowStructure(@NotNull DbSchemasTree.MyNode root2) {
                    if (root2 == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    this.cleanupUnselected(root2);
                }

                private void cleanupUnselected(@NotNull DbSchemasTree.MyNode p) {
                    if (p == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    List children = p.getShadowChildren();
                    children.removeIf(n -> !n.isChecked());
                    p.setShadowChildren(children);
                    p.getChildNodes().forEach(n -> this.cleanupUnselected((DbSchemasTree.MyNode)n));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor$3";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "root";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "p";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDataSources";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "createShadowStructure";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "cleanupUnselected";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            if (treeEditor == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(5);
            }
            return treeEditor;
        }

        public void update() {
            this.myTree.update();
        }

        public void setFiltered(boolean filtered) {
            if (this.myFiltered == filtered) {
                return;
            }
            this.myFiltered = filtered;
            this.myTree.update();
        }

        private void saveState(Element to) {
            this.saveNodes(to, "checked", (Condition<DbSchemasTree.MyNode>)((Condition)n -> n.isChecked()));
            this.saveNodes(to, "expanded", (Condition<DbSchemasTree.MyNode>)((Condition)n -> this.getTree().isExpanded(new TreePath(((CheckedTreeNode)this.myTree.getSearchModel().getNode((DbSchemasTree.MyNode)n)).getPath()))));
        }

        private void loadState(Element from) {
            this.myTree.update();
            this.loadNodes((DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject(), from.getChild("checked"), (Consumer<DbSchemasTree.MyNode>)((Consumer)n -> n.setChecked(true)));
            this.loadNodes((DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject(), from.getChild("expanded"), (Consumer<DbSchemasTree.MyNode>)((Consumer)n -> this.getTree().expandPath(new TreePath(((CheckedTreeNode)this.myTree.getSearchModel().getNode((DbSchemasTree.MyNode)n)).getPath()))));
        }

        private void saveNodes(Element to, String name, Condition<DbSchemasTree.MyNode> c) {
            Element tgt = new Element(name);
            for (DbSchemasTree.MyNode node : this.myTree.getSearchModel().getChildren(this.myTree.getSearchModel().getRootObject())) {
                this.saveNodes(tgt, node, c);
            }
            if (tgt.getContentSize() != 0) {
                to.addContent(tgt);
            }
        }

        private void loadNodes(DbSchemasTree.MyNode to, Element from, Consumer<DbSchemasTree.MyNode> c) {
            if (from == null) {
                return;
            }
            HashMap map = ContainerUtil.newHashMap();
            for (Element element : from.getChildren()) {
                String key2 = element.getAttributeValue("key");
                if (key2 == null) continue;
                map.put(key2, element);
            }
            for (DbSchemasTree.MyNode node : this.myTree.getSearchModel().getChildren(to)) {
                Element element = (Element)map.get(ExecutionTargetEditor.getKey(node.getObject()));
                if (element == null) continue;
                c.consume((Object)node);
                this.loadNodes(node, element, c);
            }
        }

        private void saveNodes(Element to, @NotNull DbSchemasTree.MyNode node, Condition<DbSchemasTree.MyNode> c) {
            if (node == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(6);
            }
            if (!c.value((Object)node)) {
                return;
            }
            Object obj = node.getObject();
            String key2 = ExecutionTargetEditor.getKey(obj);
            if (key2 == null) {
                return;
            }
            Element cur = new Element("node");
            to.addContent(cur);
            cur.setAttribute("key", key2);
            for (DbSchemasTree.MyNode child : this.myTree.getSearchModel().getChildren(node)) {
                this.saveNodes(cur, child, c);
            }
        }

        private static String getKey(Object obj) {
            String key2 = null;
            if (obj instanceof DatabaseSystem) {
                key2 = ((DatabaseSystem)obj).getUniqueId();
            } else if (obj instanceof DasObject) {
                key2 = ((DasObject)obj).getName();
            }
            return key2;
        }

        public Project getProject() {
            return this.myTree.getProject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dsSupplier";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectionModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTreeActions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createTree";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "saveNodes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @State(name="ExecutionTargetDialog", storages={@Storage(value="$WORKSPACE_FILE$")})
    public static class DialogState
    implements PersistentStateComponent<Element> {
        public volatile Element element;

        @Nullable
        public Element getState() {
            return this.element == null ? null : this.element.clone();
        }

        public void loadState(@NotNull Element state) {
            if (state == null) {
                DialogState.$$$reportNull$$$0(0);
            }
            this.element = state.clone();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/console/ExecutionTargetDialog$DialogState", "loadState"));
        }
    }
}

