/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DataSourceScopeEditorTree
extends DbCheckBoxTree<MyNode> {
    public DataSourceScopeEditorTree(@NotNull CheckedTreeNode root2, @NotNull Getter<Couple<String>> fakeCurrent) {
        if (root2 == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(0);
        }
        if (fakeCurrent == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(1);
        }
        super(root2, new MyTreeCellRenderer(fakeCurrent));
    }

    static CheckedTreeNode createNode(MyNode node) {
        return new CheckedTreeNode(node){

            public boolean isChecked() {
                return ((MyNode)this.getUserObject()).isChecked();
            }

            public void setChecked(boolean checked) {
                ((MyNode)this.getUserObject()).setChecked(checked);
            }

            public boolean isLeaf() {
                MyNode userNode = (MyNode)ObjectUtils.tryCast((Object)this.getUserObject(), MyNode.class);
                if (userNode == null) {
                    return super.isLeaf();
                }
                return (userNode.getObject() == "*" || userNode instanceof CurNode) && userNode.getChildNodes().isEmpty() || userNode.getKind() == ObjectKind.SCHEMA;
            }
        };
    }

    @Nullable
    static DataSourceScopeEditorTree getTree(DataContext dataContext) {
        return (DataSourceScopeEditorTree)((Object)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext), DataSourceScopeEditorTree.class));
    }

    public static boolean matches(Couple<String> fsc, MyNode node) {
        return node.getKind() == ObjectKind.DATABASE ? DataSourceScopeEditorTree.matches(fsc, node.getName(), null) : DataSourceScopeEditorTree.matches(fsc, DataSourceScopeEditorTree.getParentName(node), node.getName());
    }

    @Nullable
    public static String getParentName(MyNode node) {
        MyNode parent = (MyNode)node.getParent();
        return parent != null && parent.getKind() == ObjectKind.DATABASE ? parent.getName() : null;
    }

    public static boolean matches(Couple<String> fsc, String pName, String name) {
        return fsc != null && Comparing.equal((String)((String)fsc.first), (String)pName) && (name == null || Comparing.equal((String)((String)fsc.second), (String)name));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fakeCurrent";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/DataSourceScopeEditorTree";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyTreeCellRenderer
    extends DbCheckBoxTree.CellWithUnderlinedAllRenderer<MyNode> {
        private final Getter<Couple<String>> myCurrent;

        public MyTreeCellRenderer(@NotNull Getter<Couple<String>> current) {
            if (current == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            this.myCurrent = current;
        }

        @Override
        protected void customizeCheckboxRenderer(MyNode node) {
            CurNode cur;
            if (node.getParent() == null) {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            this.renderText(node, (ColoredTextContainer)renderer);
            if (node.getObject() instanceof DasObject && (cur = node.getCurrentSibling()) != null && cur.getCurObject() == node.getObject() && cur.isChecked() && !this.myCheckbox.isSelected()) {
                this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
            }
        }

        @Override
        protected void renderText(MyNode node, ColoredTextContainer renderer) {
            String name = node.getName();
            Couple fcs = (Couple)this.myCurrent.get();
            if (node.getObject() instanceof DasObject) {
                CurNode cur;
                if (StringUtil.isEmpty((String)name)) {
                    renderer.append("<Unnamed>", SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    renderer.append(name, node.getKind() == ObjectKind.DATABASE ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                boolean isCurrent = fcs == null ? (cur = node.getCurrentSibling()) != null && cur.getCurObject() == node.getObject() : DataSourceScopeEditorTree.matches((Couple<String>)fcs, node);
                if (isCurrent) {
                    renderer.append("  (Current " + node.getKind().code() + ")", fcs == null ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                }
            } else if (node instanceof CurNode) {
                renderer.append("Current " + node.getKind().code(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (fcs == null) {
                    DasObject curObject = ((CurNode)node).getCurObject();
                    if (curObject != null) {
                        renderer.append(" (" + curObject.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else {
                    String cur;
                    String string = cur = node.getKind() == ObjectKind.DATABASE ? (String)fcs.first : (String)fcs.second;
                    if (cur != null) {
                        renderer.append(" (" + cur + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                    }
                }
            } else if (node.getObject() == "*") {
                renderer.append("All " + StringUtil.pluralize((String)node.getKind().code()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                renderer.append(StringUtil.isEmpty((String)name) ? "<Unnamed>" : name, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyTreeCellRenderer", "<init>"));
        }
    }

    static class CurNode
    extends MyNode {
        private DasObject myCurObject;

        public CurNode(ObjectKind kind, DasObject curObject) {
            super("Current", kind, "@");
            this.myCurObject = curObject;
        }

        public DasObject getCurObject() {
            return this.myCurObject;
        }

        public void setCurObject(DasObject curObject) {
            this.myCurObject = curObject;
        }
    }

    static class MyNode
    extends DbCheckBoxTree.MyNode<MyNode> {
        private CurNode myCurNode = null;

        public MyNode(String name, ObjectKind kind, Object object) {
            super(name, kind, object);
        }

        @Nullable
        public CurNode getCurrentSibling() {
            MyNode parent = (MyNode)this.getParent();
            return parent == null ? null : parent.getCurNode();
        }

        @Nullable
        public CurNode getCurNode() {
            return this.myCurNode;
        }

        @Override
        @NotNull
        protected MyNode createAll() {
            MyNode myNode = new MyNode("All", this.getAllKind(), "*");
            if (myNode == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            return myNode;
        }

        @Override
        @NotNull
        public Iterable<MyNode> getSimpleChildNodes() {
            JBIterable jBIterable = this.myCurNode == null ? super.getSimpleChildNodes() : JBIterable.of((Object)this.myCurNode).append(super.getSimpleChildNodes());
            if (jBIterable == null) {
                MyNode.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public void setHasAllAndCur(boolean has) {
            this.setHasAll(has);
            if (has == (this.myCurNode != null)) {
                return;
            }
            if (has) {
                this.myCurNode = new CurNode(this.getAllKind(), null);
                this.reparent(Collections.singletonList(this.myCurNode));
            } else {
                this.myCurNode = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAll";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleChildNodes";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

