/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportTarget;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReaderTask
implements Runnable {
    private static final String IO_ERROR = "Import failed. Can't access file.";
    private final LinkedTransferQueue<Result> myTransferQueue;
    private final Input myInput;
    private final AtomicReference<String> myError;
    private volatile boolean myStopped;

    ReaderTask(@NotNull Input input, @NotNull LinkedTransferQueue<Result> transferQueue) {
        if (input == null) {
            ReaderTask.$$$reportNull$$$0(0);
        }
        if (transferQueue == null) {
            ReaderTask.$$$reportNull$$$0(1);
        }
        this.myTransferQueue = transferQueue;
        this.myInput = input;
        this.myError = new AtomicReference();
    }

    void stop() {
        this.myStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (Input input = this.myInput;){
            Result records;
            while ((records = input.read()) != null) {
                this.send(records);
            }
        }
        catch (InterruptedException e) {
            this.onStop();
        }
        catch (IOException e) {
            this.onError(IO_ERROR);
        }
        catch (Exception e) {
            this.onError(e.getMessage());
        }
        finally {
            this.poisonQueue();
        }
    }

    private void poisonQueue() {
        if (this.myStopped) {
            return;
        }
        this.send(Result.POISON);
        this.myStopped = true;
    }

    private void send(@NotNull Result parameters) {
        if (parameters == null) {
            ReaderTask.$$$reportNull$$$0(2);
        }
        try {
            this.myTransferQueue.transfer(parameters);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.onStop();
        }
    }

    private void onStop() {
        if (this.myStopped) {
            return;
        }
        this.myTransferQueue.clear();
        this.myTransferQueue.offer(Result.POISON);
        this.myStopped = true;
    }

    private void onError(@NotNull String message) {
        if (message == null) {
            ReaderTask.$$$reportNull$$$0(3);
        }
        this.myError.set(message);
    }

    @Nullable
    public String getError() {
        return this.myError.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferQueue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dbimport/ReaderTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "send";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ImporterImpl
    implements Importer {
        private final BatchRecords myRecords;
        private final List<ErrorRecord> myErrorRecords;

        public ImporterImpl(@NotNull BatchRecords records, @NotNull List<ErrorRecord> errorRecords) {
            if (records == null) {
                ImporterImpl.$$$reportNull$$$0(0);
            }
            if (errorRecords == null) {
                ImporterImpl.$$$reportNull$$$0(1);
            }
            this.myRecords = records;
            this.myErrorRecords = errorRecords;
        }

        @Override
        public void insert(@NotNull ImportInfo info, @NotNull ImportTarget target, @NotNull ImportIndicatorUpdater updater, @NotNull ImportErrorHandler handler) throws RemoteException, SQLException {
            if (info == null) {
                ImporterImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                ImporterImpl.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ImporterImpl.$$$reportNull$$$0(4);
            }
            if (handler == null) {
                ImporterImpl.$$$reportNull$$$0(5);
            }
            ArrayList errorRecords = ContainerUtil.newArrayList(this.myErrorRecords);
            if (!this.myRecords.isEmpty()) {
                errorRecords.addAll(target.importBatch(info, this.myRecords));
            }
            handler.handle(errorRecords);
            updater.update(this.myRecords, this.myRecords.getLinesCount() + this.myErrorRecords.size());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorRecords";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ReaderTask$ImporterImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insert";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ResultImpl
    implements Result {
        private final BatchRecords myRecords;
        private final List<ErrorRecord> myErrors;

        public ResultImpl(@NotNull BatchRecords records) {
            if (records == null) {
                ResultImpl.$$$reportNull$$$0(0);
            }
            this(records, ContainerUtil.newArrayList());
        }

        public ResultImpl(@NotNull BatchRecords records, @NotNull List<ErrorRecord> errors) {
            if (records == null) {
                ResultImpl.$$$reportNull$$$0(1);
            }
            if (errors == null) {
                ResultImpl.$$$reportNull$$$0(2);
            }
            this.myRecords = records;
            this.myErrors = errors;
        }

        @Override
        @NotNull
        public Importer prepare(@NotNull ImportInfo info) {
            if (info == null) {
                ResultImpl.$$$reportNull$$$0(3);
            }
            ImportInfo.Cache cache2 = info.cache();
            List records = this.myRecords.getRecords();
            BatchRecords.Builder builder = this.myRecords.builder();
            for (int i2 = 0; i2 < records.size(); ++i2) {
                Object[] line = (Object[])records.get(i2);
                try {
                    builder.record(cache2.convertLine(line), i2);
                    continue;
                }
                catch (ImportInfo.ConversionException e) {
                    this.myErrors.add(this.myRecords.getErrorRecord((Exception)e, i2));
                }
            }
            ImporterImpl importerImpl = new ImporterImpl(builder.size(this.myRecords.getBatchSize()).build(), this.myErrors);
            if (importerImpl == null) {
                ResultImpl.$$$reportNull$$$0(4);
            }
            return importerImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errors";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ReaderTask$ResultImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ReaderTask$ResultImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Importer {
        public static final Importer INACTIVE = new Importer(){

            @Override
            public void insert(@NotNull ImportInfo info, @NotNull ImportTarget target, @NotNull ImportIndicatorUpdater updater, @NotNull ImportErrorHandler handler) {
                if (info == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (target == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (updater == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "info";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "target";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "updater";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "handler";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dbimport/ReaderTask$Importer$1";
                objectArray[2] = "insert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        public void insert(@NotNull ImportInfo var1, @NotNull ImportTarget var2, @NotNull ImportIndicatorUpdater var3, @NotNull ImportErrorHandler var4) throws RemoteException, SQLException;
    }

    public static interface Result {
        public static final Result POISON = new Result(){

            @Override
            @NotNull
            public Importer prepare(@NotNull ImportInfo info) {
                if (info == null) {
                    1.$$$reportNull$$$0(0);
                }
                Importer importer = Importer.INACTIVE;
                if (importer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return importer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dbimport/ReaderTask$Result$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dbimport/ReaderTask$Result$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "prepare";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "prepare";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        @NotNull
        public Importer prepare(@NotNull ImportInfo var1);
    }

    public static interface Input
    extends AutoCloseable {
        @Nullable
        public Result read() throws Exception;

        public void calculateSize(@NotNull Consumer<Double> var1);

        @NotNull
        public ImportIndicatorUpdater getIndicatorUpdater(@NotNull ProgressIndicator var1, @NotNull DoubleAdder var2, @NotNull ImportInfo var3);
    }
}

