/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresForeignTable;
import com.intellij.database.model.postgres.PostgresModCheck;
import com.intellij.database.model.postgres.PostgresModForeignTableColumn;
import com.intellij.database.model.postgres.PostgresModRule;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModTable;
import com.intellij.database.model.postgres.PostgresModTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModForeignTable
extends PostgresForeignTable,
PostgresModTable {
    @Override
    @NotNull
    public PostgresModSchema getSchema();

    @Override
    @NotNull
    default public PostgresModSchema getParent() {
        PostgresModSchema postgresModSchema = this.getSchema();
        if (postgresModSchema == null) {
            PostgresModForeignTable.$$$reportNull$$$0(0);
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModForeignTable> getParentFamily();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModRule> getRules();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends PostgresModForeignTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModCheck> getChecks();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getRules(), this.getColumns(), this.getChecks(), this.getTriggers());
        if (list == null) {
            PostgresModForeignTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setTemporary(boolean var1);

    @Override
    public void setAncestorIds(@NotNull List<Long> var1);

    @Override
    default public void setAncestorIds(Long ... ancestorIds) {
        this.setAncestorIds(Arrays.asList(ancestorIds));
    }

    @Override
    public void setSuccessorIds(@NotNull Set<Long> var1);

    public void setServer(@Nullable String var1);

    public void setOptions(@NotNull List<String> var1);

    default public void setOptions(String ... options) {
        this.setOptions(Arrays.asList(options));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            PostgresModForeignTable.$$$reportNull$$$0(2);
        }
        String objectId = _properties.get("ObjectId");
        String name = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String system = _properties.get("System");
        String stateNumber = _properties.get("StateNumber");
        String temporary = _properties.get("Temporary");
        String ancestorIds = _properties.get("AncestorIds");
        String successorIds = _properties.get("SuccessorIds");
        String server = _properties.get("Server");
        String options = _properties.get("Options");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setSystem(system != null ? PropertyConverter.importBoolean(system) : false);
        this.setStateNumber(stateNumber != null ? PropertyConverter.importLong(stateNumber) : 0L);
        this.setTemporary(temporary != null ? PropertyConverter.importBoolean(temporary) : false);
        this.setAncestorIds(ancestorIds != null ? PropertyConverter.importListOfLong(ancestorIds) : Collections.emptyList());
        this.setSuccessorIds(successorIds != null ? PropertyConverter.importSetOfLong(successorIds) : Collections.emptySet());
        this.setServer(server != null ? PropertyConverter.importString(server) : null);
        this.setOptions(options != null ? PropertyConverter.importListOfString(options) : Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresModForeignTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresModForeignTable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

