/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresModLikeStoredTable;
import com.intellij.database.model.postgres.PostgresModLikeTrigger;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresRule;
import com.intellij.database.model.postgresbase.PostgresBaseModSourceAware;
import com.intellij.database.model.properties.PostgresFireMode;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModRule
extends PostgresRule,
PostgresModLikeTrigger,
PostgresBaseModSourceAware {
    @Override
    @NotNull
    public PostgresModLikeStoredTable getLikeStoredTable();

    @Override
    @NotNull
    default public PostgresModLikeStoredTable getParent() {
        PostgresModLikeStoredTable postgresModLikeStoredTable = this.getLikeStoredTable();
        if (postgresModLikeStoredTable == null) {
            PostgresModRule.$$$reportNull$$$0(0);
        }
        return postgresModLikeStoredTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModRule> getParentFamily();

    @Override
    @NotNull
    default public PostgresModSchema getSchema() {
        PostgresModSchema postgresModSchema = this.getLikeStoredTable().getSchema();
        if (postgresModSchema == null) {
            PostgresModRule.$$$reportNull$$$0(1);
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            PostgresModRule.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setTurn(@Nullable TrigTurn var1);

    @Override
    public void setEvents(@NotNull Set<TrigEvent> var1);

    @Override
    public void setCondition(@Nullable String var1);

    @Override
    public void setFireMode(@Nullable PostgresFireMode var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    public void setCommands(@NotNull List<String> var1);

    default public void setCommands(String ... commands) {
        this.setCommands(Arrays.asList(commands));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            PostgresModRule.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String stateNumber = _properties.get("StateNumber");
        String turn = _properties.get("Turn");
        String events = _properties.get("Events");
        String condition = _properties.get("Condition");
        String fireMode = _properties.get("FireMode");
        String invalid = _properties.get("Invalid");
        String commands = _properties.get("Commands");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setStateNumber(stateNumber != null ? PropertyConverter.importLong(stateNumber) : 0L);
        this.setTurn(turn != null ? PropertyConverter.importTrigTurn(turn) : null);
        this.setEvents(events != null ? PropertyConverter.importSetOfTrigEvent(events) : Collections.emptySet());
        this.setCondition(condition != null ? PropertyConverter.importString(condition) : null);
        this.setFireMode(fireMode != null ? PropertyConverter.importPostgresFireMode(fireMode) : null);
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean(invalid) : false);
        this.setCommands(commands != null ? PropertyConverter.importListOfString(commands) : Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresModRule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresModRule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

