/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseView;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.redshift.RedshiftLikeStoredTable;
import com.intellij.database.model.redshift.RedshiftSchema;
import com.intellij.database.model.redshift.RedshiftViewColumn;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftView
extends RedshiftLikeStoredTable,
PostgresBaseView {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.VIEW;
        if (objectKind == null) {
            RedshiftView.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public RedshiftSchema getSchema();

    @Override
    @Nullable
    default public RedshiftSchema getParent() {
        return this.getSchema();
    }

    default public @NotNull @Nullable NamingIdentifyingFamily<? extends RedshiftView> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull @NotNull PositioningNamingFamily<? extends RedshiftViewColumn> getColumns();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.COLUMN);
        if (list == null) {
            RedshiftView.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List<PositioningNamingFamily<? extends RedshiftViewColumn>> list = Collections.singletonList(this.getColumns());
        if (list == null) {
            RedshiftView.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = Collections.emptyList();
        if (list == null) {
            RedshiftView.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    default public boolean isInvalid() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean invalid;
        long stateNumber;
        boolean system;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            RedshiftView.$$$reportNull$$$0(4);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", PropertyConverter.export(invalid));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "System", "StateNumber", "Errors", "Invalid");
        if (list == null) {
            RedshiftView.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/redshift/RedshiftView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/redshift/RedshiftView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

