/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sqlite.SqliteModLikeTable;
import com.intellij.database.model.sqlite.SqliteModSchema;
import com.intellij.database.model.sqlite.SqliteModTrigger;
import com.intellij.database.model.sqlite.SqliteModVirtualTableColumn;
import com.intellij.database.model.sqlite.SqliteVirtualTable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteModVirtualTable
extends SqliteVirtualTable,
SqliteModLikeTable {
    @Override
    @NotNull
    public SqliteModSchema getSchema();

    @Override
    @NotNull
    default public SqliteModSchema getParent() {
        SqliteModSchema sqliteModSchema = this.getSchema();
        if (sqliteModSchema == null) {
            SqliteModVirtualTable.$$$reportNull$$$0(0);
        }
        return sqliteModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends SqliteModVirtualTable> getParentFamily();

    @Override
    @NotNull
    public ModNamingFamily<? extends SqliteModTrigger> getTriggers();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends SqliteModVirtualTableColumn> getColumns();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getTriggers(), this.getColumns());
        if (list == null) {
            SqliteModVirtualTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    public void setModule(@Nullable String var1);

    public void setArguments(@NotNull List<String> var1);

    default public void setArguments(String ... arguments) {
        this.setArguments(Arrays.asList(arguments));
    }

    public void setTemporary(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            SqliteModVirtualTable.$$$reportNull$$$0(2);
        }
        String name = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String system = _properties.get("System");
        String module = _properties.get("Module");
        String arguments = _properties.get("Arguments");
        String temporary = _properties.get("Temporary");
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setSystem(system != null ? PropertyConverter.importBoolean(system) : false);
        this.setModule(module != null ? PropertyConverter.importString(module) : null);
        this.setArguments(arguments != null ? PropertyConverter.importListOfString(arguments) : Collections.emptyList());
        this.setTemporary(temporary != null ? PropertyConverter.importBoolean(temporary) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/sqlite/SqliteModVirtualTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/sqlite/SqliteModVirtualTable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

