/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public class RevertMutations
extends DumbAwareAction
implements GridAction {
    public void update(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        if (grid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GridDataSupport support = grid.getDataSupport();
        boolean hasChanges = support.hasPendingChanges();
        boolean visible = (!support.isSubmitImmediately() || hasChanges) && !grid.getDataHookup().isReadOnly();
        boolean enabled = visible && hasChanges && support.canRevert() && RevertMutations.hasChangeUnderSelection(grid);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        if (grid == null || !grid.getDataSupport().hasRowMutator()) {
            return;
        }
        GridDataSupport support = grid.getDataSupport();
        ModelIndexSet<DataConsumer.Column> columns2 = grid.getSelectionModel().getSelectedColumns();
        ModelIndexSet<DataConsumer.Row> rows = grid.getSelectionModel().getSelectedRows();
        if (columns2.size() != 0 && rows.size() != 0) {
            support.revert(rows, columns2);
        }
    }

    private static boolean hasChangeUnderSelection(@NotNull DataGrid grid) {
        if (grid == null) {
            RevertMutations.$$$reportNull$$$0(0);
        }
        SelectionModel model = grid.getSelectionModel();
        ModelIndexSet rows = model.getSelectedRows();
        ModelIndexSet columns2 = model.getSelectedColumns();
        GridDataSupport support = grid.getDataSupport();
        for (ModelIndex rowIdx : rows.asIterable()) {
            ModelIndexSet<DataConsumer.Row> rowIdxSet = ModelIndexSet.forRows(grid, rowIdx.asInteger());
            if (support.isDeletedRows(rowIdxSet) || grid.isInsertedRow(rowIdx)) {
                return true;
            }
            for (ModelIndex columnIdx : columns2.asIterable()) {
                if (!support.isModified(rowIdx, columnIdx)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/actions/RevertMutations", "hasChangeUnderSelection"));
    }
}

