/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.session;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.SessionView;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import icons.DatabaseIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class BaseSessionView<S extends Session<?, ?>>
implements SessionView<S> {
    public static final String OUTPUT_CONTENT_ID = "Input";
    private static final Logger LOG = Logger.getInstance(BaseSessionView.class);
    private final LanguageConsoleView myConsoleView;
    private final RunnerLayoutUi myUi;
    private final Content myContent;
    private final DataAuditor.ConsoleLogger myHistoryLogger;
    private final S mySession;
    private final SessionLogger mySessionLogger;
    private SyntaxHighlighter myHighlighter;

    public BaseSessionView(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull LanguageConsoleView consoleView, @NotNull S session) {
        if (project == null) {
            BaseSessionView.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            BaseSessionView.$$$reportNull$$$0(1);
        }
        if (consoleView == null) {
            BaseSessionView.$$$reportNull$$$0(2);
        }
        if (session == null) {
            BaseSessionView.$$$reportNull$$$0(3);
        }
        this.myConsoleView = consoleView;
        this.mySession = session;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create(this.getToolWindowId(), this.getTitle(), this.getTitle(), (Disposable)this);
        this.myUi.getContentManager().addDataProvider((DataProvider)this);
        this.myContent = ContentFactory.SERVICE.getInstance().createContent(this.myUi.getComponent(), this.getTitle(), false);
        this.myContent.setIcon(DatabaseIcons.Table);
        ((ConsoleViewImpl)consoleView).setEmulateCarriageReturn(false);
        this.myHistoryLogger = this.createHistoryLogger(consoleView);
        this.mySessionLogger = this.createAuditor();
        messageBus.addAuditor(this.mySessionLogger);
        Disposer.register((Disposable)this, (Disposable)this.myConsoleView);
    }

    @Override
    @NotNull
    public S getSession() {
        S s = this.mySession;
        if (s == null) {
            BaseSessionView.$$$reportNull$$$0(4);
        }
        return s;
    }

    @Override
    public boolean isShowing() {
        return this.isValid() && this.myUi.getComponent().isShowing();
    }

    @Override
    @NotNull
    public DataAuditor.ConsoleLogger getHistoryLogger() {
        DataAuditor.ConsoleLogger consoleLogger = this.myHistoryLogger;
        if (consoleLogger == null) {
            BaseSessionView.$$$reportNull$$$0(5);
        }
        return consoleLogger;
    }

    @Override
    @NotNull
    public LanguageConsoleView getConsoleView() {
        LanguageConsoleView languageConsoleView = this.myConsoleView;
        if (languageConsoleView == null) {
            BaseSessionView.$$$reportNull$$$0(6);
        }
        return languageConsoleView;
    }

    @Override
    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.myUi;
        if (runnerLayoutUi == null) {
            BaseSessionView.$$$reportNull$$$0(7);
        }
        return runnerLayoutUi;
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            BaseSessionView.$$$reportNull$$$0(8);
        }
        return content;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myConsoleView.getProject();
        if (project == null) {
            BaseSessionView.$$$reportNull$$$0(9);
        }
        return project;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = this.myConsoleView.getTitle();
        if (string == null) {
            BaseSessionView.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public Object getData(String dataId) {
        return Session.SESSION_KEY.is(dataId) ? this.mySession : null;
    }

    @Override
    @NotNull
    public Promise<Void> show(boolean activate, boolean requestFocus) {
        ContentManager contentManager;
        if (!this.mySession.isValid()) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                BaseSessionView.$$$reportNull$$$0(11);
            }
            return promise;
        }
        ToolWindow window = this.getOrCreateToolWindow();
        this.ensureContentInitialized(requestFocus);
        this.beforeExecution();
        if (this.myContent.getManager() == null) {
            for (Session session : AbstractQueryLanguageConsole.getActiveSessions(this.getProject(), this.getToolWindowId())) {
                if (session.getView().getConsoleView().getFile() != this.getConsoleView().getFile()) continue;
                LOG.error("Console already created for " + this.getConsoleView().getFile().getName());
            }
            contentManager = window.getContentManager();
            window.setAvailable(true, null);
            this.myContent.getComponent().updateUI();
            contentManager.addContent(this.myContent);
        } else {
            contentManager = this.myContent.getManager();
        }
        if (activate) {
            AsyncPromise callback = new AsyncPromise();
            window.activate(() -> {
                if (!this.myContent.isValid()) {
                    return;
                }
                contentManager.setSelectedContent(this.myContent, requestFocus, false);
                callback.setResult(null);
            }, false, requestFocus);
            AsyncPromise asyncPromise = callback;
            if (asyncPromise == null) {
                BaseSessionView.$$$reportNull$$$0(12);
            }
            return asyncPromise;
        }
        contentManager.setSelectedContent(this.myContent, requestFocus, false);
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            BaseSessionView.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @NotNull
    private ToolWindow getOrCreateToolWindow() {
        Project project = this.getProject();
        String windowId = this.getToolWindowId();
        Icon icon = this.getToolWindowIcon();
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ToolWindowEx window = (ToolWindowEx)manager.getToolWindow(windowId);
        if (window == null) {
            window = (ToolWindowEx)manager.registerToolWindow(windowId, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
            window.setIcon(icon);
            ToolWindowEx w = window;
            w.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter((ToolWindow)w, manager, windowId){
                final /* synthetic */ ToolWindow val$w;
                final /* synthetic */ ToolWindowManager val$manager;
                final /* synthetic */ String val$windowId;
                {
                    this.val$w = toolWindow;
                    this.val$manager = toolWindowManager;
                    this.val$windowId = string;
                }

                public void contentRemoved(ContentManagerEvent event) {
                    if (this.val$w.getContentManager().getContentCount() == 0) {
                        this.val$w.hide(null);
                        this.val$manager.unregisterToolWindow(this.val$windowId);
                    }
                }
            });
            this.setupToolWindow(window);
        }
        ToolWindowEx toolWindowEx = window;
        if (toolWindowEx == null) {
            BaseSessionView.$$$reportNull$$$0(14);
        }
        return toolWindowEx;
    }

    @Override
    public void beforeExecution() {
        EditorHighlighter highlighter = this.myConsoleView.getCurrentEditor().getHighlighter();
        this.myHighlighter = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
    }

    @Override
    public void addRequestToHistory(@NotNull DataRequest.Context context) {
        String query;
        if (context == null) {
            BaseSessionView.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmpty((String)(query = context.getQuery()))) {
            return;
        }
        LanguageConsoleView console = this.getConsoleView();
        String prompt = console.getPrompt();
        if (StringUtil.isNotEmpty((String)prompt)) {
            console.print(prompt, (ConsoleViewContentType)ObjectUtils.notNull((Object)console.getPromptAttributes(), (Object)ConsoleViewContentType.USER_INPUT));
        }
        String adjustedQuery = StringUtil.convertLineSeparators((String)query);
        if (this.myHighlighter != null) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)console, (String)adjustedQuery, (SyntaxHighlighter)this.myHighlighter);
        } else {
            console.print(adjustedQuery, ConsoleViewContentType.USER_INPUT);
        }
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
    }

    @Override
    @Nullable
    public Content getOutputContent() {
        return this.getUi().findContent(OUTPUT_CONTENT_ID);
    }

    public void dispose() {
        ContentManager manager = this.getContent().getManager();
        if (manager != null) {
            manager.removeContent(this.getContent(), false);
        }
        Disposer.dispose((Disposable)this.getContent());
    }

    @Override
    public void startLoading() {
        this.withLoadingPanel((Consumer<JBLoadingPanel>)((Consumer)p -> p.startLoading()));
    }

    @Override
    public void stopLoading() {
        this.withLoadingPanel((Consumer<JBLoadingPanel>)((Consumer)p -> p.stopLoading()));
    }

    @NotNull
    public SessionLogger getSessionLogger() {
        SessionLogger sessionLogger = this.mySessionLogger;
        if (sessionLogger == null) {
            BaseSessionView.$$$reportNull$$$0(16);
        }
        return sessionLogger;
    }

    public void ensureContentInitialized(boolean focused) {
        if (this.myContent.getDisposer() != null) {
            return;
        }
        this.myContent.setDisposer(new Disposable(){

            public void dispose() {
                Disposer.dispose((Disposable)BaseSessionView.this.mySession);
            }
        });
        this.buildConsoleUi(focused);
    }

    @Override
    public boolean isValid() {
        return !this.getUi().isDisposed() && !this.getConsoleView().getHistoryViewer().isDisposed() && this.getConsoleView().getVirtualFile().isValid();
    }

    @NotNull
    protected DataAuditor.ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            BaseSessionView.$$$reportNull$$$0(17);
        }
        DataAuditor.ConsoleLogger consoleLogger = new DataAuditor.ConsoleLogger((ConsoleView)consoleView);
        if (consoleLogger == null) {
            BaseSessionView.$$$reportNull$$$0(18);
        }
        return consoleLogger;
    }

    @NotNull
    protected SessionLogger createAuditor() {
        SessionLogger sessionLogger = new SessionLogger(this);
        if (sessionLogger == null) {
            BaseSessionView.$$$reportNull$$$0(19);
        }
        return sessionLogger;
    }

    protected void setupToolWindow(@NotNull ToolWindowEx window) {
        if (window == null) {
            BaseSessionView.$$$reportNull$$$0(20);
        }
    }

    private void withLoadingPanel(@NotNull Consumer<JBLoadingPanel> consumer) {
        Content content;
        JComponent component;
        if (consumer == null) {
            BaseSessionView.$$$reportNull$$$0(21);
        }
        JComponent jComponent = component = (content = this.getOutputContent()) == null ? null : content.getComponent();
        if (!(component instanceof JBLoadingPanel)) {
            return;
        }
        JBLoadingPanel loadingPanel = (JBLoadingPanel)component;
        consumer.consume((Object)loadingPanel);
    }

    protected abstract void buildConsoleUi(boolean var1);

    @NotNull
    public abstract Icon getToolWindowIcon();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/session/BaseSessionView";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/session/BaseSessionView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryLogger";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateToolWindow";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionLogger";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createHistoryLogger";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRequestToHistory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createHistoryLogger";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setupToolWindow";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withLoadingPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

