/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.model.delta.ElementCreation;
import com.intellij.database.model.delta.ElementDelta;
import com.intellij.database.model.delta.ElementRemotion;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseAlterGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.EffectType;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.Producer;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptingAlterTask;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.vfs.ObjectPath;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a3\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0012*\u0001\b\b&\u0018\u0000 ^2\u00020\u0001:\u0011NOPQRSTUVWXYZ[\\]^B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0004Jg\u0010$\u001a\u00020%2\u0010\u0010&\u001a\f\u0012\u0006\b\u0001\u0012\u00020!\u0018\u00010'2\u0010\u0010(\u001a\f\u0012\u0006\b\u0001\u0012\u00020!\u0018\u00010'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020#0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020#0*2\u001c\b\u0002\u0010,\u001a\u0016\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010%0-H\u0084\bJ\u0012\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0/H\u0002J\u001c\u00100\u001a\n\u0012\u0002\b\u000301R\u00020\u00002\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0016J\u0012\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u0002080*H\u0016J\u001c\u00109\u001a\u00020%2\b\u0010:\u001a\u0004\u0018\u00010\f2\b\u0010;\u001a\u0004\u0018\u00010\fH\u0004J\u001e\u0010<\u001a\u0004\u0018\u00010\u001c2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010>\u001a\u00020\u001cH\u0016J\u001a\u0010?\u001a\u0004\u0018\u00010\u001c2\u0006\u0010@\u001a\u00020\f2\u0006\u0010>\u001a\u00020\u001cH\u0002J\u001a\u0010A\u001a\u0004\u0018\u00010\u001c2\u0006\u0010@\u001a\u00020\f2\u0006\u0010>\u001a\u00020\u001cH\u0002J(\u0010B\u001a\u0004\u0018\u00010\u001c2\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010>\u001a\u00020\u001c2\b\b\u0002\u0010C\u001a\u00020%H\u0014J\b\u0010D\u001a\u00020\u001fH\u0016J#\u0010E\u001a\u0004\u0018\u0001HF\"\b\b\u0000\u0010F*\u00020\f*\b\u0012\u0004\u0012\u0002HF0\rH\u0002\u00a2\u0006\u0002\u0010GJ-\u0010H\u001a\b\u0012\u0004\u0012\u0002HF03\"\b\b\u0000\u0010F*\u00020\f*\u0006\u0012\u0002\b\u0003032\u0006\u00106\u001a\u0002HFH\u0004\u00a2\u0006\u0002\u0010IJ \u0010J\u001a\u00020\u001f\"\b\b\u0000\u0010F*\u00020\f*\f\u0012\u0004\u0012\u0002HF01R\u00020\u0000H\u0014J \u0010K\u001a\u00020\u001f\"\b\b\u0000\u0010F*\u00020\f*\f\u0012\u0004\u0012\u0002HF01R\u00020\u0000H\u0014J\u000e\u0010L\u001a\u0004\u0018\u00010#*\u00020MH\u0014R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR8\u0010\n\u001a&\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000bj\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r`\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R8\u0010\u0011\u001a&\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000bj\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r`\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR0\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001c0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001c`\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010\u00a8\u0006_"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "CYCLIC_RENAME_FIXER", "com/intellij/database/scripting/BaseAlterGenerator$CYCLIC_RENAME_FIXER$1", "Lcom/intellij/database/scripting/BaseAlterGenerator$CYCLIC_RENAME_FIXER$1;", "bySource", "Ljava/util/HashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/delta/ElementDelta;", "Lkotlin/collections/HashMap;", "getBySource", "()Ljava/util/HashMap;", "byTarget", "getByTarget", "creator", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "getCreator", "()Lcom/intellij/database/scripting/BaseCreatingGenerator;", "dropper", "Lcom/intellij/database/scripting/BaseDropGenerator;", "getDropper", "()Lcom/intellij/database/scripting/BaseDropGenerator;", "prepared", "Lcom/intellij/database/scripting/Operation;", "getPrepared", "alterColumn", "", "c", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "rename", "", "checkAlterColumnsImpl", "", "f1", "Lcom/intellij/database/model/families/NamingFamily;", "f2", "cols1", "", "cols2", "extra", "Lkotlin/Function2;", "correspondence", "", "createAlterProducer", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "depth", "", "e", "getEdgeFixers", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "isAlteredTo", "e1", "e2", "makeAlterOperation", "delta", "root", "makeCreateOperation", "element", "makeDropOperation", "prepareElement", "forceRoot", "prepareScenario", "anyElement", "T", "(Lcom/intellij/database/model/delta/ElementDelta;)Lcom/intellij/database/model/basic/BasicElement;", "cast", "(Lcom/intellij/database/model/delta/ElementAlteration;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/delta/ElementAlteration;", "genericAlterComment", "genericRename", "getKindName", "Lcom/intellij/database/model/ObjectKind;", "AlterCheck", "AlterColumniation", "AlterDatabase", "AlterForeignKey", "AlterIndex", "AlterKey", "AlterProducer", "AlterRoutine", "AlterSchema", "AlterSequence", "AlterSynonym", "AlterTable", "AlterTableColumn", "AlterTrigger", "AlterUnknown", "AlterView", "Companion", "intellij.database.scripting"})
public abstract class BaseAlterGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final HashMap<BasicElement, ElementDelta<?>> bySource;
    @NotNull
    private final HashMap<BasicElement, ElementDelta<?>> byTarget;
    @NotNull
    private final HashMap<BasicElement, Operation> prepared;
    private final CYCLIC_RENAME_FIXER.1 CYCLIC_RENAME_FIXER;
    @NotNull
    private static final OperationType ALTER;
    public static final Companion Companion;

    @NotNull
    protected abstract BaseCreatingGenerator getCreator();

    @NotNull
    protected abstract BaseDropGenerator getDropper();

    @NotNull
    protected final HashMap<BasicElement, ElementDelta<?>> getBySource() {
        return this.bySource;
    }

    @NotNull
    protected final HashMap<BasicElement, ElementDelta<?>> getByTarget() {
        return this.byTarget;
    }

    @NotNull
    protected final HashMap<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    private final Collection<ElementDelta<?>> correspondence() {
        Object object;
        ScriptingTask scriptingTask = this.getTask();
        if (!(scriptingTask instanceof ScriptingAlterTask)) {
            scriptingTask = null;
        }
        if ((object = (ScriptingAlterTask)scriptingTask) == null || (object = ((ScriptingAlterTask)object).getCorrespondence()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final int depth(BasicElement e) {
        int d = 0;
        for (BasicElement t = e; t != null; t = t.getParent()) {
        }
        return ++d;
    }

    @Override
    public void prepareScenario() {
        Iterable $receiver$iv = this.correspondence();
        Iterable iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(this){
            final /* synthetic */ BaseAlterGenerator this$0;
            {
                this.this$0 = baseAlterGenerator;
            }

            public final int compare(T a, T b) {
                ElementDelta it = (ElementDelta)a;
                Comparable comparable = Integer.valueOf(BaseAlterGenerator.access$depth(this.this$0, BaseAlterGenerator.access$anyElement(this.this$0, it)));
                it = (ElementDelta)b;
                Comparable comparable2 = comparable;
                Integer n = BaseAlterGenerator.access$depth(this.this$0, BaseAlterGenerator.access$anyElement(this.this$0, it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List downwards = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        $receiver$iv = downwards;
        for (Object element$iv : $receiver$iv) {
            ElementDelta it = (ElementDelta)element$iv;
            BaseAlterGenerator.prepareElement$default(this, it, this.getScenario().getRoot(), false, 4, null);
        }
        this.getDropper().fillDependencies();
    }

    @NotNull
    protected final <T extends BasicElement> ElementAlteration<T> cast(@NotNull ElementAlteration<?> $receiver, @NotNull T e) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        return $receiver;
    }

    private final <T extends BasicElement> T anyElement(@NotNull ElementDelta<? extends T> $receiver) {
        T t = $receiver.getSourceElement();
        if (t == null) {
            t = $receiver.getTargetElement();
        }
        return t;
    }

    @Nullable
    protected Operation prepareElement(@NotNull ElementDelta<?> element, @NotNull Operation root2, boolean forceRoot) {
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        return this.makeAlterOperation(element, root2);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Operation prepareElement$default(BaseAlterGenerator baseAlterGenerator, ElementDelta elementDelta, Operation operation, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseAlterGenerator.prepareElement(elementDelta, operation, bl);
    }

    @Nullable
    public Operation makeAlterOperation(@NotNull ElementDelta<?> delta, @NotNull Operation root2) {
        Intrinsics.checkParameterIsNotNull(delta, (String)"delta");
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        if (delta instanceof ElementCreation) {
            return this.makeCreateOperation((BasicElement)((ElementCreation)delta).getTargetElement(), root2);
        }
        if (delta instanceof ElementRemotion) {
            return this.makeDropOperation((BasicElement)((ElementRemotion)delta).getSourceElement(), root2);
        }
        if (delta instanceof ElementAlteration) {
            AlterProducer<?> alterProducer = this.createAlterProducer((ElementAlteration)delta);
            return alterProducer != null ? alterProducer.register(root2) : null;
        }
        return null;
    }

    private final Operation makeDropOperation(BasicElement element, Operation root2) {
        return BaseDropGenerator.prepareElement$default(this.getDropper(), element, root2, false, 4, null);
    }

    private final Operation makeCreateOperation(BasicElement element, Operation root2) {
        Operation operation;
        Operation operation2 = BaseCreatingGenerator.prepareElement$default(this.getCreator(), element, root2, false, 4, null);
        if (operation2 != null) {
            Operation operation3;
            Operation $receiver = operation3 = operation2;
            ScenarioOperations.requires($receiver, ScenarioOperations.parents(EffectType.Modified, element));
            operation = operation3;
        } else {
            operation = null;
        }
        return operation;
    }

    @NotNull
    public AlterProducer<?> createAlterProducer(@NotNull ElementAlteration<?> elements) {
        Object obj;
        Object it;
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Object obj2 = it = (obj = elements.getSourceElement());
        return obj2 instanceof BasicDatabase ? (AlterProducer)new AlterDatabase(this.cast(elements, (BasicElement)it)) : (obj2 instanceof BasicSchema ? (AlterProducer)new AlterSchema(this.cast(elements, (BasicElement)it)) : (obj2 instanceof BasicTable ? (AlterProducer)new AlterTable(this.cast(elements, (BasicElement)it)) : (obj2 instanceof BasicTableColumn ? (AlterProducer)new AlterTableColumn(this.cast(elements, (BasicElement)it)) : (obj2 instanceof BasicKey ? (AlterProducer)new AlterKey(this.cast(elements, (BasicElement)it)) : (obj2 instanceof BasicIndex ? (AlterProducer)new AlterIndex(this.cast(elements, (BasicElement)it)) : (obj2 instanceof BasicForeignKey ? (AlterProducer)new AlterForeignKey(this.cast(elements, (BasicElement)it)) : (obj2 instanceof BasicCheck ? (AlterProducer)new AlterCheck(this.cast(elements, (BasicElement)it)) : (obj2 instanceof BasicSynonym ? (AlterProducer)new AlterSynonym(this.cast(elements, (BasicElement)it)) : (AlterProducer)new AlterUnknown(elements)))))))));
    }

    @Override
    @NotNull
    public List<AbstractCodeGenerator.EdgeFixer> getEdgeFixers() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.getDropper().getEdgeFixers(), (Iterable)this.getCreator().getEdgeFixers()), (Object)this.CYCLIC_RENAME_FIXER);
    }

    /*
     * WARNING - void declaration
     */
    protected final void alterColumn(@NotNull BasicLikeColumn c, @Nullable String rename) {
        void $receiver$iv;
        void text$iv;
        Object object;
        BaseAlterGenerator this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        AbstractCodeGenerator.alterTable$default(this, c.getLikeTable(), null, 2, null);
        CodeTextBuilder.append$default(this.getBuilder(), " alter column ", null, false, null, 10, null);
        CodeTextBuilder codeTextBuilder = this.getBuilder();
        BaseAlterGenerator baseAlterGenerator = this;
        String string = rename;
        if (string == null) {
            string = c.getRealName();
        }
        if (string != null) {
            void $receiver$iv2;
            String string2 = string;
            this_$iv = this;
            object = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv2);
        } else {
            object = null;
        }
        this_$iv = object;
        boolean eoln$iv = false;
        if (text$iv == null) {
            boolean bl = eoln$iv;
            CompositeText.Kind kind = null;
            CharSequence charSequence = "???";
            void var9_11 = $receiver$iv;
            String string3 = "unknown column";
            CodeTextBuilder.append$default((CodeTextBuilder)var9_11, charSequence, kind, bl, string3, 2, null);
        } else {
            CodeTextBuilder.append$default((CodeTextBuilder)$receiver$iv, (CharSequence)text$iv, null, eoln$iv, null, 10, null);
        }
    }

    public static /* bridge */ /* synthetic */ void alterColumn$default(BaseAlterGenerator baseAlterGenerator, BasicLikeColumn basicLikeColumn, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: alterColumn");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        baseAlterGenerator.alterColumn(basicLikeColumn, string);
    }

    protected final boolean checkAlterColumnsImpl(@Nullable NamingFamily<? extends BasicLikeColumn> f1, @Nullable NamingFamily<? extends BasicLikeColumn> f2, @NotNull List<String> cols12, @NotNull List<String> cols22, @NotNull Function2<? super String, ? super String, Boolean> extra) {
        Intrinsics.checkParameterIsNotNull(cols12, (String)"cols1");
        Intrinsics.checkParameterIsNotNull(cols22, (String)"cols2");
        Intrinsics.checkParameterIsNotNull(extra, (String)"extra");
        if (cols12.size() != cols22.size()) {
            return true;
        }
        if (cols12.isEmpty()) {
            return false;
        }
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)cols12.size());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn c2;
            BasicLikeColumn c1;
            String n2;
            int element$iv = ((IntIterator)iterator).nextInt();
            int it = element$iv;
            String n1 = cols12.get(it);
            Boolean e = (Boolean)extra.invoke((Object)n1, (Object)(n2 = cols22.get(it)));
            if (!(e != null ? e != false : (f1 == null || f2 == null ? Intrinsics.areEqual((Object)n1, (Object)n2) ^ true : !this.isAlteredTo(c1 = f1.get(n1), c2 = f2.get(n2))))) continue;
            return true;
        }
        return false;
    }

    public static /* bridge */ /* synthetic */ boolean checkAlterColumnsImpl$default(BaseAlterGenerator this_, NamingFamily f1, NamingFamily f2, List cols12, List cols22, Function2 extra, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkAlterColumnsImpl");
        }
        if ((n & 0x10) != 0) {
            extra = checkAlterColumnsImpl.1.INSTANCE;
        }
        Intrinsics.checkParameterIsNotNull((Object)cols12, (String)"cols1");
        Intrinsics.checkParameterIsNotNull((Object)cols22, (String)"cols2");
        Intrinsics.checkParameterIsNotNull((Object)extra, (String)"extra");
        if (cols12.size() != cols22.size()) {
            return true;
        }
        if (cols12.isEmpty()) {
            return false;
        }
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)cols12.size());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn c2;
            BasicLikeColumn c1;
            String n2;
            int element$iv = ((IntIterator)iterator).nextInt();
            int it = element$iv;
            String n1 = (String)cols12.get(it);
            Boolean e = (Boolean)extra.invoke((Object)n1, (Object)(n2 = (String)cols22.get(it)));
            if (!(e != null ? e != false : (f1 == null || f2 == null ? Intrinsics.areEqual((Object)n1, (Object)n2) ^ true : !this_.isAlteredTo(c1 = (BasicLikeColumn)f1.get(n1), c2 = (BasicLikeColumn)f2.get(n2))))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isAlteredTo(@Nullable BasicElement e1, @Nullable BasicElement e2) {
        if (e1 == null) {
            if (e2 == null) return true;
        }
        if (e1 == null) return false;
        if (e2 == null) return false;
        ElementDelta<?> elementDelta = this.bySource.get(e1);
        if (!Intrinsics.areEqual(elementDelta != null ? elementDelta.getTargetElement() : null, (Object)e2)) return false;
        return true;
    }

    @Nullable
    protected String getKindName(@NotNull ObjectKind $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.code();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"code()");
        return StringsKt.replace$default((String)string, (String)"-", (String)" ", (boolean)false, (int)4, null);
    }

    protected <T extends BasicElement> void genericRename(@NotNull AlterProducer<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, $receiver){
            final /* synthetic */ BaseAlterGenerator this$0;
            final /* synthetic */ AlterProducer receiver$0;

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                block3: {
                    block2: {
                        v0 = this.receiver$0.getElement().getKind();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"element.kind");
                        type = this.this$0.getKindName(v0);
                        if (type != null) break block2;
                        this.this$0.getBuilder().appendErrorComment("rename of " + this.receiver$0.getElement().getKind() + " not supported");
                        break block3;
                    }
                    v1 = this.this$0.getBuilder();
                    v2 = new CharSequence[5];
                    v2[0] = "alter";
                    v2[1] = type;
                    v2[2] = this.this$0.currentScopeName((BasicElement)this.receiver$0.getElement(), this.receiver$0.fromNameOpt());
                    v2[3] = "rename to";
                    v3 = v2;
                    v4 = v2;
                    v5 = 4;
                    v6 = this.receiver$0.toName();
                    if (v6 == null) ** GOTO lbl-1000
                    var3_2 = v6;
                    var2_3 = this.this$0;
                    var8_4 = v5;
                    var7_5 = v3;
                    var6_6 = v4;
                    var5_7 = v1;
                    var9_8 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                    v1 = var5_7;
                    v4 = var6_6;
                    v3 = var7_5;
                    v5 = var8_4;
                    v6 = var9_8;
                    if (v6 != null) {
                        v7 = v6;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = "???";
                    }
                    v3[v5] = v7;
                    v1.phrase(v4);
                }
            }
            {
                this.this$0 = baseAlterGenerator;
                this.receiver$0 = alterProducer;
                super(0);
            }
        }, 3, null);
    }

    protected <T extends BasicElement> void genericAlterComment(@NotNull AlterProducer<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, $receiver){
            final /* synthetic */ BaseAlterGenerator this$0;
            final /* synthetic */ AlterProducer receiver$0;

            public final void invoke() {
                ObjectKind objectKind = this.receiver$0.getElement().getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
                String type = this.this$0.getKindName(objectKind);
                if (type == null) {
                    this.this$0.getBuilder().appendErrorComment("comment on " + this.receiver$0.getElement().getKind() + " not supported");
                } else {
                    String string;
                    this.this$0.getBuilder().phrase("comment on", type, this.this$0.currentScopeName((BasicElement)this.receiver$0.getElement(), this.receiver$0.toName()), "is", (string = this.receiver$0.getTo().getComment()) != null && (string = this.this$0.getSqlString(string)) != null ? (CharSequence)string : (CharSequence)"null");
                }
            }
            {
                this.this$0 = baseAlterGenerator;
                this.receiver$0 = alterProducer;
                super(0);
            }
        }, 3, null);
    }

    public BaseAlterGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
        this.bySource = new HashMap();
        this.byTarget = new HashMap();
        this.prepared = new HashMap();
        Iterable $receiver$iv = this.correspondence();
        for (Object element$iv : $receiver$iv) {
            ElementDelta elementDelta;
            Map map;
            Object it;
            Object t;
            ElementDelta d = (ElementDelta)element$iv;
            if (d.getSourceElement() != null) {
                it = t;
                map = this.bySource;
                elementDelta = d;
                map.put(it, elementDelta);
            }
            if (d.getTargetElement() == null) continue;
            it = t;
            map = this.byTarget;
            elementDelta = d;
            map.put(it, elementDelta);
        }
        this.CYCLIC_RENAME_FIXER = new AbstractCodeGenerator.EdgeFixer(this){
            final /* synthetic */ BaseAlterGenerator this$0;

            public boolean fix(@NotNull Operation root2, @NotNull Operation op1, @NotNull Operation op2) {
                block7: {
                    AlterProducer<?> alterProducer;
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    Intrinsics.checkParameterIsNotNull((Object)op1, (String)"op1");
                    Intrinsics.checkParameterIsNotNull((Object)op2, (String)"op2");
                    Producer producer = op1.getProducer();
                    if (!(producer instanceof AlterProducer)) {
                        producer = null;
                    }
                    AlterProducer<?> alterProducer2 = (AlterProducer<?>)producer;
                    if (alterProducer2 == null) {
                        return false;
                    }
                    AlterProducer<?> r1 = alterProducer2;
                    Producer producer2 = op2.getProducer();
                    if (!(producer2 instanceof AlterProducer)) {
                        producer2 = null;
                    }
                    AlterProducer alterProducer3 = (AlterProducer)producer2;
                    if (alterProducer3 == null) {
                        return false;
                    }
                    AlterProducer r2 = alterProducer3;
                    if (!r1.isRename() || r1.getTmpName() != null || !r2.isRename()) {
                        return false;
                    }
                    String tmp = r1.getElement().getName() + "_dg_tmp";
                    T t = op1.getParent();
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    Operation p = (Operation)t;
                    op1.setParent(null);
                    AlterProducer<?> $receiver = alterProducer = r1;
                    $receiver.setTmpName((Pair<String, Boolean>)new Pair((Object)tmp, (Object)false));
                    $receiver.register(p);
                    AlterProducer<?> alterProducer4 = this.this$0.createAlterProducer(new ElementAlteration<T>(r1.getTo(), r1.getTo()));
                    if (alterProducer4 == null) break block7;
                    $receiver = alterProducer = alterProducer4;
                    $receiver.setTmpName((Pair<String, Boolean>)new Pair((Object)tmp, (Object)true));
                    Operation operation = $receiver.register(p);
                    if (operation != null) {
                        ScenarioOperations.requires(operation, ScenarioOperations.matches$default(EffectType.RenamedTo, ScenarioOperations.renamed(r1.getElement(), null, tmp), null, 2, null));
                    }
                }
                return true;
            }

            public boolean isBackward() {
                return true;
            }

            public boolean requiresResolve() {
                return true;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    static {
        Companion = new Companion(null);
        ALTER = new OperationType("alter");
    }

    public static final /* synthetic */ int access$depth(BaseAlterGenerator $this, @Nullable BasicElement e) {
        return $this.depth(e);
    }

    @Nullable
    public static final /* synthetic */ BasicElement access$anyElement(BaseAlterGenerator $this, @NotNull ElementDelta $receiver) {
        return $this.anyElement($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterDatabase;", "T", "Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "intellij.database.scripting"})
    protected class AlterDatabase<T extends BasicDatabase>
    extends AlterProducer<T> {
        public AlterDatabase(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterSchema;", "T", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "intellij.database.scripting"})
    protected class AlterSchema<T extends BasicSchema>
    extends AlterProducer<T> {
        public AlterSchema(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterSequence;", "T", "Lcom/intellij/database/model/basic/BasicSequence;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "intellij.database.scripting"})
    protected class AlterSequence<T extends BasicSequence>
    extends AlterProducer<T> {
        public AlterSequence(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterView;", "T", "Lcom/intellij/database/model/basic/BasicView;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "intellij.database.scripting"})
    protected class AlterView<T extends BasicView>
    extends AlterProducer<T> {
        public AlterView(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterTrigger;", "T", "Lcom/intellij/database/model/basic/BasicTrigger;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "intellij.database.scripting"})
    protected class AlterTrigger<T extends BasicTrigger>
    extends AlterProducer<T> {
        public AlterTrigger(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterRoutine;", "T", "Lcom/intellij/database/model/basic/BasicRoutine;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "intellij.database.scripting"})
    protected class AlterRoutine<T extends BasicRoutine>
    extends AlterProducer<T> {
        public AlterRoutine(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterCheck;", "T", "Lcom/intellij/database/model/basic/BasicCheck;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterColumniation;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "intellij.database.scripting"})
    protected class AlterCheck<T extends BasicCheck>
    extends AlterColumniation<T> {
        public AlterCheck(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\tH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterSynonym;", "T", "Lcom/intellij/database/model/basic/BasicSynonym;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "hasRename", "", "register", "Lcom/intellij/database/scripting/Operation;", "root", "requireRecreate", "intellij.database.scripting"})
    protected class AlterSynonym<T extends BasicSynonym>
    extends AlterProducer<T> {
        protected boolean hasRename() {
            return false;
        }

        protected boolean requireRecreate() {
            return this.isAnyRename() && !this.hasRename();
        }

        @Override
        @Nullable
        public Operation register(@NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.isEmpty() ? null : (this.requireRecreate() ? this.registerDropCreate(root2) : this.registerThis(root2));
        }

        public AlterSynonym(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\b\u0010\u0012\u001a\u00020\u000fH\u0014J\b\u0010\u0013\u001a\u00020\u000fH\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterTableColumn;", "T", "Lcom/intellij/database/model/basic/BasicTableColumn;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "columns", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "isAlterDefault", "", "()Z", "isAlterNullable", "isAlterType", "isEmpty", "produce", "", "produceAlterDefault", "produceAlterNullable", "produceAlterType", "produceRename", "intellij.database.scripting"})
    protected class AlterTableColumn<T extends BasicTableColumn>
    extends AlterProducer<T> {
        private final boolean isAlterType;
        private final boolean isAlterNullable;
        private final boolean isAlterDefault;

        public final boolean isAlterType() {
            return this.isAlterType;
        }

        public final boolean isAlterNullable() {
            return this.isAlterNullable;
        }

        public final boolean isAlterDefault() {
            return this.isAlterDefault;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && !this.isAlterType && !this.isAlterNullable && !this.isAlterDefault;
        }

        @Override
        public void produce() {
            super.produce();
            if (this.isAlterType) {
                this.produceAlterType();
            }
            if (this.isAlterNullable) {
                this.produceAlterNullable();
            }
            if (this.isAlterDefault) {
                this.produceAlterDefault();
            }
        }

        @Override
        protected void produceRename() {
            AbstractCodeGenerator.coding$default(BaseAlterGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ AlterTableColumn this$0;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    String string;
                    String string2;
                    CodeTextBuilder codeTextBuilder;
                    CodeTextBuilder $receiver$iv;
                    CharSequence charSequence;
                    CompositeText.Kind kind;
                    boolean bl;
                    void text$iv;
                    Object object;
                    BaseAlterGenerator this_$iv;
                    AbstractCodeGenerator.alterTable$default(this.this$0.BaseAlterGenerator.this, ((BasicTableColumn)this.this$0.getElement()).getTable(), null, 2, null);
                    this.this$0.BaseAlterGenerator.this.words(this.this$0.BaseAlterGenerator.this.getBuilder(), " rename column ");
                    CodeTextBuilder codeTextBuilder2 = this.this$0.BaseAlterGenerator.this.getBuilder();
                    BaseAlterGenerator baseAlterGenerator = this.this$0.BaseAlterGenerator.this;
                    String string3 = this.this$0.fromName();
                    if (string3 != null) {
                        void $receiver$iv2;
                        String string4 = string3;
                        this_$iv = this.this$0.BaseAlterGenerator.this;
                        object = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv2);
                    } else {
                        object = null;
                    }
                    this_$iv = object;
                    boolean eoln$iv2 = false;
                    if (text$iv == null) {
                        bl = eoln$iv2;
                        kind = null;
                        charSequence = "???";
                        codeTextBuilder = $receiver$iv;
                        string2 = "no column name";
                        CodeTextBuilder.append$default(codeTextBuilder, charSequence, kind, bl, string2, 2, null);
                    } else {
                        CodeTextBuilder.append$default($receiver$iv, (CharSequence)text$iv, null, eoln$iv2, null, 10, null);
                    }
                    CodeTextBuilder.append$default(this.this$0.BaseAlterGenerator.this.getBuilder(), " to ", null, false, null, 10, null);
                    $receiver$iv = this.this$0.BaseAlterGenerator.this.getBuilder();
                    BaseAlterGenerator this_$iv2 = this.this$0.BaseAlterGenerator.this;
                    String string5 = this.this$0.toName();
                    if (string5 != null) {
                        void $receiver$iv3;
                        String eoln$iv2 = string5;
                        this_$iv = this.this$0.BaseAlterGenerator.this;
                        string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv3);
                    } else {
                        string = null;
                    }
                    this_$iv = string;
                    boolean eoln$iv3 = false;
                    if (text$iv == null) {
                        bl = eoln$iv3;
                        kind = null;
                        charSequence = "???";
                        codeTextBuilder = $receiver$iv;
                        string2 = "no column name";
                        CodeTextBuilder.append$default(codeTextBuilder, charSequence, kind, bl, string2, 2, null);
                    } else {
                        CodeTextBuilder.append$default($receiver$iv, (CharSequence)text$iv, null, eoln$iv3, null, 10, null);
                    }
                }
                {
                    this.this$0 = alterTableColumn;
                    super(0);
                }
            }, 3, null);
        }

        protected void produceAlterDefault() {
            AbstractCodeGenerator.coding$default(BaseAlterGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ AlterTableColumn this$0;

                public final void invoke() {
                    this.this$0.BaseAlterGenerator.this.getBuilder().appendErrorComment("don't know how to alter default on " + this.this$0.BaseAlterGenerator.this.currentScopeName((BasicElement)this.this$0.getElement(), this.this$0.fromName()));
                }
                {
                    this.this$0 = alterTableColumn;
                    super(0);
                }
            }, 3, null);
        }

        protected void produceAlterNullable() {
            AbstractCodeGenerator.coding$default(BaseAlterGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ AlterTableColumn this$0;

                public final void invoke() {
                    this.this$0.BaseAlterGenerator.this.getBuilder().appendErrorComment("don't know how to alter nullability of " + this.this$0.BaseAlterGenerator.this.currentScopeName((BasicElement)this.this$0.getElement(), this.this$0.fromName()));
                }
                {
                    this.this$0 = alterTableColumn;
                    super(0);
                }
            }, 3, null);
        }

        protected void produceAlterType() {
            AbstractCodeGenerator.coding$default(BaseAlterGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ AlterTableColumn this$0;

                public final void invoke() {
                    this.this$0.BaseAlterGenerator.this.getBuilder().appendErrorComment("don't know how to alter type of " + this.this$0.BaseAlterGenerator.this.currentScopeName((BasicElement)this.this$0.getElement(), this.this$0.fromName()));
                }
                {
                    this.this$0 = alterTableColumn;
                    super(0);
                }
            }, 3, null);
        }

        public AlterTableColumn(ElementAlteration<? extends T> columns2) {
            Intrinsics.checkParameterIsNotNull(columns2, (String)"columns");
            super(columns2);
            this.isAlterType = Intrinsics.areEqual((Object)((BasicTableColumn)this.getElement()).getDataType(), (Object)((BasicTableColumn)this.getTo()).getDataType()) ^ true;
            this.isAlterNullable = ((BasicTableColumn)this.getElement()).isNotNull() != ((BasicTableColumn)this.getTo()).isNotNull();
            this.isAlterDefault = Intrinsics.areEqual((Object)((BasicTableColumn)this.getElement()).getDefaultExpression(), (Object)((BasicTableColumn)this.getTo()).getDefaultExpression()) ^ true;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\tH\u0014J\b\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterForeignKey;", "T", "Lcom/intellij/database/model/basic/BasicForeignKey;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterColumniation;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "indices", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "isAlterActions", "", "()Z", "isAlterRef", "checkAlterColumns", "checkAlterRef", "isEmpty", "requireRecreate", "intellij.database.scripting"})
    protected class AlterForeignKey<T extends BasicForeignKey>
    extends AlterColumniation<T> {
        private final boolean isAlterRef;
        private final boolean isAlterActions;

        public final boolean isAlterRef() {
            return this.isAlterRef;
        }

        public final boolean isAlterActions() {
            return this.isAlterActions;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean checkAlterColumns() {
            boolean bl;
            block7: {
                void cols2$iv;
                void cols1$iv;
                BaseAlterGenerator baseAlterGenerator = BaseAlterGenerator.this;
                BasicLikeTable basicLikeTable = ((BasicForeignKey)this.getElement()).getLikeTable();
                NamingFamily namingFamily = basicLikeTable != null ? basicLikeTable.getColumns() : null;
                BasicLikeTable basicLikeTable2 = ((BasicForeignKey)this.getTo()).getLikeTable();
                NamingFamily namingFamily2 = basicLikeTable2 != null ? basicLikeTable2.getColumns() : null;
                List<String> list = ((BasicForeignKey)this.getElement()).getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.colNames");
                List<String> list2 = list;
                List<String> list3 = ((BasicForeignKey)this.getTo()).getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"to.colNames");
                List<String> list4 = list3;
                if (cols1$iv.size() != cols2$iv.size()) {
                    bl = true;
                } else if (cols1$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterable $receiver$iv$iv = (Iterable)RangesKt.until((int)0, (int)cols1$iv.size());
                    Iterator iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void f2$iv;
                        void f1$iv;
                        String n2$iv;
                        int element$iv$iv;
                        int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
                        String n1$iv = (String)cols1$iv.get(it$iv);
                        String string = n2$iv = (String)cols2$iv.get(it$iv);
                        String $noName_0 = n1$iv;
                        Boolean e$iv = null;
                        if (f1$iv == null || f2$iv == null) {
                            if (!(Intrinsics.areEqual((Object)n1$iv, (Object)n2$iv) ^ true)) continue;
                            bl = true;
                        } else {
                            BasicLikeColumn c2$iv;
                            void this_$iv;
                            BasicLikeColumn c1$iv = (BasicLikeColumn)f1$iv.get(n1$iv);
                            if (((BaseAlterGenerator)this_$iv).isAlteredTo(c1$iv, c2$iv = (BasicLikeColumn)f2$iv.get(n2$iv))) continue;
                            bl = true;
                        }
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean checkAlterRef() {
            boolean bl;
            block9: {
                void cols2$iv;
                void cols1$iv;
                if (!(((BasicForeignKey)this.getElement()).getRefSchemaName() == null && ((BasicForeignKey)this.getTo()).getRefSchemaName() == null || BaseAlterGenerator.this.isAlteredTo(((BasicForeignKey)this.getElement()).getRefSchema(), ((BasicForeignKey)this.getTo()).getRefSchema()))) {
                    return true;
                }
                if (!(((BasicForeignKey)this.getElement()).getRefTableName() == null && ((BasicForeignKey)this.getTo()).getRefTableName() == null || BaseAlterGenerator.this.isAlteredTo(((BasicForeignKey)this.getElement()).getRefTable(), ((BasicForeignKey)this.getTo()).getRefTable()))) {
                    return true;
                }
                BaseAlterGenerator baseAlterGenerator = BaseAlterGenerator.this;
                BasicTableOrView basicTableOrView = ((BasicForeignKey)this.getElement()).getRefTable();
                NamingFamily namingFamily = basicTableOrView != null ? basicTableOrView.getColumns() : null;
                BasicTableOrView basicTableOrView2 = ((BasicForeignKey)this.getTo()).getRefTable();
                NamingFamily namingFamily2 = basicTableOrView2 != null ? basicTableOrView2.getColumns() : null;
                List<String> list = ((BasicForeignKey)this.getElement()).getRefColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.refColNames");
                List<String> list2 = list;
                List<String> list3 = ((BasicForeignKey)this.getTo()).getRefColNames();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"to.refColNames");
                List<String> list4 = list3;
                if (cols1$iv.size() != cols2$iv.size()) {
                    bl = true;
                } else if (cols1$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterable $receiver$iv$iv = (Iterable)RangesKt.until((int)0, (int)cols1$iv.size());
                    Iterator iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void f2$iv;
                        void f1$iv;
                        String n2$iv;
                        int element$iv$iv;
                        int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
                        String n1$iv = (String)cols1$iv.get(it$iv);
                        String string = n2$iv = (String)cols2$iv.get(it$iv);
                        String $noName_0 = n1$iv;
                        Boolean e$iv = null;
                        if (f1$iv == null || f2$iv == null) {
                            if (!(Intrinsics.areEqual((Object)n1$iv, (Object)n2$iv) ^ true)) continue;
                            bl = true;
                        } else {
                            BasicLikeColumn c2$iv;
                            void this_$iv;
                            BasicLikeColumn c1$iv = (BasicLikeColumn)f1$iv.get(n1$iv);
                            if (((BaseAlterGenerator)this_$iv).isAlteredTo(c1$iv, c2$iv = (BasicLikeColumn)f2$iv.get(n2$iv))) continue;
                            bl = true;
                        }
                        break block9;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && !this.isAlterActions && !this.isAlterRef;
        }

        @Override
        protected boolean requireRecreate() {
            return this.isAlterActions || this.isAlterRef || super.requireRecreate();
        }

        public AlterForeignKey(ElementAlteration<? extends T> indices) {
            Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
            super(indices);
            this.isAlterRef = this.checkAlterRef();
            this.isAlterActions = Intrinsics.areEqual((Object)((Object)((BasicForeignKey)this.getElement()).getOnUpdate()), (Object)((Object)((BasicForeignKey)this.getTo()).getOnUpdate())) ^ true || Intrinsics.areEqual((Object)((Object)((BasicForeignKey)this.getElement()).getOnDelete()), (Object)((Object)((BasicForeignKey)this.getTo()).getOnDelete())) ^ true || ((BasicForeignKey)this.getElement()).isDeferrable() != ((BasicForeignKey)this.getTo()).isDeferrable() || ((BasicForeignKey)this.getElement()).isInitiallyDeferred() != ((BasicForeignKey)this.getTo()).isInitiallyDeferred();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterKey;", "T", "Lcom/intellij/database/model/basic/BasicKey;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterColumniation;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "indices", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "isAlterPrimary", "", "()Z", "isEmpty", "requireRecreate", "intellij.database.scripting"})
    protected class AlterKey<T extends BasicKey>
    extends AlterColumniation<T> {
        private final boolean isAlterPrimary;

        public final boolean isAlterPrimary() {
            return this.isAlterPrimary;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && !this.isAlterPrimary;
        }

        @Override
        protected boolean requireRecreate() {
            return this.isAlterPrimary || super.requireRecreate();
        }

        public AlterKey(ElementAlteration<? extends T> indices) {
            Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
            super(indices);
            this.isAlterPrimary = ((BasicKey)this.getElement()).isPrimary() != ((BasicKey)this.getTo()).isPrimary();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterIndex;", "T", "Lcom/intellij/database/model/basic/BasicIndex;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterColumniation;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "indices", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "isAlterType", "", "()Z", "checkAlterColumns", "isEmpty", "requireRecreate", "intellij.database.scripting"})
    protected class AlterIndex<T extends BasicIndex>
    extends AlterColumniation<T> {
        private final boolean isAlterType;

        public final boolean isAlterType() {
            return this.isAlterType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean checkAlterColumns() {
            boolean bl;
            block12: {
                void cols2$iv;
                void cols1$iv;
                Set<String> rev1 = ((BasicIndex)this.getElement()).getReverseColNames();
                Set<String> rev2 = ((BasicIndex)this.getTo()).getReverseColNames();
                if (rev1.size() != rev2.size()) {
                    return true;
                }
                BaseAlterGenerator baseAlterGenerator = BaseAlterGenerator.this;
                BasicLikeTable basicLikeTable = ((BasicIndex)this.getElement()).getLikeTable();
                if (basicLikeTable == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable, (String)"element.likeTable!!");
                NamingFamily namingFamily = basicLikeTable.getColumns();
                BasicLikeTable basicLikeTable2 = ((BasicIndex)this.getTo()).getLikeTable();
                if (basicLikeTable2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable2, (String)"to.likeTable!!");
                NamingFamily namingFamily2 = basicLikeTable2.getColumns();
                List<String> list = ((BasicIndex)this.getElement()).getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.colNames");
                List<String> list2 = list;
                List<String> list3 = ((BasicIndex)this.getTo()).getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"to.colNames");
                List<String> list4 = list3;
                if (cols1$iv.size() != cols2$iv.size()) {
                    bl = true;
                } else if (cols1$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterable $receiver$iv$iv = (Iterable)RangesKt.until((int)0, (int)cols1$iv.size());
                    Iterator iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void f2$iv;
                        void f1$iv;
                        void n2;
                        String n2$iv;
                        int element$iv$iv;
                        int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
                        String n1$iv = (String)cols1$iv.get(it$iv);
                        String string = n2$iv = (String)cols2$iv.get(it$iv);
                        String n1 = n1$iv;
                        if (rev1.contains(n1) != rev2.contains(n2)) {
                            return true;
                        }
                        if (StringsKt.startsWith$default((CharSequence)n1, (char)'\u001b', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)((CharSequence)n2), (char)'\u001b', (boolean)false, (int)2, null)) {
                            return Intrinsics.areEqual((Object)n1, (Object)n2) ^ true;
                        }
                        Boolean e$iv = null;
                        if (f1$iv == null || f2$iv == null) {
                            if (!(Intrinsics.areEqual((Object)n1$iv, (Object)n2$iv) ^ true)) continue;
                            bl = true;
                        } else {
                            BasicLikeColumn c2$iv;
                            void this_$iv;
                            BasicLikeColumn c1$iv = (BasicLikeColumn)f1$iv.get(n1$iv);
                            if (((BaseAlterGenerator)this_$iv).isAlteredTo(c1$iv, c2$iv = (BasicLikeColumn)f2$iv.get(n2$iv))) continue;
                            bl = true;
                        }
                        break block12;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && !this.isAlterType;
        }

        @Override
        protected boolean requireRecreate() {
            return this.isAlterType || super.requireRecreate();
        }

        public AlterIndex(ElementAlteration<? extends T> indices) {
            Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
            super(indices);
            this.isAlterType = ((BasicIndex)this.getElement()).isUnique() != ((BasicIndex)this.getTo()).isUnique();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0014J\b\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0014R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterColumniation;", "T", "Lcom/intellij/database/model/basic/BasicColumniation;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "indices", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "isAlterColumns", "", "isAlterColumns$annotations", "()V", "()Z", "checkAlterColumns", "hasRename", "isEmpty", "register", "Lcom/intellij/database/scripting/Operation;", "root", "requireRecreate", "intellij.database.scripting"})
    protected class AlterColumniation<T extends BasicColumniation>
    extends AlterProducer<T> {
        private final boolean isAlterColumns;

        public static /* synthetic */ void isAlterColumns$annotations() {
        }

        public final boolean isAlterColumns() {
            return this.isAlterColumns;
        }

        /*
         * WARNING - void declaration
         */
        protected boolean checkAlterColumns() {
            boolean bl;
            block9: {
                void cols2$iv;
                void cols1$iv;
                BaseAlterGenerator baseAlterGenerator = BaseAlterGenerator.this;
                BasicLikeTable basicLikeTable = ((BasicColumniation)this.getElement()).getLikeTable();
                if (basicLikeTable == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable, (String)"element.likeTable!!");
                NamingFamily namingFamily = basicLikeTable.getColumns();
                BasicLikeTable basicLikeTable2 = ((BasicColumniation)this.getTo()).getLikeTable();
                if (basicLikeTable2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable2, (String)"to.likeTable!!");
                NamingFamily namingFamily2 = basicLikeTable2.getColumns();
                List<String> list = ((BasicColumniation)this.getElement()).getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.colNames");
                List<String> list2 = list;
                List<String> list3 = ((BasicColumniation)this.getTo()).getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"to.colNames");
                List<String> list4 = list3;
                if (cols1$iv.size() != cols2$iv.size()) {
                    bl = true;
                } else if (cols1$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterable $receiver$iv$iv = (Iterable)RangesKt.until((int)0, (int)cols1$iv.size());
                    Iterator iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void f2$iv;
                        void f1$iv;
                        String n2$iv;
                        int element$iv$iv;
                        int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
                        String n1$iv = (String)cols1$iv.get(it$iv);
                        String string = n2$iv = (String)cols2$iv.get(it$iv);
                        String $noName_0 = n1$iv;
                        Boolean e$iv = null;
                        if (f1$iv == null || f2$iv == null) {
                            if (!(Intrinsics.areEqual((Object)n1$iv, (Object)n2$iv) ^ true)) continue;
                            bl = true;
                        } else {
                            BasicLikeColumn c2$iv;
                            void this_$iv;
                            BasicLikeColumn c1$iv = (BasicLikeColumn)f1$iv.get(n1$iv);
                            if (((BaseAlterGenerator)this_$iv).isAlteredTo(c1$iv, c2$iv = (BasicLikeColumn)f2$iv.get(n2$iv))) continue;
                            bl = true;
                        }
                        break block9;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && !this.isAlterColumns;
        }

        protected boolean hasRename() {
            return false;
        }

        protected boolean requireRecreate() {
            return this.isAlterColumns || this.isAnyRename() && !this.hasRename();
        }

        @Override
        @Nullable
        public Operation register(@NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.isEmpty() ? null : (this.requireRecreate() ? this.registerDropCreate(root2) : this.registerThis(root2));
        }

        public AlterColumniation(ElementAlteration<? extends T> indices) {
            Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
            super(indices);
            this.isAlterColumns = this.checkAlterColumns();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterTable;", "T", "Lcom/intellij/database/model/basic/BasicTable;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "tables", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "intellij.database.scripting"})
    protected class AlterTable<T extends BasicTable>
    extends AlterProducer<T> {
        public AlterTable(ElementAlteration<? extends T> tables) {
            Intrinsics.checkParameterIsNotNull(tables, (String)"tables");
            super(tables);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0096\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u001b\u001a\u00020\tH\u0004J\b\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\b\u0010 \u001a\u00020\u001eH\u0014J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\"H\u0004J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0004J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u0004\u0018\u00010\u000eJ\n\u0010(\u001a\u0004\u0018\u00010\u000eH\u0004R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR(\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/AbstractCodeGenerator$ElementProducer;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "isAlterComment", "", "()Z", "isRename", "tmpName", "Lkotlin/Pair;", "", "getTmpName", "()Lkotlin/Pair;", "setTmpName", "(Lkotlin/Pair;)V", "to", "getTo", "()Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/basic/BasicElement;", "canAlterComment", "canRename", "fromName", "fromNameOpt", "isAnyRename", "isEmpty", "produce", "", "produceAlterComment", "produceRename", "register", "Lcom/intellij/database/scripting/Operation;", "root", "registerDropCreate", "registerThis", "shortText", "toName", "toNameOpt", "intellij.database.scripting"})
    public class AlterProducer<T extends BasicElement>
    extends AbstractCodeGenerator.ElementProducer<T> {
        @NotNull
        private final T to;
        private final boolean isRename;
        @Nullable
        private Pair<String, Boolean> tmpName;
        private final boolean isAlterComment;

        @NotNull
        public final T getTo() {
            return this.to;
        }

        public final boolean isRename() {
            return this.isRename;
        }

        @Nullable
        public final Pair<String, Boolean> getTmpName() {
            return this.tmpName;
        }

        public final void setTmpName(@Nullable Pair<String, Boolean> pair) {
            this.tmpName = pair;
        }

        public final boolean isAlterComment() {
            return this.isAlterComment;
        }

        public boolean isEmpty() {
            return !this.isAnyRename() && !this.isAlterComment;
        }

        @Nullable
        public Operation register(@NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.isEmpty() ? null : this.registerThis(root2);
        }

        @NotNull
        protected final Operation registerThis(@NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = new Operation(this);
            Object object = BaseAlterGenerator.this.getPrepared();
            Object t = this.getElement();
            Operation operation2 = $receiver;
            object.put(t, operation2);
            $receiver.setParent((Node)root2);
            if (this.isAnyRename()) {
                ScenarioOperations.provides($receiver, ScenarioOperations.invoke(EffectType.RenamedFrom, ScenarioOperations.renamed(this.getElement(), null, this.fromNameOpt())), ScenarioOperations.invoke(EffectType.RenamedTo, ScenarioOperations.renamed(this.getElement(), this.to, this.toNameOpt())));
                if (this.toNameOpt() == null) {
                    NamingFamily namingFamily;
                    Family<? extends BasicElement> family = this.getElement().getParentFamily();
                    if (!(family instanceof NamingFamily)) {
                        family = null;
                    }
                    if ((namingFamily = (NamingFamily)family) != null && (namingFamily = namingFamily.get(this.to.getName())) != null) {
                        Object it = object = namingFamily;
                        ScenarioOperations.requires($receiver, ScenarioOperations.matches$default(EffectType.RenamedFrom, ScenarioOperations.renamed(this.getElement(), this.to, null), null, 2, null));
                    }
                }
            }
            ScenarioOperations.requires($receiver, ScenarioOperations.children(EffectType.Unexistent, this.getElement()));
            ScenarioOperations.requires($receiver, ScenarioOperations.children(EffectType.Modified, this.to));
            if (this.toNameOpt() == null) {
                ScenarioOperations.provides($receiver, ScenarioOperations.invoke(EffectType.Modified, this.to));
            }
            return operation;
        }

        @Override
        public void produce() {
            if (this.isAnyRename()) {
                this.produceRename();
            }
            if (this.isAlterComment) {
                this.produceAlterComment();
            }
        }

        protected final boolean isAnyRename() {
            return this.isRename || this.tmpName != null;
        }

        protected void produceAlterComment() {
            BaseAlterGenerator.this.genericAlterComment(this);
        }

        protected void produceRename() {
            AbstractCodeGenerator.coding$default(BaseAlterGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ AlterProducer this$0;

                public final void invoke() {
                    this.this$0.BaseAlterGenerator.this.getBuilder().appendErrorComment("" + this.this$0.getElement().getKind().code() + " does not support rename");
                }
                {
                    this.this$0 = alterProducer;
                    super(0);
                }
            }, 3, null);
        }

        @Nullable
        public final String fromName() {
            String string = this.fromNameOpt();
            if (string == null) {
                string = this.getElement().getRealName();
            }
            return string;
        }

        @Nullable
        public final String toName() {
            String string = this.toNameOpt();
            if (string == null) {
                string = this.to.getRealName();
            }
            return string;
        }

        @Nullable
        public final String fromNameOpt() {
            Pair<String, Boolean> pair;
            Pair<String, Boolean> it;
            Pair<String, Boolean> pair2 = this.tmpName;
            return pair2 != null ? (!((Boolean)(it = (pair = pair2)).getSecond()).booleanValue() ? null : (String)it.getFirst()) : null;
        }

        @Nullable
        protected final String toNameOpt() {
            Pair<String, Boolean> pair;
            Pair<String, Boolean> it;
            Pair<String, Boolean> pair2 = this.tmpName;
            return pair2 != null ? (((Boolean)(it = (pair = pair2)).getSecond()).booleanValue() ? null : (String)it.getFirst()) : null;
        }

        @Override
        @NotNull
        public String shortText() {
            String p = super.shortText();
            if (this.tmpName == null) {
                return p;
            }
            Pair<String, Boolean> pair = this.tmpName;
            if (pair == null) {
                Intrinsics.throwNpe();
            }
            String d = (Boolean)pair.getSecond() != false ? "->" : "<-";
            StringBuilder stringBuilder = new StringBuilder().append("").append(p).append('(').append(d).append("");
            Pair<String, Boolean> pair2 = this.tmpName;
            if (pair2 == null) {
                Intrinsics.throwNpe();
            }
            return stringBuilder.append((String)pair2.getFirst()).append(')').toString();
        }

        @Nullable
        protected final Operation registerDropCreate(@NotNull Operation root2) {
            block0: {
                Operation operation;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                BaseAlterGenerator.this.makeDropOperation(this.getElement(), root2);
                Operation operation2 = BaseAlterGenerator.this.makeCreateOperation(this.to, root2);
                if (operation2 == null) break block0;
                Operation $receiver = operation = operation2;
                ScenarioOperations.requires($receiver, ScenarioOperations.matches$default(EffectType.Unexistent, this.getElement(), null, 2, null));
            }
            return null;
        }

        public boolean canRename() {
            return true;
        }

        public boolean canAlterComment() {
            return true;
        }

        public AlterProducer(ElementAlteration<? extends T> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(BaseAlterGenerator.this, Companion.getALTER(), (BasicElement)elements.getSourceElement(), null, 4, null);
            this.to = elements.getTargetElement();
            this.isRename = Intrinsics.areEqual((Object)this.getElement().getName(), (Object)this.to.getName()) ^ true;
            this.isAlterComment = Intrinsics.areEqual((Object)this.getElement().getComment(), (Object)this.to.getComment()) ^ true;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$AlterUnknown;", "Lcom/intellij/database/scripting/BaseAlterGenerator$AlterProducer;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/BaseAlterGenerator;", "elements", "Lcom/intellij/database/model/delta/ElementAlteration;", "(Lcom/intellij/database/scripting/BaseAlterGenerator;Lcom/intellij/database/model/delta/ElementAlteration;)V", "canAlterComment", "", "canRename", "isEmpty", "produce", "", "intellij.database.scripting"})
    protected class AlterUnknown
    extends AlterProducer<BasicElement> {
        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(BaseAlterGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ AlterUnknown this$0;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.BaseAlterGenerator.this.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[1];
                    StringBuilder stringBuilder = new StringBuilder().append("-- Unknown how to alter ").append(this.this$0.getElement().getKind().code()).append(' ');
                    ObjectPath objectPath = BasicPaths.of(this.this$0.getElement());
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectPath, (String)"BasicPaths.of(element)");
                    charSequenceArray[0] = stringBuilder.append(objectPath.getDisplayName()).append(" :(").toString();
                    codeTextBuilder.phrase(charSequenceArray);
                }
                {
                    this.this$0 = alterUnknown;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        public boolean canRename() {
            return false;
        }

        @Override
        public boolean canAlterComment() {
            return false;
        }

        public AlterUnknown(ElementAlteration<?> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(elements);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/scripting/BaseAlterGenerator$Companion;", "", "()V", "ALTER", "Lcom/intellij/database/scripting/OperationType;", "getALTER", "()Lcom/intellij/database/scripting/OperationType;", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        public final OperationType getALTER() {
            return ALTER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

