/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.DBFacadeProvider;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.scripting.AbstractScriptingServiceKt;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.CompositeTextFun;
import com.intellij.database.scripting.CustomScriptingOptions;
import com.intellij.database.scripting.DbSrcMigration;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptGeneratorSettings;
import com.intellij.database.scripting.ScriptGeneratorUI;
import com.intellij.database.scripting.ScriptGeneratorUI$WhenMappings;
import com.intellij.database.scripting.ScriptGeneratorUIKt$sam$Runnable$c443607f;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingNativeDefinitionTask;
import com.intellij.database.scripting.ScriptingOption;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingResult;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 k2\u00020\u0001:\u0006klmnopB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u000206H\u0002J\u0010\u00108\u001a\u0002062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u00109\u001a\u000206H\u0002J\u001e\u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0002J\u0016\u0010@\u001a\u0002062\f\u0010A\u001a\b\u0012\u0004\u0012\u0002060BH\u0002J\b\u0010C\u001a\u000206H\u0002J4\u0010D\u001a\u00020E2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010;\u001a\u00020<2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00120G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0GH\u0002J\b\u0010J\u001a\u000206H\u0016J\b\u0010K\u001a\u000206H\u0002J\b\u0010L\u001a\u000206H\u0002J\b\u0010M\u001a\u000206H\u0002J,\u0010N\u001a\u0002HO\"\u0004\b\u0000\u0010O2\u0006\u0010P\u001a\u00020Q2\u000e\b\u0004\u0010R\u001a\b\u0012\u0004\u0012\u0002HO0BH\u0082\b\u00a2\u0006\u0002\u0010SJ\u0014\u0010T\u001a\u0004\u0018\u00010U2\b\u0010;\u001a\u0004\u0018\u00010<H\u0002J\b\u0010V\u001a\u00020$H\u0002J\u001c\u0010W\u001a\u0002062\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>J\u0016\u0010X\u001a\u0002062\f\u0010Y\u001a\b\u0012\u0004\u0012\u0002060BH\u0002J\b\u0010Z\u001a\u000206H\u0002J\u000e\u0010[\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\b\u0010\\\u001a\u000206H\u0002J\u0018\u0010]\u001a\u00020\u00162\u0006\u0010^\u001a\u00020\u00162\u0006\u0010_\u001a\u00020UH\u0002J\b\u0010`\u001a\u000206H\u0002J(\u0010a\u001a\u0014\u0012\u0004\u0012\u00020I\u0012\n\u0012\b\u0012\u0004\u0012\u00020Q0c0b2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020I0GH\u0002J(\u0010e\u001a\u0014\u0012\u0004\u0012\u00020I\u0012\n\u0012\b\u0012\u0004\u0012\u00020Q0c0b2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020I0GH\u0002J\b\u0010f\u001a\u000206H\u0002J\b\u0010g\u001a\u000206H\u0002J(\u0010h\u001a\u0012\u0012\u0004\u0012\u0002HO0ij\b\u0012\u0004\u0012\u0002HO`j\"\u0004\b\u0000\u0010O*\b\u0012\u0004\u0012\u0002HO0\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n )*\u0004\u0018\u00010(0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u000202X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006q"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorUI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "categorySelector", "Lcom/intellij/openapi/ui/ComboBox;", "content", "Lcom/intellij/ui/content/Content;", "getContent$intellij_database_impl", "()Lcom/intellij/ui/content/Content;", "setContent$intellij_database_impl", "(Lcom/intellij/ui/content/Content;)V", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "document", "Lcom/intellij/openapi/editor/Document;", "generatedText", "Lcom/intellij/database/scripting/CompositeText;", "generationInProgress", "Ljava/lang/Object;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel$intellij_database_impl", "()Ljavax/swing/JPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "scriptingOptions", "Lcom/intellij/database/scripting/ScriptingOptions;", "selection", "Lcom/intellij/database/scripting/ScriptGeneratorUI$Selection;", "settings", "Lcom/intellij/database/scripting/ScriptGeneratorSettings;", "kotlin.jvm.PlatformType", "toRequestFocus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "uiOptions", "Ljava/util/SortedSet;", "Lcom/intellij/database/scripting/ScriptGeneratorUI$UiOption;", "uiOptionsModifying", "Ljava/util/concurrent/atomic/AtomicInteger;", "viewer", "Lcom/intellij/ui/EditorTextField;", "getViewer$intellij_database_impl", "()Lcom/intellij/ui/EditorTextField;", "adjustCategories", "", "adjustOptionsUI", "assignCategory", "assignOptionsFromSettings", "assignSelection", "model", "Lcom/intellij/database/model/basic/BasicModel;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "changingUiOptions", "op", "Lkotlin/Function0;", "clear", "createTask", "Lcom/intellij/database/scripting/ScriptingTask;", "schemasToGenerate", "", "objectsToGenerate", "Lcom/intellij/database/model/basic/BasicElement;", "dispose", "doCopyToClipboard", "doOpenInConsole", "doSaveToFile", "doing", "T", "message", "", "operation", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "findDsForModel", "Lcom/intellij/database/dataSource/LocalDataSource;", "gatherOptions", "generate", "inUI", "block", "prepareDocument", "prepareOptionComponents", "processOptionChange", "reformatCompositeText", "compositeText", "dataSource", "regenerate", "retrieveNativeDefinitionsForElements", "", "", "elements", "retrieveNativeDefinitionsForElementsInternal", "showTheScript", "showTheScriptInsideUI", "getItems", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "Companion", "FinalAction", "LabeledComponent", "OptionGroup", "Selection", "UiOption", "intellij.database.impl"})
public final class ScriptGeneratorUI
implements Disposable {
    @NotNull
    public Content content;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final EditorTextField viewer;
    private final JBLoadingPanel loadingPanel;
    private final ComboBox<ScriptCategory> categorySelector;
    private final SortedSet<UiOption> uiOptions;
    private final AtomicInteger uiOptionsModifying;
    private final SingleAlarm alarm;
    private final ScriptGeneratorSettings settings;
    private Selection selection;
    private ScriptCategory category;
    private final Object generationInProgress;
    private final AtomicBoolean toRequestFocus;
    private CompositeText generatedText;
    private BasicSchema currentSchema;
    private ScriptingOptions scriptingOptions;
    private Document document;
    private PsiFile psiFile;
    @NotNull
    private final Project project;
    @NotNull
    private static final Application application;
    @NotNull
    private static final Key<ScriptGeneratorUI> contextKey;
    @NotNull
    private static final Key<BasicModel> modelKey;
    @NotNull
    private static final List<ScriptCategory> implementedCategories;
    @NotNull
    private static final List<ScriptingOption<?>> applicableOptions;
    @NotNull
    private static final Logger log;
    @Nullable
    private static String lastPath;
    @NotNull
    private static final Map<CompositeText.Kind, CompositeText.Kind> formattableKindRemapping;
    @NotNull
    public static final String normalLoadingPanelText = "Generating SQL script\u2026";
    public static final Companion Companion;

    @NotNull
    public final Content getContent$intellij_database_impl() {
        Content content = this.content;
        if (content == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
        }
        return content;
    }

    public final void setContent$intellij_database_impl(@NotNull Content content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"<set-?>");
        this.content = content;
    }

    @NotNull
    public final JPanel getMainPanel$intellij_database_impl() {
        return this.mainPanel;
    }

    @NotNull
    public final EditorTextField getViewer$intellij_database_impl() {
        return this.viewer;
    }

    public final void generate(@NotNull BasicModel model, @NotNull Iterable<? extends BasicNode> nodes2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        this.alarm.cancel();
        this.assignSelection(model, nodes2);
        this.adjustCategories();
        this.assignOptionsFromSettings();
        this.adjustOptionsUI();
        Object object2 = this.selection;
        if (object2 == null || (object2 = ((Selection)object2).getElements()) == null || !(!(object = object2).isEmpty())) {
            this.clear();
            return;
        }
        this.toRequestFocus.set(true);
        this.alarm.cancelAndRequest();
    }

    /*
     * WARNING - void declaration
     */
    private final SortedSet<UiOption> prepareOptionComponents() {
        TreeSet uiOptions = new TreeSet();
        for (ScriptingOption<?> option : Companion.getApplicableOptions()) {
            Collection collection;
            UiOption o;
            if (JvmClassMappingKt.getJavaClass(option.getValueClass()).isEnum()) {
                Object[] objectArray;
                void thisCollection$iv;
                void $receiver$iv;
                ComboBox comboBox;
                Collection collection2 = option.getItems();
                ComboBox comboBox2 = comboBox;
                ComboBox comboBox3 = comboBox;
                if ($receiver$iv == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                if (thisCollection$iv.toArray(new Object[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                comboBox2(objectArray);
                ComboBox itemSelector = comboBox3;
                itemSelector.setToolTipText(option.getDescription());
                LabeledComponent component = new LabeledComponent(option.getDisplayName() + ':', (JComponent)itemSelector);
                component.setVisible(false);
                ScriptingOption<?> scriptingOption = option;
                Intrinsics.checkExpressionValueIsNotNull(scriptingOption, (String)"option");
                o = new UiOption(OptionGroup.SELECTOR, scriptingOption, component, option.getDefaultValue());
                itemSelector.addActionListener(new ActionListener(this, o, itemSelector, option){
                    final /* synthetic */ ScriptGeneratorUI this$0;
                    final /* synthetic */ UiOption $o;
                    final /* synthetic */ ComboBox $itemSelector;
                    final /* synthetic */ ScriptingOption $option;

                    public final void actionPerformed(ActionEvent it) {
                        Enum enum_;
                        Object object = this.$itemSelector.getSelectedItem();
                        if (!(object instanceof Enum)) {
                            object = null;
                        }
                        if ((enum_ = (Enum)object) == null) {
                            enum_ = this.$option.getDefaultValue();
                        }
                        this.$o.setValue(enum_);
                        ScriptGeneratorUI.access$processOptionChange(this.this$0);
                        ScriptGeneratorUI.access$getAlarm$p(this.this$0).cancelAndRequest();
                    }
                    {
                        this.this$0 = scriptGeneratorUI;
                        this.$o = uiOption;
                        this.$itemSelector = comboBox;
                        this.$option = scriptingOption;
                    }
                });
                collection = uiOptions;
                collection.add(o);
                continue;
            }
            if (!Intrinsics.areEqual(option.getValueClass(), (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) continue;
            Object obj = option.getDefaultValue();
            if (!(obj instanceof Boolean)) {
                obj = null;
            }
            Boolean bl = (Boolean)obj;
            boolean checked = bl != null ? bl : false;
            JCheckBox checkbox = ComponentsKt.CheckBox((String)option.getDisplayName(), (boolean)checked, null);
            checkbox.setToolTipText(option.getDescription());
            ScriptingOption<?> scriptingOption = option;
            Intrinsics.checkExpressionValueIsNotNull(scriptingOption, (String)"option");
            o = new UiOption(OptionGroup.CHECKBOX, scriptingOption, checkbox, option.getDefaultValue());
            checkbox.setVisible(false);
            checkbox.addActionListener(new ActionListener(this, o, checkbox){
                final /* synthetic */ ScriptGeneratorUI this$0;
                final /* synthetic */ UiOption $o;
                final /* synthetic */ JCheckBox $checkbox;

                public final void actionPerformed(ActionEvent it) {
                    this.$o.setValue(this.$checkbox.isSelected());
                    ScriptGeneratorUI.access$processOptionChange(this.this$0);
                    ScriptGeneratorUI.access$getAlarm$p(this.this$0).cancelAndRequest();
                }
                {
                    this.this$0 = scriptGeneratorUI;
                    this.$o = uiOption;
                    this.$checkbox = jCheckBox;
                }
            });
            collection = uiOptions;
            collection.add(o);
        }
        return uiOptions;
    }

    /*
     * WARNING - void declaration
     */
    private final void assignSelection(BasicModel model, Iterable<? extends BasicNode> nodes2) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable<? extends BasicNode> iterable = nodes2;
        void var5_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            BasicElement basicElement;
            Object element$iv$iv = element$iv$iv$iv;
            BasicNode it = (BasicNode)element$iv$iv;
            BasicNode basicNode = it;
            if (!(basicNode instanceof BasicElement)) {
                basicNode = null;
            }
            if ((BasicElement)basicNode == null) continue;
            BasicElement it$iv$iv = basicElement;
            destination$iv$iv.add(it$iv$iv);
        }
        List elements = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        this.selection = new Selection(model, elements);
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustCategories() {
        ScriptCategory it;
        void $receiver$iv$iv;
        void $receiver$iv;
        ArrayList arrayList;
        Object object = this.selection;
        if (object == null || (object = ((Selection)object).getModel()) == null || (object = object.getRdbms()) == null) {
            object = UnknownDatabase.RDBMS;
        }
        Object rdbms = object;
        Iterable iterable = Companion.getImplementedCategories();
        ArrayList arrayList2 = arrayList;
        ArrayList arrayList3 = arrayList;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ScriptCategory)((Object)element$iv$iv);
            if (!it.getApplicableRdbms().contains(rdbms)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        arrayList2(list);
        ArrayList needCategories = arrayList3;
        ArrayList<ScriptCategory> existentCategories = this.getItems(this.categorySelector);
        if (Intrinsics.areEqual(needCategories, existentCategories)) {
            return;
        }
        ScriptCategory savedCategory = this.category;
        this.categorySelector.removeAllItems();
        if (needCategories.isEmpty()) {
            return;
        }
        Iterable $receiver$iv2 = needCategories;
        for (Object element$iv : $receiver$iv2) {
            it = (ScriptCategory)((Object)element$iv);
            this.categorySelector.addItem((Object)it);
        }
        if (needCategories.contains((Object)savedCategory)) {
            this.categorySelector.setSelectedItem((Object)savedCategory);
            this.assignCategory(savedCategory);
        } else {
            this.categorySelector.setSelectedIndex(0);
            this.assignCategory((ScriptCategory)((Object)CollectionsKt.first((List)needCategories)));
        }
    }

    private final void assignCategory(ScriptCategory category) {
        this.category = category;
        this.assignOptionsFromSettings();
    }

    private final void assignOptionsFromSettings() {
        Object object = this.selection;
        Rdbms rdbms = object != null && (object = ((Selection)object).getModel()) != null ? object.getRdbms() : null;
        CustomScriptingOptions customScriptingOptions = rdbms != null ? this.settings.get(rdbms, this.category) : null;
        this.scriptingOptions = customScriptingOptions != null ? (ScriptingOptions)customScriptingOptions : (ScriptingOptions)DefaultScriptingOptions.INSTANCE;
    }

    private final void adjustOptionsUI() {
        Object object = this.selection;
        if (object == null || (object = ((Selection)object).getModel()) == null || (object = object.getRdbms()) == null) {
            object = UnknownDatabase.RDBMS;
        }
        Object rdbms = object;
        ScriptCategory category = this.category;
        this.changingUiOptions((Function0<Unit>)((Function0)new Function0<Unit>(this, category, (Rdbms)rdbms){
            final /* synthetic */ ScriptGeneratorUI this$0;
            final /* synthetic */ ScriptCategory $category;
            final /* synthetic */ Rdbms $rdbms;

            public final void invoke() {
                Iterable $receiver$iv = ScriptGeneratorUI.access$getUiOptions$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    UiOption it = (UiOption)element$iv;
                    JComponent component = it.getComponent();
                    ScriptingOption<?> option = it.getOption();
                    component.setVisible(option.getApplicableCategories().contains((Object)((Object)this.$category)) && option.getApplicableRdbms().contains(this.$rdbms));
                    if (option.isBoolean()) {
                        JComponent jComponent = component;
                        if (jComponent == null) {
                            throw new TypeCastException("null cannot be cast to non-null type javax.swing.JCheckBox");
                        }
                        ? obj = ScriptGeneratorUI.access$getScriptingOptions$p(this.this$0).get(option);
                        if (obj == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        ((JCheckBox)jComponent).setSelected((Boolean)obj);
                        continue;
                    }
                    if (!option.isEnum()) continue;
                    JComponent jComponent = component;
                    if (jComponent == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.scripting.ScriptGeneratorUI.LabeledComponent");
                    }
                    JComponent jComponent2 = ((LabeledComponent)jComponent).getComponent();
                    if (jComponent2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.ui.ComboBox<*>");
                    }
                    ((ComboBox)jComponent2).setSelectedItem(ScriptGeneratorUI.access$getScriptingOptions$p(this.this$0).get(option));
                }
            }
            {
                this.this$0 = scriptGeneratorUI;
                this.$category = scriptCategory;
                this.$rdbms = rdbms;
                super(0);
            }
        }));
        this.mainPanel.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changingUiOptions(Function0<Unit> op) {
        this.uiOptionsModifying.incrementAndGet();
        try {
            op.invoke();
        }
        finally {
            this.uiOptionsModifying.decrementAndGet();
        }
    }

    private final void processOptionChange() {
        Rdbms rdbms;
        ScriptingOptions newOptions;
        if (this.uiOptionsModifying.get() > 0) {
            return;
        }
        this.scriptingOptions = newOptions = this.gatherOptions();
        Object object = this.selection;
        Rdbms rdbms2 = object != null && (object = ((Selection)object).getModel()) != null ? object.getRdbms() : (rdbms = null);
        if (rdbms != null) {
            ScriptingOptions scriptingOptions = newOptions;
            if (!(scriptingOptions instanceof CustomScriptingOptions)) {
                scriptingOptions = null;
            }
            this.settings.set(rdbms, this.category, (CustomScriptingOptions)scriptingOptions);
        }
    }

    private final ScriptingOptions gatherOptions() {
        TreeMap map = new TreeMap();
        for (UiOption o : this.uiOptions) {
            if (Intrinsics.areEqual((Object)o.getValue(), o.getOption().getDefaultValue())) continue;
            Map map2 = map;
            ScriptingOption<?> scriptingOption = o.getOption();
            Object object = o.getValue();
            map2.put(scriptingOption, object);
        }
        return map.isEmpty() ? (ScriptingOptions)DefaultScriptingOptions.INSTANCE : (ScriptingOptions)new CustomScriptingOptions(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void regenerate() {
        Selection selection = this.selection;
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        ScriptCategory category = this.category;
        Companion.invokeLater((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$getLoadingPanel$p(this.this$0).startLoading();
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
        ScriptingFactory scriptingFactory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        Object object = this.generationInProgress;
        synchronized (object) {
            LocalDataSource dataSource;
            JBIterable sel = JBIterable.from((Iterable)selection2.getElements());
            JBIterable explicitDatabases = sel.filter(BasicDatabase.class);
            JBIterable explicitSchemas = sel.filter(BasicSchema.class);
            JBIterable explicitScriptableObjects = sel.filter(BasicScriptable.class);
            List schemasToGenerate2 = explicitDatabases.flatten((Function)regenerate.2.schemasToGenerate.1.INSTANCE).append((Iterable)explicitSchemas).toList();
            List objectsToGenerate2 = explicitScriptableObjects.filter((Condition)new Condition<BasicScriptable>(schemasToGenerate2){
                final /* synthetic */ List $schemasToGenerate;

                public final boolean value(BasicScriptable it) {
                    BasicScriptable basicScriptable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicScriptable, (String)"it");
                    return !this.$schemasToGenerate.contains(basicScriptable.getSchema());
                }
                {
                    this.$schemasToGenerate = list;
                }
            }).toList();
            Rdbms rdbms = selection2.getModel().getRdbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"selection.model.rdbms");
            ScriptingService service = scriptingFactory.getScriptingService(rdbms);
            BasicModel basicModel = selection2.getModel();
            List list = schemasToGenerate2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemasToGenerate");
            List list2 = objectsToGenerate2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"objectsToGenerate");
            ScriptingTask task = this.createTask(category, basicModel, list, list2);
            ScriptingResult result2 = service.makeScript(task);
            CompositeText gt = result2.getScript();
            if (this.scriptingOptions.get(ScriptingOptionStatic.REFORMAT).booleanValue() && (dataSource = this.findDsForModel(selection2.getModel())) != null) {
                gt = this.reformatCompositeText(gt, dataSource);
            }
            this.generatedText = gt;
            BasicSchema basicSchema = task.getCurrentSchema();
            if (basicSchema == null) {
                BasicRoot basicRoot = selection2.getModel().getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot, (String)"selection.model.root");
                BasicDatabase basicDatabase = basicRoot.getCurrentDatabase();
                basicSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
            }
            this.currentSchema = basicSchema;
            Unit unit = Unit.INSTANCE;
        }
        this.showTheScript();
    }

    /*
     * WARNING - void declaration
     */
    private final ScriptingTask createTask(ScriptCategory category, BasicModel model, List<? extends BasicSchema> schemasToGenerate2, List<? extends BasicElement> objectsToGenerate2) {
        ScriptingTask scriptingTask;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ArrayList elements = new ArrayList();
        BasicSchema schema = schemasToGenerate2.size() == 1 ? schemasToGenerate2.get(0) : null;
        Iterable iterable = $receiver$iv = (Iterable)schemasToGenerate2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BasicSchema it = (BasicSchema)element$iv$iv;
            Iterable<BasicMajorObject> list$iv$iv = AbstractScriptingServiceKt.getScriptableMajorObjects(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)elements);
        CollectionsKt.toCollection((Iterable)objectsToGenerate2, (Collection)elements);
        switch (ScriptGeneratorUI$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
            case 1: {
                BasicSchema basicSchema = schema;
                scriptingTask = new ScriptingNativeDefinitionTask(model, elements, basicSchema != null ? basicSchema.getDatabase() : null, schema, this.scriptingOptions, (Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>>)((Function1)new Function1<List<? extends BasicElement>, Map<BasicElement, ? extends String[]>>(this){

                    @NotNull
                    public final Map<BasicElement, String[]> invoke(@NotNull List<? extends BasicElement> p1) {
                        Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                        return ScriptGeneratorUI.access$retrieveNativeDefinitionsForElements((ScriptGeneratorUI)this.receiver, p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(ScriptGeneratorUI.class);
                    }

                    public final String getName() {
                        return "retrieveNativeDefinitionsForElements";
                    }

                    public final String getSignature() {
                        return "retrieveNativeDefinitionsForElements(Ljava/util/List;)Ljava/util/Map;";
                    }
                }));
                break;
            }
            default: {
                BasicSchema basicSchema = schema;
                scriptingTask = new ScriptingSingleModelTask(model, elements, basicSchema != null ? basicSchema.getDatabase() : null, schema, category, this.scriptingOptions);
            }
        }
        return scriptingTask;
    }

    private final CompositeText reformatCompositeText(CompositeText compositeText, LocalDataSource dataSource) {
        if (compositeText.getLength() > FileUtilRt.getUserFileSizeLimit()) {
            return compositeText;
        }
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(dataSource);
        CompositeText newCompositeText = CompositeTextFun.remapFragmentKinds(compositeText, Companion.getFormattableKindRemapping());
        PersistentMarkup persistentMarkup = DbSrcMigration.formatCompositeText(this.project, dialect, newCompositeText);
        Intrinsics.checkExpressionValueIsNotNull((Object)persistentMarkup, (String)"DbSrcMigration.formatCom\u2026ialect, newCompositeText)");
        return persistentMarkup;
    }

    private final void showTheScript() {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$prepareDocument(this.this$0);
                ScriptGeneratorUI.access$showTheScriptInsideUI(this.this$0);
                ScriptGeneratorUI.access$getLoadingPanel$p(this.this$0).stopLoading();
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
    }

    private final void prepareDocument() {
        Document document;
        Selection selection = this.selection;
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        BasicModel model = selection2.getModel();
        Document document2 = this.document;
        if ((document2 != null ? (BasicModel)document2.getUserData(Companion.getModelKey()) : null) == model) {
            return;
        }
        LocalDataSource localDataSource = this.findDsForModel(model);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource dataSource = localDataSource;
        DbDataSource dbDataSource = DbPsiFacadeImpl.getInstance((Project)this.project).findDataSource(dataSource.getUniqueId());
        if (dbDataSource == null) {
            return;
        }
        DbDataSource dbDataSource2 = dbDataSource;
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(dataSource);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText("generated.sql", (Language)language, (CharSequence)"");
        DatabaseDataKeys.DATA_SOURCE_KEY.set((UserDataHolder)psiFile, (Object)dbDataSource2);
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)ObjectPaths.searchPathOf(this.currentSchema));
        this.psiFile = psiFile;
        Document document3 = document = PsiDocumentManager.getInstance((Project)this.project).getDocument(psiFile);
        if (document3 == null) {
            Intrinsics.throwNpe();
        }
        document3.putUserData(Companion.getModelKey(), (Object)model);
        this.document = document;
    }

    private final void showTheScriptInsideUI() {
        block4: {
            Document document = this.document;
            if (document == null) {
                String string = "The document is not prepared";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Document document2 = document;
            document2.setReadOnly(false);
            Object object = this.generatedText;
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            document2.setText((CharSequence)object);
            document2.setReadOnly(true);
            if (this.viewer.getDocument() != document2) {
                this.viewer.setDocument(document2);
            }
            this.viewer.setVisible(true);
            Editor editor = this.viewer.getEditor();
            if (!(editor instanceof EditorImpl)) {
                editor = null;
            }
            EditorImpl editorImpl = (EditorImpl)editor;
            if (editorImpl == null) break block4;
            editorImpl.setCaretEnabled(true);
        }
    }

    private final void doCopyToClipboard() {
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((Object)generatedText.getText()).toString()));
    }

    private final void doSaveToFile() {
        File file;
        VirtualFileWrapper fileWrapper;
        String string;
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        if (Companion.getLastPath() != null) {
            string = Companion.getLastPath();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else if (StringsKt.equals((String)this.project.getName(), (String)"default", (boolean)true)) {
            string = System.getProperty("user.home");
            if (string == null) {
                string = "";
            }
        } else {
            string = this.project.getBasePath();
            if (string == null) {
                string = "";
            }
        }
        String path = string;
        FileSaverDescriptor descriptor = new FileSaverDescriptor("Select File to Save the Script", "", new String[]{"sql"});
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileSaverDialog, (String)"FileChooserFactory.getIn\u2026alog(descriptor, project)");
        FileSaverDialog chooser = fileSaverDialog;
        VirtualFile virtualBaseDir = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        VirtualFileWrapper virtualFileWrapper = chooser.save(virtualBaseDir, "script.sql");
        if (virtualFileWrapper == null) {
            return;
        }
        VirtualFileWrapper virtualFileWrapper2 = fileWrapper = virtualFileWrapper;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileWrapper2, (String)"fileWrapper");
        File file2 = file = virtualFileWrapper2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
        Companion.setLastPath(file2.getParent());
        try {
            Files.write(Paths.get(file.getPath(), new String[0]), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)generatedText.getText()), new OpenOption[0]);
        }
        catch (Exception e) {
            String message = "Failed to save SQL script into a file \"" + file.getAbsolutePath() + ": exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
            Companion.getLog().warn(message, (Throwable)e);
        }
    }

    private final void doOpenInConsole() {
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        Selection selection = this.selection;
        LocalDataSource localDataSource = this.findDsForModel(selection != null ? selection.getModel() : null);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        VirtualFile virtualFile = DatabaseEditorHelper.createNewConsoleVirtualFile(ds);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(document2, generatedText){
            final /* synthetic */ Document $document;
            final /* synthetic */ CompositeText $generatedText;

            public final void run() {
                this.$document.setText(this.$generatedText.getText());
            }
            {
                this.$document = document;
                this.$generatedText = compositeText;
            }
        });
        DatabaseEditorHelper.openConsoleForFile(this.project, null, virtualFile2);
    }

    private final LocalDataSource findDsForModel(BasicModel model) {
        Object v3;
        block2: {
            if (model == null) {
                return null;
            }
            DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dataSourceStorage), (String)"DataSourceStorage.getProjectStorage(project)");
            List<LocalDataSource> list = dataSourceStorage.getDataSources();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"DataSourceStorage.getPro\u2026oject)\n      .dataSources");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                LocalDataSource ds;
                LocalDataSource localDataSource = ds = (LocalDataSource)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"ds");
                if (!Intrinsics.areEqual((Object)localDataSource.getModel(), (Object)model)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<BasicElement, String[]> retrieveNativeDefinitionsForElements(List<? extends BasicElement> elements) {
        Map map;
        void this_$iv;
        int n = elements.size();
        if (n == 0) {
            return MapsKt.emptyMap();
        }
        ScriptGeneratorUI scriptGeneratorUI = this;
        String message$iv = "Retrieving native definitions for " + n + ' ' + StringUtil.pluralize((String)"element", (int)n);
        ((ScriptGeneratorUI)this_$iv).loadingPanel.setLoadingText(message$iv);
        try {
            map = this.retrieveNativeDefinitionsForElementsInternal(elements);
        }
        finally {
            ((ScriptGeneratorUI)this_$iv).loadingPanel.setLoadingText(normalLoadingPanelText);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<BasicElement, String[]> retrieveNativeDefinitionsForElementsInternal(List<? extends BasicElement> elements) {
        void result2;
        BasicModel model;
        LocalDataSource dataSource;
        Selection selection = this.selection;
        if (selection == null) {
            Intrinsics.throwNpe();
        }
        if ((dataSource = this.findDsForModel(model = selection.getModel())) == null) {
            Map map = JBIterable.from((Iterable)elements).toMap((Convertor)retrieveNativeDefinitionsForElementsInternal.1.INSTANCE, (Convertor)retrieveNativeDefinitionsForElementsInternal.2.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"JBIterable.from(elements\u2026taSource not found :(\")})");
            return map;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        DBFacadeProvider.withFacade(this.project, dataSource, (Function1<? super DBFacade, Unit>)((Function1)new Function1<DBFacade, Unit>(model, (Ref.ObjectRef)result2, elements){
            final /* synthetic */ BasicModel $model;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ List $elements;

            public final void invoke(@NotNull DBFacade db) {
                Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(this.$model);
                introspector.attachToDB(db);
                this.$result.element = introspector.introspectNativeDefinitions(this.$elements, false);
            }
            {
                this.$model = basicModel;
                this.$result = objectRef;
                this.$elements = list;
                super(1);
            }
        }));
        Map map = (Map)result2.element;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final void clear() {
        this.generatedText = null;
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$setDocument$p(this.this$0, null);
                this.this$0.getViewer$intellij_database_impl().getDocument().setText((CharSequence)"");
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
    }

    public void dispose() {
        Content content = this.content;
        if (content == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
        }
        content.putUserData(Companion.getContextKey(), null);
        this.loadingPanel.removeAll();
    }

    /*
     * WARNING - void declaration
     */
    private final <T> ArrayList<T> getItems(@NotNull ComboBox<T> $receiver) {
        int n = $receiver.getItemCount();
        ArrayList<Object> list = new ArrayList<Object>(n);
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            list.add($receiver.getItemAt((int)i2));
            ++i2;
        }
        return list;
    }

    private final void inUI(Function0<Unit> block) {
        Companion.invokeLater((Function0<Unit>)((Function0)new Function0<Unit>(block){
            final /* synthetic */ Function0 $block;

            public final void invoke() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ inUI.1 this$0;

                    public final void run() {
                        this.this$0.$block.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$block = function0;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T doing(String message, Function0<? extends T> operation) {
        this.loadingPanel.setLoadingText(message);
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.loadingPanel.setLoadingText(normalLoadingPanelText);
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptGeneratorUI(@NotNull Project project) {
        JScrollPane optionsScrollPane;
        Document $receiver$iv;
        ComboBox comboBox;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.uiOptionsModifying = new AtomicInteger(0);
        this.alarm = new SingleAlarm(new Runnable(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void run() {
                ScriptGeneratorUI.access$regenerate(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
            }
        }, 250, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
        this.settings = (ScriptGeneratorSettings)ServiceManager.getService((Project)this.project, ScriptGeneratorSettings.class);
        this.category = ScriptCategory.CREATE_COMPLETE;
        this.generationInProgress = new Object();
        this.toRequestFocus = new AtomicBoolean(false);
        this.scriptingOptions = DefaultScriptingOptions.INSTANCE;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Object object2 = editorFactory.createDocument((CharSequence)"");
        ScriptGeneratorUI scriptGeneratorUI = this;
        Object $receiver = object2;
        $receiver.setReadOnly(true);
        scriptGeneratorUI.document = object = object2;
        this.viewer = new EditorTextField(this.document, this.project, null, true, false);
        this.viewer.setFontInheritedFromLAF(false);
        this.viewer.addSettingsProvider(new EditorSettingsProvider(){

            public final void customizeSettings(EditorEx editor) {
                EditorSettings settings;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                EditorEx editorEx = editor;
                Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"editor");
                PsiFile psiFile = psiDocumentManager.getPsiFile((Document)editorEx.getDocument());
                if (psiFile != null) {
                    DatabaseDialogsHelper.setSpecificSyntaxHighlighter(psiFile, this.getProject(), psiFile.getLanguage(), editor);
                }
                editor.setHorizontalScrollbarVisible(true);
                editor.setVerticalScrollbarVisible(true);
                editor.setBorder((Border)JBUI.Borders.empty());
                EditorSettings editorSettings = settings = editor.getSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"settings");
                editorSettings.setWheelFontChangeEnabled(true);
                settings.setFoldingOutlineShown(true);
                settings.setAdditionalLinesCount(2);
                settings.setUseSoftWraps(false);
                settings.setLineNumbersShown(true);
                settings.setAnimatedScrolling(true);
            }
        });
        object2 = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        scriptGeneratorUI = this;
        $receiver = object2;
        $receiver.add((Component)this.viewer, (Object)"Center");
        $receiver.setLoadingText(normalLoadingPanelText);
        object = object2;
        scriptGeneratorUI.loadingPanel = object;
        object2 = Companion.getImplementedCategories();
        ComboBox comboBox2 = comboBox;
        object = comboBox;
        scriptGeneratorUI = this;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v1;
        ScriptCategory[] scriptCategoryArray = thisCollection$iv.toArray(new ScriptCategory[0]);
        if (scriptCategoryArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ScriptCategory[] scriptCategoryArray2 = scriptCategoryArray;
        comboBox2((Object[])scriptCategoryArray2);
        $receiver$iv = object;
        $receiver = $receiver$iv;
        $receiver.setEditable(false);
        $receiver.setSelectedItem((Object)this.category);
        $receiver.addActionListener(new ActionListener((ComboBox)$receiver, this){
            final /* synthetic */ ComboBox receiver$0;
            final /* synthetic */ ScriptGeneratorUI this$0;
            {
                this.receiver$0 = comboBox;
                this.this$0 = scriptGeneratorUI;
            }

            public final void actionPerformed(ActionEvent it) {
                ScriptCategory selectedCategory;
                Object object = this.receiver$0.getSelectedItem();
                if (!(object instanceof ScriptCategory)) {
                    object = null;
                }
                if ((selectedCategory = (ScriptCategory)((Object)object)) != null) {
                    ScriptGeneratorUI.access$assignCategory(this.this$0, selectedCategory);
                    ScriptGeneratorUI.access$adjustOptionsUI(this.this$0);
                    ScriptGeneratorUI.access$getAlarm$p(this.this$0).cancelAndRequest();
                }
            }
        });
        scriptGeneratorUI.categorySelector = object = $receiver$iv;
        this.uiOptions = this.prepareOptionComponents();
        Object $receiver2 = $receiver = new JPanel((LayoutManager)new VerticalLayout(4), false);
        UIUtil.addInsets((JComponent)((JComponent)$receiver2), (Insets)UIUtil.PANEL_REGULAR_INSETS);
        ((Container)$receiver2).add(new LabeledComponent("Generate:", (JComponent)this.categorySelector));
        Iterable $receiver$iv2 = this.uiOptions;
        for (Object element$iv : $receiver$iv2) {
            UiOption it = (UiOption)element$iv;
            ((Container)$receiver2).add(it.getComponent());
        }
        Object optionsInnerPanel = $receiver;
        JScrollPane jScrollPane = optionsScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)optionsInnerPanel), (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"optionsScrollPane");
        jScrollPane.setVerticalScrollBarPolicy(20);
        optionsScrollPane.setHorizontalScrollBarPolicy(31);
        FinalAction doCopyToClipboardAction2 = new FinalAction(this, "Copy to Clipboard", null, AllIcons.Actions.Copy, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$doCopyToClipboard(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        FinalAction doSaveToFileAction2 = new FinalAction(this, "Save into a File", null, AllIcons.Actions.Menu_saveall, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$doSaveToFile(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        FinalAction doOpenInConsoleAction2 = new FinalAction(this, "Open in Console", null, DatabaseIcons.ConsoleRun, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$doOpenInConsole(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actions = new DefaultActionGroup(new AnAction[]{doCopyToClipboardAction2, doSaveToFileAction2, doOpenInConsoleAction2});
        ActionToolbar actionToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)actions, false);
        JPanel jPanel = new JPanel(new BorderLayout());
        scriptGeneratorUI = this;
        JPanel $receiver3 = jPanel;
        $receiver3.add((Component)this.loadingPanel, "Center");
        $receiver3.add((Component)optionsScrollPane, "West");
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar2, (String)"actionToolbar");
        $receiver3.add((Component)actionToolbar2.getComponent(), "East");
        object = jPanel;
        scriptGeneratorUI.mainPanel = object;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Companion = new Companion(null);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ScriptGeneratorUI.application = application;
        contextKey = new Key("DatabaseScriptingContext");
        modelKey = new Key("DatabaseModel");
        implementedCategories = CollectionsKt.listOf((Object[])new ScriptCategory[]{ScriptCategory.CREATE_COMPLETE, ScriptCategory.CREATE_DEFINITION, ScriptCategory.NATIVE_DEFINITION, ScriptCategory.ENABLE_CONSTRAINTS, ScriptCategory.DISABLE_CONSTRAINTS, ScriptCategory.REFRESH, ScriptCategory.EXECUTE});
        Iterable iterable = $receiver$iv = (Iterable)ScriptingOptionStatic.SCRIPTING_OPTIONS;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ScriptingOption it = (ScriptingOption)element$iv$iv;
            Collection collection = CollectionsKt.intersect((Iterable)it.getApplicableCategories(), (Iterable)Companion.getImplementedCategories());
            if (!(!collection.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        applicableOptions = (List)var2_2;
        log = Logger.getInstance(ScriptGeneratorUI.class);
        formattableKindRemapping = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)CompositeText.Kind.PLAIN_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.FIXED_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.ORIGINAL_TEXT), (Object)((Object)CompositeText.Kind.DECOMPILED_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.DECOMPILED_TEXT), (Object)((Object)CompositeText.Kind.DECOMPILED_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.SPECIFICATION_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.SQL_DELIMITER), (Object)((Object)CompositeText.Kind.SQL_DELIMITER))});
    }

    public static final /* synthetic */ void access$processOptionChange(ScriptGeneratorUI $this) {
        $this.processOptionChange();
    }

    @NotNull
    public static final /* synthetic */ SingleAlarm access$getAlarm$p(ScriptGeneratorUI $this) {
        return $this.alarm;
    }

    @NotNull
    public static final /* synthetic */ SortedSet access$getUiOptions$p(ScriptGeneratorUI $this) {
        return $this.uiOptions;
    }

    @NotNull
    public static final /* synthetic */ ScriptingOptions access$getScriptingOptions$p(ScriptGeneratorUI $this) {
        return $this.scriptingOptions;
    }

    public static final /* synthetic */ void access$setScriptingOptions$p(ScriptGeneratorUI $this, @NotNull ScriptingOptions scriptingOptions) {
        $this.scriptingOptions = scriptingOptions;
    }

    @NotNull
    public static final /* synthetic */ Map access$retrieveNativeDefinitionsForElements(ScriptGeneratorUI $this, @NotNull List elements) {
        return $this.retrieveNativeDefinitionsForElements(elements);
    }

    public static final /* synthetic */ void access$prepareDocument(ScriptGeneratorUI $this) {
        $this.prepareDocument();
    }

    public static final /* synthetic */ void access$showTheScriptInsideUI(ScriptGeneratorUI $this) {
        $this.showTheScriptInsideUI();
    }

    @Nullable
    public static final /* synthetic */ Document access$getDocument$p(ScriptGeneratorUI $this) {
        return $this.document;
    }

    public static final /* synthetic */ void access$setDocument$p(ScriptGeneratorUI $this, @Nullable Document document) {
        $this.document = document;
    }

    public static final /* synthetic */ void access$regenerate(ScriptGeneratorUI $this) {
        $this.regenerate();
    }

    public static final /* synthetic */ void access$assignCategory(ScriptGeneratorUI $this, @NotNull ScriptCategory category) {
        $this.assignCategory(category);
    }

    public static final /* synthetic */ void access$adjustOptionsUI(ScriptGeneratorUI $this) {
        $this.adjustOptionsUI();
    }

    public static final /* synthetic */ void access$doCopyToClipboard(ScriptGeneratorUI $this) {
        $this.doCopyToClipboard();
    }

    public static final /* synthetic */ void access$doSaveToFile(ScriptGeneratorUI $this) {
        $this.doSaveToFile();
    }

    public static final /* synthetic */ void access$doOpenInConsole(ScriptGeneratorUI $this) {
        $this.doOpenInConsole();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorUI$OptionGroup;", "", "(Ljava/lang/String;I)V", "SELECTOR", "CHECKBOX", "intellij.database.impl"})
    private static final class OptionGroup
    extends Enum<OptionGroup> {
        public static final /* enum */ OptionGroup SELECTOR;
        public static final /* enum */ OptionGroup CHECKBOX;
        private static final /* synthetic */ OptionGroup[] $VALUES;

        static {
            OptionGroup[] optionGroupArray = new OptionGroup[2];
            OptionGroup[] optionGroupArray2 = optionGroupArray;
            optionGroupArray[0] = SELECTOR = new OptionGroup();
            optionGroupArray[1] = CHECKBOX = new OptionGroup();
            $VALUES = optionGroupArray;
        }

        public static OptionGroup[] values() {
            return (OptionGroup[])$VALUES.clone();
        }

        public static OptionGroup valueOf(String string) {
            return Enum.valueOf(OptionGroup.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J5\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0016H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorUI$UiOption;", "", "groupOrder", "Lcom/intellij/database/scripting/ScriptGeneratorUI$OptionGroup;", "option", "Lcom/intellij/database/scripting/ScriptingOption;", "component", "Ljavax/swing/JComponent;", "value", "", "(Lcom/intellij/database/scripting/ScriptGeneratorUI$OptionGroup;Lcom/intellij/database/scripting/ScriptingOption;Ljavax/swing/JComponent;Ljava/lang/Object;)V", "getComponent", "()Ljavax/swing/JComponent;", "getGroupOrder", "()Lcom/intellij/database/scripting/ScriptGeneratorUI$OptionGroup;", "getOption", "()Lcom/intellij/database/scripting/ScriptingOption;", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "compareTo", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "hashCode", "toString", "", "intellij.database.impl"})
    private static final class UiOption
    implements Comparable<UiOption> {
        @NotNull
        private final OptionGroup groupOrder;
        @NotNull
        private final ScriptingOption<?> option;
        @NotNull
        private final JComponent component;
        @NotNull
        private Object value;

        @Override
        public int compareTo(@NotNull UiOption other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE});
        }

        @NotNull
        public final OptionGroup getGroupOrder() {
            return this.groupOrder;
        }

        @NotNull
        public final ScriptingOption<?> getOption() {
            return this.option;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        public final void setValue(@NotNull Object object) {
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"<set-?>");
            this.value = object;
        }

        public UiOption(@NotNull OptionGroup groupOrder, @NotNull ScriptingOption<?> option, @NotNull JComponent component, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)groupOrder), (String)"groupOrder");
            Intrinsics.checkParameterIsNotNull(option, (String)"option");
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.groupOrder = groupOrder;
            this.option = option;
            this.component = component;
            this.value = value;
        }

        @NotNull
        public final OptionGroup component1() {
            return this.groupOrder;
        }

        @NotNull
        public final ScriptingOption<?> component2() {
            return this.option;
        }

        @NotNull
        public final JComponent component3() {
            return this.component;
        }

        @NotNull
        public final Object component4() {
            return this.value;
        }

        @NotNull
        public final UiOption copy(@NotNull OptionGroup groupOrder, @NotNull ScriptingOption<?> option, @NotNull JComponent component, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)groupOrder), (String)"groupOrder");
            Intrinsics.checkParameterIsNotNull(option, (String)"option");
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new UiOption(groupOrder, option, component, value);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ UiOption copy$default(UiOption uiOption, OptionGroup optionGroup, ScriptingOption scriptingOption, JComponent jComponent, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                optionGroup = uiOption.groupOrder;
            }
            if ((n & 2) != 0) {
                scriptingOption = uiOption.option;
            }
            if ((n & 4) != 0) {
                jComponent = uiOption.component;
            }
            if ((n & 8) != 0) {
                object = uiOption.value;
            }
            return uiOption.copy(optionGroup, scriptingOption, jComponent, object);
        }

        public String toString() {
            return "UiOption(groupOrder=" + (Object)((Object)this.groupOrder) + ", option=" + this.option + ", component=" + this.component + ", value=" + this.value + ")";
        }

        public int hashCode() {
            OptionGroup optionGroup = this.groupOrder;
            ScriptingOption<?> scriptingOption = this.option;
            JComponent jComponent = this.component;
            Object object = this.value;
            return (((optionGroup != null ? ((Object)((Object)optionGroup)).hashCode() : 0) * 31 + (scriptingOption != null ? ((Object)scriptingOption).hashCode() : 0)) * 31 + (jComponent != null ? jComponent.hashCode() : 0)) * 31 + (object != null ? object.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UiOption)) break block3;
                    UiOption uiOption = (UiOption)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.groupOrder), (Object)((Object)uiOption.groupOrder)) || !Intrinsics.areEqual(this.option, uiOption.option) || !Intrinsics.areEqual((Object)this.component, (Object)uiOption.component) || !Intrinsics.areEqual((Object)this.value, (Object)uiOption.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorUI$Selection;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;)V", "getElements", "()Ljava/util/Collection;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
    private static final class Selection {
        @NotNull
        private final BasicModel model;
        @NotNull
        private final Collection<BasicElement> elements;

        @NotNull
        public final BasicModel getModel() {
            return this.model;
        }

        @NotNull
        public final Collection<BasicElement> getElements() {
            return this.elements;
        }

        public Selection(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            this.model = model;
            this.elements = elements;
        }

        @NotNull
        public final BasicModel component1() {
            return this.model;
        }

        @NotNull
        public final Collection<BasicElement> component2() {
            return this.elements;
        }

        @NotNull
        public final Selection copy(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return new Selection(model, elements);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Selection copy$default(Selection selection, BasicModel basicModel, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                basicModel = selection.model;
            }
            if ((n & 2) != 0) {
                collection = selection.elements;
            }
            return selection.copy(basicModel, collection);
        }

        public String toString() {
            return "Selection(model=" + this.model + ", elements=" + this.elements + ")";
        }

        public int hashCode() {
            BasicModel basicModel = this.model;
            Collection<BasicElement> collection = this.elements;
            return (basicModel != null ? basicModel.hashCode() : 0) * 31 + (collection != null ? ((Object)collection).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Selection)) break block3;
                    Selection selection = (Selection)object;
                    if (!Intrinsics.areEqual((Object)this.model, (Object)selection.model) || !Intrinsics.areEqual(this.elements, selection.elements)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorUI$LabeledComponent;", "Ljavax/swing/JPanel;", "labelText", "", "component", "Ljavax/swing/JComponent;", "(Ljava/lang/String;Ljavax/swing/JComponent;)V", "getComponent", "()Ljavax/swing/JComponent;", "label", "Ljavax/swing/JLabel;", "getLabel", "()Ljavax/swing/JLabel;", "intellij.database.impl"})
    private static final class LabeledComponent
    extends JPanel {
        @NotNull
        private final JLabel label;
        @NotNull
        private final JComponent component;

        @NotNull
        public final JLabel getLabel() {
            return this.label;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        public LabeledComponent(@NotNull String labelText, @NotNull JComponent component) {
            Intrinsics.checkParameterIsNotNull((Object)labelText, (String)"labelText");
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            super(new BorderLayout(), false);
            this.component = component;
            this.label = new JLabel(labelText + ' ');
            this.add((Component)this.label, "West");
            this.add((Component)this.component, "Center");
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@Nullable MouseEvent e) {
                    this.getComponent().requestFocus();
                }
            });
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorUI$FinalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "(Lcom/intellij/database/scripting/ScriptGeneratorUI;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private final class FinalAction
    extends AnAction {
        @NotNull
        private final Function0<Unit> action;
        final /* synthetic */ ScriptGeneratorUI this$0;

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public void actionPerformed(@Nullable AnActionEvent e) {
            this.action.invoke();
        }

        public FinalAction(@NotNull ScriptGeneratorUI $outer, @Nullable String text, @Nullable String description, @NotNull Icon icon, Function0<Unit> action) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            super(text, description, icon);
            this.this$0 = $outer;
            this.action = action;
        }

        public /* synthetic */ FinalAction(ScriptGeneratorUI scriptGeneratorUI, String string, String string2, Icon icon, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this(scriptGeneratorUI, string, string2, icon, (Function0<Unit>)function0);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0+R'\u0010\u0003\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0011R\u000e\u0010'\u001a\u00020\u001bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/scripting/ScriptGeneratorUI$Companion;", "", "()V", "applicableOptions", "", "Lcom/intellij/database/scripting/ScriptingOption;", "kotlin.jvm.PlatformType", "getApplicableOptions", "()Ljava/util/List;", "application", "Lcom/intellij/openapi/application/Application;", "getApplication", "()Lcom/intellij/openapi/application/Application;", "contextKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/scripting/ScriptGeneratorUI;", "getContextKey", "()Lcom/intellij/openapi/util/Key;", "formattableKindRemapping", "", "Lcom/intellij/database/scripting/CompositeText$Kind;", "getFormattableKindRemapping", "()Ljava/util/Map;", "implementedCategories", "Lcom/intellij/database/scripting/ScriptCategory;", "getImplementedCategories", "lastPath", "", "getLastPath", "()Ljava/lang/String;", "setLastPath", "(Ljava/lang/String;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "modelKey", "Lcom/intellij/database/model/basic/BasicModel;", "getModelKey", "normalLoadingPanelText", "invokeLater", "", "whatToDo", "Lkotlin/Function0;", "intellij.database.impl"})
    public static final class Companion {
        @NotNull
        public final Application getApplication() {
            return application;
        }

        @NotNull
        public final Key<ScriptGeneratorUI> getContextKey() {
            return contextKey;
        }

        @NotNull
        public final Key<BasicModel> getModelKey() {
            return modelKey;
        }

        @NotNull
        public final List<ScriptCategory> getImplementedCategories() {
            return implementedCategories;
        }

        @NotNull
        public final List<ScriptingOption<?>> getApplicableOptions() {
            return applicableOptions;
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @Nullable
        public final String getLastPath() {
            return lastPath;
        }

        public final void setLastPath(@Nullable String string) {
            lastPath = string;
        }

        @NotNull
        public final Map<CompositeText.Kind, CompositeText.Kind> getFormattableKindRemapping() {
            return formattableKindRemapping;
        }

        public final void invokeLater(@NotNull Function0<Unit> whatToDo) {
            Intrinsics.checkParameterIsNotNull(whatToDo, (String)"whatToDo");
            Function0<Unit> function0 = whatToDo;
            this.getApplication().invokeLater((Runnable)new ScriptGeneratorUIKt$sam$Runnable$c443607f(function0), this.getApplication().getAnyModalityState());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

