/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingTaskKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/intellij/database/scripting/ScriptingContext;", "", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingTask;)V", "db", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentDatabase", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setCurrentDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "s", "Lcom/intellij/database/model/basic/BasicSchema;", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "model", "Lcom/intellij/database/model/basic/BasicModel;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "script", "", "Lcom/intellij/database/scripting/CompositeText;", "getScript", "()Ljava/util/List;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "intellij.database.scripting"})
public class ScriptingContext {
    @Nullable
    private BasicDatabase currentDatabase;
    @Nullable
    private BasicSchema currentSchema;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private final List<CompositeText> script;
    @NotNull
    private final ScriptingTask task;

    @NotNull
    public final Rdbms getRdbms() {
        return ScriptingTaskKt.getRdbms(this.task);
    }

    @NotNull
    public final BasicModel getModel() {
        BasicModel basicModel = ScriptingTaskKt.getAnyModel(this.task);
        if (basicModel == null) {
            Intrinsics.throwNpe();
        }
        return basicModel;
    }

    @Nullable
    public final BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    public final void setCurrentDatabase(@Nullable BasicDatabase db) {
        if (db != null) {
            boolean bl = Intrinsics.areEqual((Object)db.getModel(), (Object)ScriptingTaskKt.getAnyModel(this.task));
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (Intrinsics.areEqual((Object)this.currentDatabase, (Object)db) ^ true) {
                this.setCurrentSchema(null);
                this.currentDatabase = db;
            }
        } else {
            this.setCurrentSchema(null);
            this.currentDatabase = null;
        }
    }

    @Nullable
    public final BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    public final void setCurrentSchema(@Nullable BasicSchema s) {
        if (s != null) {
            boolean bl = Intrinsics.areEqual((Object)s.getModel(), (Object)ScriptingTaskKt.getAnyModel(this.task));
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.setCurrentDatabase(s.getDatabase());
            this.currentSchema = s;
        } else {
            this.currentSchema = null;
        }
    }

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final List<CompositeText> getScript() {
        return this.script;
    }

    @NotNull
    public final ScriptingTask getTask() {
        return this.task;
    }

    public ScriptingContext(@NotNull ScriptingTask task) {
        BasicSchema basicSchema;
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.task = task;
        BasicDatabase basicDatabase = this.task.getCurrentDatabase();
        if (basicDatabase == null) {
            Object object = ScriptingTaskKt.getAnyModel(this.task);
            basicDatabase = this.currentDatabase = object != null && (object = object.getRoot()) != null ? object.getCurrentDatabase() : null;
        }
        if ((basicSchema = this.task.getCurrentSchema()) == null) {
            BasicDatabase basicDatabase2 = this.currentDatabase;
            basicSchema = basicDatabase2 != null ? ModelFun.getCurrentSchema(basicDatabase2) : null;
        }
        this.currentSchema = basicSchema;
        this.options = DefaultScriptingOptions.INSTANCE;
        this.script = new ArrayList();
    }
}

