/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.scripting.ExasolScriptingHelper;
import com.intellij.database.scripting.GenericScriptingHelper;
import com.intellij.database.scripting.H2ScriptingHelper;
import com.intellij.database.scripting.MsScriptingHelper;
import com.intellij.database.scripting.MysqlScriptingHelper;
import com.intellij.database.scripting.OraScriptingHelper;
import com.intellij.database.scripting.PostgresScriptingHelper;
import com.intellij.database.scripting.RedshiftScriptingHelper;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.SizeAndScale;
import com.intellij.database.scripting.SqliteScriptingHelper;
import com.intellij.database.scripting.SybaseScriptingHelper;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Exasol;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Redshift;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u0082\u0001\b\u001f !\"#$%&\u00a8\u0006'"}, d2={"Lcom/intellij/database/scripting/ScriptingHelper;", "", "()V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/scripting/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "supportsCreateOrReplace", "getSupportsCreateOrReplace", "getObjectPreliminaryOrder", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getObjectPreliminaryOrderPart", "isDefaultSize", "", "d", "Lcom/intellij/database/model/DataType;", "isNullExplicit", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "script", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "Companion", "Lcom/intellij/database/scripting/GenericScriptingHelper;", "Lcom/intellij/database/scripting/OraScriptingHelper;", "Lcom/intellij/database/scripting/TransactScriptingHelper;", "Lcom/intellij/database/scripting/PgBaseScriptingHelper;", "Lcom/intellij/database/scripting/MysqlScriptingHelper;", "Lcom/intellij/database/scripting/SqliteScriptingHelper;", "Lcom/intellij/database/scripting/H2ScriptingHelper;", "Lcom/intellij/database/scripting/ExasolScriptingHelper;", "intellij.database.scripting"})
public abstract class ScriptingHelper {
    @NotNull
    private final Set<ObjectKind> supportsCreateOrReplace = SetsKt.emptySet();
    @NotNull
    private final Set<ObjectKind> supportsCreateIfNotExists = SetsKt.emptySet();
    @NotNull
    private final Map<String, SizeAndScale> defaultPrimitiveSizes = MapsKt.emptyMap();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Set<ObjectKind> getSupportsCreateOrReplace() {
        return this.supportsCreateOrReplace;
    }

    @NotNull
    public Set<ObjectKind> getSupportsCreateIfNotExists() {
        return this.supportsCreateIfNotExists;
    }

    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    public boolean isNullExplicit(@Nullable BasicLikeColumn column2) {
        return false;
    }

    @NotNull
    public String script(@NotNull DataType d, @NotNull ScriptingOptions options) {
        String string;
        boolean defaultSize;
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        String specification = null;
        if (!d.custom && !d.sizeUnitExplicit && d.size != -1 && (defaultSize = this.isDefaultSize(d))) {
            specification = d.typeName;
            if (d.suffix != null) {
                specification = specification + " " + d.suffix;
            }
        }
        if ((string = specification) == null) {
            String string2 = d.getSpecification();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"d.specification");
        }
        return string;
    }

    protected boolean isDefaultSize(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        SizeAndScale defaults = this.getDefaultPrimitiveSizes().get(d.typeName);
        return defaults != null && d.size == defaults.getSize() && d.scale == defaults.getScale();
    }

    @NotNull
    public final String getObjectPreliminaryOrder(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        StringBuilder b = new StringBuilder(60);
        for (BasicElement e = element; e != null; e = e.getParent()) {
            CharSequence charSequence = b;
            if (charSequence.length() > 0) {
                b.insert(0, '.');
            }
            b.insert(0, this.getObjectPreliminaryOrderPart(e));
            if (e instanceof BasicMajorObject) break;
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    public final String getObjectPreliminaryOrderPart(@NotNull BasicElement element) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
        String kindOrder = ScriptingUtilsKt.orderString(objectKind);
        BasicElement basicElement = element;
        if (basicElement instanceof BasicArrangedElement) {
            string = "#" + ScriptingUtilsKt.toFixedOrderString(((BasicArrangedElement)element).getPosition()) + "#" + element.identity();
        } else if (basicElement instanceof BasicIdentifiedElement) {
            string = ScriptingUtilsKt.toOrderString(((BasicIdentifiedElement)element).getObjectId()) + "#" + element.identity();
        } else if (basicElement instanceof BasicOverloadable) {
            string = "?_" + element.identity();
        } else if (basicElement instanceof BasicNamedElement) {
            StringBuilder stringBuilder = new StringBuilder().append("?_");
            String string2 = ((BasicNamedElement)element).getRealName();
            if (string2 == null) {
                string2 = "???";
            }
            string = stringBuilder.append((Object)string2).append("#").append(element.identity()).toString();
        } else {
            string = "?????";
        }
        String elementOrder = string;
        return kindOrder + "_" + elementOrder;
    }

    private ScriptingHelper() {
    }

    public /* synthetic */ ScriptingHelper(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/scripting/ScriptingHelper$Companion;", "", "()V", "get", "Lcom/intellij/database/scripting/ScriptingHelper;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        public final ScriptingHelper get(@NotNull Rdbms rdbms) {
            Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
            Rdbms rdbms2 = rdbms;
            return Intrinsics.areEqual((Object)rdbms2, (Object)Oracle.RDBMS) ? (ScriptingHelper)OraScriptingHelper.INSTANCE : (Intrinsics.areEqual((Object)rdbms2, (Object)Mssql.RDBMS) ? (ScriptingHelper)MsScriptingHelper.INSTANCE : (Intrinsics.areEqual((Object)rdbms2, (Object)Sybase.RDBMS) ? (ScriptingHelper)SybaseScriptingHelper.INSTANCE : (Intrinsics.areEqual((Object)rdbms2, (Object)Postgres.RDBMS) ? (ScriptingHelper)PostgresScriptingHelper.INSTANCE : (Intrinsics.areEqual((Object)rdbms2, (Object)Redshift.RDBMS) ? (ScriptingHelper)RedshiftScriptingHelper.INSTANCE : (Intrinsics.areEqual((Object)rdbms2, (Object)Mysql.RDBMS) ? (ScriptingHelper)MysqlScriptingHelper.INSTANCE : (Intrinsics.areEqual((Object)rdbms2, (Object)Sqlite.RDBMS) ? (ScriptingHelper)SqliteScriptingHelper.INSTANCE : (Intrinsics.areEqual((Object)rdbms2, (Object)H2db.RDBMS) ? (ScriptingHelper)H2ScriptingHelper.INSTANCE : (Intrinsics.areEqual((Object)rdbms2, (Object)Exasol.RDBMS) ? (ScriptingHelper)ExasolScriptingHelper.INSTANCE : (ScriptingHelper)GenericScriptingHelper.INSTANCE))))))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

