/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.database.settings.ExtraParametersProvider;
import com.intellij.database.settings.UserPatterns;
import com.intellij.database.util.TokenPatternCache;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DatabaseSettings", storages={@Storage(value="databaseSettings.xml")})
public class DatabaseSettings
implements PersistentStateComponent<DatabaseSettings> {
    private static final int CURRENT_VERSION = 3;
    static final String STATE_NAME = "databaseSettings";
    static final int EXEC_COUNT = 3;
    public static final int EXECUTE_INSIDE_SHOW_CHOOSER = 1;
    public static final int EXECUTE_INSIDE_SMALLEST = 2;
    public static final int EXECUTE_INSIDE_LARGEST = 3;
    public static final int EXECUTE_INSIDE_BATCH = 4;
    public static final int EXECUTE_INSIDE_WHOLE_SCRIPT = 5;
    public static final int EXECUTE_INSIDE_SCRIPT_TAIL = 6;
    public static final int EXECUTE_OUTSIDE_NOTHING = 1;
    public static final int EXECUTE_OUTSIDE_WHOLE_SCRIPT = 2;
    public static final int EXECUTE_OUTSIDE_SCRIPT_TAIL = 3;
    public static final int EXECUTE_SELECTION_EXACTLY_ONE = 1;
    public static final int EXECUTE_SELECTION_EXACTLY_SCRIPT = 2;
    public static final int EXECUTE_SELECTION_SMART_EXPAND = 3;
    public static final CsvFormat TSV_FORMAT = DatabaseSettings.xsvFormat("Tab-separated (TSV)", "\t");
    public static final CsvFormat CSV_FORMAT = DatabaseSettings.xsvFormat("Comma-separated (CSV)", ",");
    public static final List<CsvFormat> DEFAULT_CSV_FORMATS = ContainerUtil.immutableList((Object[])new CsvFormat[]{TSV_FORMAT, CSV_FORMAT});
    public static final Topic<Listener> TOPIC = Topic.create((String)"Database settings", Listener.class);
    @Attribute(value="version")
    @Property(alwaysWrite=true)
    private int version = 0;
    @OptionTag(value="submit-immediately")
    public boolean submitImmediately = false;
    @OptionTag(value="page-size")
    public int pageSize = 500;
    @Deprecated
    @OptionTag(value="reuse-result-tab")
    public boolean reuseResultTab = true;
    @OptionTag(value="always-review-parameters")
    public boolean alwaysReviewParameters = true;
    @Deprecated
    @OptionTag(value="execute-inside-option")
    public int executeInsideOption = 1;
    @Deprecated
    @OptionTag(value="execute-outside-option")
    public int executeOutsideOption = 1;
    @Deprecated
    @OptionTag(value="execute-selection-option")
    public int executeSelectionOption = 2;
    @OptionTag(value="load-slow-documentation")
    public boolean loadSlowDocumentation = true;
    @OptionTag(value="preview-rows")
    public int previewRows = 10;
    @OptionTag(value="filters-history-size")
    public int filtersHistorySize = 10;
    @OptionTag(value="prefetch-size")
    public int prefetchSize = 100;
    @OptionTag(value="lob-length")
    public int lobLength = 204800;
    @OptionTag(value="error-in-editor")
    public boolean showErrorInEditor = true;
    @OptionTag(value="navigate-to-ddl")
    public boolean navigateToDdl = true;
    @Deprecated
    @OptionTag(value="auto-introspect-on-creation")
    public boolean trackNamespaces = true;
    @OptionTag(value="ddl-editor-confirm-loss")
    public boolean ddlConfirmLoss = true;
    @XCollection(propertyElementName="exec-options", elementName="exec-option", elementTypes={ExecOption.class})
    public List<ExecOption> execOptions = ContainerUtil.newArrayList((Iterable)JBIterable.of((Object)"").repeat(3).map(o -> new ExecOption()));
    @Property(surroundWithTag=false)
    public UserPatterns userPatterns = new UserPatterns();
    @XCollection(propertyElementName="csv-formats", elementName="format", elementTypes={PersistentCsvFormat.class})
    public List<PersistentCsvFormat> csvFormats = ContainerUtil.newArrayList();
    @Transient
    public final TokenPatternCache patternCache = new TokenPatternCache(this);

    private static CsvFormat xsvFormat(@NotNull String name, @NotNull String valueSeparator) {
        if (name == null) {
            DatabaseSettings.$$$reportNull$$$0(0);
        }
        if (valueSeparator == null) {
            DatabaseSettings.$$$reportNull$$$0(1);
        }
        ImmutableList quotes = ContainerUtil.immutableList((Object[])new CsvRecordFormat.Quotes[]{new CsvRecordFormat.Quotes("\"", "\"", "\"\"", "\"\""), new CsvRecordFormat.Quotes("'", "'", "''", "''")});
        CsvRecordFormat.QuotationPolicy quotationPolicy = CsvRecordFormat.QuotationPolicy.AS_NEEDED;
        CsvRecordFormat dataFormat = new CsvRecordFormat("", "", "", (List<CsvRecordFormat.Quotes>)quotes, quotationPolicy, valueSeparator, "\n", false);
        return new CsvFormat(name, dataFormat, null, name + "_id", false);
    }

    @NotNull
    public static ExecOption getDefaultExecOption() {
        ExecOption execOption = DatabaseSettings.getSettings().execOptions.get(0);
        if (execOption == null) {
            DatabaseSettings.$$$reportNull$$$0(2);
        }
        return execOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseSettings getSettings() {
        DatabaseSettings settings = (DatabaseSettings)ServiceManager.getService(DatabaseSettings.class);
        if (settings != null && settings.version == 0) {
            DatabaseSettings databaseSettings = settings;
            synchronized (databaseSettings) {
                settings.ensureDefaultsSet();
            }
        }
        return settings;
    }

    public static void fireSettingsChanged() {
        DatabaseSettings.getSettings().patternCache.clear();
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).settingsChanged();
    }

    public static DatabaseSettings create() {
        DatabaseSettings settings = new DatabaseSettings();
        settings.ensureDefaultsSet();
        return settings;
    }

    private DatabaseSettings() {
    }

    public void initTestDefaults() {
        LinkedHashSet predef = ContainerUtil.newLinkedHashSet();
        predef.addAll(UserPatterns.getPredefined());
        ContainerUtil.addAll((Collection)predef, (Object[])new ExtraParametersProvider().getPatterns());
        this.getUserPatterns().patterns = ContainerUtil.newArrayList((Iterable)predef);
        this.patternCache.clear();
    }

    @Nullable
    public DatabaseSettings getState() {
        ExecOption o = this.execOptions.get(0);
        this.reuseResultTab = !o.newTab;
        this.executeInsideOption = o.execInside;
        this.executeOutsideOption = o.execOutside;
        this.executeSelectionOption = o.execSelection;
        return this;
    }

    public void loadState(@NotNull DatabaseSettings state) {
        if (state == null) {
            DatabaseSettings.$$$reportNull$$$0(3);
        }
        List<ExecOption> execOptionsPrev = this.execOptions;
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (this.execOptions.size() != 3) {
            JBIterable required = JBIterable.from(this.execOptions).append(execOptionsPrev).take(3);
            this.execOptions = ContainerUtil.newArrayList((Iterable)required);
        }
        ExecOption o = this.execOptions.get(0);
        o.newTab = !this.reuseResultTab;
        o.execInside = this.executeInsideOption;
        o.execOutside = this.executeOutsideOption;
        o.execSelection = this.executeSelectionOption;
        this.ensureDefaultsSet();
    }

    public boolean isSubmitImmediately() {
        return this.submitImmediately;
    }

    public void setSubmitImmediately(boolean submitImmediately) {
        this.submitImmediately = submitImmediately;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPreviewRows() {
        return this.previewRows;
    }

    public void setPreviewRows(int rows) {
        this.previewRows = rows;
    }

    public int getFiltersHistorySize() {
        return this.filtersHistorySize;
    }

    public void setFiltersHistorySize(int filtersHistorySize) {
        this.filtersHistorySize = filtersHistorySize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getMaxLobLength() {
        return this.lobLength;
    }

    public void setMaxLobLength(int lobLength) {
        this.lobLength = lobLength;
    }

    public boolean isShowErrorInEditor() {
        return this.showErrorInEditor;
    }

    public void setShowErrorInEditor(boolean show) {
        this.showErrorInEditor = show;
    }

    public UserPatterns getUserPatterns() {
        return this.userPatterns;
    }

    @NotNull
    public List<CsvFormat> getCsvFormats() {
        List<CsvFormat> formats = DatabaseSettings.getImmutableFormats(this.csvFormats);
        List<CsvFormat> list = formats.isEmpty() ? DEFAULT_CSV_FORMATS : formats;
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setCsvFormats(@NotNull List<CsvFormat> formats) {
        if (formats == null) {
            DatabaseSettings.$$$reportNull$$$0(5);
        }
        this.csvFormats = ContainerUtil.map(formats, PersistentCsvFormat::new);
    }

    private void ensureDefaultsSet() {
        this.userPatterns.migrate(this.version);
        if (DatabaseSettings.getImmutableFormats(this.csvFormats).isEmpty()) {
            this.setCsvFormats(DEFAULT_CSV_FORMATS);
        } else if (this.version < 2) {
            int idx = 0;
            for (PersistentCsvFormat format : this.csvFormats) {
                if (ContainerUtil.exists(DEFAULT_CSV_FORMATS, f -> StringUtil.equals((CharSequence)format.id, (CharSequence)f.id))) continue;
                CsvFormat similar = (CsvFormat)ContainerUtil.find(DEFAULT_CSV_FORMATS, f -> DatabaseSettings.formatsSimilar(f, format));
                if (similar == null || ContainerUtil.exists(this.csvFormats, f -> StringUtil.equals((CharSequence)f.id, (CharSequence)similar.id))) {
                    format.id = String.valueOf(idx++);
                    continue;
                }
                format.id = similar.id;
            }
        }
        this.version = 3;
    }

    private static boolean formatsSimilar(@NotNull CsvFormat format, @NotNull PersistentCsvFormat f) {
        if (format == null) {
            DatabaseSettings.$$$reportNull$$$0(6);
        }
        if (f == null) {
            DatabaseSettings.$$$reportNull$$$0(7);
        }
        if (StringUtil.equals((CharSequence)f.name, (CharSequence)format.name)) {
            return true;
        }
        CsvFormat immutable = f.immutable();
        return immutable != null && immutable.rowNumbers == format.rowNumbers && Comparing.equal((Object)immutable.headerRecord, (Object)format.headerRecord) && Comparing.equal((Object)immutable.dataRecord, (Object)format.dataRecord);
    }

    @NotNull
    private static List<CsvFormat> getImmutableFormats(@NotNull List<PersistentCsvFormat> persistentFormats) {
        if (persistentFormats == null) {
            DatabaseSettings.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.mapNotNull(persistentFormats, format -> format == null ? null : format.immutable());
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSeparator";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/DatabaseSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentFormats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/DatabaseSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExecOption";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCsvFormats";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableFormats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "xsvFormat";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCsvFormats";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatsSimilar";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImmutableFormats";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="xsv-extractor")
    public static class XsvState
    extends StdState {
        @OptionTag(value="opening-quote")
        public String openingQuote = "\"";
        @OptionTag(value="closing-quote")
        public String closingQuote = "\"";
        @OptionTag(value="line-separator")
        public String lineSeparator = "\\n";
        @OptionTag(value="value-separator")
        public String valueSeparator = ",";
        @OptionTag(value="line-prefix")
        public String linePrefix = "";
        @OptionTag(value="line-suffix")
        public String lineSuffix = "";
        @OptionTag(value="always-quote")
        public boolean alwaysQuote = false;

        public XsvState() {
            this.type = "xsv";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XsvState state = (XsvState)o;
            if (this.alwaysQuote != state.alwaysQuote) {
                return false;
            }
            if (!this.closingQuote.equals(state.closingQuote)) {
                return false;
            }
            if (!this.linePrefix.equals(state.linePrefix)) {
                return false;
            }
            if (!this.lineSeparator.equals(state.lineSeparator)) {
                return false;
            }
            if (!this.lineSuffix.equals(state.lineSuffix)) {
                return false;
            }
            if (!this.openingQuote.equals(state.openingQuote)) {
                return false;
            }
            return this.valueSeparator.equals(state.valueSeparator);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.openingQuote.hashCode();
            result2 = 31 * result2 + this.closingQuote.hashCode();
            result2 = 31 * result2 + this.lineSeparator.hashCode();
            result2 = 31 * result2 + this.valueSeparator.hashCode();
            result2 = 31 * result2 + this.linePrefix.hashCode();
            result2 = 31 * result2 + this.lineSuffix.hashCode();
            result2 = 31 * result2 + (this.alwaysQuote ? 1 : 0);
            return result2;
        }
    }

    @Tag(value="std-extractor")
    public static class StdState
    extends BaseState {
        @OptionTag(value="row-numbers")
        public boolean rowNumber;
        @OptionTag(value="column-names")
        public boolean columnNames;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StdState state = (StdState)o;
            if (this.columnNames != state.columnNames) {
                return false;
            }
            return this.rowNumber == state.rowNumber;
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.rowNumber ? 1 : 0);
            result2 = 31 * result2 + (this.columnNames ? 1 : 0);
            return result2;
        }
    }

    @Tag(value="extractor")
    public static class BaseState
    implements Cloneable {
        @Attribute(value="type")
        public String type = "";
        @Attribute(value="name")
        public String name = "";

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseState state = (BaseState)o;
            if (!this.name.equals(state.name)) {
                return false;
            }
            return this.type.equals(state.type);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = 31 * result2 + this.type.hashCode();
            return result2;
        }

        public BaseState clone() {
            try {
                return (BaseState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    @Tag(value="exec-option")
    public static class ExecOption {
        @Attribute(value="new-tab")
        public boolean newTab;
        @Attribute(value="exec-inside")
        public int execInside = 1;
        @Attribute(value="exec-outside")
        public int execOutside = 1;
        @Attribute(value="exec-selection")
        public int execSelection = 2;

        @NotNull
        public ExecOption copyFrom(@NotNull ExecOption o) {
            if (o == null) {
                ExecOption.$$$reportNull$$$0(0);
            }
            this.newTab = o.newTab;
            this.execInside = o.execInside;
            this.execOutside = o.execOutside;
            this.execSelection = o.execSelection;
            ExecOption execOption = this;
            if (execOption == null) {
                ExecOption.$$$reportNull$$$0(1);
            }
            return execOption;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecOption option = (ExecOption)o;
            if (this.newTab != option.newTab) {
                return false;
            }
            if (this.execInside != option.execInside) {
                return false;
            }
            if (this.execOutside != option.execOutside) {
                return false;
            }
            return this.execSelection == option.execSelection;
        }

        public int hashCode() {
            int result2 = this.newTab ? 1 : 0;
            result2 = 31 * result2 + this.execInside;
            result2 = 31 * result2 + this.execOutside;
            result2 = 31 * result2 + this.execSelection;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/settings/DatabaseSettings$ExecOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/settings/DatabaseSettings$ExecOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyFrom";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "copyFrom";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener {
        public void settingsChanged();
    }
}

