/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import com.intellij.util.containers.JBIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseVirtualFileSystem
extends DummyCachingFileSystem<VirtualFile> {
    private static final String PROTOCOL = "das";
    private static final String SRC_PREFIX = "src:";
    private static final String PROTOCOL_SEPARATOR = ":/";

    public static DatabaseVirtualFileSystem getDatabaseFileSystem() {
        return (DatabaseVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DatabaseVirtualFileSystem() {
        super(PROTOCOL);
    }

    public void onProjectOpened(Project project) {
        super.onProjectOpened(project);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().invokeLater(() -> DatabaseEditorHelper.installEditorFactoryListener(project), project.getDisposed()));
        project.getMessageBus().connect((Disposable)project).subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                Application app = ApplicationManager.getApplication();
                app.invokeLater(() -> DatabaseVirtualFileSystem.this.clearInvalidFiles(), app.getDisposed());
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null || dataSource.isInBatch()) {
                    return;
                }
                Application app = ApplicationManager.getApplication();
                app.invokeLater(() -> DatabaseVirtualFileSystem.this.updateReadonlyFlag(dataSource), app.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/vfs/DatabaseVirtualFileSystem$1", "dataSourceRemoved"));
            }
        });
    }

    protected String getPresentableUrl(@NotNull VirtualFile file) {
        if (file == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(0);
        }
        if (file instanceof VirtualFilePathWrapper) {
            return ((VirtualFilePathWrapper)file).getPresentablePath();
        }
        return super.getPresentableUrl(file);
    }

    protected VirtualFile findFileByPathInner(@NotNull String path) {
        int separatorIdx;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(1);
        }
        if ((separatorIdx = path.indexOf(PROTOCOL_SEPARATOR)) != -1) {
            return this.migrateOldPath(path, separatorIdx);
        }
        return DatabaseVirtualFileSystem.findFileByNewPath(path);
    }

    private VirtualFile migrateOldPath(@NotNull String path, int separatorIdx) {
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(2);
        }
        int separatorEnd = separatorIdx + PROTOCOL_SEPARATOR.length();
        boolean source = path.startsWith(SRC_PREFIX);
        int elementTypeStart = source ? SRC_PREFIX.length() : 0;
        int projectIdEnd = path.indexOf(47, separatorEnd);
        String projectId = path.substring(separatorEnd, projectIdEnd);
        int dataSourceEnd = path.indexOf(47, projectIdEnd + 1);
        if (dataSourceEnd == -1) {
            return null;
        }
        int nameStart = path.lastIndexOf(47);
        if (nameStart == -1 || nameStart <= projectIdEnd) {
            return null;
        }
        String name = DatabaseVirtualFileSystem.unescapeSlash((String)path.substring(nameStart + 1));
        String dataSourceId = path.substring(projectIdEnd + 1, nameStart);
        Project project = this.getProject(projectId);
        if (project == null) {
            return null;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource == null) {
            return null;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        ObjectKind kind = dialect.getMetaModel().findKind(path.substring(elementTypeStart, separatorIdx));
        if (kind == null) {
            return null;
        }
        ObjectPath objectPath = (ObjectPath)ObjectPaths.getObjectPaths(dialect.getMetaModel(), name, kind).first();
        if (objectPath == null) {
            return null;
        }
        return this.findFileByPath(DatabaseVirtualFileSystem.getPath(dataSourceId, objectPath, source));
    }

    private static VirtualFile findFileByNewPath(@NotNull String path) {
        boolean src;
        JBIterator it;
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(3);
        }
        if (!(it = JBIterator.from(DbSrcUtils.splitPath((src = path.endsWith(".sql")) ? path.substring(0, path.length() - ".sql".length()) : path).iterator())).advance()) {
            return null;
        }
        String dataSourceId = (String)it.current();
        LocalDataSource dataSource = DbSrcUtils.findDataSource(dataSourceId);
        if (dataSource == null) {
            return null;
        }
        ObjectPath objectPath = null;
        while (it.advance()) {
            ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(DbSrcUtils.unescapeChars((String)it.current()));
            if (kind == null || !it.advance()) {
                return null;
            }
            String name = (String)it.current();
            int idStart = name.indexOf("@");
            String id = idStart == -1 ? null : DbSrcUtils.unescapeChars(name.substring(idStart + 1));
            name = DbSrcUtils.unescapeChars(id != null ? name.substring(0, idStart) : name);
            objectPath = ObjectPath.create((String)name, (ObjectKind)kind, (boolean)true, (String)id, objectPath);
        }
        if (objectPath == null) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = new DatabaseElementVirtualFileImpl(dataSourceId, objectPath, src);
        file.setWritableInner(!dataSource.isReadOnly());
        return file;
    }

    @NotNull
    static String getPath(String dataSourceId, ObjectPath path, boolean source) {
        StringBuilder builder = (StringBuilder)path.reduce((Object)new StringBuilder(dataSourceId), (b, p) -> {
            b.append("/").append(DbSrcUtils.escapeChars(p.kind.code())).append("/").append(DbSrcUtils.escapeChars(p.name));
            String id = p.getIdentity();
            if (id != null) {
                b.append("@").append(DbSrcUtils.escapeChars(id));
            }
            return b;
        });
        if (source) {
            builder.append(".sql");
        }
        String string = builder.toString();
        if (string == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        if (vFile == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException("rename not supported: " + vFile.getUrl());
    }

    private void updateReadonlyFlag(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(7);
        }
        this.clearInvalidFiles();
        boolean writable = !dataSource.isReadOnly();
        String id = dataSource.getUniqueId();
        for (VirtualFile file : this.getCachedFiles()) {
            if (!(file instanceof DatabaseElementVirtualFileImpl) || !Comparing.equal((String)id, (String)((DatabaseElementVirtualFileImpl)file).getDataSourceId()) || file.isWritable() == writable) continue;
            ((DatabaseElementVirtualFileImpl)file).setWritable(writable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseVirtualFileSystem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseVirtualFileSystem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathInner";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "migrateOldPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNewPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateReadonlyFlag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

