/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseTableColumnEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbObjectDialog;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbRefactoringDialogHelper {
    @NotNull
    public static DbTableDialog newAddTableDialog(@NotNull DatabaseEditorContext context, @Nullable DasNamespace schema, @NotNull String tabName, @NotNull Collection<String> colNames) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(0);
        }
        if (tabName == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(1);
        }
        if (colNames == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(2);
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.setTable(dialog.createTable(schema, tabName, colNames), false);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(3);
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newModifyTableDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, boolean forceCreate) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(4);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(5);
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification((DasObject)table, forceCreate);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(6);
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newModifyTableDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(7);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(8);
        }
        DbTableDialog dbTableDialog = DbRefactoringDialogHelper.newModifyTableDialog(context, table, false);
        if (dbTableDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(9);
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newAddColumnDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String colName) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(10);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(11);
        }
        if (colName == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(12);
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification(DbRefactoringDialogHelper.createColumn(dialog, table, colName), false);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(13);
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newModifyColumnDialog(@NotNull DatabaseEditorContext context, @NotNull DasColumn column2, boolean forceCreate) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(14);
        }
        if (column2 == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(15);
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification((DasObject)column2, forceCreate);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(16);
        }
        return dbTableDialog;
    }

    public static DbTableDialog newAddForeignKeyDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String fkName, @NotNull List<? extends DasColumn> columns2) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(17);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(18);
        }
        if (fkName == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(19);
        }
        if (columns2 == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(20);
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification(DbRefactoringDialogHelper.createForeignKey(dialog, table, fkName, columns2), false);
        return dialog;
    }

    @NotNull
    public static DbTableDialog newModifyForeignKeyDialog(@NotNull DatabaseEditorContext context, @NotNull DasForeignKey fk, boolean forceCreate) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(21);
        }
        if (fk == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(22);
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification((DasObject)fk, forceCreate);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(23);
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newAddIndexDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String idxName, @NotNull List<? extends DasColumn> columns2) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(24);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(25);
        }
        if (idxName == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(26);
        }
        if (columns2 == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(27);
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification(DbRefactoringDialogHelper.createIndex(dialog, table, idxName, columns2), false);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(28);
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newModifyIndexDialog(@NotNull DatabaseEditorContext context, @NotNull DasIndex index, boolean forceCreate) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(29);
        }
        if (index == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(30);
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification((DasObject)index, forceCreate);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(31);
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbObjectDialog newAddObjectDialog(@NotNull DatabaseEditorContext context, @Nullable DasNamespace parent, @NotNull String name, @NotNull ObjectKind kind) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(32);
        }
        if (name == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(33);
        }
        if (kind == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(34);
        }
        DbObjectDialog dialog = new DbObjectDialog(context, kind);
        DeObject object = dialog.createEmptyTemplate((DasObject)parent, kind);
        object.name = name;
        dialog.configureForCreation(object, false);
        DbObjectDialog dbObjectDialog = dialog;
        if (dbObjectDialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(35);
        }
        return dbObjectDialog;
    }

    @NotNull
    public static DeIndex createIndex(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String idxName, @NotNull List<? extends DasColumn> columns2) {
        if (dialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(36);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(37);
        }
        if (idxName == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(38);
        }
        if (columns2 == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(39);
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        ArrayList items = ContainerUtil.newArrayListWithCapacity((int)columns2.size());
        for (DasColumn dasColumn : columns2) {
            items.add(new DeIndex.Item((DeColumn)dialog.export((DasObject)dasColumn, false), DasIndex.Sorting.NONE));
        }
        DeIndex index = new DeIndex(idxName, tab, dialog.myModel);
        index.items.addAll(items);
        tab.indices.add(index);
        DeIndex deIndex = index;
        if (deIndex == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(40);
        }
        return deIndex;
    }

    @NotNull
    public static DeForeignKey createForeignKey(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String fkName, @NotNull List<? extends DasColumn> columns2) {
        if (dialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(41);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(42);
        }
        if (fkName == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(43);
        }
        if (columns2 == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(44);
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        ArrayList refs = ContainerUtil.newArrayListWithCapacity((int)columns2.size());
        for (DasColumn dasColumn : columns2) {
            refs.add(new DeForeignKey.Ref((DeColumn)dialog.export((DasObject)dasColumn, true), DatabaseColumnRefEditor.createStub("", tab)));
        }
        DeForeignKey fk = new DeForeignKey(fkName, tab, dialog.myModel);
        fk.refs.addAll(refs);
        tab.foreignKeys.add(fk);
        DeForeignKey deForeignKey = fk;
        if (deForeignKey == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(45);
        }
        return deForeignKey;
    }

    @NotNull
    public static DeColumn createColumn(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String colName) {
        if (dialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(46);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(47);
        }
        if (colName == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(48);
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        DeColumn column2 = new DeColumn(colName, tab, dialog.myModel);
        tab.columns.add(column2);
        DeColumn deColumn = column2;
        if (deColumn == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(49);
        }
        return deColumn;
    }

    public static void runOnceValid(final @NotNull DatabaseEditorState state, final @NotNull Runnable r) {
        if (state == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(50);
        }
        if (r == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(51);
        }
        if (state.areAllEditorsValid()) {
            r.run();
        } else {
            state.validationTopic.addListener((EventListener)new EditorModelBase.Listener(){

                @Override
                public void changed() {
                    try {
                        r.run();
                    }
                    finally {
                        state.validationTopic.removeListener((EventListener)this);
                    }
                }
            });
        }
    }

    public static void runOnceValid(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull Runnable r) {
        if (dialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(52);
        }
        if (r == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(53);
        }
        DbRefactoringDialogHelper.runOnceValid(dialog.getState(), r);
    }

    public static DbTableDialog bootstrap(@NotNull DbTableDialog dialog, @NotNull Computable<DeObject> comp) {
        if (dialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(54);
        }
        if (comp == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(55);
        }
        DbRefactoringDialogHelper.runOnceValid(dialog, () -> {
            if (comp == null) {
                DbRefactoringDialogHelper.$$$reportNull$$$0(72);
            }
            if (dialog == null) {
                DbRefactoringDialogHelper.$$$reportNull$$$0(73);
            }
            DeObject toModify = (DeObject)comp.compute();
            DbRefactoringDialogHelper.runOnceValid(dialog, () -> {
                if (dialog == null) {
                    DbRefactoringDialogHelper.$$$reportNull$$$0(74);
                }
                dialog.startItemEditing(toModify);
            });
        });
        return dialog;
    }

    public static <T extends DeObject> JBIterable<T> export(@NotNull DbTableDialog dialog, @NotNull Iterable<? extends DasObject> objects) {
        if (dialog == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(56);
        }
        if (objects == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(57);
        }
        return JBIterable.from(objects).transform(object -> {
            if (dialog == null) {
                DbRefactoringDialogHelper.$$$reportNull$$$0(71);
            }
            return dialog.export((DasObject)object, true);
        });
    }

    public static boolean canAddIndex(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(58);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(59);
        }
        DatabaseDialectEx dialect = context.getDialect();
        return table.getKind() == ObjectKind.TABLE && dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(false).canDoAnything();
    }

    public static boolean canModifyIndex(@NotNull DatabaseEditorContext context, @NotNull DasIndex index) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(60);
        }
        if (index == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(61);
        }
        DatabaseDialectEx dialect = context.getDialect();
        return dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(true).canDoAnything();
    }

    public static boolean canAddForeignKey(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(62);
        }
        if (table == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(63);
        }
        DatabaseDialectEx dialect = context.getDialect();
        return table.getKind() == ObjectKind.TABLE && dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getForeignKeyCaps(false).canDoAnything();
    }

    public static boolean canModifyForeignKey(@NotNull DatabaseEditorContext context, @NotNull DasForeignKey fk) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(64);
        }
        if (fk == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(65);
        }
        DatabaseDialectEx dialect = context.getDialect();
        return dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getForeignKeyCaps(true).canDoAnything();
    }

    public static boolean canModifyColumn(@NotNull DatabaseEditorContext context, @NotNull DasColumn columnElement) {
        if (context == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(66);
        }
        if (columnElement == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(67);
        }
        DatabaseDialectEx dialect = context.getDialect();
        return DbRefactoringDialogHelper.getColumnCaps(dialect, columnElement).canDoAnything();
    }

    @NotNull
    public static DatabaseEditorCapabilities.TableColumnEditorCaps getColumnCaps(@NotNull DatabaseDialectEx dialect, @NotNull DasColumn column2) {
        if (dialect == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(68);
        }
        if (column2 == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(69);
        }
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = DatabaseTableColumnEditor.getTableColumnCaps(dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true), column2.getTable(), column2);
        if (tableColumnEditorCaps == null) {
            DbRefactoringDialogHelper.$$$reportNull$$$0(70);
        }
        return tableColumnEditorCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 23: 
            case 28: 
            case 31: 
            case 35: 
            case 40: 
            case 45: 
            case 49: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 23: 
            case 28: 
            case 31: 
            case 35: 
            case 40: 
            case 45: 
            case 49: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colNames";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 23: 
            case 28: 
            case 31: 
            case 35: 
            case 40: 
            case 45: 
            case 49: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbRefactoringDialogHelper";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 18: 
            case 25: 
            case 37: 
            case 42: 
            case 47: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 12: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colName";
                break;
            }
            case 15: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 19: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkName";
                break;
            }
            case 20: 
            case 27: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 22: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fk";
                break;
            }
            case 26: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idxName";
                break;
            }
            case 30: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 36: 
            case 41: 
            case 46: 
            case 52: 
            case 54: 
            case 56: 
            case 71: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 55: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnElement";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbRefactoringDialogHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newAddTableDialog";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newModifyTableDialog";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newAddColumnDialog";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newModifyColumnDialog";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newModifyForeignKeyDialog";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "newAddIndexDialog";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "newModifyIndexDialog";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "newAddObjectDialog";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndex";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createForeignKey";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumn";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newAddTableDialog";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 23: 
            case 28: 
            case 31: 
            case 35: 
            case 40: 
            case 45: 
            case 49: 
            case 70: {
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newModifyTableDialog";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newAddColumnDialog";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newModifyColumnDialog";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newAddForeignKeyDialog";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newModifyForeignKeyDialog";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "newAddIndexDialog";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "newModifyIndexDialog";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "newAddObjectDialog";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createForeignKey";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createColumn";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "runOnceValid";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "bootstrap";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "canAddIndex";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "canModifyIndex";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "canAddForeignKey";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "canModifyForeignKey";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "canModifyColumn";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getColumnCaps";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$export$2";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "lambda$bootstrap$1";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 23: 
            case 28: 
            case 31: 
            case 35: 
            case 40: 
            case 45: 
            case 49: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

