/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.scripting.SqlModelBuilderUtils;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.database.SqlTxModelWrapper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilder {
    private final Project myProject;
    private final BasicModModel myModel;
    private final SqlObjectBuilder myObjectBuilder;
    private final Map<DasObject, BasicElement> mySources;
    private Map<BasicElement, SmartPsiElementPointer<SqlElement>> myMapping;
    private SqlTxModelWrapper myStagingModel;
    private SqlFileProcessor myProcessor;
    private boolean myApplied;

    public SqlModelBuilder(@NotNull Project project, @NotNull SqlObjectBuilder objectBuilder, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(0);
        }
        if (objectBuilder == null) {
            SqlModelBuilder.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(2);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(3);
        }
        this.mySources = ContainerUtil.newHashMap();
        this.myApplied = false;
        this.myProject = project;
        this.myModel = model;
        this.myMapping = mapping;
        this.myObjectBuilder = objectBuilder;
    }

    public SqlModelBuilder(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(4);
        }
        if (language == null) {
            SqlModelBuilder.$$$reportNull$$$0(5);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(6);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(7);
        }
        this(project, (SqlObjectBuilder)SqlLanguageObjectBuilder.INSTANCE.forLanguage((Language)language), model, mapping);
    }

    public void begin(boolean saveSources) {
        this.myStagingModel = new SqlTxModelWrapper(this.myModel, this.mySources, saveSources);
        this.myProcessor = new SqlFileProcessor(this.myProject, this.myStagingModel, this.myObjectBuilder);
        this.myApplied = false;
    }

    public int introspect(@NotNull List<SqlFile> files, int start, boolean clear2, long syncTimeout) {
        if (files == null) {
            SqlModelBuilder.$$$reportNull$$$0(8);
        }
        if (this.mySources.isEmpty() && !this.myMapping.isEmpty()) {
            for (Map.Entry<BasicElement, SmartPsiElementPointer<SqlElement>> entry : this.myMapping.entrySet()) {
                DasObject object = (DasObject)ObjectUtils.tryCast((Object)entry.getValue().getElement(), DasObject.class);
                if (object == null) continue;
                this.mySources.put(object, entry.getKey());
            }
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        long time = System.currentTimeMillis();
        for (int i2 = start; i2 < files.size(); ++i2) {
            SqlFile file = files.get(i2);
            if (indicator != null) {
                indicator.setFraction(((double)i2 + 0.0) / (double)files.size());
                indicator.setText2(file.getName());
            }
            this.myStagingModel.modify(() -> this.myProcessor.process(file));
            long cur = System.currentTimeMillis();
            if ((syncTimeout == -1L || cur - time <= syncTimeout) && i2 + 1 != files.size()) continue;
            this.myMapping = this.apply(this.myProcessor, clear2);
            this.myApplied = true;
            return i2 + 1;
        }
        return files.size();
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> getMapping() {
        Map<BasicElement, SmartPsiElementPointer<SqlElement>> map = this.myMapping;
        if (map == null) {
            SqlModelBuilder.$$$reportNull$$$0(9);
        }
        return map;
    }

    public void end() {
        if (this.myApplied) {
            this.myModel.modify(BasicModRoot.class, r -> this.finish());
        }
        this.myStagingModel = null;
        this.myProcessor = null;
        this.myApplied = false;
        this.mySources.clear();
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> apply(SqlFileProcessor processor, boolean clear2) {
        final Map<BasicElement, SmartPsiElementPointer<SqlElement>> tmp = processor.reverseMap();
        this.myModel.modify(BasicModRoot.class, r -> {
            if (clear2) {
                this.prepare();
            }
            processor.apply();
        });
        final HashMap result2 = ContainerUtil.newHashMap(this.myMapping);
        new SqlTxModelWrapper.TwoModelVisitor(){

            @Override
            public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
                if (guide == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (guided == null) {
                    1.$$$reportNull$$$0(1);
                }
                ContainerUtil.putIfNotNull((Object)guide, tmp.get(guided), (Map)result2);
                super.visit(guide, guided);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guide";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guided";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/database/SqlModelBuilder$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(this.myModel.getRoot(), processor.getRoot());
        HashMap hashMap = result2;
        if (hashMap == null) {
            SqlModelBuilder.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    public void prepare() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : element.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        }
    }

    public void finish() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : element.getFamilies()) {
                modFamily.removeSyncPendingChildren();
                modFamily.sort();
            }
        }
        this.finalizeObjects();
    }

    public void finalizeObjects() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            this.myObjectBuilder.finalize((DasObject)element);
        }
    }

    public static boolean isIgnored(DatabaseFamilyId familyId, ObjectKind p, ObjectKind c) {
        if (c == SqlDbElementType.ANY) {
            return true;
        }
        if (p == ObjectKind.SCHEMA && c == SqlDbElementType.ROLE) {
            return true;
        }
        if (familyId.isOracle()) {
            if (p == ObjectKind.BODY) {
                return true;
            }
            if (p == ObjectKind.PACKAGE) {
                return c != ObjectKind.ROUTINE;
            }
            if (p == ObjectKind.SCHEMA) {
                return c == ObjectKind.OPERATOR || "exception".equals(c.name()) || "library".equals(c.name()) || "INDEX TYPE".equals(c.name());
            }
        }
        if (p == SqlDbElementType.DOMAIN) {
            return c == SqlDbElementType.CONSTRAINT;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectBuilder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "introspect";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlFileProcessor {
        private final Project myProject;
        private final Map<ObjectPath, BasicModElement> myObjects;
        private final Set<DasObject> myProcessed;
        private final Set<DasObject> myDelayed;
        private final SqlTxModelWrapper myModel;
        @NotNull
        private final SqlObjectBuilder myObjectBuilder;
        private final DatabaseFamilyId myFamilyId;
        private final Map<DasObject, PsiElement> myOraPackageRestarter;

        public SqlFileProcessor(@NotNull Project project, @NotNull SqlTxModelWrapper model, @NotNull SqlObjectBuilder objectBuilder) {
            if (project == null) {
                SqlFileProcessor.$$$reportNull$$$0(0);
            }
            if (model == null) {
                SqlFileProcessor.$$$reportNull$$$0(1);
            }
            if (objectBuilder == null) {
                SqlFileProcessor.$$$reportNull$$$0(2);
            }
            this.myObjects = ContainerUtil.newHashMap();
            this.myProcessed = ContainerUtil.newHashSet();
            this.myDelayed = ContainerUtil.newLinkedHashSet();
            this.myOraPackageRestarter = ContainerUtil.newHashMap();
            this.myProject = project;
            this.myModel = model;
            this.myObjectBuilder = objectBuilder;
            this.myFamilyId = (DatabaseFamilyId)ObjectUtils.chooseNotNull((Object)GenericIntrospectorLegacyModelUtils.findFamily(this.myModel.getRdbms()), (Object)DatabaseFamilyId.UNKNOWN);
        }

        public void processDelayed() {
            while (!this.myDelayed.isEmpty()) {
                Iterator<DasObject> it = this.myDelayed.iterator();
                DasObject d = it.next();
                it.remove();
                d.getDasChildren(null).forEach(o -> this.process((DasObject)o));
            }
        }

        public void process(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(3);
            }
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            for (DasObject obj : file.traverser().preOrderDfsTraversal()) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                this.process(obj);
            }
            for (SqlCommentStatementImpl stmt : SqlImplUtil.sqlElements((PsiElement)file).filter(SqlCommentStatementImpl.class)) {
                IElementType type = stmt.getElementType();
                if (type != SqlCompositeElementTypes.SQL_COMMENT_STATEMENT) continue;
                this.processCommentStmt(stmt);
            }
            this.processDelayed();
        }

        private void processCommentStmt(@NotNull SqlCommentStatementImpl stmt) {
            if (stmt == null) {
                SqlFileProcessor.$$$reportNull$$$0(4);
            }
            SqlReferenceExpression tgt = stmt.getAlterTargetReference();
            for (SqlClause clause : SqlImplUtil.sqlChildren((PsiElement)stmt).filter(SqlClause.class)) {
                DasObject target;
                BasicModNamedElement processed;
                SqlExpression comment;
                SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)clause, SqlReferenceExpression.class);
                SqlExpression sqlExpression = comment = ref == null ? (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)clause, SqlExpression.class) : (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)ref, SqlExpression.class);
                if (ref == null) {
                    ref = tgt;
                }
                if (ref == null || comment == null || (processed = (target = (DasObject)ObjectUtils.tryCast((Object)ref.resolve(), DasObject.class)) == null ? null : (BasicModNamedElement)ObjectUtils.tryCast((Object)this.process(target), BasicModNamedElement.class)) == null) continue;
                String text = comment instanceof SqlStringLiteralExpressionImpl ? ((SqlStringLiteralExpressionImpl)comment).getValue() : null;
                processed.setComment(text);
            }
        }

        @Nullable
        private BasicModElement process(@NotNull DasObject obj) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(5);
            }
            if (obj instanceof SqlRenameToClause || obj instanceof PsiElement && !(obj instanceof FakePsiElement) && !(obj instanceof SqlStubbedElement)) {
                return null;
            }
            ObjectPath path = ObjectPaths.of(obj);
            if (this.myProcessed.contains(obj)) {
                return this.myModel.nullize(this.myObjects.get(path));
            }
            BasicModElement parent = this.getParent(obj);
            return this.processSingle(obj, path, parent);
        }

        @Nullable
        private BasicModElement processSingle(@NotNull DasObject obj, @NotNull ObjectPath path, @Nullable BasicModElement parent) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(6);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(7);
            }
            ObjectKind kind = this.myModel.getMetaModel().unaliased(obj.getKind());
            if (this.myModel.getMetaModel().findKind(kind.code()) == null) {
                return null;
            }
            this.processOddities(obj, parent, kind);
            BasicModElement target = this.myModel.createOrGet(obj, parent, path);
            this.markObjectReady(path, obj, target);
            if (target == null) {
                ObjectKind parentKind;
                boolean ignored = false;
                ObjectPath p = path;
                while (p.parent != null && !ignored) {
                    if (SqlModelBuilder.isIgnored(this.myFamilyId, p.parent.kind, p.kind)) {
                        ignored = true;
                    }
                    p = p.parent;
                }
                ObjectKind objectKind = parentKind = parent == null ? ObjectKind.NONE : parent.getKind();
                if (!ignored && !SqlModelBuilder.isIgnored(this.myFamilyId, parentKind, obj.getKind())) {
                    SqlModelBuilderUtils.hardWarning("No family " + kind.code() + " in " + parentKind.code());
                }
            } else {
                if (!SqlFileProcessor.isAppendable(target)) {
                    target.getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
                }
                this.processRequiredChildren(obj, target);
                this.myObjectBuilder.build((DasObject)target, obj);
            }
            return target;
        }

        private static boolean isAppendable(BasicModElement target) {
            return target instanceof DasNamespace || target.getKind() == ObjectKind.PACKAGE;
        }

        private void processRequiredChildren(@NotNull DasObject obj, @NotNull BasicModElement target) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(8);
            }
            if (target == null) {
                SqlFileProcessor.$$$reportNull$$$0(9);
            }
            if (target instanceof BasicTable) {
                for (DasObject column2 : obj.getDasChildren(ObjectKind.COLUMN)) {
                    this.processSingle(column2, ObjectPaths.of(column2), target);
                }
            }
            if (target instanceof BasicModRoutine) {
                for (DasObject argument : obj.getDasChildren(ObjectKind.ARGUMENT)) {
                    this.processSingle(argument, ObjectPaths.of(argument), target);
                }
            }
        }

        private void markObjectReady(ObjectPath path, @NotNull DasObject obj, @Nullable BasicModElement target) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(10);
            }
            this.myObjects.put(path, this.myModel.notNullize(target));
            this.myProcessed.add(obj);
        }

        private void processOddities(@NotNull DasObject obj, @Nullable BasicModElement parent, @NotNull ObjectKind kind) {
            PsiElement element;
            PsiObject pkg;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(11);
            }
            if (kind == null) {
                SqlFileProcessor.$$$reportNull$$$0(12);
            }
            if (this.myFamilyId.isOracle() && parent != null && parent.getKind() == ObjectKind.PACKAGE && kind != ObjectKind.BODY && (pkg = (PsiObject)JBIterable.generate((Object)ObjectUtils.tryCast((Object)obj, PsiElement.class), x -> x.getContext()).filter(PsiObject.class).skip(1).first()) != null && pkg.getKind() == ObjectKind.PACKAGE && ((element = this.myOraPackageRestarter.get(parent)) == null || element != pkg)) {
                this.myOraPackageRestarter.put(parent, (PsiElement)pkg);
                JBIterable.from(parent.getFamilyKinds()).filter(x -> x != ObjectKind.BODY).transform(parent::familyOf).forEach(ModFamily::markChildrenAsSyncPending);
            }
        }

        @Nullable
        private BasicModElement getParent(@NotNull DasObject obj) {
            ObjectKind kind;
            DasObject parent;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(13);
            }
            if ((parent = obj.getDasParent()) != null && !this.isValidParent(parent, obj)) {
                parent = null;
            }
            ObjectKind objectKind = kind = parent == null ? ObjectKind.NONE : parent.getKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.ROOT) {
                return this.myModel.getEmptyParent(obj.getKind());
            }
            ObjectPath parentPath = ObjectPaths.of(parent);
            BasicModElement element = this.myObjects.get(parentPath);
            if (element != null) {
                return this.myModel.nullize(element);
            }
            if (!(parent instanceof DasNamespace)) {
                this.myDelayed.add(parent);
            }
            return this.process(parent);
        }

        private boolean isValidParent(DasObject parent, @NotNull DasObject obj) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(14);
            }
            boolean ok = false;
            ObjectKind pk = parent.getKind();
            if (pk == ObjectKind.NONE) {
                pk = ObjectKind.ROOT;
            }
            ObjectKind ck = obj.getKind();
            for (Couple couple : this.myModel.getDialect().getMetaModel().getKindCouples()) {
                if (couple.first != pk || couple.second != ck) continue;
                ok = true;
                break;
            }
            return ok;
        }

        @NotNull
        public Map<BasicElement, SmartPsiElementPointer<SqlElement>> reverseMap() {
            HashMap res = ContainerUtil.newHashMap();
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            for (DasObject obj : this.myProcessed) {
                BasicModElement target;
                SqlElement object = (SqlElement)ObjectUtils.tryCast((Object)obj, SqlElement.class);
                if (object == null || this.myModel.nullize(target = this.myObjects.get(ObjectPaths.of(obj))) == null) continue;
                res.put(target, pointerManager.createSmartPsiElementPointer((PsiElement)object));
            }
            HashMap hashMap = res;
            if (hashMap == null) {
                SqlFileProcessor.$$$reportNull$$$0(15);
            }
            return hashMap;
        }

        public void apply() {
            this.myModel.apply();
        }

        @NotNull
        public BasicElement getRoot() {
            BasicModElement basicModElement = this.myModel.getRoot();
            if (basicModElement == null) {
                SqlFileProcessor.$$$reportNull$$$0(16);
            }
            return basicModElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stmt";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reverseMap";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processCommentStmt";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processSingle";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "processRequiredChildren";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "markObjectReady";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processOddities";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidParent";
                    break;
                }
                case 15: 
                case 16: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

