/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlForeignKeyDefinitionImpl;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010$\u001a\n &*\u0004\u0018\u00010%0%2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\n &*\u0004\u0018\u00010%0%2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010-\u001a\u00020\t2\u0006\u0010\n\u001a\u00020.2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010/\u001a\u00020\t2\u0006\u0010\n\u001a\u0002002\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u00103\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u00104\u001a\u00020\t2\u0006\u0010\n\u001a\u0002052\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u00106\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u00107\u001a\u0004\u0018\u00010\u001c2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u00108\u001a\u0004\u0018\u00010\u001c2\b\u0010\f\u001a\u0004\u0018\u000109H\u0002J\u0018\u0010:\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010;\u001a\u00020\t2\u0006\u0010\n\u001a\u00020<2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010=\u001a\u00020\t2\u0006\u0010\n\u001a\u00020>2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010?\u001a\u00020@2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010A\u001a\u00020\t2\u0006\u0010\n\u001a\u00020B2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010C\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010D\u001a$\u0012\f\u0012\n &*\u0004\u0018\u00010F0F &*\u0010\u0012\f\u0012\n &*\u0004\u0018\u00010F0F020E2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010I\u001a\u00020\t2\u0006\u0010\n\u001a\u00020J2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010K\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010L\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010M\u001a\n &*\u0004\u0018\u00010N0N2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u000e\u0010P\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0QH\u0002J\u0010\u0010R\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010R\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0010\u0010S\u001a\u00020\t2\u0006\u0010\n\u001a\u00020.H\u0014J\"\u0010T\u001a\u0004\u0018\u0001HU\"\u0006\b\u0000\u0010U\u0018\u00012\b\u0010V\u001a\u0004\u0018\u00010\u0005H\u0084\b\u00a2\u0006\u0002\u0010WJ)\u0010T\u001a\u0004\u0018\u00010\u00052\b\u0010V\u001a\u0004\u0018\u00010\u00052\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0YH\u0084\bJ\u001c\u0010T\u001a\u0004\u0018\u00010\u00052\b\u0010Z\u001a\u0004\u0018\u00010\u00052\u0006\u0010[\u001a\u00020\u0004H\u0004J)\u0010\\\u001a\u0004\u0018\u00010\u00052\b\u0010]\u001a\u0004\u0018\u00010\u00052\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0YH\u0084\bJ\u001c\u0010\\\u001a\u0004\u0018\u00010\u00052\b\u0010]\u001a\u0004\u0018\u00010\u00052\u0006\u0010[\u001a\u00020\u0004H\u0004J'\u0010^\u001a\u00020\t2\b\u0010V\u001a\u0004\u0018\u00010\u00052\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0YH\u0084\bJ'\u0010_\u001a\u00020\t2\b\u0010`\u001a\u0004\u0018\u00010\u00052\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0YH\u0084\bJ\u0018\u0010a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010b\u001a\u0004\u0018\u00010\u001c*\u00020\u0005H\u0004R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006c"}, d2={"Lcom/intellij/sql/database/SqlObjectBuilderImpl;", "Lcom/intellij/sql/database/SqlObjectBuilder;", "()V", "elementType", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/psi/PsiElement;", "getElementType", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/tree/IElementType;", "assignName", "", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "source", "Lcom/intellij/database/model/DasObject;", "build", "Lcom/intellij/database/model/basic/BasicModElement;", "buildArgument", "Lcom/intellij/database/model/basic/BasicModArgument;", "buildArgumentDir", "Lcom/intellij/database/model/DasArgument$Direction;", "buildArranged", "Lcom/intellij/database/model/basic/BasicModArrangedElement;", "buildArrangedPos", "", "buildBasicElement", "buildCheck", "Lcom/intellij/database/model/basic/BasicModCheck;", "buildCheckPredicate", "", "buildColumniation", "Lcom/intellij/database/model/basic/BasicModColumniation;", "buildColumniationRefs", "", "buildFkIsDeferrable", "", "buildFkIsDeferred", "buildFkOnDelete", "Lcom/intellij/database/model/properties/CascadeRule;", "kotlin.jvm.PlatformType", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "buildFkOnUpdate", "buildFkRefColumns", "buildFkRefSchemaName", "buildFkRefTableName", "buildForeignKey", "Lcom/intellij/database/model/basic/BasicModForeignKey;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildIndexReverseColumns", "", "buildIndexUnique", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyIsPrimary", "buildNameFromPsiElement", "buildNameFromRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "buildNamedElement", "buildNamespace", "Lcom/intellij/database/model/basic/BasicModNamespace;", "buildRoutine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildRoutineKind", "Lcom/intellij/database/model/DasRoutine$Kind;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildTriggerCondition", "buildTriggerEvents", "", "Lcom/intellij/database/model/TrigEvent;", "buildTriggerTurn", "Lcom/intellij/database/model/TrigTurn;", "buildTyped", "Lcom/intellij/database/model/basic/BasicModTypedElement;", "buildTypedDef", "buildTypedNotNull", "buildTypedType", "Lcom/intellij/database/model/DataType;", "collectNames", "ref", "Lcom/intellij/database/model/MultiRef;", "finalize", "finalizeForeignKey", "findChild", "T", "el", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "action", "Lkotlin/Function1;", "parent", "type", "findSibling", "element", "forEachChild", "forEachSibling", "first", "partialBuild", "extractName", "intellij.database.sql.impl"})
public abstract class SqlObjectBuilderImpl
implements SqlObjectBuilder {
    public void partialBuild(@NotNull DasObject obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
    }

    public void build(@NotNull DasObject obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.build((BasicModElement)obj, source);
    }

    public void finalize(@NotNull DasObject obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        this.finalize((BasicModElement)obj);
    }

    public void finalize(@NotNull BasicModElement obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        if (obj instanceof BasicModForeignKey) {
            this.finalizeForeignKey((BasicModForeignKey)obj);
        }
    }

    protected void finalizeForeignKey(@NotNull BasicModForeignKey obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        BasicTableOrView basicTableOrView = obj.getRefTable();
        if (basicTableOrView == null) {
            return;
        }
        BasicTableOrView refTable = basicTableOrView;
        List<String> refCols = obj.getRefColNames();
        if (refCols.isEmpty()) {
            BasicKey key2;
            BasicTableOrView basicTableOrView2 = refTable;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrView2, (String)"refTable");
            BasicKey basicKey = key2 = basicTableOrView2.getPrimaryKey();
            obj.setRefKeyName(basicKey != null ? basicKey.getName() : null);
            if (key2 != null) {
                obj.setRefColNames(key2.getColNames());
            }
        } else {
            BasicKey key3;
            BasicTableOrView basicTableOrView3 = refTable;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrView3, (String)"refTable");
            BasicKey basicKey = key3 = basicTableOrView3.getKeys().find((Predicate<? extends BasicKey>)new Predicate<BasicKey>(refCols){
                final /* synthetic */ List $refCols;

                public final boolean test(BasicKey k) {
                    return k.areColNames(this.$refCols);
                }
                {
                    this.$refCols = list;
                }
            });
            obj.setRefKeyName(basicKey != null ? basicKey.getName() : null);
        }
    }

    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof BasicModNamespace) {
            this.buildNamespace((BasicModNamespace)obj, source);
        } else if (basicModElement instanceof BasicModArgument) {
            this.buildArgument((BasicModArgument)obj, source);
        } else if (basicModElement instanceof BasicModForeignKey) {
            this.buildForeignKey((BasicModForeignKey)obj, source);
        } else if (basicModElement instanceof BasicModIndex) {
            this.buildIndex((BasicModIndex)obj, source);
        } else if (basicModElement instanceof BasicModKey) {
            this.buildKey((BasicModKey)obj, source);
        } else if (basicModElement instanceof BasicModRoutine) {
            this.buildRoutine((BasicModRoutine)obj, source);
        } else if (basicModElement instanceof BasicModTrigger) {
            this.buildTrigger((BasicModTrigger)obj, source);
        } else if (basicModElement instanceof BasicModCheck) {
            this.buildCheck((BasicModCheck)obj, source);
        } else {
            this.buildBasicElement(obj, source);
        }
    }

    protected void buildBasicElement(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (obj instanceof BasicModNamedElement) {
            this.buildNamedElement((BasicModNamedElement)obj, source);
        }
        if (obj instanceof BasicModArrangedElement) {
            this.buildArranged((BasicModArrangedElement)obj, source);
        }
        if (obj instanceof BasicModTypedElement) {
            this.buildTyped((BasicModTypedElement)obj, source);
        }
        if (obj instanceof BasicModColumniation) {
            this.buildColumniation((BasicModColumniation)obj, source);
        }
    }

    protected void buildForeignKey(@NotNull BasicModForeignKey obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        BasicModModel basicModModel = (BasicModModel)obj.getModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicModModel, (String)"obj.model");
        Rdbms rdbms = basicModModel.getRdbms();
        obj.setDeferrable(this.buildFkIsDeferrable(source));
        obj.setInitiallyDeferred(this.buildFkIsDeferred(source));
        Rdbms rdbms2 = rdbms;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms2, (String)"rdbms");
        obj.setOnDelete(this.buildFkOnDelete(source, rdbms2));
        obj.setOnUpdate(this.buildFkOnUpdate(source, rdbms));
        obj.setRefColNames(this.buildFkRefColumns(source));
        obj.setRefTableName(this.buildFkRefTableName(source));
        obj.setRefSchemaName(this.buildFkRefSchemaName(source));
    }

    private final String buildFkRefSchemaName(DasObject source) {
        String string;
        DasObject dasObject = source;
        if (dasObject instanceof SqlForeignKeyDefinitionImpl) {
            SqlReferenceExpression sqlReferenceExpression = ((SqlForeignKeyDefinitionImpl)source).getRefTableReference();
            Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
            if (!(object instanceof SqlReferenceExpression)) {
                object = null;
            }
            string = this.buildNameFromRef((SqlReferenceExpression)object);
        } else {
            string = dasObject instanceof DasForeignKey ? StringUtil.nullize((String)((DasForeignKey)source).getRefTableSchema(), (boolean)true) : null;
        }
        return string;
    }

    private final String buildFkRefTableName(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof SqlForeignKeyDefinitionImpl ? this.buildNameFromRef(((SqlForeignKeyDefinitionImpl)source).getRefTableReference()) : (dasObject instanceof DasForeignKey ? ((DasForeignKey)source).getRefTableName() : null);
    }

    private final List<String> buildFkRefColumns(DasObject source) {
        List<String> list;
        DasObject dasObject = source;
        if (dasObject instanceof DasForeignKey) {
            MultiRef multiRef = ((DasForeignKey)source).getRefColumns();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.refColumns");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String buildNameFromRef(SqlReferenceExpression source) {
        if (source == null) {
            return null;
        }
        String string = this.buildNameFromPsiElement(source.resolve());
        if (string == null) {
            string = source.getName();
        }
        return string;
    }

    private final String buildNameFromPsiElement(PsiElement source) {
        PsiElement psiElement = source;
        return psiElement instanceof DasObject ? ((DasObject)source).getName() : (psiElement instanceof SqlNameElement ? ((SqlNameElement)source).getName() : null);
    }

    private final List<String> collectNames(MultiRef<? extends DasObject> ref) {
        ArrayList res = ContainerUtil.newArrayList();
        MultiRef.It it = ref.iterate();
        while (it.hasNext()) {
            String name = (String)it.next();
            DasObject obj = (DasObject)it.resolve();
            Object object = obj;
            if (object == null || (object = object.getName()) == null) {
                object = name;
            }
            res.add(object);
        }
        ArrayList arrayList = res;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"res");
        return arrayList;
    }

    private final CascadeRule buildFkOnDelete(DasObject source, Rdbms rdbms) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? GenericIntrospectorLegacyModelUtils.asCascadeRule(((DasForeignKey)source).getDeleteRule(), rdbms) : CascadeRule.no_action;
    }

    private final CascadeRule buildFkOnUpdate(DasObject source, Rdbms rdbms) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? GenericIntrospectorLegacyModelUtils.asCascadeRule(((DasForeignKey)source).getUpdateRule(), rdbms) : CascadeRule.no_action;
    }

    private final boolean buildFkIsDeferred(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? Intrinsics.areEqual((Object)((DasForeignKey)source).getDeferrability(), (Object)DasForeignKey.Deferrability.INITIALLY_DEFERRED) : false;
    }

    private final boolean buildFkIsDeferrable(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? ((DasForeignKey)source).getDeferrability() != null && Intrinsics.areEqual((Object)((DasForeignKey)source).getDeferrability(), (Object)DasForeignKey.Deferrability.NOT_DEFERRABLE) ^ true : false;
    }

    protected void buildRoutine(@NotNull BasicModRoutine obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setRoutineKind(this.buildRoutineKind(source));
    }

    private final DasRoutine.Kind buildRoutineKind(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasRoutine ? ((DasRoutine)source).getRoutineKind() : DasRoutine.Kind.NONE;
    }

    protected void buildCheck(@NotNull BasicModCheck obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setPredicate(this.buildCheckPredicate(source));
    }

    private final String buildCheckPredicate(DasObject source) {
        String string;
        DasObject dasObject = source;
        if (dasObject instanceof SqlConstraintDefinition) {
            SqlExpression sqlExpression = (SqlExpression)((SqlConstraintDefinition)source).getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
            string = sqlExpression != null ? sqlExpression.getText() : null;
        } else {
            string = null;
        }
        return string;
    }

    protected void buildTrigger(@NotNull BasicModTrigger obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setEvents(this.buildTriggerEvents(source));
        obj.setTurn(this.buildTriggerTurn(source));
        obj.setCondition(this.buildTriggerCondition(source));
    }

    private final Set<TrigEvent> buildTriggerEvents(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getEvents() : SetsKt.emptySet();
    }

    private final TrigTurn buildTriggerTurn(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getTurn() : null;
    }

    private final String buildTriggerCondition(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getCondition() : null;
    }

    protected void buildIndex(@NotNull BasicModIndex obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setUnique(this.buildIndexUnique(source));
        obj.setReverseColNames(this.buildIndexReverseColumns(source));
    }

    private final boolean buildIndexUnique(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasIndex ? ((DasIndex)source).isUnique() : false;
    }

    private final Set<String> buildIndexReverseColumns(DasObject source) {
        Set set;
        DasObject dasObject = source;
        if (dasObject instanceof DasIndex) {
            DasTypedObject it;
            Iterable $receiver$iv$iv;
            Iterable iterable = ((DasIndex)source).getColumnsRef().resolveObjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"source.columnsRef.resolveObjects()");
            Iterable $receiver$iv = iterable;
            Iterable iterable2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (DasTypedObject)element$iv$iv;
                if (!Intrinsics.areEqual((Object)((DasIndex)source).getColumnSorting(it), (Object)DasIndex.Sorting.DESCENDING)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (DasTypedObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                DasTypedObject dasTypedObject = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dasTypedObject, (String)"it");
                String string = dasTypedObject.getName();
                collection.add(string);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    protected void buildKey(@NotNull BasicModKey obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setPrimary(this.buildKeyIsPrimary(source));
    }

    private final boolean buildKeyIsPrimary(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTableKey ? ((DasTableKey)source).isPrimary() : false;
    }

    protected void buildArgument(@NotNull BasicModArgument obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setArgumentDirection(this.buildArgumentDir(source));
    }

    private final DasArgument.Direction buildArgumentDir(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasArgument ? ((DasArgument)source).getArgumentDirection() : DasArgument.Direction.IN;
    }

    protected void buildColumniation(@NotNull BasicModColumniation obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setColNames(this.buildColumniationRefs(source));
    }

    private final List<String> buildColumniationRefs(DasObject source) {
        List<String> list;
        DasObject dasObject = source;
        if (dasObject instanceof DasConstraint) {
            MultiRef multiRef = ((DasConstraint)source).getColumnsRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.columnsRef");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else if (dasObject instanceof DasIndex) {
            MultiRef multiRef = ((DasIndex)source).getColumnsRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.columnsRef");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    protected void buildArranged(@NotNull BasicModArrangedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (source instanceof DasPositioned) {
            obj.setPosition(((DasPositioned)source).getPosition());
        }
    }

    private final short buildArrangedPos(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasPositioned ? ((DasPositioned)source).getPosition() : (short)0;
    }

    protected void buildTyped(@NotNull BasicModTypedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setDataType(this.buildTypedType(source));
        obj.setDefaultExpression(this.buildTypedDef(source));
        obj.setNotNull(this.buildTypedNotNull(source));
    }

    private final DataType buildTypedType(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).getDataType() : DataType.UNKNOWN;
    }

    private final String buildTypedDef(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).getDefault() : null;
    }

    private final boolean buildTypedNotNull(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).isNotNull() : false;
    }

    protected void buildNamedElement(@NotNull BasicModNamedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.assignName(obj, source);
        obj.setComment(source.getComment());
        obj.setNameQuoted(DbSqlUtil.isQuoted(source));
        obj.setNameScripted(DbSqlUtil.isSqlObject(source));
    }

    protected void assignName(@NotNull BasicModNamedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setName(source.getName());
    }

    protected void buildNamespace(@NotNull BasicModNamespace obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        if (obj instanceof BasicModMateNamespace) {
            ((BasicModMateNamespace)obj).setVisible(true);
        }
    }

    protected final void forEachChild(@Nullable PsiElement el, @NotNull Function1<? super PsiElement, Unit> action) {
        PsiElement first$iv;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        PsiElement psiElement = el;
        for (PsiElement tmp$iv = first$iv = (v886179) != null ? (v886179).getFirstChild() : null; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            action.invoke((Object)tmp$iv);
        }
    }

    protected final void forEachSibling(@Nullable PsiElement first, @NotNull Function1<? super PsiElement, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        for (PsiElement tmp = first; tmp != null; tmp = tmp.getNextSibling()) {
            action.invoke((Object)tmp);
        }
    }

    @Nullable
    protected final PsiElement findChild(@Nullable PsiElement parent, @NotNull IElementType type) {
        PsiElement psiElement;
        block1: {
            PsiElement element$iv$iv;
            SqlObjectBuilderImpl this_$iv;
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv = this;
            PsiElement psiElement2 = parent;
            for (PsiElement tmp$iv$iv = element$iv$iv = (v886206) != null ? (v886206).getFirstChild() : null; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                if (!Intrinsics.areEqual((Object)this.getElementType(it), (Object)type)) continue;
                psiElement = tmp$iv$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    private final <T> T findChild(PsiElement el) {
        PsiElement psiElement;
        block1: {
            PsiElement element$iv;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement psiElement2 = el;
            for (PsiElement tmp$iv = element$iv = (v886225) != null ? (v886225).getFirstChild() : null; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                PsiElement it = tmp$iv;
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                if (!(it instanceof Object)) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        return (T)psiElement;
    }

    @Nullable
    protected final PsiElement findChild(@Nullable PsiElement el, @NotNull Function1<? super PsiElement, Boolean> action) {
        PsiElement psiElement;
        block1: {
            PsiElement element$iv;
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement psiElement2 = el;
            for (PsiElement tmp$iv = element$iv = (v886249) != null ? (v886249).getFirstChild() : null; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                if (!((Boolean)action.invoke((Object)tmp$iv)).booleanValue()) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element, @NotNull IElementType type) {
        PsiElement psiElement;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            SqlObjectBuilderImpl this_$iv = this;
            for (PsiElement tmp$iv = element; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                PsiElement it = tmp$iv;
                if (!Intrinsics.areEqual((Object)this.getElementType(it), (Object)type)) continue;
                psiElement = tmp$iv;
                break block1;
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element, @NotNull Function1<? super PsiElement, Boolean> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        for (PsiElement tmp = element; tmp != null; tmp = tmp.getNextSibling()) {
            if (!((Boolean)action.invoke((Object)tmp)).booleanValue()) continue;
            return tmp;
        }
        return null;
    }

    @Nullable
    protected final String extractName(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement psiElement = $receiver;
        return psiElement instanceof SqlReferenceExpressionImpl ? ((SqlReferenceExpressionImpl)$receiver).getName() : (psiElement instanceof SqlStringLiteralExpressionImpl ? ((SqlStringLiteralExpressionImpl)$receiver).getValue() : (this.getElementType($receiver) instanceof SqlKeywordTokenType || Intrinsics.areEqual((Object)this.getElementType($receiver), (Object)SqlTokens.SQL_IDENT) ? $receiver.getText() : null));
    }

    @Nullable
    protected final IElementType getElementType(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ASTNode aSTNode = $receiver.getNode();
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    public static final /* synthetic */ void access$forEachSibling(SqlObjectBuilderImpl $this, @Nullable PsiElement first, @NotNull Function1 action) {
        $this.forEachSibling(first, (Function1<? super PsiElement, Unit>)action);
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findSibling(SqlObjectBuilderImpl $this, @Nullable PsiElement element, @NotNull Function1 action) {
        return $this.findSibling(element, (Function1<? super PsiElement, Boolean>)action);
    }
}

