/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeBasedInjection
extends BaseInjection {
    public static final Pattern INVALID_PATTERN = Pattern.compile("");
    private Pattern myPattern = INVALID_PATTERN;
    private boolean myEnabled = false;
    private List<String> myHostLanguages = Collections.emptyList();
    private String myFragment = null;

    public SqlTypeBasedInjection() {
        super("sql");
    }

    public SqlTypeBasedInjection copyFrom(@NotNull BaseInjection other) {
        if (other == null) {
            SqlTypeBasedInjection.$$$reportNull$$$0(0);
        }
        super.copyFrom(other);
        this.myPattern = ((SqlTypeBasedInjection)other).myPattern;
        this.myEnabled = ((SqlTypeBasedInjection)other).myEnabled;
        this.myFragment = ((SqlTypeBasedInjection)other).myFragment;
        this.myHostLanguages = ((SqlTypeBasedInjection)other).myHostLanguages;
        return this;
    }

    public void setPattern(@NotNull Pattern p) {
        if (p == null) {
            SqlTypeBasedInjection.$$$reportNull$$$0(1);
        }
        this.myPattern = p;
    }

    @NotNull
    public Pattern getPattern() {
        Pattern pattern = this.myPattern;
        if (pattern == null) {
            SqlTypeBasedInjection.$$$reportNull$$$0(2);
        }
        return pattern;
    }

    @NotNull
    public List<String> getHostLanguages() {
        List<String> list = this.myHostLanguages;
        if (list == null) {
            SqlTypeBasedInjection.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setHostLanguages(@NotNull List<String> hostLanguages) {
        if (hostLanguages == null) {
            SqlTypeBasedInjection.$$$reportNull$$$0(4);
        }
        this.myHostLanguages = hostLanguages;
    }

    @Nullable
    public String getFragment() {
        return this.myFragment;
    }

    public void setFragment(String fragment) {
        this.myFragment = fragment;
    }

    protected void readExternalImpl(Element e) {
        super.readExternalImpl(e);
        String pattern = e.getAttributeValue("pattern");
        if (pattern != null) {
            this.myPattern = PatternUtil.compileSafe((String)pattern, (Pattern)INVALID_PATTERN);
        }
        this.myEnabled = Boolean.parseBoolean(e.getAttributeValue("enabled"));
        this.myFragment = StringUtil.nullize((String)e.getAttributeValue("fragment"));
        String hosts = e.getAttributeValue("hosts");
        this.myHostLanguages = StringUtil.isEmpty((String)hosts) ? Collections.emptyList() : ContainerUtil.newSmartList((Object[])hosts.split(","));
    }

    protected void writeExternalImpl(Element e) {
        super.writeExternalImpl(e);
        if (StringUtil.isNotEmpty((String)this.myPattern.pattern())) {
            e.setAttribute("pattern", this.myPattern.pattern());
        }
        if (this.myEnabled) {
            e.setAttribute("enabled", Boolean.toString(true));
        }
        if (StringUtil.isNotEmpty((String)this.myFragment)) {
            e.setAttribute("fragment", this.myFragment);
        }
        if (!this.myHostLanguages.isEmpty()) {
            e.setAttribute("hosts", StringUtil.join(this.myHostLanguages, (String)","));
        }
    }

    public SqlTypeBasedInjection copy() {
        return new SqlTypeBasedInjection().copyFrom(this);
    }

    public boolean sameLanguageParameters(BaseInjection that) {
        if (!super.sameLanguageParameters(that)) {
            return false;
        }
        SqlTypeBasedInjection that1 = (SqlTypeBasedInjection)((Object)ObjectUtils.tryCast((Object)that, SqlTypeBasedInjection.class));
        return that1 != null && this.myPattern.pattern().equals(that1.myPattern.pattern()) && this.myEnabled == that1.myEnabled && Comparing.equal((String)this.myFragment, (String)that1.myFragment) && this.myHostLanguages.equals(that1.myHostLanguages);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myPattern.pattern().hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.myEnabled);
        return result2;
    }

    public void setPlaceEnabled(@Nullable String text, boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isEnabled() {
        return StringUtil.isNotEmpty((String)this.myPattern.pattern()) && this.myEnabled;
    }

    public boolean acceptsPsiElement(PsiElement element) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/injection/SqlTypeBasedInjection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/injection/SqlTypeBasedInjection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPattern";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setHostLanguages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

