/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCursorDefinitionImpl;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallExpressionImpl
extends SqlExpressionImpl
implements SqlFunctionCallExpression,
NavigationItem {
    public SqlFunctionCallExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlFunctionCallExpression((SqlFunctionCallExpression)this);
    }

    @Nullable
    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getCallableExpression(), SqlReferenceExpression.class);
    }

    @Nullable
    public SqlExpression getCallableExpression() {
        return this.findNotNullChildByClass(SqlExpression.class);
    }

    public SqlExpressionList getParameterList() {
        return (SqlExpressionList)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_EXPRESSION_LIST);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlFunctionDefinition.Prototype prototype = SqlFunctionsUtil.chooseTheBestPrototype(this, true);
        if (prototype != null) {
            SqlType sqlType = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType(prototype, this.getNameElement(), (PsiElement)this.getParameterList(), (PsiElement)this);
            if (sqlType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(1);
            }
            return sqlType;
        }
        SqlType sqlType = SqlFunctionCallExpressionImpl.createFunctionReturnType(this.getNameElement(), (PsiElement)this);
        if (sqlType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(2);
        }
        return sqlType;
    }

    public static SqlType createFunctionReturnType(@Nullable SqlReferenceExpression nameElement, @NotNull PsiElement routineElement) {
        SqlTableType type;
        Object target;
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(3);
        }
        PsiElement resolve = nameElement == null ? null : nameElement.getReference().resolve();
        Object object = target = resolve instanceof DbElement ? ((DbElement)resolve).getDelegate() : resolve;
        if (target instanceof SqlFileImpl.FakeDefinition) {
            target = ((SqlFileImpl.FakeDefinition)((Object)target)).delegates().first();
        }
        if (target instanceof DasRoutine) {
            return SqlFunctionCallExpressionImpl.createRoutineType(resolve, (DasRoutine)target, false, routineElement);
        }
        if (target instanceof SqlCreateTypeStatement && (type = ((SqlCreateTypeStatement)target).getSqlType()) != null) {
            return type;
        }
        if (target instanceof SqlTypedDefinition) {
            SqlTypedDefinition definition = (SqlTypedDefinition)target;
            return SqlImplUtil.getSqlType(definition, SqlImplUtil.getSqlDialectSafe(routineElement), (PsiElement)nameElement);
        }
        return SqlType.UNKNOWN;
    }

    public static SqlType createBuiltinFunctionReturnType(@NotNull SqlFunctionDefinition.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params2, @NotNull PsiElement routineElement) {
        DataType dataType;
        if (prototype == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(4);
        }
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(5);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(routineElement);
        SqlFunctionDefinition.Type returnType = prototype.getReturnType();
        if (returnType == SqlFunctionDefinition.UNNEST) {
            List<SqlExpression> cols;
            List<Object> list = params2 instanceof SqlExpressionList ? ((SqlExpressionList)params2).getExpressionList() : (cols = params2 instanceof SqlExpression ? Collections.singletonList((SqlExpression)params2) : null);
            if (nameElement == null || ContainerUtil.isEmpty(cols)) {
                return SqlTableTypeBase.EMPTY_TABLE;
            }
            StringBuilder builder = new StringBuilder("table(");
            for (SqlExpression col : cols) {
                if (builder.charAt(builder.length() - 1) != '(') {
                    builder.append(", ");
                }
                builder.append(prototype.getFunction().getName()).append(" ").append(SqlImplUtil.getArrayElement(col.getSqlType().getDataType()).getSpecification());
            }
            builder.append(")");
            return SqlFunctionCallExpressionImpl.getSqlType(routineElement, DataTypeFactory.of(builder.toString()));
        }
        DataType dataType2 = dataType = returnType == null ? null : returnType.getDataType();
        if (dataType != null) {
            if (params2 instanceof SqlExpressionList) {
                ArrayList columns2 = ContainerUtil.newArrayList();
                if (!SqlFunctionCallExpressionImpl.collectColumnDefs(columns2, params2)) {
                    SqlFunctionCallExpressionImpl.collectColumnDefs(columns2, routineElement);
                }
                if (!columns2.isEmpty()) {
                    return new TableBasedSqlTableTypeImpl(columns2, (PsiElement)ObjectUtils.chooseNotNull((Object)nameElement, (Object)routineElement));
                }
            }
            if ("table".equalsIgnoreCase(dataType.typeName)) {
                if (dataType.vagueArg == null) {
                    dataType = DataTypeFactory.of("table(" + prototype.getFunction().getName() + " record)");
                }
                return SqlImplUtil.getSqlType(routineElement.getProject(), dataType, dialect, routineElement);
            }
            return SqlTypeFactory.of(dataType, dialect);
        }
        if (returnType instanceof SqlFunctionDefinition.ParamType && params2 instanceof SqlExpressionList) {
            int index = ((SqlFunctionDefinition.ParamType)returnType).getIndex();
            List parameters = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)params2, SqlCompositeElement.class);
            if (index > 0 && index <= parameters.size()) {
                SqlCompositeElement element = (SqlCompositeElement)parameters.get(index - 1);
                return SqlFunctionCallExpressionImpl.getParamType((SqlElement)element);
            }
            if (index == 0) {
                SqlPrimitiveType curType = SqlType.UNKNOWN;
                for (SqlCompositeElement param : parameters) {
                    SqlType type = SqlFunctionCallExpressionImpl.getParamType((SqlElement)param);
                    if (curType == SqlType.UNKNOWN || SqlType.Category.REAL.is(type)) {
                        curType = type;
                        continue;
                    }
                    if (!SqlType.Category.INTEGER.is((SqlType)curType)) continue;
                    curType = SqlTypeFactory.defaultType(SqlType.Category.REAL, dialect);
                }
                return curType;
            }
        }
        return SqlType.UNKNOWN;
    }

    private static boolean collectColumnDefs(List<SqlColumnDefinition> columns2, PsiElement container) {
        for (PsiElement element : SqlImplUtil.sqlChildren(container)) {
            if (element instanceof SqlColumnDefinition) {
                columns2.add((SqlColumnDefinition)element);
                continue;
            }
            if (!(element instanceof SqlClause) || !columns2.isEmpty()) continue;
            SqlImplUtil.sqlChildren(element).filter(SqlColumnDefinition.class).addAllTo(columns2);
            if (columns2.isEmpty()) continue;
            break;
        }
        return !columns2.isEmpty();
    }

    public static SqlType createRoutineType(@NotNull PsiElement resolve, @NotNull DasRoutine target, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (resolve == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(6);
        }
        if (target == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(7);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(8);
        }
        DatabaseFamilyId familyId = SqlImplUtil.getSqlDialectSafe(qualifier).getFamilyId();
        DasArgument retArg = target.getReturnArgument();
        if (familyId.isPostgres()) {
            JBIterable args2;
            DataType retType;
            DataType dataType = retType = retArg == null ? null : retArg.getDataType();
            if ((retType == null || retType.typeName.equalsIgnoreCase("record") || retType.typeName.equals("setof") && "record".equalsIgnoreCase(retType.suffix)) && !(args2 = JBIterable.from((Iterable)target.getArguments()).filter(o -> o.getArgumentDirection().isOut())).isEmpty()) {
                return SqlFunctionCallExpressionImpl.createTypeFromColumns(resolve, (Iterable<? extends DasTypedObject>)args2, ensureTable, qualifier);
            }
        } else if (familyId.isMicrosoft() && retArg == null) {
            return SqlFunctionCallExpressionImpl.createTypeFromColumns(resolve, (Iterable<? extends DasTypedObject>)target.getDasChildren(ObjectKind.NONE).filter(DasTypedObject.class), ensureTable, qualifier);
        }
        return retArg == null ? SqlType.UNKNOWN : SqlFunctionCallExpressionImpl.createType(resolve, retArg, ensureTable, qualifier);
    }

    @NotNull
    private static SqlType getParamType(SqlElement element) {
        Object object = element instanceof SqlTypeElement ? ((SqlTypeElement)element).findSqlType() : (element instanceof SqlExpression ? ((SqlExpression)element).getSqlType() : SqlType.UNKNOWN);
        if (object == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(9);
        }
        return object;
    }

    private static SqlType createTypeFromColumns(@NotNull PsiElement routine, @NotNull Iterable<? extends DasTypedObject> args2, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (routine == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(10);
        }
        if (args2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(11);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(12);
        }
        int size = Iterables.size(args2);
        ArrayList columns2 = ContainerUtil.newArrayListWithCapacity((int)size);
        for (DasTypedObject dasTypedObject : args2) {
            SqlType sqlType = dasTypedObject instanceof SqlTypedDefinition ? ((SqlTypedDefinition)dasTypedObject).getSqlType() : SqlFunctionCallExpressionImpl.getSqlType(routine, dasTypedObject.getDataType());
            columns2.add(new SqlImplUtil.Column(dasTypedObject.getName(), sqlType, (PsiElement)(dasTypedObject instanceof PsiElement ? (PsiElement)dasTypedObject : new FakeParameter(qualifier, dasTypedObject)), null));
        }
        if (!ensureTable && columns2.size() == 1) {
            return ((SqlImplUtil.Column)columns2.get((int)0)).type;
        }
        return SqlImplUtil.createType(columns2, qualifier);
    }

    private static SqlType createType(@NotNull PsiElement routine, @NotNull DasArgument retArg, boolean ensureTable, @NotNull PsiElement qualifier) {
        SqlType sqlType;
        if (routine == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(13);
        }
        if (retArg == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(14);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(15);
        }
        if ((sqlType = SqlFunctionCallExpressionImpl.getReturnType(routine, retArg)) != SqlType.UNKNOWN && retArg instanceof SqlElement) {
            SqlType res;
            Object object = res = ensureTable ? SqlTableTypeBase.ensureTableType(sqlType, (SqlElement)retArg, qualifier) : sqlType;
            if (sqlType instanceof SqlTableType) {
                String name = routine instanceof DasObject ? ((DasObject)routine).getName() : (routine instanceof SqlExpression ? ((SqlExpression)routine).getName() : null);
                res = ((SqlTableType)res).alias(name, qualifier, Collections.emptyList());
            }
            return res;
        }
        if (!ensureTable) {
            return sqlType;
        }
        List<SqlImplUtil.Column> columns2 = Collections.singletonList(new SqlImplUtil.Column(retArg.getName(), sqlType, (PsiElement)(retArg instanceof PsiElement ? (PsiElement)retArg : new FakeParameter(qualifier, (DasTypedObject)retArg)), null));
        return SqlImplUtil.createType(columns2, qualifier);
    }

    private static SqlType getReturnType(@NotNull PsiElement routine, @NotNull DasArgument retArg) {
        if (routine == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(16);
        }
        if (retArg == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(17);
        }
        SqlType sqlType = null;
        DatabaseFamilyId familyId = SqlImplUtil.getSqlDialectSafe(routine).getFamilyId();
        if (retArg instanceof SqlTypedDefinition) {
            sqlType = ((SqlTypedDefinition)retArg).getSqlType();
            if (familyId.isPostgres() && SqlType.Category.SETOF.is(sqlType)) {
                return SqlFunctionCallExpressionImpl.getSqlType(routine, SqlFunctionCallExpressionImpl.trimSetOf(sqlType.getDataType()));
            }
        }
        DataType dataType = retArg.getDataType();
        if (familyId.isPostgres()) {
            dataType = SqlFunctionCallExpressionImpl.trimSetOf(dataType);
        }
        return sqlType != null ? sqlType : SqlFunctionCallExpressionImpl.getSqlType(routine, dataType);
    }

    @NotNull
    private static DataType trimSetOf(DataType dataType) {
        DataType dataType2 = dataType.typeName.equals("setof") && dataType.suffix != null ? DataTypeFactory.of(dataType.suffix) : dataType;
        if (dataType2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(18);
        }
        return dataType2;
    }

    private static SqlType getSqlType(@NotNull PsiElement routine, @NotNull DataType dataType) {
        if (routine == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(19);
        }
        if (dataType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(20);
        }
        if (dataType == DataType.UNKNOWN) {
            return SqlType.UNKNOWN;
        }
        return SqlImplUtil.getSqlType(routine.getProject(), dataType, SqlImplUtil.getSqlDialectSafe(routine), routine);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                SqlReferenceExpression nameElement = SqlFunctionCallExpressionImpl.this.getNameElement();
                return nameElement == null ? null : nameElement.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    @Nullable
    public SqlFunctionDefinition getFunctionDefinition() {
        SqlReferenceExpression nameElement = this.getNameElement();
        if (nameElement == null) {
            return null;
        }
        String functionName = nameElement.getName();
        SqlFunctionDefinition definition = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getSupportedFunctions().get(functionName);
        return definition == null || !definition.isTableQueryOnly() || this.getParent() instanceof SqlFunctionCallTableExpressionImpl ? definition : null;
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        return referenceElement == this.getNameElement() && this.getFirstChild() != this.getLastChild() ? ObjectKind.ROUTINE : super.getExpectedReferenceTargetType(referenceElement);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.ARGUMENT)) {
            return true;
        }
        if (!SqlFunctionCallExpressionImpl.processNamedArgument((Processor<PsiElement>)((Processor)e -> processor.execute(e, state)), this.getNameElement(), place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public static boolean processNamedArgument(Processor<PsiElement> processor, SqlReferenceExpression ref, PsiElement place) {
        SqlNamedParameterValueExpression expr = (SqlNamedParameterValueExpression)((Object)ObjectUtils.tryCast((Object)(place == null ? null : place.getParent()), SqlNamedParameterValueExpression.class));
        if (expr != null && place == expr.getLOperand()) {
            SqlFunctionCallExpressionImpl.processParameters(ref, processor, place);
            return false;
        }
        return true;
    }

    public static boolean processParameters(@Nullable SqlReferenceExpression fooRef, Processor<PsiElement> processor, final PsiElement place) {
        if (fooRef == null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)fooRef);
        Case casing = dialect.getCasing((ObjectKind)ObjectKind.ARGUMENT, null).plain;
        SqlFunctionDefinition definition = dialect.getSupportedFunctions().get(fooRef.getName());
        if (definition != null) {
            JBIterable names = ((JBTreeTraverser)JBTreeTraverser.from(SqlFunctionCallExpressionImpl::getParameters).withRoots((Iterable)JBIterable.of((Object[])definition.getPrototypes()))).filter(SqlFunctionDefinition.SimpleParameter.class).transform(p -> p.getName());
            for (String name : names) {
                if (processor.process((Object)new FakeParameter((PsiElement)fooRef, casing.apply(name), null){

                    @Override
                    @NotNull
                    public PsiElement getNavigationElement() {
                        PsiElement psiElement = place;
                        if (psiElement == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return psiElement;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$2", "getNavigationElement"));
                    }
                })) continue;
                return false;
            }
        }
        for (ResolveResult res : fooRef.multiResolve(false)) {
            PsiElement origin = res.getElement();
            PsiElement resolve = origin instanceof DbElement ? ((DbElement)origin).getDelegate() : origin;
            DasRoutine routine = (DasRoutine)ObjectUtils.tryCast((Object)resolve, DasRoutine.class);
            SqlCursorDefinitionImpl curs = (SqlCursorDefinitionImpl)((Object)ObjectUtils.tryCast((Object)resolve, SqlCursorDefinitionImpl.class));
            if (dialect.getFamilyId().isOracle() && curs != null) {
                for (SqlParameterDefinition parameter : SqlImplUtil.childrenIt((PsiElement)curs).filter(SqlParameterDefinition.class)) {
                    if (processor.process((Object)parameter)) continue;
                    return false;
                }
            }
            if (routine == null || dialect.getFamilyId().isTransactSql() && routine.getRoutineKind() == DasRoutine.Kind.FUNCTION) continue;
            if (resolve instanceof SqlProcedureDefinitionImpl) {
                SqlProcedureDefinitionImpl procedure = (SqlProcedureDefinitionImpl)resolve;
                Iterable<SqlParameterDefinition> parameters = procedure.getArguments();
                for (SqlParameterDefinition parameter : parameters) {
                    if (processor.process((Object)parameter)) continue;
                    return false;
                }
                continue;
            }
            for (SqlParameterDefinition parameter : DasUtil.getParameters((DasRoutine)routine)) {
                if (processor.process((Object)new FakeParameter((PsiElement)fooRef, casing.apply(parameter.getName()), (DasTypedObject)parameter){

                    @Override
                    @NotNull
                    public PsiElement getNavigationElement() {
                        PsiElement psiElement = place;
                        if (psiElement == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return psiElement;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$3", "getNavigationElement"));
                    }
                })) continue;
                return false;
            }
        }
        return true;
    }

    private static Iterable<? extends SqlFunctionDefinition.Parameter> getParameters(SqlFunctionDefinition.Parameter p) {
        return p instanceof SqlFunctionDefinition.ParameterBlock ? JBIterable.of((Object[])((SqlFunctionDefinition.ParameterBlock)p).getParams()) : JBIterable.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routineElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retArg";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "trimSetOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionReturnType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBuiltinFunctionReturnType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRoutineType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromColumns";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FakeParameter
    extends SqlFileImpl.FakeDefinition {
        private final PsiElement myParent;
        private final DasTypedObject myDelegate;

        public FakeParameter(@NotNull PsiElement parent, @NotNull DasTypedObject parameter) {
            if (parent == null) {
                FakeParameter.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                FakeParameter.$$$reportNull$$$0(1);
            }
            this(parent, StringUtil.notNullize((String)parameter.getName()), parameter);
        }

        public FakeParameter(@NotNull PsiElement parent, @NotNull String name, @Nullable DasTypedObject delegate) {
            if (parent == null) {
                FakeParameter.$$$reportNull$$$0(2);
            }
            if (name == null) {
                FakeParameter.$$$reportNull$$$0(3);
            }
            super(parent, name, null);
            this.myParent = parent;
            this.myDelegate = delegate;
        }

        public boolean isNameQuoted() {
            return DbSqlUtil.isQuoted((DasObject)this.myDelegate);
        }

        public int getTextOffset() {
            return this.myParent.getTextOffset();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            if (objectKind == null) {
                FakeParameter.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @Override
        public String getTypeName() {
            if (this.myDelegate != null) {
                DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe(this.getParent()).getDatabaseDialect();
                return new DdlBuilder().applyCodeStyle(this.getProject()).withDialect(dialect).type(this.myDelegate).getStatement();
            }
            return super.getTypeName();
        }

        @Override
        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

