/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uiDesigner.GridChangeUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.componentTree.ComponentTreeBuilder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.DraggedComponentList;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.Painter;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.lw.ITabbedPane;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroComponentProperty;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormEditingUtil {
    public static final int EMPTY_COMPONENT_SIZE = 5;

    private FormEditingUtil() {
    }

    public static boolean canDeleteSelection(GuiEditor editor) {
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(editor);
        if (selection.isEmpty()) {
            return false;
        }
        RadRootContainer rootContainer = editor.getRootContainer();
        return rootContainer.getComponentCount() <= 0 || !selection.contains(rootContainer.getComponent(0));
    }

    public static void deleteSelection(GuiEditor editor) {
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(editor);
        FormEditingUtil.deleteComponents(selection, true);
        editor.refreshAndSave(true);
    }

    public static void deleteComponents(Collection<? extends RadComponent> selection, boolean deleteEmptyCells) {
        if (selection.size() == 0) {
            return;
        }
        final RadRootContainer rootContainer = (RadRootContainer)FormEditingUtil.getRoot(selection.iterator().next());
        final HashSet deletedComponentIds = new HashSet();
        for (RadComponent radComponent : selection) {
            boolean wasSelected = radComponent.isSelected();
            RadContainer parent = radComponent.getParent();
            boolean wasPackedHorz = false;
            boolean wasPackedVert = false;
            if (parent.getParent() != null && parent.getParent().isXY()) {
                Dimension minSize = parent.getMinimumSize();
                wasPackedHorz = parent.getWidth() == minSize.width;
                wasPackedVert = parent.getHeight() == minSize.height;
            }
            FormEditingUtil.iterate(radComponent, new ComponentVisitor(){

                public boolean visit(IComponent c) {
                    RadComponent rc = (RadComponent)c;
                    BindingProperty.checkRemoveUnusedField(rootContainer, rc.getBinding(), null);
                    deletedComponentIds.add(rc.getId());
                    return true;
                }
            });
            GridConstraints delConstraints = parent.getLayoutManager().isGrid() ? radComponent.getConstraints() : null;
            int index = parent.indexOfComponent(radComponent);
            parent.removeComponent(radComponent);
            if (wasSelected) {
                if (parent.getComponentCount() > index) {
                    parent.getComponent(index).setSelected(true);
                } else if (index > 0 && parent.getComponentCount() == index) {
                    parent.getComponent(index - 1).setSelected(true);
                } else {
                    parent.setSelected(true);
                }
            }
            if (delConstraints != null && deleteEmptyCells) {
                FormEditingUtil.deleteEmptyGridCells(parent, delConstraints);
            }
            if (!wasPackedHorz && !wasPackedVert) continue;
            Dimension minSize = parent.getMinimumSize();
            Dimension newSize = new Dimension(parent.getWidth(), parent.getHeight());
            if (wasPackedHorz) {
                newSize.width = minSize.width;
            }
            if (wasPackedVert) {
                newSize.height = minSize.height;
            }
            parent.setSize(newSize);
        }
        FormEditingUtil.iterate(rootContainer, new ComponentVisitor(){

            public boolean visit(IComponent component) {
                RadComponent rc = (RadComponent)component;
                for (IProperty p : component.getModifiedProperties()) {
                    IntroComponentProperty icp;
                    String value;
                    if (!(p instanceof IntroComponentProperty) || !deletedComponentIds.contains(value = (icp = (IntroComponentProperty)p).getValue(rc))) continue;
                    try {
                        icp.resetValue(rc);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
        });
    }

    public static void deleteEmptyGridCells(RadContainer parent, GridConstraints delConstraints) {
        FormEditingUtil.deleteEmptyGridCells(parent, delConstraints, true);
        FormEditingUtil.deleteEmptyGridCells(parent, delConstraints, false);
    }

    private static void deleteEmptyGridCells(RadContainer parent, GridConstraints delConstraints, boolean isRow) {
        RadAbstractGridLayoutManager layoutManager = parent.getGridLayoutManager();
        for (int cell = delConstraints.getCell(isRow) + delConstraints.getSpan(isRow) - 1; cell >= delConstraints.getCell(isRow); --cell) {
            if (cell >= parent.getGridCellCount(isRow) || GridChangeUtil.canDeleteCell(parent, cell, isRow) != GridChangeUtil.CellStatus.Empty || layoutManager.isGapCell(parent, isRow, cell)) continue;
            layoutManager.deleteGridCells(parent, cell, isRow);
        }
    }

    private static Component getDeepestEmptyComponentAt(JComponent parent, Point location) {
        int size = parent.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component result;
            Component child = parent.getComponent(i);
            if (!child.isShowing()) continue;
            if (child.getWidth() < 5 || child.getHeight() < 5) {
                Point childLocation = child.getLocationOnScreen();
                Rectangle bounds = new Rectangle();
                bounds.x = childLocation.x;
                bounds.y = childLocation.y;
                bounds.width = child.getWidth();
                bounds.height = child.getHeight();
                bounds.grow(child.getWidth() < 5 ? 5 : 0, child.getHeight() < 5 ? 5 : 0);
                if (bounds.contains(location)) {
                    return child;
                }
            }
            if (!(child instanceof JComponent) || (result = FormEditingUtil.getDeepestEmptyComponentAt((JComponent)child, location)) == null) continue;
            return result;
        }
        return null;
    }

    public static RadComponent getRadComponentAt(RadRootContainer rootContainer, int x, int y) {
        Point location = new Point(x, y);
        SwingUtilities.convertPointToScreen(location, rootContainer.getDelegee());
        Component c = FormEditingUtil.getDeepestEmptyComponentAt(rootContainer.getDelegee(), location);
        if (c == null) {
            c = SwingUtilities.getDeepestComponentAt(rootContainer.getDelegee(), x, y);
        }
        RadComponent result = null;
        while (c != null) {
            RadComponent component;
            if (c instanceof JComponent && (component = (RadComponent)((JComponent)c).getClientProperty("radComponent")) != null) {
                if (result == null) {
                    result = component;
                } else {
                    Point p = SwingUtilities.convertPoint(rootContainer.getDelegee(), x, y, c);
                    if (Painter.getResizeMask(component, p.x, p.y) != 0) {
                        result = component;
                    }
                }
            }
            c = c.getParent();
        }
        return result;
    }

    @Nullable
    public static RadComponent getDraggerHost(@NotNull GuiEditor editor) {
        if (editor == null) {
            FormEditingUtil.$$$reportNull$$$0(0);
        }
        final Ref result = new Ref();
        FormEditingUtil.iterate(editor.getRootContainer(), new ComponentVisitor<RadComponent>(){

            @Override
            public boolean visit(RadComponent component) {
                if (component.hasDragger()) {
                    result.set((Object)component);
                    return false;
                }
                return true;
            }
        });
        return (RadComponent)result.get();
    }

    public static Cursor getMoveDropCursor() {
        try {
            return Cursor.getSystemCustomCursor("MoveDrop.32x32");
        }
        catch (Exception ex) {
            return Cursor.getDefaultCursor();
        }
    }

    public static Cursor getMoveNoDropCursor() {
        try {
            return Cursor.getSystemCustomCursor("MoveNoDrop.32x32");
        }
        catch (Exception ex) {
            return Cursor.getDefaultCursor();
        }
    }

    public static Cursor getCopyDropCursor() {
        try {
            return Cursor.getSystemCustomCursor("CopyDrop.32x32");
        }
        catch (Exception ex) {
            return Cursor.getDefaultCursor();
        }
    }

    @NotNull
    public static ArrayList<RadComponent> getSelectedComponents(@NotNull GuiEditor editor) {
        if (editor == null) {
            FormEditingUtil.$$$reportNull$$$0(1);
        }
        ArrayList<RadComponent> result = new ArrayList<RadComponent>();
        FormEditingUtil.calcSelectedComponentsImpl(result, editor.getRootContainer());
        ArrayList<RadComponent> arrayList = result;
        if (arrayList == null) {
            FormEditingUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void calcSelectedComponentsImpl(ArrayList<RadComponent> result, RadContainer container) {
        if (container.isSelected() && container.getParent() != null) {
            result.add(container);
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            RadComponent component = container.getComponent(i);
            if (component instanceof RadContainer) {
                FormEditingUtil.calcSelectedComponentsImpl(result, (RadContainer)component);
                continue;
            }
            if (!component.isSelected()) continue;
            result.add(component);
        }
    }

    @NotNull
    public static ArrayList<RadComponent> getAllSelectedComponents(@NotNull GuiEditor editor) {
        if (editor == null) {
            FormEditingUtil.$$$reportNull$$$0(3);
        }
        final ArrayList<RadComponent> result = new ArrayList<RadComponent>();
        FormEditingUtil.iterate(editor.getRootContainer(), new ComponentVisitor<RadComponent>(){

            @Override
            public boolean visit(RadComponent component) {
                if (component.isSelected()) {
                    result.add(component);
                }
                return true;
            }
        });
        ArrayList<RadComponent> arrayList = result;
        if (arrayList == null) {
            FormEditingUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static String getExceptionMessage(Throwable ex) {
        Throwable target;
        if (ex instanceof RuntimeException) {
            Throwable cause = ex.getCause();
            if (cause != null && cause != ex) {
                return FormEditingUtil.getExceptionMessage(cause);
            }
        } else if (ex instanceof InvocationTargetException && (target = ((InvocationTargetException)ex).getTargetException()) != null && target != ex) {
            return FormEditingUtil.getExceptionMessage(target);
        }
        String message = ex.getMessage();
        if (ex instanceof ClassNotFoundException) {
            message = message != null ? UIDesignerBundle.message("error.class.not.found.N", message) : UIDesignerBundle.message("error.class.not.found", new Object[0]);
        } else if (ex instanceof NoClassDefFoundError) {
            message = message != null ? UIDesignerBundle.message("error.required.class.not.found.N", message) : UIDesignerBundle.message("error.required.class.not.found", new Object[0]);
        }
        return message;
    }

    public static IComponent findComponentWithBinding(IComponent component, String binding) {
        return FormEditingUtil.findComponentWithBinding(component, binding, null);
    }

    public static IComponent findComponentWithBinding(IComponent component, final String binding, final @Nullable IComponent exceptComponent) {
        final Ref boundComponent = new Ref();
        FormEditingUtil.iterate(component, new ComponentVisitor(){

            public boolean visit(IComponent component) {
                if (component != exceptComponent && binding.equals(component.getBinding())) {
                    boundComponent.set((Object)component);
                    return false;
                }
                return true;
            }
        });
        return (IComponent)boundComponent.get();
    }

    @Nullable
    public static RadContainer getRadContainerAt(RadRootContainer rootContainer, int x, int y, int epsilon) {
        RadComponent component = FormEditingUtil.getRadComponentAt(rootContainer, x, y);
        if (FormEditingUtil.isNullOrRoot(component) && epsilon > 0) {
            component = FormEditingUtil.getRadComponentAt(rootContainer, x - epsilon, y - epsilon);
            if (FormEditingUtil.isNullOrRoot(component)) {
                component = FormEditingUtil.getRadComponentAt(rootContainer, x - epsilon, y + epsilon);
            }
            if (FormEditingUtil.isNullOrRoot(component)) {
                component = FormEditingUtil.getRadComponentAt(rootContainer, x + epsilon, y - epsilon);
            }
            if (FormEditingUtil.isNullOrRoot(component)) {
                component = FormEditingUtil.getRadComponentAt(rootContainer, x + epsilon, y + epsilon);
            }
        }
        if (component != null) {
            return component instanceof RadContainer ? (RadContainer)component : component.getParent();
        }
        return null;
    }

    private static boolean isNullOrRoot(RadComponent component) {
        return component == null || component instanceof RadRootContainer;
    }

    public static GridConstraints getDefaultConstraints(RadComponent component) {
        Palette palette = Palette.getInstance(component.getProject());
        ComponentItem item = palette.getItem(component.getComponentClassName());
        if (item != null) {
            return item.getDefaultConstraints();
        }
        return new GridConstraints();
    }

    public static IRootContainer getRoot(IComponent component) {
        while (component != null) {
            if (component.getParentContainer() instanceof IRootContainer) {
                return (IRootContainer)component.getParentContainer();
            }
            component = component.getParentContainer();
        }
        return null;
    }

    public static void iterate(IComponent component, ComponentVisitor visitor) {
        FormEditingUtil.iterateImpl(component, visitor);
    }

    private static boolean iterateImpl(IComponent component, ComponentVisitor visitor) {
        boolean shouldContinue;
        try {
            shouldContinue = visitor.visit(component);
        }
        catch (ProcessCanceledException ex) {
            return false;
        }
        if (!shouldContinue) {
            return false;
        }
        if (!(component instanceof IContainer)) {
            return true;
        }
        IContainer container = (IContainer)component;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            IComponent c = container.getComponent(i);
            if (FormEditingUtil.iterateImpl(c, visitor)) continue;
            return false;
        }
        return true;
    }

    public static Set<String> collectUsedBundleNames(IRootContainer rootContainer) {
        final HashSet<String> bundleNames = new HashSet<String>();
        FormEditingUtil.iterateStringDescriptors((IComponent)rootContainer, new StringDescriptorVisitor<IComponent>(){

            @Override
            public boolean visit(IComponent component, StringDescriptor descriptor) {
                if (descriptor.getBundleName() != null && !bundleNames.contains(descriptor.getBundleName())) {
                    bundleNames.add(descriptor.getBundleName());
                }
                return true;
            }
        });
        return bundleNames;
    }

    public static Locale[] collectUsedLocales(Module module, IRootContainer rootContainer) {
        HashSet<Locale> locales = new HashSet<Locale>();
        PropertiesReferenceManager propManager = PropertiesReferenceManager.getInstance((Project)module.getProject());
        for (String bundleName : FormEditingUtil.collectUsedBundleNames(rootContainer)) {
            List propFiles = propManager.findPropertiesFiles(module, bundleName.replace('/', '.'));
            for (PropertiesFile propFile : propFiles) {
                locales.add(propFile.getLocale());
            }
        }
        return locales.toArray(new Locale[0]);
    }

    public static void deleteRowOrColumn(GuiEditor editor, RadContainer container, int[] cellsToDelete, boolean isRow) {
        Arrays.sort(cellsToDelete);
        int[] cells = ArrayUtil.reverseArray((int[])cellsToDelete);
        if (!editor.ensureEditable()) {
            return;
        }
        Runnable runnable = () -> {
            if (!GridChangeUtil.canDeleteCells(container, cells, isRow)) {
                HashSet<RadComponent> componentsInColumn = new HashSet<RadComponent>();
                RadComponent[] radComponentArray = container.getComponents();
                int n = radComponentArray.length;
                block0: for (int i = 0; i < n; ++i) {
                    RadComponent component = radComponentArray[i];
                    GridConstraints c = component.getConstraints();
                    for (int cell : cells) {
                        if (!c.contains(isRow, cell)) continue;
                        componentsInColumn.add(component);
                        continue block0;
                    }
                }
                if (componentsInColumn.size() > 0) {
                    String message = isRow ? UIDesignerBundle.message("delete.row.nonempty", componentsInColumn.size(), cells.length) : UIDesignerBundle.message("delete.column.nonempty", componentsInColumn.size(), cells.length);
                    int rc = Messages.showYesNoDialog((Component)editor, (String)message, (String)(isRow ? UIDesignerBundle.message("delete.row.title", new Object[0]) : UIDesignerBundle.message("delete.column.title", new Object[0])), (Icon)Messages.getQuestionIcon());
                    if (rc != 0) {
                        return;
                    }
                    FormEditingUtil.deleteComponents(componentsInColumn, false);
                }
            }
            for (int cell : cells) {
                container.getGridLayoutManager().deleteGridCells(container, cell, isRow);
            }
            editor.refreshAndSave(true);
        };
        CommandProcessor.getInstance().executeCommand(editor.getProject(), runnable, isRow ? UIDesignerBundle.message("command.delete.row", new Object[0]) : UIDesignerBundle.message("command.delete.column", new Object[0]), null);
    }

    public static String generateId(RadRootContainer rootContainer) {
        String id;
        while (FormEditingUtil.findComponent(rootContainer, id = Integer.toString((int)(Math.random() * 1024.0 * 1024.0), 16)) != null) {
        }
        return id;
    }

    @Nullable
    public static GuiEditor getEditorFromContext(@NotNull DataContext context) {
        FileEditor editor;
        if (context == null) {
            FormEditingUtil.$$$reportNull$$$0(5);
        }
        if ((editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context)) instanceof UIFormEditor) {
            return ((UIFormEditor)editor).getEditor();
        }
        return (GuiEditor)GuiEditor.DATA_KEY.getData(context);
    }

    @Nullable
    public static GuiEditor getActiveEditor(DataContext context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        DesignerToolWindowManager toolWindowManager = DesignerToolWindowManager.getInstance(project);
        if (toolWindowManager == null) {
            return null;
        }
        return toolWindowManager.getActiveFormEditor();
    }

    public static boolean isBindingUnique(IComponent componentToAssignBinding, String binding, IComponent component) {
        return FormEditingUtil.findComponentWithBinding(component, binding, componentToAssignBinding) == null;
    }

    @Nullable
    public static String buildResourceName(PsiFile file) {
        PsiDirectory directory = file.getContainingDirectory();
        if (directory != null) {
            String packageName;
            PsiPackage pkg = JavaDirectoryService.getInstance().getPackage(directory);
            String string = packageName = pkg != null ? pkg.getQualifiedName() : "";
            if (packageName.length() == 0) {
                return file.getName();
            }
            return packageName.replace('.', '/') + '/' + file.getName();
        }
        return null;
    }

    @Nullable
    public static RadContainer getSelectionParent(List<RadComponent> selection) {
        RadContainer parent = null;
        for (RadComponent c : selection) {
            if (parent == null) {
                parent = c.getParent();
                continue;
            }
            if (parent == c.getParent()) continue;
            parent = null;
            break;
        }
        return parent;
    }

    public static Rectangle getSelectionBounds(List<RadComponent> selection) {
        int minRow = Integer.MAX_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxRow = 0;
        int maxCol = 0;
        for (RadComponent c : selection) {
            minRow = Math.min(minRow, c.getConstraints().getRow());
            minCol = Math.min(minCol, c.getConstraints().getColumn());
            maxRow = Math.max(maxRow, c.getConstraints().getRow() + c.getConstraints().getRowSpan());
            maxCol = Math.max(maxCol, c.getConstraints().getColumn() + c.getConstraints().getColSpan());
        }
        return new Rectangle(minCol, minRow, maxCol - minCol, maxRow - minRow);
    }

    public static boolean isComponentSwitchedInView(@NotNull RadComponent component) {
        if (component == null) {
            FormEditingUtil.$$$reportNull$$$0(6);
        }
        while (component.getParent() != null) {
            if (!component.getParent().getLayoutManager().isSwitchedToChild(component.getParent(), component)) {
                return false;
            }
            component = component.getParent();
        }
        return true;
    }

    public static boolean selectComponent(GuiEditor editor, @NotNull RadComponent component) {
        if (component == null) {
            FormEditingUtil.$$$reportNull$$$0(7);
        }
        boolean hasTab = false;
        RadComponent parent = component;
        while (parent.getParent() != null) {
            if (parent.getParent().getLayoutManager().switchContainerToChild(parent.getParent(), parent)) {
                hasTab = true;
            }
            parent = parent.getParent();
        }
        component.setSelected(true);
        editor.setSelectionLead(component);
        return hasTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectSingleComponent(GuiEditor editor, RadComponent component) {
        RadContainer root = (RadContainer)FormEditingUtil.getRoot(component);
        if (root == null) {
            return;
        }
        ComponentTreeBuilder builder = DesignerToolWindowManager.getInstance(editor).getComponentTreeBuilder();
        if (builder != null) {
            builder.beginUpdateSelection();
        }
        try {
            FormEditingUtil.clearSelection(root);
            FormEditingUtil.selectComponent(editor, component);
            editor.setSelectionAnchor(component);
            editor.scrollComponentInView(component);
        }
        finally {
            if (builder != null) {
                builder.endUpdateSelection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectComponents(GuiEditor editor, List<RadComponent> components) {
        if (components.size() > 0) {
            RadComponent component = components.get(0);
            ComponentTreeBuilder builder = DesignerToolWindowManager.getInstance(editor).getComponentTreeBuilder();
            if (builder == null) {
                return;
            }
            builder.beginUpdateSelection();
            try {
                FormEditingUtil.clearSelection((RadContainer)FormEditingUtil.getRoot(component));
                for (RadComponent aComponent : components) {
                    FormEditingUtil.selectComponent(editor, aComponent);
                }
            }
            finally {
                builder.endUpdateSelection();
            }
        }
    }

    public static boolean isDropOnChild(DraggedComponentList draggedComponentList, ComponentDropLocation location) {
        if (location.getContainer() == null) {
            return false;
        }
        for (RadComponent component : draggedComponentList.getComponents()) {
            if (!FormEditingUtil.isChild(location.getContainer(), component)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChild(RadContainer maybeChild, RadComponent maybeParent) {
        while (maybeChild != null) {
            if (maybeParent == maybeChild) {
                return true;
            }
            maybeChild = maybeChild.getParent();
        }
        return false;
    }

    public static PsiMethod findCreateComponentsMethod(PsiClass aClass) {
        PsiMethod method;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        try {
            method = factory.createMethodFromText("void createUIComponents() {}", (PsiElement)aClass);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
        return aClass.findMethodBySignature(method, true);
    }

    public static Object getNextSaveUndoGroupId(Project project) {
        GuiEditor guiEditor = DesignerToolWindowManager.getInstance(project).getActiveFormEditor();
        return guiEditor == null ? null : guiEditor.getNextSaveGroupId();
    }

    public static int adjustForGap(RadContainer container, int cellIndex, boolean isRow, int delta) {
        if (container.getGridLayoutManager().isGapCell(container, isRow, cellIndex)) {
            return cellIndex + delta;
        }
        return cellIndex;
    }

    public static int prevRow(RadContainer container, int row) {
        return FormEditingUtil.adjustForGap(container, row - 1, true, -1);
    }

    public static int nextRow(RadContainer container, int row) {
        return FormEditingUtil.adjustForGap(container, row + 1, true, 1);
    }

    public static int prevCol(RadContainer container, int col) {
        return FormEditingUtil.adjustForGap(container, col - 1, false, -1);
    }

    public static int nextCol(RadContainer container, int col) {
        return FormEditingUtil.adjustForGap(container, col + 1, false, 1);
    }

    @Nullable
    public static IButtonGroup findGroupForComponent(IRootContainer radRootContainer, @NotNull IComponent component) {
        if (component == null) {
            FormEditingUtil.$$$reportNull$$$0(8);
        }
        for (IButtonGroup group : radRootContainer.getButtonGroups()) {
            for (String id : group.getComponentIds()) {
                if (!component.getId().equals(id)) continue;
                return group;
            }
        }
        return null;
    }

    public static void remapToActionTargets(List<RadComponent> selection) {
        for (int i = 0; i < selection.size(); ++i) {
            RadComponent c = selection.get(i);
            if (c.getParent() == null) continue;
            selection.set(i, c.getParent().getActionTargetComponent(c));
        }
    }

    public static void showPopupUnderComponent(JBPopup popup, RadComponent selectedComponent) {
        Rectangle rc = selectedComponent.getBounds();
        Point pnt = new Point(rc.x, rc.y + rc.height);
        popup.show(new RelativePoint((Component)selectedComponent.getDelegee().getParent(), pnt));
    }

    public static void iterateStringDescriptors(IComponent component, final StringDescriptorVisitor<IComponent> visitor) {
        FormEditingUtil.iterate(component, new ComponentVisitor<IComponent>(){

            @Override
            public boolean visit(IComponent component) {
                StringDescriptor borderTitle;
                for (IProperty prop : component.getModifiedProperties()) {
                    Object value = prop.getPropertyValue(component);
                    if (!(value instanceof StringDescriptor) || visitor.visit(component, (StringDescriptor)value)) continue;
                    return false;
                }
                if (component.getParentContainer() instanceof ITabbedPane) {
                    StringDescriptor tabTitle = ((ITabbedPane)component.getParentContainer()).getTabProperty(component, "Tab Title");
                    if (tabTitle != null && !visitor.visit(component, tabTitle)) {
                        return false;
                    }
                    StringDescriptor tabToolTip = ((ITabbedPane)component.getParentContainer()).getTabProperty(component, "Tab Tooltip");
                    if (tabToolTip != null && !visitor.visit(component, tabToolTip)) {
                        return false;
                    }
                }
                return !(component instanceof IContainer) || (borderTitle = ((IContainer)component).getBorderTitle()) == null || visitor.visit(component, borderTitle);
            }
        });
    }

    public static void clearSelection(@NotNull RadContainer container) {
        if (container == null) {
            FormEditingUtil.$$$reportNull$$$0(9);
        }
        container.setSelected(false);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            RadComponent c = container.getComponent(i);
            if (c instanceof RadContainer) {
                FormEditingUtil.clearSelection((RadContainer)c);
                continue;
            }
            c.setSelected(false);
        }
    }

    @Nullable
    public static IComponent findComponent(@NotNull IComponent component, @NotNull String id) {
        if (component == null) {
            FormEditingUtil.$$$reportNull$$$0(10);
        }
        if (id == null) {
            FormEditingUtil.$$$reportNull$$$0(11);
        }
        if (id.equals(component.getId())) {
            return component;
        }
        if (!(component instanceof IContainer)) {
            return null;
        }
        IContainer uiContainer = (IContainer)component;
        for (int i = 0; i < uiContainer.getComponentCount(); ++i) {
            IComponent found = FormEditingUtil.findComponent(uiContainer.getComponent(i), id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public static PsiClass findClassToBind(@NotNull Module module, @NotNull String classToBindName) {
        if (module == null) {
            FormEditingUtil.$$$reportNull$$$0(12);
        }
        if (classToBindName == null) {
            FormEditingUtil.$$$reportNull$$$0(13);
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(classToBindName.replace('$', '.'), module.getModuleWithDependenciesScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/FormEditingUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToBindName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/FormEditingUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedComponents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSelectedComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDraggerHost";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedComponents";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllSelectedComponents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isComponentSwitchedInView";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findGroupForComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "clearSelection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findClassToBind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ComponentVisitor<Type extends IComponent> {
        public boolean visit(Type var1);
    }

    public static interface StringDescriptorVisitor<T extends IComponent> {
        public boolean visit(T var1, StringDescriptor var2);
    }
}

